/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.colorpicker;

import com.intellij.ui.colorpicker.ColorPickerModel;
import com.intellij.ui.colorpicker.ColorPipette;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0002\r\u000eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ui/colorpicker/ColorPipetteButton;", "Ljavax/swing/JButton;", "colorPickerModel", "Lcom/intellij/ui/colorpicker/ColorPickerModel;", "pipette", "Lcom/intellij/ui/colorpicker/ColorPipette;", "(Lcom/intellij/ui/colorpicker/ColorPickerModel;Lcom/intellij/ui/colorpicker/ColorPipette;)V", "currentState", "Lcom/intellij/ui/colorpicker/ColorPipetteButton$PipetteState;", "getCurrentState", "()Lcom/intellij/ui/colorpicker/ColorPipetteButton$PipetteState;", "setCurrentState", "(Lcom/intellij/ui/colorpicker/ColorPipetteButton$PipetteState;)V", "MyCallback", "PipetteState", "intellij.platform.ide.impl"})
public final class ColorPipetteButton
extends JButton {
    @NotNull
    private PipetteState currentState;
    private final ColorPickerModel colorPickerModel;
    private final ColorPipette pipette;

    @NotNull
    public final PipetteState getCurrentState() {
        return this.currentState;
    }

    public final void setCurrentState(@NotNull PipetteState pipetteState) {
        Intrinsics.checkNotNullParameter((Object)((Object)pipetteState), (String)"<set-?>");
        this.currentState = pipetteState;
    }

    public ColorPipetteButton(@NotNull ColorPickerModel colorPickerModel, @NotNull ColorPipette pipette) {
        Intrinsics.checkNotNullParameter((Object)colorPickerModel, (String)"colorPickerModel");
        Intrinsics.checkNotNullParameter((Object)pipette, (String)"pipette");
        this.colorPickerModel = colorPickerModel;
        this.pipette = pipette;
        this.setRolloverEnabled(true);
        this.setIcon(this.pipette.getIcon());
        this.setRolloverIcon(this.pipette.getRolloverIcon());
        this.setPressedIcon(this.pipette.getPressedIcon());
        this.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                pipette.pick(new MyCallback(colorPickerModel));
            }
        });
        this.currentState = PipetteState.NONE;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ui/colorpicker/ColorPipetteButton$PipetteState;", "", "(Ljava/lang/String;I)V", "PICKED", "UPDATING", "NONE", "intellij.platform.ide.impl"})
    public static final class PipetteState
    extends Enum<PipetteState> {
        public static final /* enum */ PipetteState PICKED;
        public static final /* enum */ PipetteState UPDATING;
        public static final /* enum */ PipetteState NONE;
        private static final /* synthetic */ PipetteState[] $VALUES;

        static {
            PipetteState[] pipetteStateArray = new PipetteState[3];
            PipetteState[] pipetteStateArray2 = pipetteStateArray;
            pipetteStateArray[0] = PICKED = new PipetteState();
            pipetteStateArray[1] = UPDATING = new PipetteState();
            pipetteStateArray[2] = NONE = new PipetteState();
            $VALUES = pipetteStateArray;
        }

        public static PipetteState[] values() {
            return (PipetteState[])$VALUES.clone();
        }

        public static PipetteState valueOf(String string) {
            return Enum.valueOf(PipetteState.class, string);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ui/colorpicker/ColorPipetteButton$MyCallback;", "Lcom/intellij/ui/colorpicker/ColorPipette$Callback;", "model", "Lcom/intellij/ui/colorpicker/ColorPickerModel;", "(Lcom/intellij/ui/colorpicker/ColorPipetteButton;Lcom/intellij/ui/colorpicker/ColorPickerModel;)V", "getModel", "()Lcom/intellij/ui/colorpicker/ColorPickerModel;", "originalColor", "Ljava/awt/Color;", "cancel", "", "picked", "pickedColor", "update", "updatedColor", "intellij.platform.ide.impl"})
    private final class MyCallback
    implements ColorPipette.Callback {
        private final Color originalColor;
        @NotNull
        private final ColorPickerModel model;

        @Override
        public void picked(@NotNull Color pickedColor) {
            Intrinsics.checkNotNullParameter((Object)pickedColor, (String)"pickedColor");
            ColorPipetteButton.this.setCurrentState(PipetteState.PICKED);
            this.model.setColor(pickedColor, ColorPipetteButton.this);
            this.model.firePipettePicked(pickedColor);
            ColorPipetteButton.this.setCurrentState(PipetteState.NONE);
        }

        @Override
        public void update(@NotNull Color updatedColor) {
            Intrinsics.checkNotNullParameter((Object)updatedColor, (String)"updatedColor");
            ColorPipetteButton.this.setCurrentState(PipetteState.UPDATING);
            this.model.setColor(updatedColor, ColorPipetteButton.this);
            this.model.firePipetteUpdated(updatedColor);
        }

        @Override
        public void cancel() {
            ColorPipetteButton.this.setCurrentState(PipetteState.PICKED);
            this.model.setColor(this.originalColor, ColorPipetteButton.this);
            this.model.firePipetteCancelled();
            ColorPipetteButton.this.setCurrentState(PipetteState.NONE);
        }

        @NotNull
        public final ColorPickerModel getModel() {
            return this.model;
        }

        public MyCallback(ColorPickerModel model2) {
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            this.model = model2;
            this.originalColor = this.model.getColor();
        }
    }
}

