/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.content.custom.options;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.custom.options.CustomContentLayoutOption;
import com.intellij.ui.content.custom.options.CustomContentLayoutOptions;
import com.intellij.ui.content.custom.options.PersistentContentCustomLayoutOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH$J\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0012\u0010\r\u001a\f0\u0005\u00a2\u0006\u0002\b\u000e\u00a2\u0006\u0002\b\u000fH\u0002J\r\u0010\u0010\u001a\u00070\f\u00a2\u0006\u0002\b\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0005H$J\u0013\u0010\u0013\u001a\r\u0012\t\u0012\u00070\f\u00a2\u0006\u0002\b\u00110\u0014H\u0002J\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u0018\u001a\u00020\bH\u0016J\b\u0010\u0019\u001a\u00020\bH\u0016J\u0015\u0010\u001a\u001a\u00020\b2\u000b\u0010\u001b\u001a\u00070\u0005\u00a2\u0006\u0002\b\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ui/content/custom/options/PersistentContentCustomLayoutOptions;", "Lcom/intellij/ui/content/custom/options/CustomContentLayoutOptions;", "content", "Lcom/intellij/ui/content/Content;", "selectedOptionKey", "", "(Lcom/intellij/ui/content/Content;Ljava/lang/String;)V", "doSelect", "", "option", "Lcom/intellij/ui/content/custom/options/CustomContentLayoutOption;", "getCurrentOption", "Lcom/intellij/ui/content/custom/options/PersistentContentCustomLayoutOption;", "getCurrentOptionKey", "Lorg/jetbrains/annotations/Nullable;", "Lorg/jetbrains/annotations/NonNls;", "getDefaultOption", "Lkotlin/internal/NoInfer;", "getDefaultOptionKey", "getPersistentOptions", "", "isContentVisible", "", "isSelected", "onHide", "restore", "saveOption", "optionKey", "Lcom/intellij/openapi/util/NlsSafe;", "select", "Companion", "intellij.platform.ide.impl"})
public abstract class PersistentContentCustomLayoutOptions
implements CustomContentLayoutOptions {
    private final Content content;
    private final String selectedOptionKey;
    @NotNull
    public static final String HIDE_OPTION_KEY = "Hidden";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void select(@NotNull CustomContentLayoutOption option2) {
        Intrinsics.checkNotNullParameter((Object)option2, (String)"option");
        CustomContentLayoutOption customContentLayoutOption = option2;
        if (!(customContentLayoutOption instanceof PersistentContentCustomLayoutOption)) {
            customContentLayoutOption = null;
        }
        if ((PersistentContentCustomLayoutOption)customContentLayoutOption == null) {
            throw (Throwable)new IllegalStateException("Option is not a " + PersistentContentCustomLayoutOption.class.getName());
        }
        this.doSelect(option2);
        this.saveOption(((PersistentContentCustomLayoutOption)option2).getOptionKey());
    }

    @Override
    public boolean isSelected(@NotNull CustomContentLayoutOption option2) {
        Intrinsics.checkNotNullParameter((Object)option2, (String)"option");
        return option2.isSelected();
    }

    @Override
    public void restore() {
        PersistentContentCustomLayoutOption defaultOption = this.getDefaultOption();
        if (!defaultOption.isSelected()) {
            this.select(defaultOption);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isContentVisible() {
        if (!this.content.isValid()) return false;
        ContentManager contentManager2 = this.content.getManager();
        if (contentManager2 == null) return false;
        int n = contentManager2.getIndexOfContent(this.content);
        if (n == -1) return false;
        return true;
    }

    @Nullable
    public final PersistentContentCustomLayoutOption getCurrentOption() {
        Object element$iv2;
        block2: {
            String currentOptionKey = this.getCurrentOptionKey();
            if (Intrinsics.areEqual((Object)currentOptionKey, (Object)HIDE_OPTION_KEY)) {
                return null;
            }
            Iterable $this$first$iv = this.getPersistentOptions();
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                PersistentContentCustomLayoutOption it = (PersistentContentCustomLayoutOption)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getOptionKey(), (Object)this.getCurrentOptionKey())) continue;
                break block2;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return (PersistentContentCustomLayoutOption)element$iv2;
    }

    protected abstract void doSelect(@NotNull CustomContentLayoutOption var1);

    @NotNull
    protected abstract String getDefaultOptionKey();

    private final String getCurrentOptionKey() {
        String string = PropertiesComponent.getInstance().getValue(this.selectedOptionKey);
        if (string == null) {
            string = this.getDefaultOptionKey();
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PropertiesComponent.getI\u2026 ?: getDefaultOptionKey()");
        return string;
    }

    private final PersistentContentCustomLayoutOption getDefaultOption() {
        Object element$iv2;
        block1: {
            Iterable $this$first$iv = this.getPersistentOptions();
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                PersistentContentCustomLayoutOption it = (PersistentContentCustomLayoutOption)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getOptionKey(), (Object)this.getDefaultOptionKey())) continue;
                break block1;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return (PersistentContentCustomLayoutOption)element$iv2;
    }

    private final void saveOption(String optionKey) {
        PropertiesComponent.getInstance().setValue(this.selectedOptionKey, optionKey);
    }

    /*
     * WARNING - void declaration
     */
    private final List<PersistentContentCustomLayoutOption> getPersistentOptions() {
        void $this$filterIsInstanceTo$iv$iv;
        CustomContentLayoutOption[] customContentLayoutOptionArray = this.getAvailableOptions();
        Intrinsics.checkNotNullExpressionValue((Object)customContentLayoutOptionArray, (String)"availableOptions");
        CustomContentLayoutOption[] $this$filterIsInstance$iv = customContentLayoutOptionArray;
        boolean $i$f$filterIsInstance = false;
        CustomContentLayoutOption[] customContentLayoutOptionArray2 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof PersistentContentCustomLayoutOption)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public void onHide() {
        this.saveOption(HIDE_OPTION_KEY);
    }

    public PersistentContentCustomLayoutOptions(@NotNull Content content2, @NotNull String selectedOptionKey) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Intrinsics.checkNotNullParameter((Object)selectedOptionKey, (String)"selectedOptionKey");
        this.content = content2;
        this.selectedOptionKey = selectedOptionKey;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/ui/content/custom/options/PersistentContentCustomLayoutOptions$Companion;", "", "()V", "HIDE_OPTION_KEY", "", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

