/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.content.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.TabDescriptor;
import com.intellij.ui.content.TabGroupId;
import com.intellij.ui.content.TabbedContent;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.util.ContentUtilEx;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TabbedContentImpl
extends ContentImpl
implements TabbedContent {
    @NotNull
    private final List<TabDescriptor> myTabs;
    @NotNull
    private final TabGroupId myId;

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public TabbedContentImpl(JComponent component2, @NotNull @NlsContexts.TabTitle String displayName, boolean isPinnable, @NotNull @NonNls String titlePrefix) {
        if (displayName == null) {
            TabbedContentImpl.$$$reportNull$$$0(0);
        }
        if (titlePrefix == null) {
            TabbedContentImpl.$$$reportNull$$$0(1);
        }
        this(new TabGroupId(titlePrefix, titlePrefix), new TabDescriptor(component2, displayName), isPinnable);
    }

    public TabbedContentImpl(@NotNull TabGroupId id2, @NotNull TabDescriptor tab, boolean isPinnable) {
        if (id2 == null) {
            TabbedContentImpl.$$$reportNull$$$0(2);
        }
        if (tab == null) {
            TabbedContentImpl.$$$reportNull$$$0(3);
        }
        super(tab.getComponent(), id2.getDisplayName(tab), isPinnable);
        this.myTabs = new ArrayList<TabDescriptor>();
        this.myId = id2;
        this.myTabs.add(tab);
        Disposer.register((Disposable)this, (Disposable)tab);
    }

    @Nullable
    private TabDescriptor findTab(@NotNull JComponent c) {
        if (c == null) {
            TabbedContentImpl.$$$reportNull$$$0(4);
        }
        for (TabDescriptor tab : this.myTabs) {
            if (tab.getComponent() != c) continue;
            return tab;
        }
        return null;
    }

    @Nullable
    private TabDescriptor selectedTab() {
        return this.findTab(this.getComponent());
    }

    private int indexOf(@NotNull JComponent c) {
        if (c == null) {
            TabbedContentImpl.$$$reportNull$$$0(5);
        }
        for (int i2 = 0; i2 < this.myTabs.size(); ++i2) {
            if (this.myTabs.get(i2).getComponent() != c) continue;
            return i2;
        }
        return -1;
    }

    private void selectTab(@NotNull TabDescriptor tab) {
        if (tab == null) {
            TabbedContentImpl.$$$reportNull$$$0(6);
        }
        this.setDisplayName(this.myId.getDisplayName(tab));
        this.setComponent(tab.getComponent());
    }

    public void addContent(@NotNull JComponent content2, @NotNull String name2, boolean selectTab2) {
        if (content2 == null) {
            TabbedContentImpl.$$$reportNull$$$0(7);
        }
        if (name2 == null) {
            TabbedContentImpl.$$$reportNull$$$0(8);
        }
        this.addContent(new TabDescriptor(content2, name2), selectTab2);
    }

    public void addContent(@NotNull TabDescriptor tab, boolean selectTab2) {
        if (tab == null) {
            TabbedContentImpl.$$$reportNull$$$0(9);
        }
        Disposer.register((Disposable)this, (Disposable)tab);
        if (!this.myTabs.contains(tab)) {
            this.myTabs.add(tab);
        }
        if (selectTab2 && this.getComponent() != tab.getComponent()) {
            this.selectTab(tab);
        }
    }

    @NotNull
    public TabGroupId getId() {
        TabGroupId tabGroupId = this.myId;
        if (tabGroupId == null) {
            TabbedContentImpl.$$$reportNull$$$0(10);
        }
        return tabGroupId;
    }

    @Nls
    @NotNull
    public String getTitlePrefix() {
        String string = this.myId.getDisplayName();
        if (string == null) {
            TabbedContentImpl.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    public void setComponent(JComponent component2) {
        JComponent currentComponent = this.getComponent();
        Container parent = currentComponent.getParent();
        if (parent != null) {
            parent.remove(currentComponent);
            parent.add(component2);
        }
        super.setComponent(component2);
    }

    public void removeContent(@NotNull JComponent content2) {
        int index2;
        if (content2 == null) {
            TabbedContentImpl.$$$reportNull$$$0(12);
        }
        if ((index2 = this.indexOf(content2)) != -1) {
            Disposer.dispose((Disposable)((Disposable)this.myTabs.remove(index2)));
            int n = index2 = index2 > 0 ? index2 - 1 : index2;
            if (index2 < this.myTabs.size()) {
                this.selectContent(index2);
            }
        }
    }

    @Override
    @Nls
    public String getDisplayName() {
        TabDescriptor selectedTab = this.selectedTab();
        if (selectedTab == null) {
            return this.myId.getDisplayName();
        }
        return this.myId.getDisplayName(selectedTab);
    }

    public void selectContent(int index2) {
        this.selectTab(this.myTabs.get(index2));
    }

    public int getSelectedIndex() {
        return this.indexOf(this.getComponent());
    }

    public boolean findAndSelectContent(@NotNull JComponent contentComponent) {
        TabDescriptor tab;
        if (contentComponent == null) {
            TabbedContentImpl.$$$reportNull$$$0(13);
        }
        if ((tab = this.findTab(contentComponent)) != null) {
            this.selectTab(tab);
            return true;
        }
        return false;
    }

    @Override
    public String getTabName() {
        return this.getDisplayName();
    }

    @NotNull
    public List<Pair<String, JComponent>> getTabs() {
        List list2 = ContainerUtil.map2List(this.myTabs, tab -> Pair.create((Object)tab.getDisplayName(), (Object)tab.getComponent()));
        if (list2 == null) {
            TabbedContentImpl.$$$reportNull$$$0(14);
        }
        return list2;
    }

    public boolean hasMultipleTabs() {
        return this.myTabs.size() > 1;
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            TabbedContentImpl.$$$reportNull$$$0(15);
        }
        if (key.equals((Object)TAB_GROUP_ID_KEY)) {
            return (T)this.myId;
        }
        if (key.equals((Object)TAB_DESCRIPTOR_KEY)) {
            return (T)this.selectedTab();
        }
        return (T)super.getUserData(key);
    }

    public void split() {
        ContentManager manager2 = this.getManager();
        if (manager2 == null) {
            return;
        }
        boolean selected2 = manager2.isSelected((Content)this);
        TabDescriptor selectedTab = this.selectedTab();
        ArrayList<TabDescriptor> tabsCopy = new ArrayList<TabDescriptor>(this.myTabs);
        manager2.removeContent((Content)this, false);
        ContentUtilEx.setSplitMode(this.myId.getId(), true);
        for (TabDescriptor tab : tabsCopy) {
            ContentUtilEx.addSplitTabbedContent(manager2, this.myId, tab, selected2 && tab == selectedTab);
        }
        Disposer.dispose((Disposable)this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "titlePrefix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tab";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/content/impl/TabbedContentImpl";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentComponent";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/content/impl/TabbedContentImpl";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitlePrefix";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findTab";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "selectTab";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addContent";
                break;
            }
            case 10: 
            case 11: 
            case 14: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeContent";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findAndSelectContent";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

