/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.dsl.builder.components;

import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.dsl.UiDslException;
import com.intellij.ui.dsl.builder.HyperlinkEventAction;
import com.intellij.ui.dsl.builder.components.DslLabel$WhenMappings;
import com.intellij.ui.dsl.builder.components.DslLabelKt;
import com.intellij.ui.dsl.builder.components.DslLabelType;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00142\b\b\u0001\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0010J\b\u0010\u0018\u001a\u00020\u0014H\u0016R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ui/dsl/builder/components/DslLabel;", "Ljavax/swing/JEditorPane;", "type", "Lcom/intellij/ui/dsl/builder/components/DslLabelType;", "(Lcom/intellij/ui/dsl/builder/components/DslLabelType;)V", "action", "Lcom/intellij/ui/dsl/builder/HyperlinkEventAction;", "getAction", "()Lcom/intellij/ui/dsl/builder/HyperlinkEventAction;", "setAction", "(Lcom/intellij/ui/dsl/builder/HyperlinkEventAction;)V", "createCss", "", "wordWrap", "", "getBaseline", "", "width", "height", "patchFont", "", "setHtmlText", "text", "maxLineLength", "updateUI", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class DslLabel
extends JEditorPane {
    @Nullable
    private HyperlinkEventAction action;
    private final DslLabelType type;

    @Nullable
    public final HyperlinkEventAction getAction() {
        return this.action;
    }

    public final void setAction(@Nullable HyperlinkEventAction hyperlinkEventAction) {
        this.action = hyperlinkEventAction;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setFocusable(false);
        this.setEditable(false);
        this.setBorder(null);
        this.setBackground(UIUtil.TRANSPARENT_COLOR);
        this.setOpaque(false);
        this.patchFont();
    }

    @Override
    public int getBaseline(int width, int height) {
        FontMetrics fontMetrics;
        FontMetrics fontMetrics2 = fontMetrics = this.getFontMetrics(this.getFont());
        Intrinsics.checkNotNullExpressionValue((Object)fontMetrics2, (String)"fontMetrics");
        return fontMetrics2.getAscent();
    }

    public final void setHtmlText(@Nls @NotNull String text2, int maxLineLength) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        for (String deniedTag : DslLabelKt.access$getDENIED_TAGS$p()) {
            if (!StringsKt.contains$default((CharSequence)text2, (CharSequence)deniedTag, (boolean)false, (int)2, null)) continue;
            throw (Throwable)new UiDslException("Text contains denied tag " + deniedTag + ": " + text2, null, 2, null);
        }
        HtmlChunk htmlChunk = HtmlChunk.raw((String)StringsKt.replace((String)text2, (String)"<a>", (String)"<a href=''>", (boolean)true));
        Intrinsics.checkNotNullExpressionValue((Object)htmlChunk, (String)"HtmlChunk.raw(text.repla\u2026''>\", ignoreCase = true))");
        HtmlChunk processedText = htmlChunk;
        HtmlChunk.Element element2 = HtmlChunk.body();
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"HtmlChunk.body()");
        HtmlChunk.Element body = element2;
        if (maxLineLength > 0 && maxLineLength != Integer.MAX_VALUE && text2.length() > maxLineLength) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            String string = text2;
            int n = 0;
            boolean bl = false;
            String string2 = string.substring(n, maxLineLength);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            int width = fontMetrics.stringWidth(string2);
            HtmlChunk.Element element3 = body.attr("width", width);
            Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"body.attr(\"width\", width)");
            body = element3;
        }
        String css = this.createCss(maxLineLength != Integer.MAX_VALUE);
        this.setText(new HtmlBuilder().append(HtmlChunk.raw((String)css)).append((HtmlChunk)processedText.wrapWith(body)).wrapWith(HtmlChunk.html()).toString());
    }

    private final void patchFont() {
        if (this.type == DslLabelType.COMMENT) {
            this.setFont(ComponentPanelBuilder.getCommentFont((Font)this.getFont()));
        }
    }

    private final String createCss(boolean wordWrap) {
        List styles = CollectionsKt.mutableListOf((Object[])new String[]{"a, a:link {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.Foreground.ENABLED) + ";}", "a:visited {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.Foreground.VISITED) + ";}", "a:hover {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.Foreground.HOVERED) + ";}", "a:active {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.Foreground.PRESSED) + ";}"});
        if (!wordWrap) {
            styles.add("body, p {white-space:nowrap;}");
        }
        return CollectionsKt.joinToString$default((Iterable)styles, (CharSequence)" ", (CharSequence)"<head><style type='text/css'>", (CharSequence)"</style></head>", (int)0, null, null, (int)56, null);
    }

    public DslLabel(@NotNull DslLabelType type) {
        Color color;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.type = type;
        this.setContentType("text/html");
        this.setEditorKit(UIUtil.getHTMLEditorKit());
        switch (DslLabel$WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1: {
                color = JBUI.CurrentTheme.ContextHelp.FOREGROUND;
                break;
            }
            case 2: {
                color = JBUI.CurrentTheme.Label.foreground();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.setForeground(color);
        this.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public final void hyperlinkUpdate(HyperlinkEvent e) {
                block2: {
                    HyperlinkEvent.EventType eventType;
                    block3: {
                        block1: {
                            HyperlinkEvent hyperlinkEvent = e;
                            HyperlinkEvent.EventType eventType2 = eventType = hyperlinkEvent != null ? hyperlinkEvent.getEventType() : null;
                            if (!Intrinsics.areEqual((Object)eventType, (Object)HyperlinkEvent.EventType.ACTIVATED)) break block1;
                            HyperlinkEventAction hyperlinkEventAction = this.getAction();
                            if (hyperlinkEventAction == null) break block2;
                            HyperlinkEvent hyperlinkEvent2 = e;
                            Intrinsics.checkNotNullExpressionValue((Object)hyperlinkEvent2, (String)"e");
                            hyperlinkEventAction.hyperlinkActivated(hyperlinkEvent2);
                            break block2;
                        }
                        if (!Intrinsics.areEqual((Object)eventType, (Object)HyperlinkEvent.EventType.ENTERED)) break block3;
                        HyperlinkEventAction hyperlinkEventAction = this.getAction();
                        if (hyperlinkEventAction == null) break block2;
                        HyperlinkEvent hyperlinkEvent = e;
                        Intrinsics.checkNotNullExpressionValue((Object)hyperlinkEvent, (String)"e");
                        hyperlinkEventAction.hyperlinkEntered(hyperlinkEvent);
                        break block2;
                    }
                    if (!Intrinsics.areEqual((Object)eventType, (Object)HyperlinkEvent.EventType.EXITED)) break block2;
                    HyperlinkEventAction hyperlinkEventAction = this.getAction();
                    if (hyperlinkEventAction != null) {
                        HyperlinkEvent hyperlinkEvent = e;
                        Intrinsics.checkNotNullExpressionValue((Object)hyperlinkEvent, (String)"e");
                        hyperlinkEventAction.hyperlinkExited(hyperlinkEvent);
                    }
                }
            }
        });
        this.patchFont();
    }
}

