/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.dsl.gridLayout;

import com.intellij.ui.dsl.UiDslException;
import com.intellij.ui.dsl.UiDslExceptionKt;
import com.intellij.ui.dsl.gridLayout.Constraints;
import com.intellij.ui.dsl.gridLayout.Grid;
import com.intellij.ui.dsl.gridLayout.impl.GridImpl;
import com.intellij.ui.dsl.gridLayout.impl.PreferredSizeData;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u001c\u0010\t\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u000e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u0015J\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0012\u0010\u001a\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0015\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001eJ\u0012\u0010\u001f\u001a\u00020\n2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0012\u0010 \u001a\u00020\n2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0019H\u0016J\u0012\u0010!\u001a\u00020\"2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0012\u0010#\u001a\u00020\"2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0019H\u0016J\u0012\u0010$\u001a\u00020\"2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0019H\u0016J\u0012\u0010%\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006&"}, d2={"Lcom/intellij/ui/dsl/gridLayout/GridLayout;", "Ljava/awt/LayoutManager2;", "()V", "_rootGrid", "Lcom/intellij/ui/dsl/gridLayout/impl/GridImpl;", "rootGrid", "Lcom/intellij/ui/dsl/gridLayout/Grid;", "getRootGrid", "()Lcom/intellij/ui/dsl/gridLayout/Grid;", "addLayoutComponent", "", "comp", "Ljava/awt/Component;", "constraints", "", "name", "", "addLayoutSubGrid", "Lcom/intellij/ui/dsl/gridLayout/Constraints;", "getConstraints", "component", "Ljavax/swing/JComponent;", "getLayoutAlignmentX", "", "target", "Ljava/awt/Container;", "getLayoutAlignmentY", "getPreferredSizeData", "Lcom/intellij/ui/dsl/gridLayout/impl/PreferredSizeData;", "parent", "getPreferredSizeData$intellij_platform_ide_impl", "invalidateLayout", "layoutContainer", "maximumLayoutSize", "Ljava/awt/Dimension;", "minimumLayoutSize", "preferredLayoutSize", "removeLayoutComponent", "intellij.platform.ide.impl"})
@ApiStatus.Experimental
public final class GridLayout
implements LayoutManager2 {
    private final GridImpl _rootGrid = new GridImpl();

    @NotNull
    public final Grid getRootGrid() {
        return this._rootGrid;
    }

    @Override
    public void addLayoutComponent(@Nullable Component comp, @Nullable Object constraints2) {
        Constraints jbConstraints = UiDslExceptionKt.checkConstraints(constraints2);
        Grid grid = jbConstraints.getGrid();
        if (grid == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.ui.dsl.gridLayout.impl.GridImpl");
        }
        ((GridImpl)grid).register(UiDslExceptionKt.checkComponent(comp), jbConstraints);
    }

    @NotNull
    public final Grid addLayoutSubGrid(@NotNull Constraints constraints2) {
        Intrinsics.checkNotNullParameter((Object)constraints2, (String)"constraints");
        Grid grid = constraints2.getGrid();
        if (grid == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.ui.dsl.gridLayout.impl.GridImpl");
        }
        return ((GridImpl)grid).registerSubGrid(constraints2);
    }

    @Override
    public void addLayoutComponent(@Nullable String name2, @Nullable Component comp) {
        throw (Throwable)new UiDslException("Method addLayoutComponent(name: String?, comp: Component?) is not supported", null, 2, null);
    }

    @Override
    public void removeLayoutComponent(@Nullable Component comp) {
        if (!this._rootGrid.unregister(UiDslExceptionKt.checkComponent(comp))) {
            throw (Throwable)new UiDslException("Component has not been registered: " + comp, null, 2, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Dimension preferredLayoutSize(@Nullable Container parent) {
        if (parent == null) {
            throw (Throwable)new UiDslException("Parent is null", null, 2, null);
        }
        Object object = parent.getTreeLock();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parent.treeLock");
        Object object2 = object;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object2) {
            boolean bl3 = false;
            Dimension dimension = this.getPreferredSizeData$intellij_platform_ide_impl(parent).getPreferredSize();
            return dimension;
        }
    }

    @Override
    @NotNull
    public Dimension minimumLayoutSize(@Nullable Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    @NotNull
    public Dimension maximumLayoutSize(@Nullable Container target2) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(@Nullable Container parent) {
        if (parent == null) {
            throw (Throwable)new UiDslException("Parent is null", null, 2, null);
        }
        Object object = parent.getTreeLock();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parent.treeLock");
        Object object2 = object;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object2) {
            boolean bl3 = false;
            int n = parent.getWidth();
            int n2 = parent.getHeight();
            Insets insets = parent.getInsets();
            Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"parent.insets");
            this._rootGrid.layout(n, n2, insets);
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public float getLayoutAlignmentX(@Nullable Container target2) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(@Nullable Container target2) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(@Nullable Container target2) {
    }

    @Nullable
    public final Constraints getConstraints(@NotNull JComponent component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        return this._rootGrid.getConstraints(component2);
    }

    @NotNull
    public final PreferredSizeData getPreferredSizeData$intellij_platform_ide_impl(@NotNull Container parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Insets insets = parent.getInsets();
        Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"parent.insets");
        return this._rootGrid.getPreferredSizeData(insets);
    }
}

