/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.dsl.gridLayout.impl;

import com.intellij.ui.dsl.gridLayout.Constraints;
import com.intellij.ui.dsl.gridLayout.Gaps;
import com.intellij.ui.dsl.gridLayout.HorizontalAlign;
import com.intellij.ui.dsl.gridLayout.impl.BaselineData;
import com.intellij.ui.dsl.gridLayout.impl.ColumnsSizeCalculator;
import com.intellij.ui.dsl.gridLayout.impl.LayoutCellData;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u00101\u001a\u00020\t2\u0006\u00102\u001a\u00020,J\u000e\u00103\u001a\u00020\t2\u0006\u00102\u001a\u00020,J\u000e\u00104\u001a\u00020\t2\u0006\u00102\u001a\u00020,J\u000e\u0010\u0019\u001a\u00020\u00182\u0006\u00105\u001a\u000206J\u000e\u00107\u001a\u00020\t2\u0006\u00102\u001a\u00020,R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\"\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000e\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001f\"\u0004\b$\u0010!R\"\u0010%\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000e\u001a\u0004\b&\u0010\u000b\"\u0004\b'\u0010\rR\u0011\u0010(\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0012R \u0010*\u001a\b\u0012\u0004\u0012\u00020,0+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100\u00a8\u00068"}, d2={"Lcom/intellij/ui/dsl/gridLayout/impl/LayoutData;", "", "()V", "baselineData", "Lcom/intellij/ui/dsl/gridLayout/impl/BaselineData;", "getBaselineData", "()Lcom/intellij/ui/dsl/gridLayout/impl/BaselineData;", "columnsCoord", "", "", "getColumnsCoord", "()[Ljava/lang/Integer;", "setColumnsCoord", "([Ljava/lang/Integer;)V", "[Ljava/lang/Integer;", "columnsSizeCalculator", "Lcom/intellij/ui/dsl/gridLayout/impl/ColumnsSizeCalculator;", "getColumnsSizeCalculator", "()Lcom/intellij/ui/dsl/gridLayout/impl/ColumnsSizeCalculator;", "dimension", "Ljava/awt/Dimension;", "getDimension", "()Ljava/awt/Dimension;", "outsideGaps", "Lcom/intellij/ui/dsl/gridLayout/Gaps;", "getOutsideGaps", "()Lcom/intellij/ui/dsl/gridLayout/Gaps;", "setOutsideGaps", "(Lcom/intellij/ui/dsl/gridLayout/Gaps;)V", "preferredHeight", "getPreferredHeight", "()I", "setPreferredHeight", "(I)V", "preferredWidth", "getPreferredWidth", "setPreferredWidth", "rowsCoord", "getRowsCoord", "setRowsCoord", "rowsSizeCalculator", "getRowsSizeCalculator", "visibleCellsData", "", "Lcom/intellij/ui/dsl/gridLayout/impl/LayoutCellData;", "getVisibleCellsData", "()Ljava/util/List;", "setVisibleCellsData", "(Ljava/util/List;)V", "getFullPaddedHeight", "layoutCellData", "getFullPaddedWidth", "getHeight", "parentInsets", "Ljava/awt/Insets;", "getPaddedWidth", "intellij.platform.ide.impl"})
final class LayoutData {
    @NotNull
    private List<LayoutCellData> visibleCellsData = CollectionsKt.emptyList();
    @NotNull
    private final ColumnsSizeCalculator columnsSizeCalculator = new ColumnsSizeCalculator();
    private int preferredWidth;
    @NotNull
    private final Dimension dimension = new Dimension();
    @NotNull
    private Integer[] columnsCoord = new Integer[0];
    @NotNull
    private final ColumnsSizeCalculator rowsSizeCalculator = new ColumnsSizeCalculator();
    private int preferredHeight;
    @NotNull
    private final BaselineData baselineData = new BaselineData();
    @NotNull
    private Integer[] rowsCoord = new Integer[0];
    @NotNull
    private Gaps outsideGaps = Gaps.Companion.getEMPTY();

    @NotNull
    public final List<LayoutCellData> getVisibleCellsData() {
        return this.visibleCellsData;
    }

    public final void setVisibleCellsData(@NotNull List<LayoutCellData> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.visibleCellsData = list2;
    }

    @NotNull
    public final ColumnsSizeCalculator getColumnsSizeCalculator() {
        return this.columnsSizeCalculator;
    }

    public final int getPreferredWidth() {
        return this.preferredWidth;
    }

    public final void setPreferredWidth(int n) {
        this.preferredWidth = n;
    }

    @NotNull
    public final Dimension getDimension() {
        return this.dimension;
    }

    @NotNull
    public final Integer[] getColumnsCoord() {
        return this.columnsCoord;
    }

    public final void setColumnsCoord(@NotNull Integer[] integerArray) {
        Intrinsics.checkNotNullParameter((Object)integerArray, (String)"<set-?>");
        this.columnsCoord = integerArray;
    }

    @NotNull
    public final ColumnsSizeCalculator getRowsSizeCalculator() {
        return this.rowsSizeCalculator;
    }

    public final int getPreferredHeight() {
        return this.preferredHeight;
    }

    public final void setPreferredHeight(int n) {
        this.preferredHeight = n;
    }

    @NotNull
    public final BaselineData getBaselineData() {
        return this.baselineData;
    }

    @NotNull
    public final Integer[] getRowsCoord() {
        return this.rowsCoord;
    }

    public final void setRowsCoord(@NotNull Integer[] integerArray) {
        Intrinsics.checkNotNullParameter((Object)integerArray, (String)"<set-?>");
        this.rowsCoord = integerArray;
    }

    @NotNull
    public final Gaps getOutsideGaps() {
        return this.outsideGaps;
    }

    public final void setOutsideGaps(@NotNull Gaps gaps) {
        Intrinsics.checkNotNullParameter((Object)gaps, (String)"<set-?>");
        this.outsideGaps = gaps;
    }

    public final int getPaddedWidth(@NotNull LayoutCellData layoutCellData) {
        int n;
        Intrinsics.checkNotNullParameter((Object)layoutCellData, (String)"layoutCellData");
        int fullPaddedWidth = this.getFullPaddedWidth(layoutCellData);
        if (layoutCellData.getCell().getConstraints().getHorizontalAlign() == HorizontalAlign.FILL) {
            n = fullPaddedWidth;
        } else {
            int n2 = layoutCellData.getPreferredSize().width - layoutCellData.getCell().getConstraints().getVisualPaddings().getWidth();
            boolean bl = false;
            n = Math.min(fullPaddedWidth, n2);
        }
        return n;
    }

    public final int getFullPaddedWidth(@NotNull LayoutCellData layoutCellData) {
        Intrinsics.checkNotNullParameter((Object)layoutCellData, (String)"layoutCellData");
        Constraints constraints2 = layoutCellData.getCell().getConstraints();
        return this.columnsCoord[constraints2.getX() + constraints2.getWidth()] - this.columnsCoord[constraints2.getX()] - layoutCellData.getGapWidth();
    }

    public final int getHeight(@NotNull LayoutCellData layoutCellData) {
        Intrinsics.checkNotNullParameter((Object)layoutCellData, (String)"layoutCellData");
        Constraints constraints2 = layoutCellData.getCell().getConstraints();
        return this.rowsCoord[constraints2.getY() + constraints2.getHeight()] - this.rowsCoord[constraints2.getY()];
    }

    public final int getFullPaddedHeight(@NotNull LayoutCellData layoutCellData) {
        Intrinsics.checkNotNullParameter((Object)layoutCellData, (String)"layoutCellData");
        return this.getHeight(layoutCellData) - layoutCellData.getGapHeight();
    }

    @NotNull
    public final Gaps getOutsideGaps(@NotNull Insets parentInsets) {
        Intrinsics.checkNotNullParameter((Object)parentInsets, (String)"parentInsets");
        int n = this.outsideGaps.getTop();
        int n2 = parentInsets.top;
        boolean bl = false;
        int n3 = Math.max(n, n2);
        n = this.outsideGaps.getLeft();
        n2 = parentInsets.left;
        bl = false;
        int n4 = Math.max(n, n2);
        n = this.outsideGaps.getBottom();
        n2 = parentInsets.bottom;
        bl = false;
        int n5 = Math.max(n, n2);
        n = this.outsideGaps.getRight();
        n2 = parentInsets.right;
        bl = false;
        return new Gaps(n3, n4, n5, Math.max(n, n2));
    }
}

