/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.list;

import com.intellij.navigation.TargetPresentation;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.list.TargetPresentationMainRenderer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.function.Function;
import javax.accessibility.AccessibleContext;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001d\u0012\u0016\u0010\u0003\u001a\u0012\u0012\u0006\b\u0000\u0012\u00028\u0000\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J=\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00112\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0003\u001a\u0012\u0012\u0006\b\u0000\u0012\u00028\u0000\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ui/list/TargetPresentationRenderer;", "T", "Ljavax/swing/ListCellRenderer;", "presentationProvider", "Ljava/util/function/Function;", "Lcom/intellij/navigation/TargetPresentation;", "(Ljava/util/function/Function;)V", "myComponent", "Ljavax/swing/JPanel;", "myLocationComponent", "Lcom/intellij/ui/components/JBLabel;", "myMainRenderer", "Lcom/intellij/ui/list/TargetPresentationMainRenderer;", "mySpacerComponent", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "value", "index", "", "isSelected", "", "cellHasFocus", "(Ljavax/swing/JList;Ljava/lang/Object;IZZ)Ljava/awt/Component;", "intellij.platform.ide.impl"})
public final class TargetPresentationRenderer<T>
implements ListCellRenderer<T> {
    private final JPanel myComponent;
    private final TargetPresentationMainRenderer<T> myMainRenderer;
    private final JPanel mySpacerComponent;
    private final JBLabel myLocationComponent;
    private final Function<? super T, ? extends TargetPresentation> presentationProvider;

    @Override
    @NotNull
    public Component getListCellRendererComponent(@NotNull JList<? extends T> list2, T value2, int index2, boolean isSelected, boolean cellHasFocus) {
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        Component mainComponent = this.myMainRenderer.getListCellRendererComponent(list2, value2, index2, isSelected, cellHasFocus);
        TargetPresentation presentation2 = this.presentationProvider.apply(value2);
        String locationText = presentation2.getLocationText();
        if (locationText == null) {
            Component component2 = mainComponent;
            Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"mainComponent");
            return component2;
        }
        this.myComponent.removeAll();
        Component component3 = mainComponent;
        Intrinsics.checkNotNullExpressionValue((Object)component3, (String)"mainComponent");
        Color background = component3.getBackground();
        this.myComponent.setBackground(background);
        this.mySpacerComponent.setBackground(background);
        this.myLocationComponent.setBackground(background);
        this.myLocationComponent.setText(locationText);
        this.myLocationComponent.setIcon(presentation2.getLocationIcon());
        this.myLocationComponent.setForeground(isSelected ? UIUtil.getListSelectionForeground((boolean)cellHasFocus) : UIUtil.getInactiveTextColor());
        this.myComponent.add(mainComponent, "West");
        this.myComponent.add((Component)this.mySpacerComponent, "Center");
        this.myComponent.add((Component)this.myLocationComponent, "East");
        AccessibleContext accessibleContext = this.myComponent.getAccessibleContext();
        Intrinsics.checkNotNullExpressionValue((Object)accessibleContext, (String)"myComponent.accessibleContext");
        Object[] objectArray = new String[2];
        AccessibleContext accessibleContext2 = mainComponent.getAccessibleContext();
        objectArray[0] = accessibleContext2 != null ? accessibleContext2.getAccessibleName() : null;
        AccessibleContext accessibleContext3 = this.myLocationComponent.getAccessibleContext();
        objectArray[1] = accessibleContext3 != null ? accessibleContext3.getAccessibleName() : null;
        accessibleContext.setAccessibleName(CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        return this.myComponent;
    }

    public TargetPresentationRenderer(@NotNull Function<? super T, ? extends TargetPresentation> presentationProvider) {
        JPanel $this$apply;
        Intrinsics.checkNotNullParameter(presentationProvider, (String)"presentationProvider");
        this.presentationProvider = presentationProvider;
        this.myComponent = new JPanel(new BorderLayout());
        this.myMainRenderer = new TargetPresentationMainRenderer<T>(this.presentationProvider);
        JPanel jPanel2 = new JPanel();
        boolean bl = false;
        boolean bl2 = false;
        JPanel jPanel3 = jPanel2;
        TargetPresentationRenderer targetPresentationRenderer = this;
        boolean bl3 = false;
        $this$apply.setBorder((Border)JBUI.Borders.empty((int)0, (int)2));
        Unit unit = Unit.INSTANCE;
        targetPresentationRenderer.mySpacerComponent = jPanel2;
        jPanel2 = new JBLabel();
        bl = false;
        bl2 = false;
        $this$apply = jPanel2;
        targetPresentationRenderer = this;
        boolean bl4 = false;
        $this$apply.setBorder((Border)JBUI.Borders.emptyRight((int)UIUtil.getListCellHPadding()));
        $this$apply.setHorizontalTextPosition(2);
        $this$apply.setHorizontalAlignment(4);
        unit = Unit.INSTANCE;
        targetPresentationRenderer.myLocationComponent = jPanel2;
    }
}

