/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.ui.mac.touchbar.Helpers;
import com.intellij.ui.mac.touchbar.TBItemAnActionButton;
import com.intellij.ui.mac.touchbar.TouchBar;
import com.intellij.ui.mac.touchbar.TouchbarActionCustomizations;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class Customizer {
    private final List<ItemCustomizer> myBaseCustomizers;
    private final Map<AnAction, List<ItemCustomizer>> myAct2ButtCustomizer;
    private final Map<ActionGroup, List<ItemCustomizer>> myGroupCustomizers;
    private final Map<AnAction, ActionGroupInfo> myAct2Parent;
    private final Map<AnAction, Object> myAct2Descriptor;
    @Nullable
    private final TouchBar.CrossEscInfo myCrossEscInfo;
    private final String @Nullable [] myAutoCloseActionIds;

    Customizer(@Nullable TouchBar.CrossEscInfo crossEscInfo, String[] autoCloseActionIds, @NotNull ItemCustomizer itemCustomizer) {
        if (itemCustomizer == null) {
            Customizer.$$$reportNull$$$0(0);
        }
        this(crossEscInfo, autoCloseActionIds);
        this.addBaseCustomizations(itemCustomizer);
    }

    Customizer(@Nullable TouchBar.CrossEscInfo crossEscInfo, String @Nullable [] autoCloseActionIds) {
        this.myBaseCustomizers = new ArrayList<ItemCustomizer>();
        this.myAct2ButtCustomizer = new HashMap<AnAction, List<ItemCustomizer>>();
        this.myGroupCustomizers = new HashMap<ActionGroup, List<ItemCustomizer>>();
        this.myAct2Parent = new HashMap<AnAction, ActionGroupInfo>();
        this.myAct2Descriptor = new HashMap<AnAction, Object>();
        this.myCrossEscInfo = crossEscInfo;
        this.myAutoCloseActionIds = autoCloseActionIds;
    }

    void prepare(@NotNull ActionGroup actionGroup2) {
        if (actionGroup2 == null) {
            Customizer.$$$reportNull$$$0(1);
        }
        this.myAct2Parent.clear();
        this.fillAct2Parent(new ActionGroupInfo(actionGroup2, null));
    }

    void onBeforeActionsExpand(@NotNull ActionGroup actionGroup2) {
        if (actionGroup2 == null) {
            Customizer.$$$reportNull$$$0(2);
        }
    }

    private void fillAct2Parent(@NotNull ActionGroupInfo actionGroupInfo) {
        AnAction[] actions2;
        if (actionGroupInfo == null) {
            Customizer.$$$reportNull$$$0(3);
        }
        @NotNull ActionGroup actionGroup2 = actionGroupInfo.group;
        for (AnAction childAction : actions2 = actionGroup2.getChildren(null)) {
            if (childAction == null) continue;
            if (childAction instanceof ActionGroup) {
                this.fillAct2Parent(new ActionGroupInfo((ActionGroup)childAction, actionGroupInfo));
                continue;
            }
            this.myAct2Parent.put(childAction, actionGroupInfo);
        }
    }

    @Nullable
    TouchBar.CrossEscInfo getCrossEscInfo() {
        return this.myCrossEscInfo;
    }

    String @Nullable [] getAutoCloseActionIds() {
        return this.myAutoCloseActionIds;
    }

    /*
     * WARNING - void declaration
     */
    boolean applyCustomizations(@NotNull TBItemAnActionButton button4, @NotNull Presentation presentation2) {
        void var6_10;
        List<ItemCustomizer> customizers;
        if (button4 == null) {
            Customizer.$$$reportNull$$$0(4);
        }
        if (presentation2 == null) {
            Customizer.$$$reportNull$$$0(5);
        }
        @Nullable ActionGroupInfo parentInfo = this.myAct2Parent.get(button4.getAnAction());
        boolean result2 = false;
        if (!this.myBaseCustomizers.isEmpty()) {
            result2 = true;
            for (ItemCustomizer itemCustomizer : this.myBaseCustomizers) {
                itemCustomizer.applyCustomizations(parentInfo, button4, presentation2);
            }
        }
        if ((customizers = this.myAct2ButtCustomizer.get(button4.getAnAction())) != null && !customizers.isEmpty()) {
            result2 = true;
            for (ItemCustomizer c : customizers) {
                c.applyCustomizations(parentInfo, button4, presentation2);
            }
        }
        ActionGroupInfo actionGroupInfo = parentInfo;
        while (var6_10 != null) {
            List<ItemCustomizer> cs = this.myGroupCustomizers.get(var6_10.group);
            if (cs != null && !cs.isEmpty()) {
                result2 = true;
                for (ItemCustomizer c : cs) {
                    c.applyCustomizations(parentInfo, button4, presentation2);
                }
            }
            ActionGroupInfo actionGroupInfo2 = var6_10.parent;
        }
        return result2;
    }

    boolean isPrincipalGroupAction(@NotNull AnAction action2) {
        ActionGroupInfo groupInfo;
        if (action2 == null) {
            Customizer.$$$reportNull$$$0(6);
        }
        if ((groupInfo = this.myAct2Parent.get(action2)) != null && groupInfo.hasPrincipalParent()) {
            return true;
        }
        Object descriptor2 = this.myAct2Descriptor.get(action2);
        return descriptor2 instanceof TouchbarActionCustomizations && ((TouchbarActionCustomizations)descriptor2).isPrincipal();
    }

    void addCustomization(@NotNull AnAction action2, @NotNull ItemCustomizer buttCustomizer) {
        if (action2 == null) {
            Customizer.$$$reportNull$$$0(7);
        }
        if (buttCustomizer == null) {
            Customizer.$$$reportNull$$$0(8);
        }
        List bcl = this.myAct2ButtCustomizer.computeIfAbsent(action2, a -> new ArrayList());
        bcl.add(buttCustomizer);
    }

    void addCustomizations(@NotNull AnAction action2, ItemCustomizer ... customizers) {
        if (action2 == null) {
            Customizer.$$$reportNull$$$0(9);
        }
        Collections.addAll(this.myAct2ButtCustomizer.computeIfAbsent(action2, a -> new ArrayList()), customizers);
    }

    void addBaseCustomizations(@NotNull ItemCustomizer customizer) {
        if (customizer == null) {
            Customizer.$$$reportNull$$$0(10);
        }
        this.myBaseCustomizers.add(customizer);
    }

    void addGroupCustomization(@NotNull Map<Long, ActionGroup> actionGroups, ItemCustomizer ... customizers) {
        if (actionGroups == null) {
            Customizer.$$$reportNull$$$0(11);
        }
        for (ActionGroup actionGroup2 : actionGroups.values()) {
            this.addGroupCustomization(actionGroup2, customizers);
        }
    }

    void addGroupCustomization(@NotNull ActionGroup actionGroup2, ItemCustomizer ... customizers) {
        if (actionGroup2 == null) {
            Customizer.$$$reportNull$$$0(12);
        }
        Collections.addAll(this.myGroupCustomizers.computeIfAbsent(actionGroup2, a -> new ArrayList()), customizers);
    }

    void addDescriptor(@NotNull AnAction action2, @NotNull Object desc) {
        if (action2 == null) {
            Customizer.$$$reportNull$$$0(13);
        }
        if (desc == null) {
            Customizer.$$$reportNull$$$0(14);
        }
        this.myAct2Descriptor.put(action2, desc);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemCustomizer";
                break;
            }
            case 1: 
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroupInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buttCustomizer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customizer";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroups";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desc";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/mac/touchbar/Customizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "prepare";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "onBeforeActionsExpand";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fillAct2Parent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "applyCustomizations";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isPrincipalGroupAction";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "addCustomization";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "addCustomizations";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "addBaseCustomizations";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "addGroupCustomization";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "addDescriptor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static interface ItemCustomizer {
        public void applyCustomizations(@Nullable ActionGroupInfo var1, @NotNull TBItemAnActionButton var2, @NotNull Presentation var3);
    }

    static class ActionGroupInfo {
        @NotNull
        final ActionGroup group;
        @NotNull
        final String groupID;
        @Nullable
        final ActionGroupInfo parent;
        @Nullable
        final TouchbarActionCustomizations groupC;

        ActionGroupInfo(@NotNull ActionGroup group2, @Nullable ActionGroupInfo parent) {
            if (group2 == null) {
                ActionGroupInfo.$$$reportNull$$$0(0);
            }
            this.group = group2;
            this.parent = parent;
            this.groupID = Helpers.getActionId((AnAction)group2);
            this.groupC = TouchbarActionCustomizations.getCustomizations((AnAction)group2);
        }

        @Nullable
        TouchbarActionCustomizations getCustomizations() {
            return this.groupC;
        }

        boolean hasPrincipalParent() {
            ActionGroupInfo p = this;
            while (p != null) {
                if (p.groupC != null && p.groupC.isPrincipal()) {
                    return true;
                }
                p = p.parent;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/ui/mac/touchbar/Customizer$ActionGroupInfo", "<init>"));
        }
    }
}

