/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SimpleTimer;
import com.intellij.openapi.util.SimpleTimerTask;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.touchbar.ActionGroupTouchBar;
import com.intellij.ui.mac.touchbar.Customizer;
import com.intellij.ui.mac.touchbar.Helpers;
import com.intellij.ui.mac.touchbar.NST;
import com.intellij.ui.mac.touchbar.TouchBar;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TouchBarsManager {
    private static final Logger LOG = Logger.getInstance(TouchBarsManager.class);
    private static final boolean LOG_FOCUS_PROCESSING = Boolean.getBoolean("touchbar.TouchBarsManager.debug.focus.processing");
    private static final boolean LOG_INPUT_PROCESSING = Boolean.getBoolean("touchbar.TouchBarsManager.debug.input.processing");
    private static final boolean FORCE_UPDATE_ON_SHOW = Boolean.getBoolean("touchbar.TouchBarsManager.force.update.on.show");
    private static final long CHANGE_DELAY = Long.getLong("touchbar.TouchBarsManager.change.delay", 200L);
    private static final Map<Window, Stack> ourStacks = new WeakHashMap<Window, Stack>();
    private static final Map<Component, ComponentActions> ourComp2Actions = new WeakHashMap<Component, ComponentActions>();
    private static int ourLastModifiersEx = 0;

    TouchBarsManager() {
    }

    static synchronized void processAWTEvent(AWTEvent e) {
        if (e instanceof InputEvent) {
            TouchBarsManager.processInputEvent((InputEvent)e);
            return;
        }
        int eid = e.getID();
        if (eid == 1004 || eid == 1005 || eid == 205 || eid == 206 || eid == 208 || eid == 207) {
            TouchBarsManager.processFocusEvent(e);
        }
    }

    private static void processInputEvent(InputEvent e) {
        Window windowOfEvent;
        boolean areModifiersChanged;
        int usedKeyMask = 9152;
        int oldLastModifiersEx = ourLastModifiersEx;
        ourLastModifiersEx = e.getModifiersEx() & 0x23C0;
        boolean bl = areModifiersChanged = ourLastModifiersEx != oldLastModifiersEx;
        if (e instanceof MouseEvent && !areModifiersChanged) {
            return;
        }
        if (Helpers.isPhisycalEsc() && e instanceof KeyEvent && e.getID() == 402 && ((KeyEvent)e).getKeyCode() == 27 && ourLastModifiersEx == 0) {
            ComponentActions ca;
            windowOfEvent = TouchBarsManager.getWindow(e.getComponent());
            if (windowOfEvent == null) {
                if (LOG_INPUT_PROCESSING) {
                    LOG.debug("INPUT: can't find window of component %s (during isPhisycalEsc processing)", new Object[]{e.getComponent()});
                }
                return;
            }
            Stack s = ourStacks.get(windowOfEvent);
            if (s != null && (ca = s.getTopActions()) != null && ca.getCurrent() != null && ca.getCurrent().isCrossEsc()) {
                s.pop();
            }
        }
        if (LOG_INPUT_PROCESSING) {
            windowOfEvent = TouchBarsManager.getWindow(e.getComponent());
            @Nullable ComponentActions componentActions = TouchBarsManager.getShownActions(windowOfEvent);
            if (componentActions == null) {
                LOG.debug("INPUT: no touchbar actions are shown for window '%s', component '%s'", new Object[]{windowOfEvent, e.getComponent()});
            } else {
                LOG.debug("INPUT: show actions of component %s, keymask=%d", new Object[]{componentActions.component.get(), ourLastModifiersEx});
            }
        }
        if (areModifiersChanged) {
            for (ComponentActions ca : ourComp2Actions.values()) {
                if (ca == null) continue;
                ca.setCurrent(ourLastModifiersEx);
            }
            for (Stack s : ourStacks.values()) {
                s.updateIfNecessary();
            }
        }
    }

    private static void processFocusEvent(AWTEvent e) {
        if (!(e.getSource() instanceof Component)) {
            return;
        }
        Component src = (Component)e.getSource();
        if (e.getID() == 1004) {
            Window windowOfEvent = TouchBarsManager.getWindow(src);
            @Nullable ComponentActions shownActions = TouchBarsManager.getShownActions(windowOfEvent);
            boolean isShownPersistent = shownActions != null && shownActions.isPersistent();
            for (Component p = src; p != null; p = p.getParent()) {
                TouchBar toShow;
                @Nullable ComponentActions candidateActions = ourComp2Actions.get(p);
                if (candidateActions == null) continue;
                if (shownActions == candidateActions) {
                    return;
                }
                if (!p.isVisible() && LOG_FOCUS_PROCESSING) {
                    LOG.debug("FOCUS GAINED: skip actions of invisible component: %s, child (source): %s", new Object[]{p, src});
                }
                if (isShownPersistent && !candidateActions.isPersistent()) {
                    if (!LOG_FOCUS_PROCESSING) continue;
                    LOG.debug("FOCUS GAINED: skip not-persistent actions of parent: %s, child (source): %s", new Object[]{p, src});
                    continue;
                }
                if (LOG_FOCUS_PROCESSING) {
                    LOG.debug("FOCUS GAINED: show actions of parent: %s, child (source): %s", new Object[]{p, src});
                }
                if ((toShow = candidateActions.getTouchbar(0L, true)) instanceof ActionGroupTouchBar && ((ActionGroupTouchBar)toShow).updateAutoCloseAndCheck()) continue;
                TouchBarsManager.showTouchbar(candidateActions);
                return;
            }
            if (LOG_FOCUS_PROCESSING) {
                LOG.debug("FOCUS GAINED: components chain hasn't any actions, initial child (source): %s", new Object[]{src});
            }
        }
    }

    static int getLastModifiersEx() {
        return ourLastModifiersEx;
    }

    static synchronized void register(@NotNull Component component2, @NotNull ActionGroup actions2, @Nullable Customizer customizations) {
        if (component2 == null) {
            TouchBarsManager.$$$reportNull$$$0(0);
        }
        if (actions2 == null) {
            TouchBarsManager.$$$reportNull$$$0(1);
        }
        LOG.debug("register actions '%s' for component %s", new Object[]{actions2, component2});
        TouchBarsManager.unregister(component2);
        ourComp2Actions.put(component2, new ComponentActions(component2, actions2, null, customizations));
    }

    static synchronized void register(@NotNull Component component2, @NotNull ActionGroup actions2) {
        if (component2 == null) {
            TouchBarsManager.$$$reportNull$$$0(2);
        }
        if (actions2 == null) {
            TouchBarsManager.$$$reportNull$$$0(3);
        }
        TouchBarsManager.register(component2, actions2, null);
    }

    static synchronized void register(@NotNull Component component2, @NotNull Map<Long, ActionGroup> actions2, @Nullable Customizer customizations) {
        ActionGroup mainLayout;
        if (component2 == null) {
            TouchBarsManager.$$$reportNull$$$0(4);
        }
        if (actions2 == null) {
            TouchBarsManager.$$$reportNull$$$0(5);
        }
        if ((mainLayout = actions2.get(0L)) == null) {
            LOG.debug("can't find main layout for component: %s (actions will not be added)", new Object[]{component2});
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("register actions '" + mainLayout + "' for component " + component2);
            for (Long key : actions2.keySet()) {
                if (key == 0L) continue;
                LOG.debug("\talt action '" + actions2.get(key));
            }
        }
        TouchBarsManager.unregister(component2);
        ourComp2Actions.put(component2, new ComponentActions(component2, mainLayout, actions2, customizations));
    }

    static synchronized void register(@NotNull Component component2, @NotNull Map<Long, ActionGroup> actions2) {
        if (component2 == null) {
            TouchBarsManager.$$$reportNull$$$0(6);
        }
        if (actions2 == null) {
            TouchBarsManager.$$$reportNull$$$0(7);
        }
        TouchBarsManager.register(component2, actions2, null);
    }

    static synchronized void registerAndShow(@NotNull Component component2, @NotNull ActionGroup actions2) {
        if (component2 == null) {
            TouchBarsManager.$$$reportNull$$$0(8);
        }
        if (actions2 == null) {
            TouchBarsManager.$$$reportNull$$$0(9);
        }
        TouchBarsManager.register(component2, actions2);
        TouchBarsManager.showActionsOfComponent(component2);
    }

    static synchronized void registerAndShow(@NotNull Component component2, @NotNull Map<Long, ActionGroup> actions2) {
        if (component2 == null) {
            TouchBarsManager.$$$reportNull$$$0(10);
        }
        if (actions2 == null) {
            TouchBarsManager.$$$reportNull$$$0(11);
        }
        TouchBarsManager.register(component2, actions2);
        TouchBarsManager.showActionsOfComponent(component2);
    }

    static synchronized void registerAndShow(@NotNull Component component2, @NotNull Map<Long, ActionGroup> actions2, @Nullable Customizer customizations) {
        if (component2 == null) {
            TouchBarsManager.$$$reportNull$$$0(12);
        }
        if (actions2 == null) {
            TouchBarsManager.$$$reportNull$$$0(13);
        }
        TouchBarsManager.register(component2, actions2, customizations);
        TouchBarsManager.showActionsOfComponent(component2);
    }

    static synchronized void registerAndShow(@NotNull Component component2, @NotNull ActionGroup actions2, @Nullable Customizer customizations) {
        if (component2 == null) {
            TouchBarsManager.$$$reportNull$$$0(14);
        }
        if (actions2 == null) {
            TouchBarsManager.$$$reportNull$$$0(15);
        }
        TouchBarsManager.register(component2, actions2, customizations);
        TouchBarsManager.showActionsOfComponent(component2);
    }

    static synchronized void registerAndShow(@NotNull Component component2, @NotNull TouchBar tb) {
        if (component2 == null) {
            TouchBarsManager.$$$reportNull$$$0(16);
        }
        if (tb == null) {
            TouchBarsManager.$$$reportNull$$$0(17);
        }
        LOG.debug("registerAndShow non-action touchbar '%s' for component %s", new Object[]{tb, component2});
        TouchBarsManager.unregister(component2);
        ourComp2Actions.put(component2, new ComponentActions(component2, tb));
        TouchBarsManager.showActionsOfComponent(component2);
    }

    static synchronized void unregister(@NotNull Component component2) {
        if (component2 == null) {
            TouchBarsManager.$$$reportNull$$$0(18);
        }
        LOG.debug("UNREGISTER: component %s", new Object[]{component2});
        @Nullable ComponentActions componentActions = ourComp2Actions.remove(component2);
        if (componentActions == null) {
            LOG.debug("UNREGISTER: component '%s' hasn't any actions", new Object[]{component2});
            return;
        }
        componentActions.clearCachedTouchbars();
    }

    static synchronized void showActionsOfComponent(@NotNull Component component2) {
        ComponentActions componentActions;
        if (component2 == null) {
            TouchBarsManager.$$$reportNull$$$0(19);
        }
        if ((componentActions = ourComp2Actions.get(component2)) == null) {
            LOG.debug("SHOW: can't find actions info for component: %s (nothing to show)", new Object[]{component2});
            return;
        }
        TouchBarsManager.showTouchbar(componentActions);
    }

    static synchronized void clearAll() {
        LOG.debug("Clear all actions (disable touchbar suppoprt)");
        ourStacks.forEach((w, s) -> NST.setTouchBar(w, null));
        ourStacks.clear();
        ourComp2Actions.forEach((c, ca) -> {
            if (ca == null) {
                LOG.debug("clearAll: component '%s' hasn't any actions", new Object[]{c});
                return;
            }
            ca.clearCachedTouchbars();
        });
        ourComp2Actions.clear();
    }

    @Nullable
    private static Window getWindow(@NotNull Component component2) {
        if (component2 == null) {
            TouchBarsManager.$$$reportNull$$$0(20);
        }
        if (component2 instanceof Window) {
            return (Window)component2;
        }
        Window window = SwingUtilities.windowForComponent(component2);
        if (window == null) {
            LOG.debug("can't find window for component: %s", new Object[]{component2});
        }
        return window;
    }

    private static void showTouchbar(@NotNull ComponentActions componentActions) {
        if (componentActions == null) {
            TouchBarsManager.$$$reportNull$$$0(21);
        }
        componentActions.setCurrent(ourLastModifiersEx);
        TouchBarsManager.getWindowStack(TouchBarsManager.getWindow((Component)componentActions.component.get())).push(componentActions);
    }

    @NotNull
    private static Stack getWindowStack(final @Nullable Window window) {
        Stack stack = ourStacks.get(window);
        if (stack == null) {
            stack = new Stack(window);
            ourStacks.put(window, stack);
            if (window != null) {
                window.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent e) {
                        ourStacks.remove(window);
                    }
                });
            }
        }
        Stack stack2 = stack;
        if (stack2 == null) {
            TouchBarsManager.$$$reportNull$$$0(22);
        }
        return stack2;
    }

    static synchronized void hideTouchbar(@NotNull TouchBar tb) {
        if (tb == null) {
            TouchBarsManager.$$$reportNull$$$0(23);
        }
        for (Stack stack : ourStacks.values()) {
            stack.removeTouchbar(tb);
        }
    }

    @Nullable
    private static ComponentActions getShownActions(@Nullable Window window) {
        if (window != null) {
            Stack stack = ourStacks.get(window);
            if (stack == null && window.getType() == Window.Type.POPUP) {
                stack = ourStacks.get(window.getParent());
            }
            if (stack != null) {
                return stack.getTopActions();
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tb";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentActions";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/mac/touchbar/TouchBarsManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/mac/touchbar/TouchBarsManager";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getWindowStack";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "registerAndShow";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "unregister";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "showActionsOfComponent";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getWindow";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "showTouchbar";
                break;
            }
            case 22: {
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "hideTouchbar";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Stack {
        @Nullable
        private final WeakReference<Window> myWindow;
        private final ArrayDeque<ComponentActions> myStack = new ArrayDeque();
        private TouchBar myLastShownTouchbar = null;
        private SimpleTimerTask myNativeUpdateTask = null;

        private Stack(@Nullable Window window) {
            WeakReference<Window> weakReference = this.myWindow = window != null ? new WeakReference<Window>(window) : null;
            if (window != null) {
                window.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowActivated(WindowEvent e) {
                        @Nullable ComponentActions ca = this.getTopActions();
                        if (ca != null && ca.getCurrent() instanceof ActionGroupTouchBar) {
                            ((ActionGroupTouchBar)ca.getCurrent()).startUpdateTimer();
                        }
                    }

                    @Override
                    public void windowDeactivated(WindowEvent e) {
                        @Nullable ComponentActions ca = this.getTopActions();
                        if (ca != null && ca.getCurrent() instanceof ActionGroupTouchBar) {
                            ((ActionGroupTouchBar)ca.getCurrent()).stopUpdateTimer();
                        }
                    }
                });
            }
        }

        synchronized void push(@NotNull ComponentActions ca) {
            if (ca == null) {
                Stack.$$$reportNull$$$0(0);
            }
            if (!this.myStack.isEmpty() && this.myStack.peek() == ca) {
                return;
            }
            this.myStack.removeIf(other -> ca == other);
            this.myStack.push(ca);
            if (FORCE_UPDATE_ON_SHOW && ca.getCurrent() instanceof ActionGroupTouchBar) {
                ((ActionGroupTouchBar)ca.getCurrent()).updateActionItems();
            }
            this._scheduleUpdateNative();
        }

        synchronized void pop() {
            if (this.myStack.isEmpty()) {
                return;
            }
            this.myStack.poll();
            this._scheduleUpdateNative();
        }

        synchronized void removeTouchbar(@NotNull TouchBar tb) {
            if (tb == null) {
                Stack.$$$reportNull$$$0(1);
            }
            if (this.myStack.isEmpty()) {
                return;
            }
            @Nullable ComponentActions topCA = this.myStack.peek();
            @Nullable TouchBar top = topCA != null ? topCA.getCurrent() : null;
            this.myStack.removeIf(ca -> ca.getCurrent() == tb);
            if (top == tb) {
                this._scheduleUpdateNative();
            }
        }

        synchronized void updateIfNecessary() {
            if (this.myStack.isEmpty()) {
                return;
            }
            this._scheduleUpdateNative();
        }

        @Nullable
        synchronized ComponentActions getTopActions() {
            return this.myStack.isEmpty() ? null : this.myStack.peek();
        }

        private void _scheduleUpdateNative() {
            ComponentActions ca;
            if (this.myNativeUpdateTask != null) {
                this.myNativeUpdateTask.cancel();
            }
            if ((ca = this.myStack.peek()) == null) {
                this.myLastShownTouchbar = null;
                NST.setTouchBar(this.myWindow != null ? (Window)this.myWindow.get() : null, null);
                return;
            }
            if (ca.getCurrent() == null) {
                ca.setCurrent(ourLastModifiersEx);
                if (ca.getCurrent() == null) {
                    ca.setCurrent(0L);
                }
            }
            this.myNativeUpdateTask = SimpleTimer.getInstance().setUp(() -> {
                Window window;
                TouchBar tb;
                @Nullable ComponentActions topCA = this.myStack.peek();
                TouchBar touchBar = tb = topCA != null ? topCA.getCurrent() : null;
                if (tb == this.myLastShownTouchbar) {
                    return;
                }
                if (this.myLastShownTouchbar instanceof ActionGroupTouchBar) {
                    ((ActionGroupTouchBar)this.myLastShownTouchbar).stopUpdateTimer();
                }
                this.myLastShownTouchbar = tb;
                if (this.myLastShownTouchbar instanceof ActionGroupTouchBar) {
                    ActionGroupTouchBar atb = (ActionGroupTouchBar)this.myLastShownTouchbar;
                    atb.startUpdateTimer();
                    ApplicationManager.getApplication().invokeLater(atb::updateActionItems);
                }
                Window window2 = window = this.myWindow != null ? (Window)this.myWindow.get() : null;
                if (this.myLastShownTouchbar != null) {
                    this.myLastShownTouchbar.setTo(window);
                } else {
                    NST.setTouchBar(window, ID.NIL);
                }
            }, CHANGE_DELAY);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ca";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tb";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/mac/touchbar/TouchBarsManager$Stack";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "push";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeTouchbar";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ComponentActions {
        private static final Map<ActionGroup, TouchBar> ourActions2Touchbar = new WeakHashMap<ActionGroup, TouchBar>();
        @NotNull
        final WeakReference<Component> component;
        @Nullable
        final ActionGroup actions;
        @Nullable
        final Map<Long, ActionGroup> altActions;
        @Nullable
        final Customizer customizer;
        @Nullable
        final TouchBar customTouchbar;
        @Nullable
        private TouchBar current;

        ComponentActions(@NotNull Component component2, @NotNull ActionGroup actions2, @Nullable Map<Long, ActionGroup> altActions, @Nullable Customizer customizer) {
            if (component2 == null) {
                ComponentActions.$$$reportNull$$$0(0);
            }
            if (actions2 == null) {
                ComponentActions.$$$reportNull$$$0(1);
            }
            this.component = new WeakReference<Component>(component2);
            this.actions = actions2;
            this.altActions = altActions;
            this.customizer = customizer;
            this.customTouchbar = null;
        }

        ComponentActions(@NotNull Component component2, @NotNull TouchBar customTouchbar) {
            if (component2 == null) {
                ComponentActions.$$$reportNull$$$0(2);
            }
            if (customTouchbar == null) {
                ComponentActions.$$$reportNull$$$0(3);
            }
            this.component = new WeakReference<Component>(component2);
            this.actions = null;
            this.altActions = null;
            this.customizer = null;
            this.customTouchbar = customTouchbar;
        }

        boolean isPersistent() {
            return this.customizer != null && this.customizer.getCrossEscInfo() != null && this.customizer.getCrossEscInfo().persistent;
        }

        boolean isHidden() {
            return this.customizer != null && this.customizer.getCrossEscInfo() != null && this.customizer.getCrossEscInfo().persistent;
        }

        void setCurrent(long altKeyMask) {
            @Nullable TouchBar alt = this.getTouchbar(altKeyMask, false);
            if (alt != null && alt != TouchBar.EMPTY) {
                this.current = alt;
            }
        }

        @Nullable
        TouchBar getCurrent() {
            return this.current;
        }

        @Nullable
        TouchBar getTouchbar(long altKeyMask, boolean cachedOnly) {
            if (this.customTouchbar != null) {
                return this.customTouchbar;
            }
            @Nullable ActionGroup actions2 = this.getAltActions(altKeyMask);
            if (actions2 == null) {
                return null;
            }
            TouchBar tb = ourActions2Touchbar.get(actions2);
            if (tb == null && !cachedOnly) {
                Component cmp = (Component)this.component.get();
                tb = new ActionGroupTouchBar(actions2 + " | " + (cmp == null ? "disposed_component" : cmp.getClass().getSimpleName()), actions2, this.customizer);
                ourActions2Touchbar.put(actions2, tb);
            }
            return tb;
        }

        private static boolean isEmptyGroup(@NotNull ActionGroup actions2) {
            AnAction[] kids;
            if (actions2 == null) {
                ComponentActions.$$$reportNull$$$0(4);
            }
            if ((kids = actions2.getChildren(null)) == null || kids.length < 1) {
                return true;
            }
            for (AnAction kid : kids) {
                if (kid instanceof Separator) continue;
                return false;
            }
            return true;
        }

        void clearCachedTouchbars() {
            TouchBar tb;
            if (this.current != null) {
                this.current.release();
                this.current = null;
            }
            if (this.actions != null && (tb = ourActions2Touchbar.remove(this.actions)) != null) {
                tb.release();
            }
            if (this.altActions != null) {
                for (ActionGroup ag : this.altActions.values()) {
                    TouchBar tb2 = ourActions2Touchbar.remove(ag);
                    if (tb2 == null) continue;
                    tb2.release();
                }
            }
            if (this.customTouchbar != null) {
                this.customTouchbar.release();
            }
        }

        @Nullable
        ActionGroup getAltActions(long mask) {
            if (mask == 0L) {
                return this.actions;
            }
            if (this.altActions == null || this.altActions.isEmpty()) {
                return null;
            }
            return this.altActions.get(mask);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actions";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "customTouchbar";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/mac/touchbar/TouchBarsManager$ComponentActions";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEmptyGroup";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

