/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.layout.tableLayout;

import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.LayoutPassInfo;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.layout.TabsLayoutBase;
import com.intellij.ui.tabs.layout.tableLayout.TablePassInfo;
import com.intellij.ui.tabs.layout.tableLayout.TableRow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;

public class TableLayout
extends TabsLayoutBase {
    public TablePassInfo myLastTableLayout;

    private void computeLayoutTable(TablePassInfo data2) {
        Dimension size;
        TabLabel eachLabel;
        Insets insets = this.myCallback.getLayoutInsets();
        data2.toFitRec = new Rectangle(insets.left, insets.top, this.myCallback.getComponent().getWidth() - insets.left - insets.right, this.myCallback.getComponent().getHeight() - insets.top - insets.bottom);
        int eachX = data2.toFitRec.x;
        TableRow eachTableRow = new TableRow(data2);
        data2.table.add(eachTableRow);
        data2.requiredRows = 1;
        for (Object eachInfo : data2.myVisibleInfos) {
            eachLabel = this.myCallback.getTabLabel((TabInfo)eachInfo);
            size = eachLabel.getPreferredSize();
            if ((double)(eachX + size.width) >= data2.toFitRec.getMaxX()) {
                ++data2.requiredRows;
                eachX = data2.toFitRec.x;
            }
            this.layout((JComponent)eachLabel, eachX, 0, size.width, 1);
            eachX += size.width - this.myCallback.getBorderThickness();
            data2.requiredWidth += size.width - this.myCallback.getBorderThickness();
        }
        eachX = data2.toFitRec.x;
        data2.rowToFitMaxX = (int)data2.toFitRec.getMaxX();
        if (data2.requiredRows > 1) {
            int rowFit = insets.left + data2.requiredWidth / data2.requiredRows;
            for (TabInfo eachInfo : data2.myVisibleInfos) {
                TabLabel eachLabel2 = this.myCallback.getTabLabel(eachInfo);
                Rectangle eachBounds = eachLabel2.getBounds();
                if (!eachBounds.contains(rowFit, 0)) continue;
                data2.rowToFitMaxX = (int)eachLabel2.getBounds().getMaxX();
                break;
            }
        }
        for (Object eachInfo : data2.myVisibleInfos) {
            eachLabel = this.myCallback.getTabLabel((TabInfo)eachInfo);
            size = eachLabel.getPreferredSize();
            if (eachX + size.width <= data2.rowToFitMaxX) {
                eachTableRow.add((TabInfo)eachInfo);
                eachX += size.width - this.myCallback.getBorderThickness();
                continue;
            }
            eachTableRow = new TableRow(data2);
            data2.table.add(eachTableRow);
            eachX = insets.left + size.width;
            eachTableRow.add((TabInfo)eachInfo);
        }
    }

    @Override
    protected LayoutPassInfo doLayout(List<TabInfo> infosToShow, boolean isForced) {
        this.resetLayout(true);
        Insets insets = this.myCallback.getLayoutInsets();
        int eachY = insets.top;
        TablePassInfo data2 = new TablePassInfo(infosToShow, this, this.myCallback);
        if (!this.myCallback.isHiddenTabs()) {
            this.computeLayoutTable(data2);
            insets = this.myCallback.getLayoutInsets();
            eachY = insets.top;
            for (TableRow eachRow : data2.table) {
                int eachX = insets.left;
                int deltaToFit = 0;
                boolean toAjust = false;
                if (eachRow.width < data2.toFitRec.width && data2.table.size() > 1) {
                    deltaToFit = (int)Math.floor((double)(data2.toFitRec.width - eachRow.width) / (double)eachRow.myColumns.size());
                    toAjust = true;
                }
                for (int i2 = 0; i2 < eachRow.myColumns.size(); ++i2) {
                    TabInfo tabInfo = eachRow.myColumns.get(i2);
                    TabLabel label2 = this.myCallback.getTabLabel(tabInfo);
                    int width = i2 < eachRow.myColumns.size() - 1 || !toAjust ? label2.getPreferredSize().width + deltaToFit : data2.toFitRec.width + insets.left - eachX;
                    this.layout((JComponent)label2, eachX, eachY, width, data2.tabsRowHeight);
                    label2.setAlignmentToCenter(deltaToFit > 0);
                    boolean lastCell = i2 == eachRow.myColumns.size() - 1;
                    eachX += width - (lastCell ? 0 : this.myCallback.getBorderThickness());
                }
                eachY += data2.tabsRowHeight;
            }
        }
        if (this.myCallback.getSelectedInfo() != null) {
            JBTabsImpl.Toolbar selectedToolbar = this.myCallback.getToolbar(this.myCallback.getSelectedInfo());
            int componentY = eachY + (this.myCallback.isEditorTabs() ? 0 : 2) - this.myCallback.getLayoutInsets().top;
            if (!this.myCallback.isHorizontalToolbar() && selectedToolbar != null && !selectedToolbar.isEmpty()) {
                int vSeparatorWidth;
                int toolbarWidth = selectedToolbar.getPreferredSize().width;
                int n = vSeparatorWidth = toolbarWidth > 0 ? this.myCallback.getBorderThickness() : 0;
                if (this.myCallback.isToolbarBeforeTabs()) {
                    Rectangle compRect = this.layoutComp(toolbarWidth + vSeparatorWidth, componentY, this.myCallback.getSelectedInfo().getComponent(), 0, 0);
                    this.layout((JComponent)selectedToolbar, compRect.x - toolbarWidth - vSeparatorWidth, compRect.y, toolbarWidth, compRect.height);
                } else {
                    int width = this.myCallback.getComponent().getWidth() - toolbarWidth - vSeparatorWidth;
                    Rectangle compRect = this.layoutComp(new Rectangle(0, componentY, width, this.myCallback.getComponent().getHeight()), this.myCallback.getSelectedInfo().getComponent(), 0, 0);
                    this.layout((JComponent)selectedToolbar, compRect.x + compRect.width + vSeparatorWidth, compRect.y, toolbarWidth, compRect.height);
                }
            } else {
                this.layoutComp(0, componentY, this.myCallback.getSelectedInfo().getComponent(), 0, 0);
            }
        }
        data2.myExtraBorderLines.clear();
        for (TableRow row2 : data2.table) {
            if (row2.myColumns.isEmpty()) continue;
            TabInfo tabInfo = row2.myColumns.get(0);
            TabLabel tabLabel = this.myCallback.getTabLabel(tabInfo);
            Rectangle tabLabelBounds = tabLabel.getBounds();
            int y = tabLabelBounds.y + tabLabelBounds.height - this.myCallback.getBorderThickness();
            data2.myExtraBorderLines.add(new LayoutPassInfo.LineCoordinates(0, y, this.myCallback.getComponent().getSize().width, y));
        }
        this.myLastTableLayout = data2;
        return data2;
    }

    public int getDropIndexFor(Point point) {
        if (this.myLastTableLayout == null) {
            return -1;
        }
        int result2 = -1;
        Component c = this.myCallback.getComponent().getComponentAt(point);
        if (c instanceof JBTabsImpl) {
            for (int i2 = 0; i2 < this.myLastTableLayout.myVisibleInfos.size() - 1; ++i2) {
                boolean between;
                TabLabel first = this.myCallback.getTabLabel((TabInfo)this.myLastTableLayout.myVisibleInfos.get(i2));
                TabLabel second = this.myCallback.getTabLabel((TabInfo)this.myLastTableLayout.myVisibleInfos.get(i2 + 1));
                Rectangle firstBounds = first.getBounds();
                Rectangle secondBounds = second.getBounds();
                boolean bl = between = firstBounds.getMaxX() < (double)point.x && secondBounds.getX() > (double)point.x && firstBounds.y < point.y && secondBounds.getMaxY() > (double)point.y;
                if (!between) continue;
                c = first;
                break;
            }
        }
        if (c instanceof TabLabel) {
            TabInfo info2 = ((TabLabel)c).getInfo();
            int index2 = this.myLastTableLayout.myVisibleInfos.indexOf(info2);
            boolean isDropTarget = this.myCallback.isDropTarget(info2);
            if (!isDropTarget) {
                for (int i3 = 0; i3 <= index2; ++i3) {
                    if (!this.myCallback.isDropTarget((TabInfo)this.myLastTableLayout.myVisibleInfos.get(i3))) continue;
                    --index2;
                    break;
                }
                result2 = index2;
            } else if (index2 < this.myLastTableLayout.myVisibleInfos.size()) {
                result2 = index2;
            }
        }
        return result2;
    }

    public boolean isSingleRow() {
        return false;
    }

    @Override
    public boolean isDragOut(TabLabel tabLabel, int deltaX, int deltaY) {
        if (this.myLastTableLayout == null) {
            return super.isDragOut(tabLabel, deltaX, deltaY);
        }
        Rectangle area = new Rectangle(this.myLastTableLayout.toFitRec.width, tabLabel.getBounds().height);
        for (int i2 = 0; i2 < this.myLastTableLayout.myVisibleInfos.size(); ++i2) {
            area = area.union(this.myCallback.getTabLabel((TabInfo)this.myLastTableLayout.myVisibleInfos.get(i2)).getBounds());
        }
        return (double)Math.abs(deltaY) > (double)area.height * this.getDragOutMultiplier();
    }
}

