/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.util.SlowOperations;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTreeNodeVisitor<T>
implements TreeVisitor {
    protected static final Logger LOG = Logger.getInstance(AbstractTreeNodeVisitor.class);
    private final Supplier<? extends T> supplier;
    private final Predicate<? super TreePath> predicate;

    public AbstractTreeNodeVisitor(@NotNull Supplier<? extends T> supplier2, @Nullable Predicate<? super TreePath> predicate2) {
        if (supplier2 == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(0);
        }
        this.supplier = supplier2;
        this.predicate = predicate2;
    }

    @Nullable
    public final T getElement() {
        return this.supplier.get();
    }

    @NotNull
    public TreeVisitor.Action visit(@NotNull TreePath path2) {
        T element2;
        if (path2 == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(1);
        }
        if (LOG.isTraceEnabled()) {
            LOG.debug("process ", new Object[]{path2});
        }
        if ((element2 = this.getElement()) == null) {
            TreeVisitor.Action action2 = TreeVisitor.Action.SKIP_SIBLINGS;
            if (action2 == null) {
                AbstractTreeNodeVisitor.$$$reportNull$$$0(2);
            }
            return action2;
        }
        Object component2 = path2.getLastPathComponent();
        if (component2 instanceof AbstractTreeNode) {
            TreeVisitor.Action action3 = this.visit(path2, (AbstractTreeNode)component2, element2);
            if (action3 == null) {
                AbstractTreeNodeVisitor.$$$reportNull$$$0(3);
            }
            return action3;
        }
        if (component2 instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)component2;
            Object object = node2.getUserObject();
            if (object instanceof AbstractTreeNode) {
                TreeVisitor.Action action4 = this.visit(path2, (AbstractTreeNode)object, element2);
                if (action4 == null) {
                    AbstractTreeNodeVisitor.$$$reportNull$$$0(4);
                }
                return action4;
            }
            if (object instanceof String) {
                LOG.debug("ignore children: ", new Object[]{object});
            } else {
                LOG.warn((String)(object == null ? "no object" : "unexpected object " + object.getClass()));
            }
        } else if (component2 instanceof String) {
            LOG.debug("ignore children: ", new Object[]{component2});
        } else {
            LOG.warn((String)(component2 == null ? "no component" : "unexpected component " + component2.getClass()));
        }
        TreeVisitor.Action action5 = TreeVisitor.Action.SKIP_CHILDREN;
        if (action5 == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(5);
        }
        return action5;
    }

    @NotNull
    protected TreeVisitor.Action visit(@NotNull TreePath path2, @NotNull AbstractTreeNode node2, @NotNull T element2) {
        if (path2 == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(6);
        }
        if (node2 == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(7);
        }
        if (element2 == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(8);
        }
        if (this.matches(node2, element2)) {
            LOG.debug("found ", new Object[]{path2});
            if (this.predicate == null) {
                TreeVisitor.Action action2 = TreeVisitor.Action.INTERRUPT;
                if (action2 == null) {
                    AbstractTreeNodeVisitor.$$$reportNull$$$0(9);
                }
                return action2;
            }
            if (this.predicate.test(path2)) {
                TreeVisitor.Action action3 = TreeVisitor.Action.CONTINUE;
                if (action3 == null) {
                    AbstractTreeNodeVisitor.$$$reportNull$$$0(10);
                }
                return action3;
            }
        } else if (this.contains(node2, element2)) {
            LOG.debug("visit ", new Object[]{path2});
            TreeVisitor.Action action4 = TreeVisitor.Action.CONTINUE;
            if (action4 == null) {
                AbstractTreeNodeVisitor.$$$reportNull$$$0(11);
            }
            return action4;
        }
        TreeVisitor.Action action5 = TreeVisitor.Action.SKIP_CHILDREN;
        if (action5 == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(12);
        }
        return action5;
    }

    protected boolean matches(@NotNull AbstractTreeNode node2, @NotNull T element2) {
        if (node2 == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(13);
        }
        if (element2 == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(14);
        }
        return (Boolean)SlowOperations.allowSlowOperations(() -> node2.canRepresent(element2));
    }

    protected boolean contains(@NotNull AbstractTreeNode node2, @NotNull T element2) {
        T content2;
        if (node2 == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(15);
        }
        if (element2 == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(16);
        }
        return (content2 = this.getContent(node2)) != null && this.isAncestor(content2, element2);
    }

    protected T getContent(@NotNull AbstractTreeNode node2) {
        if (node2 == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(17);
        }
        return null;
    }

    protected boolean isAncestor(@NotNull T content2, @NotNull T element2) {
        if (content2 == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(18);
        }
        if (element2 == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(19);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tree/AbstractTreeNodeVisitor";
                break;
            }
            case 7: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 8: 
            case 14: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tree/AbstractTreeNodeVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "visit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "visit";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getContent";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

