/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.tree.AbstractTreeWalker;
import com.intellij.ui.tree.ChildrenProvider;
import com.intellij.ui.tree.LeafState;
import com.intellij.ui.tree.Searchable;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.ui.tree.AbstractTreeModel;
import com.intellij.util.ui.tree.TreeModelAdapter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class AsyncTreeModel
extends AbstractTreeModel
implements Searchable,
TreeVisitor.Acceptor {
    private static final Logger LOG = Logger.getInstance(AsyncTreeModel.class);
    private final Invoker foreground;
    private final Invoker background;
    private final Tree tree;
    private final TreeModel model;
    private final boolean showLoadingNode;
    private final TreeModelListener listener;

    public AsyncTreeModel(@NotNull TreeModel model2, @NotNull Disposable parent) {
        if (model2 == null) {
            AsyncTreeModel.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            AsyncTreeModel.$$$reportNull$$$0(1);
        }
        this(model2, true, parent);
    }

    public AsyncTreeModel(@NotNull TreeModel model2, boolean showLoadingNode, @NotNull Disposable parent) {
        if (model2 == null) {
            AsyncTreeModel.$$$reportNull$$$0(2);
        }
        if (parent == null) {
            AsyncTreeModel.$$$reportNull$$$0(3);
        }
        this.tree = new Tree();
        this.listener = new TreeModelAdapter(){

            protected void process(@NotNull TreeModelEvent event, @NotNull TreeModelAdapter.EventType type) {
                TreePath path2;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (type == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((path2 = event.getTreePath()) == null) {
                    AsyncTreeModel.this.submit(new CmdGetRoot("Reload root", null));
                    return;
                }
                Object object = path2.getLastPathComponent();
                if (object == null) {
                    LOG.warn("unsupported path: " + path2);
                    return;
                }
                if (path2.getParentPath() == null && type == TreeModelAdapter.EventType.StructureChanged) {
                    AsyncTreeModel.this.submit(new CmdGetRoot("Update root", object));
                    return;
                }
                AsyncTreeModel.this.onValidThread(() -> {
                    Node node2 = AsyncTreeModel.this.tree.map.get(object);
                    if (node2 == null) {
                        if (LOG.isTraceEnabled()) {
                            LOG.debug("ignore updating of nonexistent node: ", new Object[]{object});
                        }
                    } else if (type == TreeModelAdapter.EventType.NodesChanged) {
                        AsyncTreeModel.this.treeNodesChanged(event.getTreePath(), event.getChildIndices(), event.getChildren());
                    } else if (node2.isLoadingRequired()) {
                        AsyncTreeModel.this.treeNodesChanged(event.getTreePath(), null, null);
                    } else if (type == TreeModelAdapter.EventType.NodesInserted) {
                        AsyncTreeModel.this.submit(new CmdGetChildren("Insert children", node2, false));
                    } else if (type == TreeModelAdapter.EventType.NodesRemoved) {
                        AsyncTreeModel.this.submit(new CmdGetChildren("Remove children", node2, false));
                    } else {
                        AsyncTreeModel.this.submit(new CmdGetChildren("Update children", node2, true));
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ui/tree/AsyncTreeModel$1";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (model2 instanceof Disposable) {
            Disposer.register((Disposable)this, (Disposable)((Disposable)model2));
        }
        this.foreground = Invoker.forEventDispatchThread((Disposable)this);
        if (model2 instanceof InvokerSupplier) {
            InvokerSupplier supplier2 = (InvokerSupplier)((Object)model2);
            this.background = supplier2.getInvoker();
        } else {
            this.background = this.foreground;
        }
        this.model = model2;
        this.model.addTreeModelListener(this.listener);
        this.showLoadingNode = showLoadingNode;
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    public void dispose() {
        super.dispose();
        this.model.removeTreeModelListener(this.listener);
    }

    @Override
    @NotNull
    public Promise<TreePath> getTreePath(Object object) {
        if (this.disposed) {
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                AsyncTreeModel.$$$reportNull$$$0(4);
            }
            return promise;
        }
        return this.resolve(this.model instanceof Searchable ? ((Searchable)((Object)this.model)).getTreePath(object) : null);
    }

    @NotNull
    public Promise<TreePath> resolve(TreePath path2) {
        AsyncPromise async = new AsyncPromise();
        this.onValidThread(() -> this.resolve((AsyncPromise<? super TreePath>)async, path2));
        AsyncPromise asyncPromise = async;
        if (asyncPromise == null) {
            AsyncTreeModel.$$$reportNull$$$0(5);
        }
        return asyncPromise;
    }

    @NotNull
    private Promise<TreePath> resolve(Promise<? extends TreePath> promise) {
        if (promise == null && this.isValidThread()) {
            Promise promise2 = Promises.rejectedPromise();
            if (promise2 == null) {
                AsyncTreeModel.$$$reportNull$$$0(6);
            }
            return promise2;
        }
        AsyncPromise async = new AsyncPromise();
        if (promise == null) {
            this.onValidThread(() -> async.setError("rejected"));
        } else {
            promise.onError(this.onValidThread(arg_0 -> ((AsyncPromise)async).setError(arg_0)));
            promise.onSuccess(this.onValidThread((? super T path2) -> this.resolve((AsyncPromise<? super TreePath>)async, (TreePath)path2)));
        }
        AsyncPromise asyncPromise = async;
        if (asyncPromise == null) {
            AsyncTreeModel.$$$reportNull$$$0(7);
        }
        return asyncPromise;
    }

    private void resolve(@NotNull AsyncPromise<? super TreePath> async, TreePath path2) {
        if (async == null) {
            AsyncTreeModel.$$$reportNull$$$0(8);
        }
        if (LOG.isTraceEnabled()) {
            LOG.debug("resolve path: ", new Object[]{path2});
        }
        if (path2 == null) {
            async.setError("path is null");
            return;
        }
        Object object = path2.getLastPathComponent();
        if (object == null) {
            async.setError("path is wrong");
            return;
        }
        this.accept((TreeVisitor)new TreeVisitor.ByTreePath(path2, o -> o)).onProcessed(result2 -> {
            if (result2 == null) {
                async.setError("path not found");
                return;
            }
            async.setResult(result2);
        });
    }

    public Object getRoot() {
        if (this.disposed) {
            return null;
        }
        this.onValidThread(this::promiseRootEntry);
        Node node2 = this.tree.root;
        return node2 == null ? null : node2.object;
    }

    public Object getChild(Object object, int index2) {
        List<Node> children2 = this.getEntryChildren(object);
        return 0 <= index2 && index2 < children2.size() ? children2.get((int)index2).object : null;
    }

    public int getChildCount(Object object) {
        return this.getEntryChildren(object).size();
    }

    public boolean isLeaf(Object object) {
        List<Node> children2;
        Node node2 = this.getEntry(object);
        if (node2 == null) {
            return true;
        }
        if (node2.leafState == LeafState.ALWAYS) {
            return true;
        }
        if (node2.leafState == LeafState.NEVER) {
            return false;
        }
        if (node2.leafState == LeafState.ASYNC && node2.children == null) {
            this.promiseChildren(node2);
        }
        return (children2 = node2.children) != null && children2.isEmpty();
    }

    public void valueForPathChanged(@NotNull TreePath path2, Object value2) {
        if (path2 == null) {
            AsyncTreeModel.$$$reportNull$$$0(9);
        }
        this.background.invoke(() -> this.model.valueForPathChanged(path2, value2));
    }

    public int getIndexOfChild(Object object, Object child2) {
        if (child2 != null) {
            List<Node> children2 = this.getEntryChildren(object);
            for (int i2 = 0; i2 < children2.size(); ++i2) {
                if (!child2.equals(children2.get((int)i2).object)) continue;
                return i2;
            }
        }
        return -1;
    }

    @NotNull
    public Promise<TreePath> accept(@NotNull TreeVisitor visitor) {
        if (visitor == null) {
            AsyncTreeModel.$$$reportNull$$$0(10);
        }
        Promise<TreePath> promise = this.accept(visitor, true);
        if (promise == null) {
            AsyncTreeModel.$$$reportNull$$$0(11);
        }
        return promise;
    }

    @NotNull
    public Promise<TreePath> accept(@NotNull TreeVisitor visitor, final boolean allowLoading) {
        if (visitor == null) {
            AsyncTreeModel.$$$reportNull$$$0(12);
        }
        AbstractTreeWalker<Node> walker = new AbstractTreeWalker<Node>(visitor, node2 -> node2.object){

            @Override
            protected Collection<Node> getChildren(@NotNull Node node2) {
                if (node2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (node2.leafState == LeafState.ALWAYS || !allowLoading) {
                    return node2.getChildren();
                }
                AsyncTreeModel.this.promiseChildren(node2).onSuccess(parent -> this.setChildren(parent.getChildren())).onError(this::setError);
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/ui/tree/AsyncTreeModel$2", "getChildren"));
            }
        };
        if (allowLoading) {
            this.background.invokeLater(() -> this.onValidThread(() -> this.promiseRootEntry().onSuccess(walker::start).onError(walker::setError)));
        } else {
            this.onValidThread(() -> walker.start(this.tree.root));
        }
        Promise<TreePath> promise = walker.promise();
        if (promise == null) {
            AsyncTreeModel.$$$reportNull$$$0(13);
        }
        return promise;
    }

    public boolean isProcessing() {
        if (this.foreground.getTaskCount() > 0) {
            return true;
        }
        if (this.background.getTaskCount() > 0) {
            return true;
        }
        CmdGetRoot command = this.tree.queue.get();
        return command != null && command.isPending();
    }

    private void submit(@NotNull Command command) {
        if (command == null) {
            AsyncTreeModel.$$$reportNull$$$0(14);
        }
        this.background.compute(command).onSuccess(value2 -> this.foreground.invoke(() -> command.accept((Node)value2)));
    }

    private boolean isValidThread() {
        if (this.foreground.isValidThread()) {
            return true;
        }
        LOG.warn((Throwable)new IllegalStateException("AsyncTreeModel is used from unexpected thread"));
        return false;
    }

    public void onValidThread(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            AsyncTreeModel.$$$reportNull$$$0(15);
        }
        this.foreground.invoke(runnable2);
    }

    @NotNull
    private <T> Consumer<T> onValidThread(@NotNull Consumer<? super T> consumer2) {
        if (consumer2 == null) {
            AsyncTreeModel.$$$reportNull$$$0(16);
        }
        Consumer<Object> consumer3 = value2 -> this.onValidThread(() -> consumer2.accept(value2));
        if (consumer3 == null) {
            AsyncTreeModel.$$$reportNull$$$0(17);
        }
        return consumer3;
    }

    @NotNull
    private Promise<Node> promiseRootEntry() {
        if (this.disposed) {
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                AsyncTreeModel.$$$reportNull$$$0(18);
            }
            return promise;
        }
        Promise<Node> promise = this.tree.queue.promise(this::submit, () -> new CmdGetRoot("Load root", null));
        if (promise == null) {
            AsyncTreeModel.$$$reportNull$$$0(19);
        }
        return promise;
    }

    @NotNull
    private Promise<Node> promiseChildren(@NotNull Node node2) {
        if (node2 == null) {
            AsyncTreeModel.$$$reportNull$$$0(20);
        }
        if (this.disposed) {
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                AsyncTreeModel.$$$reportNull$$$0(21);
            }
            return promise;
        }
        Promise<Node> promise = node2.queue.promise(this::submit, () -> {
            node2.setLoading(!this.showLoadingNode ? null : new Node(new LoadingNode(), LeafState.ALWAYS));
            return new CmdGetChildren("Load children", node2, false);
        });
        if (promise == null) {
            AsyncTreeModel.$$$reportNull$$$0(22);
        }
        return promise;
    }

    private Node getEntry(Object object) {
        return this.disposed || object == null || !this.isValidThread() ? null : this.tree.map.get(object);
    }

    @NotNull
    private List<Node> getEntryChildren(Object object) {
        Node node2 = this.getEntry(object);
        if (node2 == null) {
            List<Node> list2 = Collections.emptyList();
            if (list2 == null) {
                AsyncTreeModel.$$$reportNull$$$0(23);
            }
            return list2;
        }
        if (node2.isLoadingRequired()) {
            this.promiseChildren(node2);
        }
        List<Node> list3 = node2.getChildren();
        if (list3 == null) {
            AsyncTreeModel.$$$reportNull$$$0(24);
        }
        return list3;
    }

    @NotNull
    private TreeModelEvent createEvent(@NotNull TreePath path2, Map<Object, Integer> map2) {
        if (path2 == null) {
            AsyncTreeModel.$$$reportNull$$$0(25);
        }
        if (map2 == null || map2.isEmpty()) {
            return new TreeModelEvent((Object)this, path2, null, null);
        }
        int i2 = 0;
        int size = map2.size();
        int[] indices = new int[size];
        Object[] children2 = new Object[size];
        for (Map.Entry<Object, Integer> entry2 : map2.entrySet()) {
            indices[i2] = entry2.getValue();
            children2[i2] = entry2.getKey();
            ++i2;
        }
        return new TreeModelEvent((Object)this, path2, indices, children2);
    }

    private void treeNodesChanged(@NotNull Node node2, Map<Object, Integer> map2) {
        if (node2 == null) {
            AsyncTreeModel.$$$reportNull$$$0(26);
        }
        if (!this.listeners.isEmpty()) {
            for (TreePath path2 : node2.paths) {
                this.listeners.treeNodesChanged(this.createEvent(path2, map2));
            }
        }
    }

    private void treeNodesInserted(@NotNull Node node2, Map<Object, Integer> map2) {
        if (node2 == null) {
            AsyncTreeModel.$$$reportNull$$$0(27);
        }
        if (!this.listeners.isEmpty()) {
            for (TreePath path2 : node2.paths) {
                this.listeners.treeNodesInserted(this.createEvent(path2, map2));
            }
        }
    }

    private void treeNodesRemoved(@NotNull Node node2, Map<Object, Integer> map2) {
        if (node2 == null) {
            AsyncTreeModel.$$$reportNull$$$0(28);
        }
        if (!this.listeners.isEmpty()) {
            for (TreePath path2 : node2.paths) {
                this.listeners.treeNodesRemoved(this.createEvent(path2, map2));
            }
        }
    }

    @NotNull
    private static LinkedHashMap<Object, Integer> getIndices(@NotNull List<Node> children2, @Nullable ToIntFunction<? super Node> function) {
        if (children2 == null) {
            AsyncTreeModel.$$$reportNull$$$0(29);
        }
        LinkedHashMap<Object, Integer> map2 = new LinkedHashMap<Object, Integer>();
        for (int i2 = 0; i2 < children2.size(); ++i2) {
            Node child2 = children2.get(i2);
            if (map2.containsKey(child2.object)) {
                LOG.warn("ignore duplicated " + (function == null ? "old" : "new") + " child at " + i2);
                continue;
            }
            map2.put(child2.object, function == null ? i2 : function.applyAsInt(child2));
        }
        LinkedHashMap<Object, Integer> linkedHashMap = map2;
        if (linkedHashMap == null) {
            AsyncTreeModel.$$$reportNull$$$0(30);
        }
        return linkedHashMap;
    }

    private static int getIntersectionCount(@NotNull Map<Object, Integer> indices, @NotNull Iterable<Object> objects) {
        if (indices == null) {
            AsyncTreeModel.$$$reportNull$$$0(31);
        }
        if (objects == null) {
            AsyncTreeModel.$$$reportNull$$$0(32);
        }
        int count = 0;
        int last = -1;
        for (Object object : objects) {
            Integer index2 = indices.get(object);
            if (index2 == null || last >= index2) continue;
            last = index2;
            ++count;
        }
        return count;
    }

    @NotNull
    private static List<Object> getIntersection(@NotNull Map<Object, Integer> indices, @NotNull Iterable<Object> objects) {
        if (indices == null) {
            AsyncTreeModel.$$$reportNull$$$0(33);
        }
        if (objects == null) {
            AsyncTreeModel.$$$reportNull$$$0(34);
        }
        ArrayList<Object> list2 = new ArrayList<Object>(indices.size());
        int last = -1;
        for (Object object : objects) {
            Integer index2 = indices.get(object);
            if (index2 == null || last >= index2) continue;
            last = index2;
            list2.add(object);
        }
        ArrayList<Object> arrayList = list2;
        if (arrayList == null) {
            AsyncTreeModel.$$$reportNull$$$0(35);
        }
        return arrayList;
    }

    @NotNull
    private static List<Object> getIntersection(@NotNull Map<Object, Integer> removed, @NotNull Map<Object, Integer> inserted) {
        int countTwo;
        if (removed == null) {
            AsyncTreeModel.$$$reportNull$$$0(36);
        }
        if (inserted == null) {
            AsyncTreeModel.$$$reportNull$$$0(37);
        }
        if (removed.isEmpty() || inserted.isEmpty()) {
            List<Object> list2 = Collections.emptyList();
            if (list2 == null) {
                AsyncTreeModel.$$$reportNull$$$0(38);
            }
            return list2;
        }
        int countOne = AsyncTreeModel.getIntersectionCount(removed, inserted.keySet());
        if (countOne > (countTwo = AsyncTreeModel.getIntersectionCount(inserted, removed.keySet()))) {
            return AsyncTreeModel.getIntersection(removed, inserted.keySet());
        }
        if (countTwo > 0) {
            return AsyncTreeModel.getIntersection(inserted, removed.keySet());
        }
        List<Object> list3 = Collections.emptyList();
        if (list3 == null) {
            AsyncTreeModel.$$$reportNull$$$0(39);
        }
        return list3;
    }

    protected void treeStructureChanged(TreePath path2, int[] indices, Object[] children2) {
        try {
            super.treeStructureChanged(path2, indices, children2);
        }
        catch (Throwable throwable) {
            LOG.error("custom model: " + this.model, throwable);
        }
    }

    public void treeStructureChanged(TreePath path2) {
        this.treeStructureChanged(path2, null, null);
    }

    protected void treeNodesChanged(TreePath path2, int[] indices, Object[] children2) {
        try {
            super.treeNodesChanged(path2, indices, children2);
        }
        catch (Throwable throwable) {
            LOG.error("custom model: " + this.model, throwable);
        }
    }

    public void treeNodesChanged(TreePath path2) {
        this.treeNodesChanged(path2, null, null);
    }

    protected void treeNodesInserted(TreePath path2, int[] indices, Object[] children2) {
        try {
            super.treeNodesInserted(path2, indices, children2);
        }
        catch (Throwable throwable) {
            LOG.error("custom model: " + this.model, throwable);
        }
    }

    public void treeNodesInserted(TreePath path2) {
        this.treeNodesInserted(path2, null, null);
    }

    protected void treeNodesRemoved(TreePath path2, int[] indices, Object[] children2) {
        try {
            super.treeNodesRemoved(path2, indices, children2);
        }
        catch (Throwable throwable) {
            LOG.error("custom model: " + this.model, throwable);
        }
    }

    public void treeNodesRemoved(TreePath path2) {
        this.treeNodesRemoved(path2, null, null);
    }

    @Deprecated
    public void setRootImmediately(@NotNull Object object) {
        if (object == null) {
            AsyncTreeModel.$$$reportNull$$$0(40);
        }
        Node node2 = new Node(object, LeafState.NEVER);
        node2.insertPath(new TreePath(object));
        this.tree.root = node2;
        this.tree.map.put(object, node2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 30: 
            case 35: 
            case 38: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 30: 
            case 35: 
            case 38: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 30: 
            case 35: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tree/AsyncTreeModel";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "async";
                break;
            }
            case 9: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 20: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indices";
                break;
            }
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removed";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inserted";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tree/AsyncTreeModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreePath";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "accept";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "onValidThread";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "promiseRootEntry";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "promiseChildren";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntryChildren";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndices";
                break;
            }
            case 35: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntersection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 30: 
            case 35: 
            case 38: 
            case 39: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "valueForPathChanged";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "submit";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "onValidThread";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "promiseChildren";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createEvent";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "treeNodesChanged";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "treeNodesInserted";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "treeNodesRemoved";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getIndices";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getIntersectionCount";
                break;
            }
            case 33: 
            case 34: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getIntersection";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "setRootImmediately";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 30: 
            case 35: 
            case 38: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Node {
        private final CommandQueue<CmdGetChildren> queue;
        private final Set<TreePath> paths;
        private volatile Object object;
        private volatile LeafState leafState;
        @Nullable
        private volatile List<Node> children;
        private volatile Node loading;

        private Node(@NotNull Object object, @NotNull LeafState leafState) {
            if (object == null) {
                Node.$$$reportNull$$$0(0);
            }
            if (leafState == null) {
                Node.$$$reportNull$$$0(1);
            }
            this.queue = new CommandQueue();
            this.paths = new SmartHashSet();
            this.object = object;
            this.leafState = leafState;
        }

        private void setLeafState(@NotNull LeafState leafState) {
            if (leafState == null) {
                Node.$$$reportNull$$$0(2);
            }
            this.leafState = leafState;
            this.children = leafState == LeafState.ALWAYS ? null : Collections.emptyList();
            this.loading = null;
        }

        private void setChildren(@NotNull List<Node> children2) {
            if (children2 == null) {
                Node.$$$reportNull$$$0(3);
            }
            this.leafState = LeafState.NEVER;
            this.children = children2;
            this.loading = null;
        }

        private void setLoading(Node loading) {
            this.leafState = LeafState.NEVER;
            this.children = loading != null ? Collections.singletonList(loading) : Collections.emptyList();
            this.loading = loading;
        }

        private boolean isLoadingRequired() {
            return this.leafState != LeafState.ALWAYS && this.children == null;
        }

        @NotNull
        private List<Node> getChildren() {
            List<Node> list2 = this.children;
            List<Node> list3 = list2 != null ? list2 : Collections.emptyList();
            if (list3 == null) {
                Node.$$$reportNull$$$0(4);
            }
            return list3;
        }

        private void forEachChildExceptLoading(Consumer<? super Node> consumer2) {
            for (Node node2 : this.getChildren()) {
                if (node2 == this.loading) continue;
                consumer2.accept(node2);
            }
        }

        private void insertPath(@NotNull TreePath path2) {
            if (path2 == null) {
                Node.$$$reportNull$$$0(5);
            }
            if (!this.paths.add(path2)) {
                LOG.warn("node is already attached to " + path2);
            }
            this.forEachChildExceptLoading(child2 -> child2.insertPath(path2.pathByAddingChild(child2.object)));
        }

        private void insertMapping(Node parent) {
            if (parent == null) {
                this.insertPath(new TreePath(this.object));
            } else if (parent.loading == this) {
                LOG.warn("insert loading node unexpectedly");
            } else if (parent.paths.isEmpty()) {
                LOG.warn("insert to invalid parent");
            } else {
                parent.paths.forEach(path2 -> this.insertPath(path2.pathByAddingChild(this.object)));
            }
        }

        private void removePath(@NotNull TreePath path2) {
            if (path2 == null) {
                Node.$$$reportNull$$$0(6);
            }
            if (!this.paths.remove(path2)) {
                LOG.warn("node is not attached to " + path2);
            }
            this.forEachChildExceptLoading(child2 -> child2.removePath(path2.pathByAddingChild(child2.object)));
        }

        private void removeMapping(Node parent, @NotNull Tree tree) {
            if (tree == null) {
                Node.$$$reportNull$$$0(7);
            }
            if (parent == null) {
                this.removePath(new TreePath(this.object));
                tree.removeEmpty(this);
            } else if (parent.loading == this) {
                parent.loading = null;
            } else if (parent.paths.isEmpty()) {
                LOG.warn("remove from invalid parent");
            } else {
                parent.paths.forEach(path2 -> this.removePath(path2.pathByAddingChild(this.object)));
                tree.removeEmpty(this);
            }
        }

        private void updatePaths(@NotNull Object oldObject, @NotNull Object newObject) {
            if (oldObject == null) {
                Node.$$$reportNull$$$0(8);
            }
            if (newObject == null) {
                Node.$$$reportNull$$$0(9);
            }
            if (this.paths.stream().anyMatch(path2 -> Node.contains(path2, oldObject))) {
                List updated = ContainerUtil.map(this.paths, path2 -> Node.update(path2, oldObject, newObject));
                this.paths.clear();
                this.paths.addAll(updated);
                this.forEachChildExceptLoading(child2 -> child2.updatePaths(oldObject, newObject));
            }
        }

        @NotNull
        private static TreePath update(@NotNull TreePath path2, @NotNull Object oldObject, @NotNull Object newObject) {
            if (path2 == null) {
                Node.$$$reportNull$$$0(10);
            }
            if (oldObject == null) {
                Node.$$$reportNull$$$0(11);
            }
            if (newObject == null) {
                Node.$$$reportNull$$$0(12);
            }
            if (!Node.contains(path2, oldObject)) {
                TreePath treePath = path2;
                if (treePath == null) {
                    Node.$$$reportNull$$$0(13);
                }
                return treePath;
            }
            if (LOG.isTraceEnabled()) {
                LOG.debug("update path: ", new Object[]{path2});
            }
            Object[] objects = TreePathUtil.convertTreePathToArray(path2);
            for (int i2 = 0; i2 < objects.length; ++i2) {
                if (oldObject != objects[i2]) continue;
                objects[i2] = newObject;
            }
            TreePath treePath = TreePathUtil.convertArrayToTreePath(objects);
            if (treePath == null) {
                Node.$$$reportNull$$$0(14);
            }
            return treePath;
        }

        private static boolean contains(@NotNull TreePath path2, @NotNull Object object) {
            if (path2 == null) {
                Node.$$$reportNull$$$0(15);
            }
            if (object == null) {
                Node.$$$reportNull$$$0(16);
            }
            while (object != path2.getLastPathComponent()) {
                if ((path2 = path2.getParentPath()) != null) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 13: 
                case 14: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 13: 
                case 14: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "leafState";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "children";
                    break;
                }
                case 4: 
                case 13: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/tree/AsyncTreeModel$Node";
                    break;
                }
                case 5: 
                case 6: 
                case 10: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 8: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldObject";
                    break;
                }
                case 9: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newObject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/tree/AsyncTreeModel$Node";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "update";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setLeafState";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setChildren";
                    break;
                }
                case 4: 
                case 13: 
                case 14: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "insertPath";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "removePath";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "removeMapping";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "updatePaths";
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 13: 
                case 14: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class Tree {
        private final CommandQueue<CmdGetRoot> queue = new CommandQueue();
        private final Map<Object, Node> map = new HashMap<Object, Node>();
        private volatile Node root;

        private Tree() {
        }

        private void removeEmpty(@NotNull Node child2) {
            if (child2 == null) {
                Tree.$$$reportNull$$$0(0);
            }
            child2.forEachChildExceptLoading(this::removeEmpty);
            if (child2.paths.isEmpty()) {
                child2.queue.close();
                Node node2 = this.map.remove(child2.object);
                if (node2 != child2) {
                    LOG.warn("invalid node: " + child2.object);
                    if (node2 != null) {
                        this.map.put(node2.object, node2);
                    }
                }
            }
        }

        private void fixEqualButNotSame(@NotNull Node node2, @NotNull Object object) {
            if (node2 == null) {
                Tree.$$$reportNull$$$0(1);
            }
            if (object == null) {
                Tree.$$$reportNull$$$0(2);
            }
            if (object == node2.object) {
                return;
            }
            this.map.remove(node2.object);
            node2.updatePaths(node2.object, object);
            node2.object = object;
            this.map.put(object, node2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/tree/AsyncTreeModel$Tree";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeEmpty";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fixEqualButNotSame";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class CommandQueue<T extends Command> {
        private final Deque<T> deque = new ArrayDeque<T>();
        private volatile boolean closed;

        private CommandQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        T get() {
            Deque<T> deque = this.deque;
            synchronized (deque) {
                return (T)((Command)this.deque.peekFirst());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NotNull
        Promise<Node> promise(@NotNull Consumer<? super Command> submitter, @NotNull Supplier<? extends T> supplier2) {
            Command command;
            if (submitter == null) {
                CommandQueue.$$$reportNull$$$0(0);
            }
            if (supplier2 == null) {
                CommandQueue.$$$reportNull$$$0(1);
            }
            Deque<T> deque = this.deque;
            synchronized (deque) {
                command = (Command)this.deque.peekFirst();
                if (command != null) {
                    AsyncPromise<Node> asyncPromise = command.promise;
                    // MONITOREXIT @DISABLED, blocks:[2, 5] lbl10 : MonitorExitStatement: MONITOREXIT : var4_3
                    if (asyncPromise == null) {
                        CommandQueue.$$$reportNull$$$0(2);
                    }
                    return asyncPromise;
                }
                command = (Command)supplier2.get();
            }
            submitter.accept(command);
            AsyncPromise<Node> asyncPromise = command.promise;
            if (asyncPromise == null) {
                CommandQueue.$$$reportNull$$$0(3);
            }
            return asyncPromise;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(@NotNull T command, @NotNull Predicate<? super T> predicate2) {
            if (command == null) {
                CommandQueue.$$$reportNull$$$0(4);
            }
            if (predicate2 == null) {
                CommandQueue.$$$reportNull$$$0(5);
            }
            Deque<T> deque = this.deque;
            synchronized (deque) {
                boolean add2;
                if (this.closed) {
                    return;
                }
                Command old = (Command)this.deque.peekFirst();
                boolean bl = add2 = old == null || predicate2.test(old);
                if (add2) {
                    this.deque.addFirst(command);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void done(@NotNull T command, Node node2) {
            Iterable<AsyncPromise<Node>> promises;
            if (command == null) {
                CommandQueue.$$$reportNull$$$0(6);
            }
            Deque<T> deque = this.deque;
            synchronized (deque) {
                if (this.closed) {
                    return;
                }
                if (!this.deque.contains(command)) {
                    return;
                }
                promises = this.getPromises(command);
                if (this.deque.isEmpty()) {
                    this.deque.addLast(command);
                }
            }
            promises.forEach(promise -> promise.setResult((Object)node2));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            Iterable<AsyncPromise<Node>> promises;
            Deque<T> deque = this.deque;
            synchronized (deque) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                if (this.deque.isEmpty()) {
                    return;
                }
                promises = this.getPromises(null);
            }
            promises.forEach(promise -> promise.setError("cancel loading"));
        }

        @NotNull
        private Iterable<AsyncPromise<Node>> getPromises(T command) {
            Command last;
            ArrayList<AsyncPromise<Node>> list2 = new ArrayList<AsyncPromise<Node>>();
            while ((last = (Command)this.deque.pollLast()) != null) {
                if (last.isPending()) {
                    list2.add(last.promise);
                }
                if (!last.equals(command)) continue;
                break;
            }
            ArrayList<AsyncPromise<Node>> arrayList = list2;
            if (arrayList == null) {
                CommandQueue.$$$reportNull$$$0(7);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "submitter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "supplier";
                    break;
                }
                case 2: 
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/tree/AsyncTreeModel$CommandQueue";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "predicate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/tree/AsyncTreeModel$CommandQueue";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "promise";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPromises";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "promise";
                    break;
                }
                case 2: 
                case 3: 
                case 7: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "done";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class CmdGetChildren
    extends Command {
        private final Node node;
        private volatile boolean deep;

        CmdGetChildren(@NotNull String name2, Node node2, boolean deep) {
            if (name2 == null) {
                CmdGetChildren.$$$reportNull$$$0(0);
            }
            if (node2 == null) {
                CmdGetChildren.$$$reportNull$$$0(1);
            }
            super(name2, node2.object);
            this.node = node2;
            if (deep) {
                this.deep = true;
            }
            node2.queue.add(this, old -> {
                if (!deep && old.deep && old.isPending()) {
                    this.deep = true;
                }
                return true;
            });
        }

        public boolean isObsolete() {
            return AsyncTreeModel.this.disposed || this != this.node.queue.get();
        }

        @Override
        Node getNode(Object object) {
            Node loaded = new Node(object, LeafState.get((Object)object, (TreeModel)AsyncTreeModel.this.model));
            if (loaded.leafState == LeafState.ALWAYS || this.isObsolete()) {
                return loaded;
            }
            if (AsyncTreeModel.this.model instanceof ChildrenProvider) {
                ChildrenProvider provider2 = (ChildrenProvider)((Object)AsyncTreeModel.this.model);
                List children2 = provider2.getChildren(object);
                if (children2 == null) {
                    throw new ProcessCanceledException();
                }
                loaded.children = this.load(children2.size(), index2 -> children2.get(index2));
            } else {
                loaded.children = this.load(AsyncTreeModel.this.model.getChildCount(object), index2 -> AsyncTreeModel.this.model.getChild(object, index2));
            }
            return loaded;
        }

        @Nullable
        private List<Node> load(int count, @NotNull IntFunction<?> childGetter) {
            if (childGetter == null) {
                CmdGetChildren.$$$reportNull$$$0(2);
            }
            if (count < 0) {
                LOG.warn("illegal child count: " + count);
            }
            if (count <= 0) {
                return Collections.emptyList();
            }
            Object set2 = count == 1 ? new SmartHashSet() : new HashSet(count);
            ArrayList<Node> children2 = new ArrayList<Node>(count);
            for (int i2 = 0; i2 < count; ++i2) {
                ProgressManager.checkCanceled();
                if (this.isObsolete()) {
                    return null;
                }
                Object child2 = childGetter.apply(i2);
                if (child2 == null) {
                    LOG.warn("ignore null child at " + i2);
                    continue;
                }
                if (!set2.add(child2)) {
                    LOG.warn("ignore duplicated child at " + i2 + ": " + child2);
                    continue;
                }
                if (this.isObsolete()) {
                    return null;
                }
                children2.add(new Node(child2, LeafState.get(child2, (TreeModel)AsyncTreeModel.this.model)));
            }
            return children2;
        }

        @Override
        void setNode(Node loaded) {
            if (loaded == null || loaded.isLoadingRequired()) {
                if (LOG.isTraceEnabled()) {
                    LOG.debug("cancelled command: ", new Object[]{this});
                }
                return;
            }
            if (this.node != AsyncTreeModel.this.tree.map.get(loaded.object)) {
                this.node.queue.close();
                LOG.warn("ignore removed node: " + this.node.object);
                return;
            }
            List<Node> oldChildren = this.node.getChildren();
            List<Node> newChildren = loaded.getChildren();
            if (oldChildren.isEmpty() && newChildren.isEmpty()) {
                this.node.setLeafState(loaded.leafState);
                AsyncTreeModel.this.treeNodesChanged(this.node, null);
                if (LOG.isTraceEnabled()) {
                    LOG.debug("no children: ", new Object[]{this.node.object});
                }
                this.node.queue.done(this, this.node);
                return;
            }
            LinkedHashMap<Object, Integer> removed = AsyncTreeModel.getIndices(oldChildren, null);
            if (newChildren.isEmpty()) {
                oldChildren.forEach(child2 -> child2.removeMapping(this.node, AsyncTreeModel.this.tree));
                this.node.setLeafState(loaded.leafState);
                AsyncTreeModel.this.treeNodesRemoved(this.node, removed);
                if (LOG.isTraceEnabled()) {
                    LOG.debug("children removed: ", new Object[]{this.node.object});
                }
                this.node.queue.done(this, this.node);
                return;
            }
            ArrayList<Node> list2 = new ArrayList<Node>(newChildren.size());
            SmartHashSet reload2 = new SmartHashSet();
            LinkedHashMap<Object, Integer> inserted = AsyncTreeModel.getIndices(newChildren, child2 -> {
                Node found = AsyncTreeModel.this.tree.map.get(child2.object);
                if (found == null) {
                    AsyncTreeModel.this.tree.map.put(child2.object, (Node)child2);
                    list2.add((Node)child2);
                } else {
                    AsyncTreeModel.this.tree.fixEqualButNotSame(found, child2.object);
                    list2.add(found);
                    if (found.leafState == LeafState.ALWAYS) {
                        if (child2.leafState != LeafState.ALWAYS) {
                            found.setLeafState(child2.leafState);
                            reload2.add(found.object);
                        }
                    } else if (child2.leafState == LeafState.ALWAYS || !found.isLoadingRequired() && (this.deep || !removed.containsKey(found.object))) {
                        reload2.add(found.object);
                    }
                }
                return list2.size() - 1;
            });
            newChildren = list2;
            if (oldChildren.isEmpty()) {
                newChildren.forEach(child2 -> child2.insertMapping(this.node));
                this.node.setChildren(newChildren);
                AsyncTreeModel.this.treeNodesInserted(this.node, inserted);
                if (LOG.isTraceEnabled()) {
                    LOG.debug("children inserted: ", new Object[]{this.node.object});
                }
                this.node.queue.done(this, this.node);
                return;
            }
            LinkedHashMap<Object, Integer> contained = new LinkedHashMap<Object, Integer>();
            for (Object object : AsyncTreeModel.getIntersection(removed, inserted)) {
                Integer newIndex;
                Integer oldIndex = (Integer)removed.remove(object);
                if (oldIndex == null) {
                    LOG.warn("intersection failed");
                }
                if ((newIndex = (Integer)inserted.remove(object)) == null) {
                    LOG.warn("intersection failed");
                    continue;
                }
                contained.put(object, newIndex);
            }
            for (Node child3 : newChildren) {
                if (removed.containsKey(child3.object) || !inserted.containsKey(child3.object)) continue;
                child3.insertMapping(this.node);
            }
            for (Node child3 : oldChildren) {
                if (!removed.containsKey(child3.object) || inserted.containsKey(child3.object)) continue;
                child3.removeMapping(this.node, AsyncTreeModel.this.tree);
            }
            this.node.setChildren(newChildren);
            if (!removed.isEmpty()) {
                AsyncTreeModel.this.treeNodesRemoved(this.node, removed);
            }
            if (!inserted.isEmpty()) {
                AsyncTreeModel.this.treeNodesInserted(this.node, inserted);
            }
            if (!contained.isEmpty()) {
                AsyncTreeModel.this.treeNodesChanged(this.node, contained);
            }
            if (removed.isEmpty() && inserted.isEmpty() && contained.isEmpty()) {
                AsyncTreeModel.this.treeNodesChanged(this.node, null);
            }
            if (LOG.isTraceEnabled()) {
                LOG.debug("children changed: ", new Object[]{this.node.object});
            }
            if (!reload2.isEmpty()) {
                for (Node child3 : newChildren) {
                    if (!reload2.contains(child3.object)) continue;
                    AsyncTreeModel.this.submit(new CmdGetChildren("Update children recursively", child3, true));
                }
            }
            this.node.queue.done(this, this.node);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childGetter";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/tree/AsyncTreeModel$CmdGetChildren";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "load";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class CmdGetRoot
    extends Command {
        private CmdGetRoot(String name2, Object object) {
            if (name2 == null) {
                CmdGetRoot.$$$reportNull$$$0(0);
            }
            super(name2, object);
            AsyncTreeModel.this.tree.queue.add(this, old -> old.started || old.object != object);
        }

        public boolean isObsolete() {
            return AsyncTreeModel.this.disposed || this != AsyncTreeModel.this.tree.queue.get();
        }

        @Override
        Node getNode(Object object) {
            if (object == null) {
                object = AsyncTreeModel.this.model.getRoot();
            }
            if (object == null || this.isObsolete()) {
                return null;
            }
            return new Node(object, LeafState.get((Object)object, (TreeModel)AsyncTreeModel.this.model));
        }

        @Override
        void setNode(Node loaded) {
            Node root2 = AsyncTreeModel.this.tree.root;
            if (root2 == null && loaded == null) {
                if (LOG.isTraceEnabled()) {
                    LOG.debug("no root");
                }
                AsyncTreeModel.this.tree.queue.done(this, null);
                return;
            }
            if (root2 != null && loaded != null && root2.object.equals(loaded.object)) {
                AsyncTreeModel.this.tree.fixEqualButNotSame(root2, loaded.object);
                if (LOG.isTraceEnabled()) {
                    LOG.debug("same root: ", new Object[]{root2.object});
                }
                if (!root2.isLoadingRequired()) {
                    AsyncTreeModel.this.submit(new CmdGetChildren("Update root children", root2, true));
                }
                AsyncTreeModel.this.tree.queue.done(this, root2);
                return;
            }
            if (root2 != null) {
                root2.removeMapping(null, AsyncTreeModel.this.tree);
            }
            if (!AsyncTreeModel.this.tree.map.isEmpty()) {
                AsyncTreeModel.this.tree.map.values().forEach(node2 -> {
                    node2.queue.close();
                    LOG.warn("remove staled node: " + node2.object);
                });
                AsyncTreeModel.this.tree.map.clear();
            }
            AsyncTreeModel.this.tree.root = loaded;
            if (loaded != null) {
                AsyncTreeModel.this.tree.map.put(loaded.object, loaded);
                TreePath path2 = new TreePath(loaded.object);
                loaded.insertPath(path2);
                AsyncTreeModel.this.treeStructureChanged(path2, null, null);
                if (LOG.isTraceEnabled()) {
                    LOG.debug("new root: ", new Object[]{loaded.object});
                }
                AsyncTreeModel.this.tree.queue.done(this, loaded);
            } else {
                AsyncTreeModel.this.treeStructureChanged(null, null, null);
                if (LOG.isTraceEnabled()) {
                    LOG.debug("root removed");
                }
                AsyncTreeModel.this.tree.queue.done(this, null);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ui/tree/AsyncTreeModel$CmdGetRoot", "<init>"));
        }
    }

    private static abstract class Command
    implements Obsolescent,
    Supplier<Node>,
    Consumer<Node> {
        final AsyncPromise<Node> promise;
        final String name;
        final Object object;
        volatile boolean started;

        Command(@NotNull @NonNls String name2, Object object) {
            if (name2 == null) {
                Command.$$$reportNull$$$0(0);
            }
            this.promise = new AsyncPromise();
            this.name = name2;
            this.object = object;
            if (LOG.isTraceEnabled()) {
                LOG.debug("create command: ", new Object[]{this});
            }
        }

        abstract Node getNode(Object var1);

        abstract void setNode(Node var1);

        boolean isPending() {
            return Promise.State.PENDING == this.promise.getState();
        }

        public String toString() {
            return this.object == null ? this.name : this.name + ": " + this.object;
        }

        @Override
        public Node get() {
            this.started = true;
            if (this.isObsolete()) {
                if (LOG.isTraceEnabled()) {
                    LOG.debug("obsolete command: ", new Object[]{this});
                }
                return null;
            }
            if (LOG.isTraceEnabled()) {
                LOG.debug("background command: ", new Object[]{this});
            }
            return this.getNode(this.object);
        }

        @Override
        public void accept(Node node2) {
            if (this.isObsolete()) {
                if (LOG.isTraceEnabled()) {
                    LOG.debug("obsolete command: ", new Object[]{this});
                }
            } else {
                if (LOG.isTraceEnabled()) {
                    LOG.debug("foreground command: ", new Object[]{this});
                }
                this.setNode(node2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ui/tree/AsyncTreeModel$Command", "<init>"));
        }
    }
}

