/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class TreePathUtil {
    @NotNull
    public static TreePath createTreePath(TreePath parent, @NotNull Object component2) {
        if (component2 == null) {
            TreePathUtil.$$$reportNull$$$0(0);
        }
        return parent != null ? parent.pathByAddingChild(component2) : new TreePath(component2);
    }

    public static String[] convertTreePathToStrings(@NotNull TreePath path2) {
        if (path2 == null) {
            TreePathUtil.$$$reportNull$$$0(1);
        }
        return TreePathUtil.convertTreePathToArray(path2, Object::toString, String.class);
    }

    public static Object[] convertTreePathToArray(@NotNull TreePath path2) {
        if (path2 == null) {
            TreePathUtil.$$$reportNull$$$0(2);
        }
        return TreePathUtil.convertTreePathToArray(path2, object -> object, Object.class);
    }

    public static Object[] convertTreePathToArray(@NotNull TreePath path2, @NotNull Function<Object, Object> converter) {
        if (path2 == null) {
            TreePathUtil.$$$reportNull$$$0(3);
        }
        if (converter == null) {
            TreePathUtil.$$$reportNull$$$0(4);
        }
        return TreePathUtil.convertTreePathToArray(path2, converter, Object.class);
    }

    private static <T> T[] convertTreePathToArray(@NotNull TreePath path2, @NotNull Function<Object, ? extends T> converter, @NotNull Class<T> type) {
        int count;
        if (path2 == null) {
            TreePathUtil.$$$reportNull$$$0(5);
        }
        if (converter == null) {
            TreePathUtil.$$$reportNull$$$0(6);
        }
        if (type == null) {
            TreePathUtil.$$$reportNull$$$0(7);
        }
        if ((count = path2.getPathCount()) <= 0) {
            return null;
        }
        Object[] array2 = ArrayUtil.newArray(type, (int)count);
        while (path2 != null && count > 0) {
            Object component2 = path2.getLastPathComponent();
            if (component2 == null) {
                return null;
            }
            T object = TreePathUtil.convert(component2, converter);
            if (object == null) {
                return null;
            }
            array2[--count] = object;
            path2 = path2.getParentPath();
        }
        return path2 != null || count > 0 ? null : array2;
    }

    @SafeVarargs
    public static <T> TreePath convertArrayToTreePath(T ... array2) {
        if (array2 == null) {
            TreePathUtil.$$$reportNull$$$0(8);
        }
        return TreePathUtil.convertArrayToTreePath(array2, object -> object);
    }

    public static <T> TreePath convertArrayToTreePath(T @NotNull [] array2, @NotNull Function<? super T, Object> converter) {
        if (converter == null) {
            TreePathUtil.$$$reportNull$$$0(9);
        }
        if (array2 == null) {
            TreePathUtil.$$$reportNull$$$0(10);
        }
        return array2.length == 0 ? null : TreePathUtil.convertCollectionToTreePath(Arrays.asList(array2), converter);
    }

    public static <T> TreePath convertCollectionToTreePath(@NotNull Iterable<? extends T> collection) {
        if (collection == null) {
            TreePathUtil.$$$reportNull$$$0(11);
        }
        return TreePathUtil.convertCollectionToTreePath(collection, object -> object);
    }

    public static <T> TreePath convertCollectionToTreePath(@NotNull Iterable<? extends T> collection, @NotNull Function<? super T, Object> converter) {
        if (collection == null) {
            TreePathUtil.$$$reportNull$$$0(12);
        }
        if (converter == null) {
            TreePathUtil.$$$reportNull$$$0(13);
        }
        TreePath path2 = null;
        for (T object : collection) {
            Object component2 = TreePathUtil.convert(object, converter);
            if (component2 == null) {
                return null;
            }
            path2 = TreePathUtil.createTreePath(path2, component2);
        }
        return path2;
    }

    public static TreePath pathToTreeNode(@NotNull TreeNode node2) {
        if (node2 == null) {
            TreePathUtil.$$$reportNull$$$0(14);
        }
        return TreePathUtil.pathToTreeNode(node2, object -> object);
    }

    public static TreePath pathToTreeNode(@NotNull TreeNode node2, @NotNull Function<? super TreeNode, Object> converter) {
        if (node2 == null) {
            TreePathUtil.$$$reportNull$$$0(15);
        }
        if (converter == null) {
            TreePathUtil.$$$reportNull$$$0(16);
        }
        return TreePathUtil.pathToCustomNode(node2, TreeNode::getParent, converter);
    }

    public static <T> TreePath pathToCustomNode(@NotNull T node2, @NotNull Function<? super T, ? extends T> getParent) {
        if (node2 == null) {
            TreePathUtil.$$$reportNull$$$0(17);
        }
        if (getParent == null) {
            TreePathUtil.$$$reportNull$$$0(18);
        }
        return TreePathUtil.pathToCustomNode(node2, getParent, object -> object);
    }

    public static <T> TreePath pathToCustomNode(@NotNull T node2, @NotNull Function<? super T, ? extends T> getParent, @NotNull Function<? super T, Object> converter) {
        if (node2 == null) {
            TreePathUtil.$$$reportNull$$$0(19);
        }
        if (getParent == null) {
            TreePathUtil.$$$reportNull$$$0(20);
        }
        if (converter == null) {
            TreePathUtil.$$$reportNull$$$0(21);
        }
        ArrayDeque<T> deque = new ArrayDeque<T>();
        while (node2 != null) {
            deque.addFirst(node2);
            node2 = getParent.apply(node2);
        }
        return TreePathUtil.convertCollectionToTreePath(deque, converter);
    }

    private static <I, O> O convert(I object, @NotNull Function<? super I, ? extends O> converter) {
        if (converter == null) {
            TreePathUtil.$$$reportNull$$$0(22);
        }
        return object == null ? null : (O)converter.apply((I)object);
    }

    public static TreePath @NotNull [] toTreePathArray(@NotNull Collection<TreePath> collection) {
        if (collection == null) {
            TreePathUtil.$$$reportNull$$$0(23);
        }
        TreePath[] treePathArray = collection.isEmpty() ? TreeUtil.EMPTY_TREE_PATH : collection.toArray(TreeUtil.EMPTY_TREE_PATH);
        if (treePathArray == null) {
            TreePathUtil.$$$reportNull$$$0(24);
        }
        return treePathArray;
    }

    public static TreeNode toTreeNode(TreePath path2) {
        Object component2 = path2 == null ? null : path2.getLastPathComponent();
        return component2 instanceof TreeNode ? (TreeNode)component2 : null;
    }

    @Contract(value="!null->!null")
    public static TreeNode[] toTreeNodes(TreePath ... paths2) {
        return paths2 == null ? null : (TreeNode[])Stream.of(paths2).map(TreePathUtil::toTreeNode).filter(Objects::nonNull).toArray(TreeNode[]::new);
    }

    public static TreePath toTreePath(TreeNode node2) {
        return node2 == null ? null : TreePathUtil.pathToTreeNode(node2);
    }

    public static TreePath[] toTreePaths(TreeNode ... nodes) {
        return nodes == null ? null : (TreePath[])Stream.of(nodes).map(TreePathUtil::toTreePath).filter(Objects::nonNull).toArray(TreePath[]::new);
    }

    public static TreePath findAncestor(TreePath path2, @NotNull Predicate<? super TreePath> predicate2) {
        if (predicate2 == null) {
            TreePathUtil.$$$reportNull$$$0(25);
        }
        while (path2 != null) {
            if (predicate2.test(path2)) {
                return path2;
            }
            path2 = path2.getParentPath();
        }
        return null;
    }

    public static TreePath findCommonAncestor(TreePath ... paths2) {
        if (ArrayUtil.isEmpty((Object[])paths2)) {
            return null;
        }
        if (paths2.length == 1) {
            return paths2[0];
        }
        return TreePathUtil.findCommonAncestor(Arrays.asList(paths2));
    }

    /*
     * WARNING - void declaration
     */
    public static TreePath findCommonAncestor(@NotNull Iterable<? extends TreePath> paths2) {
        if (paths2 == null) {
            TreePathUtil.$$$reportNull$$$0(26);
        }
        TreePath ancestor = null;
        for (int i2 = 0; i2 < Integer.MAX_VALUE; ++i2) {
            TreePath first = null;
            for (TreePath treePath : paths2) {
                void var5_5;
                int count = treePath.getPathCount();
                if (count <= i2) {
                    return ancestor;
                }
                while (--count > i2) {
                    TreePath treePath2 = var5_5.getParentPath();
                }
                if (var5_5 == null) {
                    throw new IllegalStateException("unexpected");
                }
                if (first == null) {
                    first = var5_5;
                }
                if (first == var5_5 || Objects.equals(first.getLastPathComponent(), var5_5.getLastPathComponent())) continue;
                return ancestor;
            }
            if (first == null) {
                return ancestor;
            }
            ancestor = TreePathUtil.createTreePath(ancestor, first.getLastPathComponent());
        }
        return ancestor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 13: 
            case 16: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 11: 
            case 12: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 14: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getParent";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tree/TreePathUtil";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tree/TreePathUtil";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "toTreePathArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTreePath";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "convertTreePathToStrings";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "convertTreePathToArray";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "convertArrayToTreePath";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "convertCollectionToTreePath";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "pathToTreeNode";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "pathToCustomNode";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "toTreePathArray";
                break;
            }
            case 24: {
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findAncestor";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findCommonAncestor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

