/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree.project;

import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.ui.tree.BaseTreeModel;
import com.intellij.ui.tree.TreeCollector;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.tree.project.ProjectFileNode;
import com.intellij.ui.tree.project.ProjectFileNodeUpdater;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.containers.SmartHashSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProjectFileTreeModel
extends BaseTreeModel<ProjectFileNode>
implements InvokerSupplier {
    private final Invoker invoker;
    private final ProjectFileNodeUpdater updater;
    private final ProjectNode root;

    public ProjectFileTreeModel(@NotNull Project project) {
        if (project == null) {
            ProjectFileTreeModel.$$$reportNull$$$0(0);
        }
        this.invoker = Invoker.forBackgroundThreadWithReadAction((Disposable)this);
        this.root = new ProjectNode(project);
        this.updater = new ProjectFileNodeUpdater(project, this.invoker){

            @Override
            protected void updateStructure(boolean fromRoot, @NotNull Set<? extends VirtualFile> updatedFiles) {
                if (updatedFiles == null) {
                    1.$$$reportNull$$$0(0);
                }
                boolean filtered2 = ProjectFileTreeModel.this.root.filter != null;
                SmartHashSet nodes = fromRoot || filtered2 ? null : new SmartHashSet();
                ProjectFileTreeModel.this.root.children.forEach(child2 -> child2.invalidateChildren(node2 -> {
                    Node n;
                    if (!updatedFiles.contains(node2.file)) {
                        return true;
                    }
                    if (filtered2) {
                        node2.resetVisibility();
                        Node parent = node2.parent;
                        while (parent != null) {
                            parent.visibility = null;
                            parent = parent.parent;
                        }
                    }
                    if (nodes == null) {
                        return false;
                    }
                    Node node3 = n = node2.file.isDirectory() ? node2 : node2.parent;
                    if (n == null) {
                        return false;
                    }
                    Node p = n.parent;
                    while (p != null) {
                        if (nodes.contains((Object)p)) {
                            return false;
                        }
                        p = p.parent;
                    }
                    nodes.add((Object)n);
                    return false;
                }));
                if (nodes != null) {
                    nodes.forEach(node2 -> {
                        TreePath path2 = TreePathUtil.pathToCustomNode(node2, child2 -> child2.parent);
                        if (path2 != null) {
                            ProjectFileTreeModel.this.pathChanged(path2);
                        }
                    });
                } else {
                    ProjectFileTreeModel.this.root.valid = false;
                    ProjectFileTreeModel.this.pathChanged(null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updatedFiles", "com/intellij/ui/tree/project/ProjectFileTreeModel$1", "updateStructure"));
            }
        };
    }

    @NotNull
    public ProjectFileNodeUpdater getUpdater() {
        ProjectFileNodeUpdater projectFileNodeUpdater = this.updater;
        if (projectFileNodeUpdater == null) {
            ProjectFileTreeModel.$$$reportNull$$$0(1);
        }
        return projectFileNodeUpdater;
    }

    @Override
    @NotNull
    public Invoker getInvoker() {
        Invoker invoker = this.invoker;
        if (invoker == null) {
            ProjectFileTreeModel.$$$reportNull$$$0(2);
        }
        return invoker;
    }

    public boolean isValidThread() {
        return this.invoker.isValidThread();
    }

    public void onValidThread(@NotNull Runnable task2) {
        if (task2 == null) {
            ProjectFileTreeModel.$$$reportNull$$$0(3);
        }
        this.invoker.invoke(task2);
    }

    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object object) {
        return this.root != object && super.isLeaf(object);
    }

    @Override
    public int getIndexOfChild(Object parent, Object object) {
        Node node2 = object instanceof Node ? (Node)object : null;
        return node2 == null || node2.parent != parent ? -1 : super.getIndexOfChild(parent, object);
    }

    @Override
    @NotNull
    public List<ProjectFileNode> getChildren(Object object) {
        Node node2;
        Node node3 = node2 = object instanceof Node && this.isValidThread() ? (Node)object : null;
        if (node2 == null) {
            List<ProjectFileNode> list2 = Collections.emptyList();
            if (list2 == null) {
                ProjectFileTreeModel.$$$reportNull$$$0(4);
            }
            return list2;
        }
        List<FileNode> children2 = node2.getChildren();
        if (children2.isEmpty()) {
            List<ProjectFileNode> list3 = Collections.emptyList();
            if (list3 == null) {
                ProjectFileTreeModel.$$$reportNull$$$0(5);
            }
            return list3;
        }
        SmartList result2 = new SmartList();
        VirtualFileFilter filter = this.root.filter;
        for (FileNode child2 : children2) {
            if (!(child2 instanceof FileNode) || !this.isVisible(child2, filter)) continue;
            result2.add(child2);
        }
        SmartList smartList = result2;
        if (smartList == null) {
            ProjectFileTreeModel.$$$reportNull$$$0(6);
        }
        return smartList;
    }

    private boolean isVisible(@NotNull FileNode node2, @Nullable VirtualFileFilter filter) {
        if (node2 == null) {
            ProjectFileTreeModel.$$$reportNull$$$0(7);
        }
        if (!node2.file.isValid() || this.root.project.isDisposed()) {
            return false;
        }
        if (filter == null) {
            return !this.root.isExcluded(node2.file);
        }
        ThreeState visibility = node2.visibility;
        if (visibility == ThreeState.NO) {
            return false;
        }
        if (visibility == ThreeState.YES) {
            return true;
        }
        ProgressManager.checkCanceled();
        boolean visible = node2.isVisible(filter, this.root);
        node2.visibility = ThreeState.fromBoolean((boolean)visible);
        return visible;
    }

    public void setFilter(@Nullable VirtualFileFilter filter) {
        this.onValidThread(() -> {
            if (this.root.filter == null && filter == null) {
                return;
            }
            this.root.filter = filter;
            this.root.resetVisibility();
            this.pathChanged(null);
        });
    }

    public void setSettings(boolean showExcludedFiles, boolean showModules) {
        this.onValidThread(() -> {
            if (this.root.showExcludedFiles != showExcludedFiles) {
                if (this.root.filter != null) {
                    this.root.resetVisibility();
                }
                this.root.showExcludedFiles = showExcludedFiles;
                this.root.valid = false;
            }
            if (this.root.showModules != showModules) {
                this.root.showModules = showModules;
                this.root.valid = false;
            }
        });
    }

    private void pathChanged(@Nullable TreePath path2) {
        this.onValidThread(() -> this.treeStructureChanged(path2, null, null));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tree/project/ProjectFileTreeModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tree/project/ProjectFileTreeModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdater";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvoker";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onValidThread";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isVisible";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FileNode
    extends Node
    implements ProjectFileNode {
        final VirtualFile file;
        final Object id;

        FileNode(@NotNull VirtualFile file2, @NotNull Object id2) {
            if (file2 == null) {
                FileNode.$$$reportNull$$$0(0);
            }
            if (id2 == null) {
                FileNode.$$$reportNull$$$0(1);
            }
            this.file = file2;
            this.id = id2;
        }

        @Override
        @NotNull
        public Object getRootID() {
            Object object = this.id;
            if (object == null) {
                FileNode.$$$reportNull$$$0(2);
            }
            return object;
        }

        @Override
        @NotNull
        public VirtualFile getVirtualFile() {
            VirtualFile virtualFile2 = this.file;
            if (virtualFile2 == null) {
                FileNode.$$$reportNull$$$0(3);
            }
            return virtualFile2;
        }

        public String toString() {
            return this.parent instanceof ProjectNode ? this.file.getPath() : this.file.getName();
        }

        @Override
        @NotNull
        List<FileNode> getChildren(@NotNull List<? extends FileNode> oldList) {
            if (oldList == null) {
                FileNode.$$$reportNull$$$0(4);
            }
            this.visibility = ThreeState.NO;
            VirtualFile file2 = this.getVirtualFile();
            if (!file2.isValid()) {
                List<FileNode> list2 = Collections.emptyList();
                if (list2 == null) {
                    FileNode.$$$reportNull$$$0(5);
                }
                return list2;
            }
            ProjectNode parent = this.findParent(ProjectNode.class);
            if (parent == null) {
                List<FileNode> list3 = Collections.emptyList();
                if (list3 == null) {
                    FileNode.$$$reportNull$$$0(6);
                }
                return list3;
            }
            this.visibility = ThreeState.UNSURE;
            VirtualFile[] children2 = file2.getChildren();
            if (children2 == null || children2.length == 0) {
                List<FileNode> list4 = Collections.emptyList();
                if (list4 == null) {
                    FileNode.$$$reportNull$$$0(7);
                }
                return list4;
            }
            Mapper mapper2 = new Mapper(oldList);
            List<FileNode> list5 = Arrays.stream(children2).filter(child2 -> this.isValidChild((VirtualFile)child2, parent.project)).map(child2 -> mapper2.apply((VirtualFile)child2, this.id)).collect(Collectors.toList());
            if (list5 == null) {
                FileNode.$$$reportNull$$$0(8);
            }
            return list5;
        }

        void invalidateChildren(Predicate<? super FileNode> validator2) {
            if (this.valid || !this.file.isDirectory()) {
                if (validator2 == null || !validator2.test(this)) {
                    validator2 = null;
                    this.valid = false;
                }
                for (FileNode node2 : this.children) {
                    node2.invalidateChildren(validator2);
                }
            }
        }

        boolean isVisible(@NotNull VirtualFileFilter filter, @NotNull ProjectNode root2) {
            if (filter == null) {
                FileNode.$$$reportNull$$$0(9);
            }
            if (root2 == null) {
                FileNode.$$$reportNull$$$0(10);
            }
            return !VfsUtilCore.iterateChildrenRecursively((VirtualFile)this.file, child2 -> !root2.isExcluded(child2) && this.isValidChild(child2, root2.project), child2 -> !filter.accept(child2));
        }

        private boolean isValidChild(@NotNull VirtualFile file2, @NotNull Project project) {
            if (file2 == null) {
                FileNode.$$$reportNull$$$0(11);
            }
            if (project == null) {
                FileNode.$$$reportNull$$$0(12);
            }
            if (file2.is(VFileProperty.SYMLINK) && VfsUtilCore.isInvalidLink((VirtualFile)file2)) {
                return false;
            }
            AreaInstance area = ProjectFileNode.findArea(file2, project);
            return area != null && (this.id instanceof VirtualFile || this.id.equals(area));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/tree/project/ProjectFileTreeModel$FileNode";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldList";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/tree/project/ProjectFileTreeModel$FileNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRootID";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVirtualFile";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getChildren";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "isVisible";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "isValidChild";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ProjectNode
    extends Node {
        volatile VirtualFileFilter filter;
        volatile boolean showExcludedFiles;
        volatile boolean showModules;
        final Project project;

        ProjectNode(@NotNull Project project) {
            if (project == null) {
                ProjectNode.$$$reportNull$$$0(0);
            }
            this.project = project;
        }

        boolean isExcluded(@NotNull VirtualFile file2) {
            if (file2 == null) {
                ProjectNode.$$$reportNull$$$0(1);
            }
            return !this.showExcludedFiles && (ProjectFileIndex.getInstance((Project)this.project).isExcluded(file2) || ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)file2));
        }

        public String toString() {
            return this.project.getName();
        }

        @Override
        @NotNull
        List<FileNode> getChildren(@NotNull List<? extends FileNode> oldList) {
            if (oldList == null) {
                ProjectNode.$$$reportNull$$$0(2);
            }
            SmartList list2 = new SmartList();
            Mapper mapper2 = new Mapper(oldList);
            if (this.showModules) {
                ProjectNode.visitContentRoots(this.project, (arg_0, arg_1) -> ProjectNode.lambda$getChildren$0((List)list2, mapper2, arg_0, arg_1));
            } else {
                TreeCollector collector = TreeCollector.VirtualFileRoots.create();
                ProjectNode.visitContentRoots(this.project, (file2, area) -> collector.add(file2));
                collector.get().forEach(arg_0 -> ProjectNode.lambda$getChildren$2((List)list2, mapper2, arg_0));
            }
            SmartList smartList = list2;
            if (smartList == null) {
                ProjectNode.$$$reportNull$$$0(3);
            }
            return smartList;
        }

        private static void visitContentRoots(@Nullable Project project, @NotNull BiConsumer<? super VirtualFile, ? super AreaInstance> consumer2) {
            VirtualFile ancestor;
            if (consumer2 == null) {
                ProjectNode.$$$reportNull$$$0(4);
            }
            if ((ancestor = ProjectFileNode.findBaseDir(project)) != null && project == ProjectFileNode.findArea(ancestor, project)) {
                consumer2.accept((VirtualFile)ancestor, (AreaInstance)project);
            }
            if (project != null && !project.isDisposed()) {
                for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                    if (module.isDisposed()) continue;
                    for (VirtualFile file2 : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                        consumer2.accept((VirtualFile)file2, (AreaInstance)module);
                    }
                }
            }
            for (RootType rootType : RootType.getAllRootTypes()) {
                if (rootType.isHidden()) continue;
                String path2 = ScratchFileService.getInstance().getRootPath(rootType);
                VirtualFile file3 = LocalFileSystem.getInstance().findFileByPath(path2);
                if (file3 == null) continue;
                consumer2.accept((VirtualFile)file3, (AreaInstance)ApplicationManager.getApplication());
            }
        }

        private static /* synthetic */ void lambda$getChildren$2(List list2, Mapper mapper2, VirtualFile file2) {
            list2.add(mapper2.apply(file2, (Object)file2));
        }

        private static /* synthetic */ void lambda$getChildren$0(List list2, Mapper mapper2, VirtualFile file2, AreaInstance area) {
            list2.add(mapper2.apply(file2, (Object)area));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldList";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/tree/project/ProjectFileTreeModel$ProjectNode";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/tree/project/ProjectFileTreeModel$ProjectNode";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isExcluded";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getChildren";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "visitContentRoots";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class Node {
        volatile Node parent;
        volatile ThreeState visibility;
        volatile List<FileNode> children = Collections.emptyList();
        volatile boolean valid;

        private Node() {
        }

        @NotNull
        abstract List<FileNode> getChildren(@NotNull List<? extends FileNode> var1);

        final List<FileNode> getChildren() {
            List<FileNode> oldList = this.children;
            if (this.valid) {
                return oldList;
            }
            ProgressManager.checkCanceled();
            List<FileNode> newList = this.getChildren(oldList);
            oldList.forEach(node2 -> {
                node2.parent = null;
            });
            newList.forEach(node2 -> {
                node2.parent = this;
            });
            oldList.stream().filter(node2 -> node2.parent == null).forEach(Node::cleanup);
            this.children = newList;
            this.valid = true;
            return newList;
        }

        private void cleanup() {
            this.children.forEach(Node::cleanup);
            this.children = Collections.emptyList();
            this.parent = null;
        }

        final void resetVisibility() {
            this.visibility = null;
            this.children.forEach(Node::resetVisibility);
        }

        final <N> N findParent(Class<N> type) {
            Node node2 = this;
            while (node2 != null) {
                if (type.isInstance(node2)) {
                    return type.cast(node2);
                }
                node2 = node2.parent;
            }
            return null;
        }
    }

    private static final class Mapper
    implements BiFunction<VirtualFile, Object, FileNode> {
        private final HashMap<VirtualFile, FileNode> map;

        Mapper(@NotNull List<? extends FileNode> list2) {
            if (list2 == null) {
                Mapper.$$$reportNull$$$0(0);
            }
            this.map = new HashMap();
            list2.forEach(node2 -> this.map.put(node2.file, (FileNode)node2));
        }

        @Override
        @NotNull
        public FileNode apply(VirtualFile file2, Object id2) {
            FileNode node2 = this.map.isEmpty() ? null : this.map.remove(file2);
            return node2 != null && node2.id.equals(id2) ? node2 : new FileNode(file2, id2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ui/tree/project/ProjectFileTreeModel$Mapper", "<init>"));
        }
    }
}

