/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.jna.JnaLoader;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.TimeoutUtil;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.StdCallLibrary;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class Restarter {
    private static final String DO_NOT_LOCK_INSTALL_FOLDER_PROPERTY = "restarter.do.not.lock.install.folder";
    private static final String SPECIAL_EXIT_CODE_FOR_RESTART_ENV_VAR = "IDEA_RESTART_VIA_EXIT_CODE";
    private static final NullableLazyValue<File> ourStarter = NullableLazyValue.createValue(() -> {
        File starter2;
        if (SystemInfo.isWindows && JnaLoader.isLoaded()) {
            char[] buffer;
            Kernel32 kernel32 = (Kernel32)Native.load((String)"kernel32", Kernel32.class);
            int result2 = kernel32.GetModuleFileNameW(null, buffer = new char[Short.MAX_VALUE], new WinDef.DWORD((long)buffer.length)).intValue();
            if (result2 != 0) {
                return new File(Native.toString((char[])buffer));
            }
        } else if (SystemInfo.isMac) {
            File appDir = new File(PathManager.getHomePath()).getParentFile();
            if (appDir != null && appDir.getName().endsWith(".app") && appDir.isDirectory()) {
                return appDir;
            }
        } else if (SystemInfo.isUnix && (starter2 = new File(PathManager.getBinPath(), ApplicationNamesInfo.getInstance().getScriptName() + ".sh")).canExecute()) {
            return starter2;
        }
        return null;
    });
    private static final NotNullLazyValue<Boolean> ourRestartSupported = NotNullLazyValue.atomicLazy(() -> {
        Object problem;
        String restartExitCode = EnvironmentUtil.getValue((String)SPECIAL_EXIT_CODE_FOR_RESTART_ENV_VAR);
        if (restartExitCode != null) {
            try {
                int code = Integer.parseInt(restartExitCode);
                if (code >= 0 && code <= 255) {
                    return true;
                }
                problem = "Requested exit code out of range (" + code + ")";
            }
            catch (NumberFormatException ex) {
                problem = "IDEA_RESTART_VIA_EXIT_CODE contains a value that can't be parsed as an integer (" + restartExitCode + ")";
            }
        } else {
            problem = SystemInfo.isWindows ? (!JnaLoader.isLoaded() ? "JNA not loaded" : (ourStarter.getValue() == null ? "GetModuleFileName() failed" : Restarter.checkRestarter("restarter.exe"))) : (SystemInfo.isMac ? (ourStarter.getValue() == null ? "not a bundle: " + PathManager.getHomePath() : Restarter.checkRestarter("restarter")) : (SystemInfo.isUnix ? (OSProcessUtil.getCurrentProcessId() <= 0 ? "cannot detect process ID" : (ourStarter.getValue() == null ? "cannot find launcher script in " + PathManager.getBinPath() : (PathEnvironmentVariableUtil.findInPath((String)"python") == null && PathEnvironmentVariableUtil.findInPath((String)"python3") == null ? "cannot find neither 'python' nor 'python3' in 'PATH'" : Restarter.checkRestarter("restart.py")))) : "Platform unsupported: " + SystemInfo.OS_NAME));
        }
        if (problem == null) {
            return true;
        }
        Logger.getInstance(Restarter.class).info("not supported: " + (String)problem);
        return false;
    });

    private Restarter() {
    }

    public static boolean isSupported() {
        return (Boolean)ourRestartSupported.getValue();
    }

    private static String checkRestarter(String restarterName) {
        Path restarter = PathManager.findBinFile((String)restarterName);
        return restarter != null && Files.isExecutable(restarter) ? null : "not an executable file: " + restarter;
    }

    public static void scheduleRestart(boolean elevate, String ... beforeRestart) throws IOException {
        String exitCodeVariable;
        if (beforeRestart == null) {
            Restarter.$$$reportNull$$$0(0);
        }
        if ((exitCodeVariable = EnvironmentUtil.getValue((String)SPECIAL_EXIT_CODE_FOR_RESTART_ENV_VAR)) != null) {
            if (beforeRestart.length > 0) {
                throw new IOException("Cannot restart application: specific exit code restart mode does not support executing additional commands");
            }
            try {
                int code = Integer.parseInt(exitCodeVariable);
                System.exit(code);
            }
            catch (NumberFormatException ex) {
                throw new IOException("Cannot restart application: can't parse required exit code", ex);
            }
        } else if (SystemInfo.isWindows) {
            Restarter.restartOnWindows(elevate, beforeRestart);
        } else if (SystemInfo.isMac) {
            Restarter.restartOnMac(beforeRestart);
        } else if (SystemInfo.isUnix) {
            Restarter.restartOnUnix(beforeRestart);
        } else {
            throw new IOException("Cannot restart application: not supported.");
        }
    }

    @Nullable
    public static File getIdeStarter() {
        return (File)ourStarter.getValue();
    }

    private static void restartOnWindows(boolean elevate, String ... beforeRestart) throws IOException {
        Path launcher;
        Kernel32 kernel32 = (Kernel32)Native.load((String)"kernel32", Kernel32.class);
        Shell32 shell32 = (Shell32)Native.load((String)"shell32", Shell32.class);
        int pid2 = OSProcessUtil.getCurrentProcessId();
        IntByReference argc = new IntByReference();
        Pointer argvPtr = shell32.CommandLineToArgvW(kernel32.GetCommandLineW(), argc);
        String[] argv = Restarter.getRestartArgv(argvPtr.getWideStringArray(0L, argc.getValue()));
        kernel32.LocalFree(argvPtr);
        File starter2 = (File)ourStarter.getValue();
        if (starter2 == null) {
            throw new IOException("GetModuleFileName() failed");
        }
        argv[0] = starter2.getPath();
        ArrayList<String> args = new ArrayList<String>();
        args.add(String.valueOf(pid2));
        if (beforeRestart.length > 0) {
            args.add(String.valueOf(beforeRestart.length));
            Collections.addAll(args, beforeRestart);
        }
        if (elevate && (launcher = PathManager.findBinFile((String)"launcher.exe")) != null) {
            args.add(String.valueOf(argv.length + 1));
            args.add(launcher.toString());
        } else {
            args.add(String.valueOf(argv.length));
        }
        Collections.addAll(args, argv);
        Path restarter = PathManager.findBinFile((String)"restarter.exe");
        if (restarter == null) {
            throw new IOException("Can't find restarter.exe; please reinstall the IDE");
        }
        Restarter.runRestarter(restarter.toFile(), args);
        TimeoutUtil.sleep((long)500L);
    }

    private static String[] getRestartArgv(String[] argv) {
        String mainClass = System.getProperty("idea.main.class.name", "com.intellij.idea.Main");
        int countArgs = argv.length;
        for (int i2 = argv.length - 1; i2 >= 0; --i2) {
            if (!argv[i2].equals(mainClass) && !argv[i2].endsWith(".exe")) continue;
            countArgs = i2 + 1;
            if (!argv[i2].endsWith(".exe") || argv[i2].indexOf(File.separatorChar) >= 0) break;
            argv[i2] = new File(PathManager.getBinPath(), argv[i2]).getPath();
            break;
        }
        return Arrays.copyOf(argv, countArgs);
    }

    private static void restartOnMac(String ... beforeRestart) throws IOException {
        File appDir = (File)ourStarter.getValue();
        if (appDir == null) {
            throw new IOException("Application bundle not found: " + PathManager.getHomePath());
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(appDir.getPath());
        Collections.addAll(args, beforeRestart);
        Restarter.runRestarter(new File(PathManager.getBinPath(), "restarter"), args);
    }

    private static void restartOnUnix(String ... beforeRestart) throws IOException {
        File starterScript = (File)ourStarter.getValue();
        if (starterScript == null) {
            throw new IOException("Starter script not found in " + PathManager.getBinPath());
        }
        int pid2 = OSProcessUtil.getCurrentProcessId();
        if (pid2 <= 0) {
            throw new IOException("Invalid process ID: " + pid2);
        }
        File python = PathEnvironmentVariableUtil.findInPath((String)"python");
        if (python == null) {
            python = PathEnvironmentVariableUtil.findInPath((String)"python3");
        }
        if (python == null) {
            throw new IOException("Cannot find neither 'python' nor 'python3' in 'PATH'");
        }
        File script = new File(PathManager.getBinPath(), "restart.py");
        ArrayList<String> args = new ArrayList<String>();
        if ("python".equals(python.getName())) {
            args.add(String.valueOf(pid2));
            args.add(starterScript.getPath());
            Collections.addAll(args, beforeRestart);
            Restarter.runRestarter(script, args);
        } else {
            args.add(script.getPath());
            args.add(String.valueOf(pid2));
            args.add(starterScript.getPath());
            Collections.addAll(args, beforeRestart);
            Restarter.runRestarter(python, args);
        }
    }

    public static void doNotLockInstallFolderOnRestart() {
        System.setProperty(DO_NOT_LOCK_INSTALL_FOLDER_PROPERTY, "true");
    }

    private static void runRestarter(File restarterFile, List<String> restarterArgs) throws IOException {
        String restarter = restarterFile.getPath();
        boolean doNotLock = SystemProperties.getBooleanProperty((String)DO_NOT_LOCK_INSTALL_FOLDER_PROPERTY, (boolean)false);
        Path tempDir = null;
        if (doNotLock || restarterArgs.contains("com.intellij.updater.Runner")) {
            tempDir = Paths.get(PathManager.getSystemPath(), "restart");
            Files.createDirectories(tempDir, new FileAttribute[0]);
            Path copy2 = tempDir.resolve(restarterFile.getName());
            Files.copy(restarterFile.toPath(), copy2, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
            restarter = copy2.toString();
        }
        restarterArgs.add(0, restarter);
        Logger.getInstance(Restarter.class).info("run restarter: " + restarterArgs);
        ProcessBuilder processBuilder = new ProcessBuilder(restarterArgs);
        if (doNotLock) {
            processBuilder.directory(tempDir.toFile());
        }
        if (SystemInfo.isXWindow) {
            Restarter.setDesktopStartupId(processBuilder);
        }
        processBuilder.start();
    }

    private static void setDesktopStartupId(ProcessBuilder processBuilder) {
        if (!SystemInfo.isJetBrainsJvm || !"sun.awt.X11.XToolkit".equals(Toolkit.getDefaultToolkit().getClass().getName())) {
            return;
        }
        try {
            Long lastUserActionTime = (Long)ReflectionUtil.getStaticFieldValue(Class.forName("sun.awt.X11.XBaseWindow"), Long.TYPE, (String)"globalUserTime");
            if (lastUserActionTime == null) {
                Logger.getInstance(Restarter.class).warn("Couldn't obtain last user action's timestamp");
            } else {
                processBuilder.environment().put("DESKTOP_STARTUP_ID", ApplicationNamesInfo.getInstance().getProductName() + "-restart_TIME" + lastUserActionTime);
            }
        }
        catch (Exception e) {
            Logger.getInstance(Restarter.class).warn("Couldn't set DESKTOP_STARTUP_ID", (Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beforeRestart", "com/intellij/util/Restarter", "scheduleRestart"));
    }

    private static interface Shell32
    extends StdCallLibrary {
        public Pointer CommandLineToArgvW(WString var1, IntByReference var2);
    }

    private static interface Kernel32
    extends StdCallLibrary {
        public WString GetCommandLineW();

        public Pointer LocalFree(Pointer var1);

        public WinDef.DWORD GetModuleFileNameW(WinDef.HMODULE var1, char[] var2, WinDef.DWORD var3);
    }
}

