/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.util.CachedValueImpl;
import com.intellij.util.indexing.IndexableFileSet;
import com.intellij.util.indexing.IndexableSetContributor;
import com.intellij.util.indexing.IndexableSetContributorModificationTracker;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AdditionalIndexableFileSet
implements IndexableFileSet {
    @Nullable
    private final Project myProject;
    private final Supplier<IndexableSetContributor[]> myExtensions;
    private final CachedValue<AdditionalIndexableRoots> myAdditionalIndexableRoots;

    public AdditionalIndexableFileSet(@Nullable Project project, IndexableSetContributor ... extensions2) {
        if (extensions2 == null) {
            AdditionalIndexableFileSet.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myExtensions = () -> extensions2;
        this.myAdditionalIndexableRoots = new CachedValueImpl<AdditionalIndexableRoots>(() -> new CachedValueProvider.Result((Object)this.collectFilesAndDirectories(), new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS}));
    }

    public AdditionalIndexableFileSet(@Nullable Project project) {
        this.myProject = project;
        this.myExtensions = () -> (IndexableSetContributor[])IndexableSetContributor.EP_NAME.getExtensions();
        this.myAdditionalIndexableRoots = new CachedValueImpl<AdditionalIndexableRoots>(() -> new CachedValueProvider.Result((Object)this.collectFilesAndDirectories(), new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS, IndexableSetContributorModificationTracker.getInstance()}));
    }

    @NotNull
    private AdditionalIndexableRoots collectFilesAndDirectories() {
        HashSet<VirtualFile> files2 = new HashSet<VirtualFile>();
        HashMap<IndexableSetContributor, Set<VirtualFile>> directories = new HashMap<IndexableSetContributor, Set<VirtualFile>>();
        for (IndexableSetContributor contributor : this.myExtensions.get()) {
            for (VirtualFile root2 : IndexableSetContributor.getRootsToIndex((IndexableSetContributor)contributor)) {
                (root2.isDirectory() ? directories.computeIfAbsent(contributor, __ -> new HashSet()) : files2).add(root2);
            }
            if (this.myProject == null) continue;
            Set projectRoots = IndexableSetContributor.getProjectRootsToIndex((IndexableSetContributor)contributor, (Project)this.myProject);
            for (VirtualFile root3 : projectRoots) {
                (root3.isDirectory() ? directories.computeIfAbsent(contributor, __ -> new HashSet()) : files2).add(root3);
            }
        }
        return new AdditionalIndexableRoots(files2, directories);
    }

    @Override
    public boolean isInSet(@NotNull VirtualFile file2) {
        if (file2 == null) {
            AdditionalIndexableFileSet.$$$reportNull$$$0(1);
        }
        AdditionalIndexableRoots additionalIndexableRoots = (AdditionalIndexableRoots)this.myAdditionalIndexableRoots.getValue();
        if (additionalIndexableRoots.files.contains(file2)) {
            return true;
        }
        for (Map.Entry<IndexableSetContributor, Set<VirtualFile>> entry2 : additionalIndexableRoots.directories.entrySet()) {
            IndexableSetContributor contributor = entry2.getKey();
            Set<VirtualFile> directories = entry2.getValue();
            VirtualFile dir = AdditionalIndexableFileSet.findRoot(file2, directories);
            if (dir == null || !contributor.acceptFile(file2, dir, this.myProject)) continue;
            return true;
        }
        return false;
    }

    private static VirtualFile findRoot(@NotNull VirtualFile file2, @Nullable Set<? extends VirtualFile> roots2) {
        if (file2 == null) {
            AdditionalIndexableFileSet.$$$reportNull$$$0(2);
        }
        if (roots2 == null || roots2.isEmpty()) {
            return null;
        }
        for (VirtualFile parent = file2; parent != null; parent = parent.getParent()) {
            if (!roots2.contains(parent)) continue;
            return parent;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/AdditionalIndexableFileSet";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isInSet";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findRoot";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class AdditionalIndexableRoots {
        @NotNull
        private final Set<VirtualFile> files;
        @NotNull
        private final Map<IndexableSetContributor, Set<VirtualFile>> directories;

        private AdditionalIndexableRoots(@NotNull Set<VirtualFile> files2, @NotNull Map<IndexableSetContributor, Set<VirtualFile>> directories) {
            if (files2 == null) {
                AdditionalIndexableRoots.$$$reportNull$$$0(0);
            }
            if (directories == null) {
                AdditionalIndexableRoots.$$$reportNull$$$0(1);
            }
            this.files = files2;
            this.directories = directories;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "files";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "directories";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/indexing/AdditionalIndexableFileSet$AdditionalIndexableRoots";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

