/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexInfrastructureExtension;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.PersistentIndicesConfiguration;
import com.intellij.util.indexing.diagnostic.IndexDiagnosticDumper;
import com.intellij.util.indexing.impl.storage.FileBasedIndexLayoutSettings;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.File;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J\b\u0010\u0010\u001a\u00020\u000eH\u0007J\b\u0010\u0011\u001a\u00020\u000eH\u0007J\b\u0010\u0012\u001a\u00020\u000eH\u0007J\b\u0010\u0013\u001a\u00020\u000eH\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/intellij/util/indexing/CorruptionMarker;", "", "()V", "CORRUPTION_MARKER_NAME", "", "EXPLICIT_INVALIDATION_REASON", "FORCE_REBUILD_REASON", "MARKED_AS_DIRTY_REASON", "corruptionMarker", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getCorruptionMarker", "()Ljava/nio/file/Path;", "createCorruptionMarker", "", "reason", "dropIndexes", "markIndexesAsClosed", "markIndexesAsDirty", "requestInvalidation", "requireInvalidation", "", "intellij.platform.lang.impl"})
@ApiStatus.Internal
public final class CorruptionMarker {
    private static final String CORRUPTION_MARKER_NAME = "corruption.marker";
    private static final String MARKED_AS_DIRTY_REASON = "Indexes marked as dirty (IDE is expected to be work)";
    private static final String FORCE_REBUILD_REASON = "Indexes were forcibly marked as corrupted";
    private static final String EXPLICIT_INVALIDATION_REASON = "Explicit index invalidation";
    @NotNull
    public static final CorruptionMarker INSTANCE;

    private final Path getCorruptionMarker() {
        return PathManager.getIndexRoot().resolve(CORRUPTION_MARKER_NAME);
    }

    @JvmStatic
    public static final void markIndexesAsDirty() {
        INSTANCE.createCorruptionMarker(MARKED_AS_DIRTY_REASON);
    }

    @JvmStatic
    public static final void markIndexesAsClosed() {
        Path path2 = INSTANCE.getCorruptionMarker();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"corruptionMarker");
        boolean corruptionMarkerExists = PathKt.exists((Path)path2);
        if (corruptionMarkerExists) {
            try {
                Path path3 = INSTANCE.getCorruptionMarker();
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"corruptionMarker");
                if (Intrinsics.areEqual((Object)PathKt.readText((Path)path3), (Object)MARKED_AS_DIRTY_REASON)) {
                    Path path4 = INSTANCE.getCorruptionMarker();
                    Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"corruptionMarker");
                    Path path5 = path4;
                    boolean bl = false;
                    Files.delete(path5);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @JvmStatic
    public static final void requestInvalidation() {
        FileBasedIndexImpl.LOG.info("Explicit index invalidation has been requested");
        INSTANCE.createCorruptionMarker(EXPLICIT_INVALIDATION_REASON);
    }

    @JvmStatic
    public static final boolean requireInvalidation() {
        Path path2 = INSTANCE.getCorruptionMarker();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"corruptionMarker");
        boolean corruptionMarkerExists = PathKt.exists((Path)path2);
        if (corruptionMarkerExists) {
            String message2 = "Indexes are corrupted and will be rebuilt";
            try {
                Path path3 = INSTANCE.getCorruptionMarker();
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"corruptionMarker");
                String corruptionReason = PathKt.readText((Path)path3);
                FileBasedIndexImpl.LOG.info(message2 + " (reason = " + corruptionReason + ')');
            }
            catch (Exception e) {
                FileBasedIndexImpl.LOG.info(message2);
            }
        }
        return IndexInfrastructure.hasIndices() && corruptionMarkerExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void dropIndexes() {
        Path path2 = PathManager.getIndexRoot();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"PathManager.getIndexRoot()");
        Path indexRoot = path2;
        if (Files.exists(indexRoot, new LinkOption[0])) {
            void $this$mapNotNullTo$iv$iv;
            ExtensionPointName<FileBasedIndexInfrastructureExtension> extensionPointName = FileBasedIndexInfrastructureExtension.EP_NAME;
            Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"FileBasedIndexInfrastructureExtension.EP_NAME");
            Object[] objectArray = extensionPointName.getExtensions();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"FileBasedIndexInfrastruc\u2026ension.EP_NAME.extensions");
            Object[] $this$mapNotNull$iv = objectArray;
            boolean $i$f$mapNotNull = false;
            Object object = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            void var9_18 = $this$forEach$iv$iv$iv;
            int n = ((void)var9_18).length;
            for (int j = 0; j < n; ++j) {
                String string;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = var9_18[j];
                boolean bl = false;
                FileBasedIndexInfrastructureExtension it = (FileBasedIndexInfrastructureExtension)element$iv$iv;
                boolean bl2 = false;
                FileBasedIndexInfrastructureExtension fileBasedIndexInfrastructureExtension = it;
                Intrinsics.checkNotNullExpressionValue((Object)fileBasedIndexInfrastructureExtension, (String)"it");
                if (fileBasedIndexInfrastructureExtension.getPersistentStateRoot() == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                String it$iv$iv = string;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Set filesToBeIgnored = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            Path $this$directoryStreamIfExists$iv = indexRoot;
            boolean $i$f$directoryStreamIfExists = false;
            try {
                object = Files.newDirectoryStream($this$directoryStreamIfExists$iv);
                boolean bl = false;
                $i$f$mapNotNullTo2 = false;
                Throwable $i$f$mapNotNullTo2 = null;
                try {
                    DirectoryStream dirStream = (DirectoryStream)object;
                    boolean bl6 = false;
                    Iterable $this$forEach$iv = dirStream;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Path it = (Path)element$iv;
                        boolean bl7 = false;
                        Path path3 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"it");
                        if (filesToBeIgnored.contains(((Object)path3.getFileName()).toString())) continue;
                        FileUtil.deleteWithRenaming((File)it.toFile());
                    }
                    dirStream = Unit.INSTANCE;
                }
                catch (Throwable dirStream) {
                    $i$f$mapNotNullTo2 = dirStream;
                    throw dirStream;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)$i$f$mapNotNullTo2);
                }
            }
            catch (NoSuchFileException noSuchFileException) {
            }
        } else {
            Files.createDirectories(indexRoot, new FileAttribute[0]);
        }
        if (SystemProperties.getBooleanProperty((String)"idea.index.clear.diagnostic.on.invalidation", (boolean)true)) {
            IndexDiagnosticDumper.Companion.clearDiagnostic();
        }
        SerializationManagerEx.getInstanceEx().reinitializeNameStorage();
        ID.reinitializeDiskStorage();
        PersistentIndicesConfiguration.saveConfiguration();
        FileUtil.delete((Path)INSTANCE.getCorruptionMarker());
        ExtensionPointName<FileBasedIndexInfrastructureExtension> extensionPointName = FileBasedIndexInfrastructureExtension.EP_NAME;
        Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"FileBasedIndexInfrastructureExtension.EP_NAME");
        Object[] objectArray = extensionPointName.getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"FileBasedIndexInfrastruc\u2026ension.EP_NAME.extensions");
        Object[] $this$forEach$iv = objectArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FileBasedIndexInfrastructureExtension it = (FileBasedIndexInfrastructureExtension)element$iv;
            boolean bl = false;
            it.resetPersistentState();
        }
        FileBasedIndexLayoutSettings.INSTANCE.saveCurrentLayout();
    }

    private final void createCorruptionMarker(String reason) {
        try {
            Path path2 = this.getCorruptionMarker();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"corruptionMarker");
            PathKt.write$default((Path)path2, (CharSequence)reason, null, (boolean)false, (int)6, null);
        }
        catch (Exception e) {
            FileBasedIndexImpl.LOG.warn((Throwable)e);
        }
    }

    private CorruptionMarker() {
    }

    static {
        CorruptionMarker corruptionMarker;
        INSTANCE = corruptionMarker = new CorruptionMarker();
    }
}

