/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.UpdatableIndex;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class IndexConfiguration {
    private final Int2ObjectMap<Pair<UpdatableIndex<?, ?, FileContent>, FileBasedIndex.InputFilter>> myIndices = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<Throwable> myInitializationProblems = new Int2ObjectOpenHashMap();
    private final List<ID<?, ?>> myIndexIds = new ArrayList();
    private final Object2IntMap<ID<?, ?>> myIndexIdToVersionMap = new Object2IntOpenHashMap();
    private final List<ID<?, ?>> myIndicesWithoutFileTypeInfo = new ArrayList();
    private final Map<FileType, List<ID<?, ?>>> myFileType2IndicesWithFileTypeInfoMap = CollectionFactory.createSmallMemoryFootprintMap();
    private volatile boolean myFreezed;

    IndexConfiguration() {
    }

    @Nullable
    <K, V> UpdatableIndex<K, V, FileContent> getIndex(@NotNull ID<K, V> indexId) {
        if (indexId == null) {
            IndexConfiguration.$$$reportNull$$$0(0);
        }
        assert (this.myFreezed);
        Pair pair = (Pair)this.myIndices.get(indexId.getUniqueId());
        return (UpdatableIndex)Pair.getFirst((Pair)pair);
    }

    @Nullable
    Throwable getInitializationProblem(@NotNull ID<?, ?> indexId) {
        if (indexId == null) {
            IndexConfiguration.$$$reportNull$$$0(1);
        }
        return (Throwable)this.myInitializationProblems.get(indexId.getUniqueId());
    }

    @NotNull
    FileBasedIndex.InputFilter getInputFilter(@NotNull ID<?, ?> indexId) {
        if (indexId == null) {
            IndexConfiguration.$$$reportNull$$$0(2);
        }
        assert (this.myFreezed);
        Pair pair = (Pair)this.myIndices.get(indexId.getUniqueId());
        assert (pair != null) : "Index data is absent for index " + indexId;
        FileBasedIndex.InputFilter inputFilter = (FileBasedIndex.InputFilter)pair.getSecond();
        if (inputFilter == null) {
            IndexConfiguration.$$$reportNull$$$0(3);
        }
        return inputFilter;
    }

    void freeze() {
        this.myFreezed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerIndexInitializationProblem(@NotNull ID<?, ?> indexId, @NotNull Throwable problemTrace) {
        if (indexId == null) {
            IndexConfiguration.$$$reportNull$$$0(4);
        }
        if (problemTrace == null) {
            IndexConfiguration.$$$reportNull$$$0(5);
        }
        assert (!this.myFreezed);
        Int2ObjectMap<Throwable> int2ObjectMap = this.myInitializationProblems;
        synchronized (int2ObjectMap) {
            this.myInitializationProblems.put(indexId.getUniqueId(), (Object)problemTrace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <K, V> void registerIndex(@NotNull ID<K, V> indexId, @NotNull UpdatableIndex<K, V, FileContent> index2, @NotNull FileBasedIndex.InputFilter inputFilter, int version2, @Nullable Collection<? extends FileType> associatedFileTypes) {
        if (indexId == null) {
            IndexConfiguration.$$$reportNull$$$0(6);
        }
        if (index2 == null) {
            IndexConfiguration.$$$reportNull$$$0(7);
        }
        if (inputFilter == null) {
            IndexConfiguration.$$$reportNull$$$0(8);
        }
        assert (!this.myFreezed);
        Int2ObjectMap<Pair<UpdatableIndex<?, ?, FileContent>, FileBasedIndex.InputFilter>> int2ObjectMap = this.myIndices;
        synchronized (int2ObjectMap) {
            this.myIndexIds.add(indexId);
            this.myIndexIdToVersionMap.put(indexId, version2);
            if (associatedFileTypes != null) {
                for (FileType fileType : associatedFileTypes) {
                    List ids = this.myFileType2IndicesWithFileTypeInfoMap.computeIfAbsent(fileType, __ -> new ArrayList(5));
                    ids.add(indexId);
                }
            } else {
                this.myIndicesWithoutFileTypeInfo.add(indexId);
            }
            Pair old = (Pair)this.myIndices.put(indexId.getUniqueId(), (Object)new Pair(index2, (Object)inputFilter));
            if (old != null) {
                throw new IllegalStateException("Index " + old.first + " already registered for the name '" + indexId + "'");
            }
        }
    }

    @NotNull
    List<ID<?, ?>> getFileTypesForIndex(@NotNull FileType fileType) {
        if (fileType == null) {
            IndexConfiguration.$$$reportNull$$$0(9);
        }
        assert (this.myFreezed);
        List<ID<?, ?>> ids = this.myFileType2IndicesWithFileTypeInfoMap.get(fileType);
        if (ids == null) {
            ids = this.myIndicesWithoutFileTypeInfo;
        }
        List<ID<?, ?>> list2 = ids;
        if (list2 == null) {
            IndexConfiguration.$$$reportNull$$$0(10);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finalizeFileTypeMappingForIndices() {
        assert (!this.myFreezed);
        Int2ObjectMap<Pair<UpdatableIndex<?, ?, FileContent>, FileBasedIndex.InputFilter>> int2ObjectMap = this.myIndices;
        synchronized (int2ObjectMap) {
            for (List<ID<?, ?>> value2 : this.myFileType2IndicesWithFileTypeInfoMap.values()) {
                value2.addAll(this.myIndicesWithoutFileTypeInfo);
            }
        }
    }

    @NotNull
    Collection<ID<?, ?>> getIndexIDs() {
        assert (this.myFreezed);
        List<ID<?, ?>> list2 = this.myIndexIds;
        if (list2 == null) {
            IndexConfiguration.$$$reportNull$$$0(11);
        }
        return list2;
    }

    int getIndexVersion(@NotNull ID<?, ?> id2) {
        if (id2 == null) {
            IndexConfiguration.$$$reportNull$$$0(12);
        }
        assert (this.myFreezed);
        return this.myIndexIdToVersionMap.getInt(id2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 3: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/IndexConfiguration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemTrace";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputFilter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/IndexConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypesForIndex";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexIDs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIndex";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInitializationProblem";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInputFilter";
                break;
            }
            case 3: 
            case 10: 
            case 11: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerIndexInitializationProblem";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerIndex";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypesForIndex";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getIndexVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

