/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.google.common.collect.ImmutableSortedMap;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.BinaryFileStubBuilders;
import com.intellij.psi.stubs.StubIndexExtension;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.Function;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexVersionInfo;
import com.intellij.util.indexing.ID;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class IndexInfrastructureVersionBase {
    private static final Logger LOG = Logger.getInstance(IndexInfrastructureVersionBase.class);
    @NotNull
    protected final SortedMap<String, String> myBaseIndexes;
    @NotNull
    protected final SortedMap<String, FileBasedIndexVersionInfo> myFileBasedIndexVersions;
    @NotNull
    protected final SortedMap<String, String> myStubIndexVersions;
    @NotNull
    protected final SortedMap<String, String> myStubFileElementTypeVersions;
    @NotNull
    protected final SortedMap<String, String> myCompositeBinaryStubFileBuilderVersions;

    public IndexInfrastructureVersionBase(@NotNull Map<String, String> baseIndexes, @NotNull Map<String, FileBasedIndexVersionInfo> fileBasedIndexVersions2, @NotNull Map<String, String> stubIndexVersions, @NotNull Map<String, String> stubFileElementTypeVersions, @NotNull Map<String, String> compositeBinaryStubFileBuilderVersions) {
        if (baseIndexes == null) {
            IndexInfrastructureVersionBase.$$$reportNull$$$0(0);
        }
        if (fileBasedIndexVersions2 == null) {
            IndexInfrastructureVersionBase.$$$reportNull$$$0(1);
        }
        if (stubIndexVersions == null) {
            IndexInfrastructureVersionBase.$$$reportNull$$$0(2);
        }
        if (stubFileElementTypeVersions == null) {
            IndexInfrastructureVersionBase.$$$reportNull$$$0(3);
        }
        if (compositeBinaryStubFileBuilderVersions == null) {
            IndexInfrastructureVersionBase.$$$reportNull$$$0(4);
        }
        this.myBaseIndexes = ImmutableSortedMap.copyOf(baseIndexes);
        this.myFileBasedIndexVersions = ImmutableSortedMap.copyOf(fileBasedIndexVersions2);
        this.myStubIndexVersions = ImmutableSortedMap.copyOf(stubIndexVersions);
        this.myStubFileElementTypeVersions = ImmutableSortedMap.copyOf(stubFileElementTypeVersions);
        this.myCompositeBinaryStubFileBuilderVersions = ImmutableSortedMap.copyOf(compositeBinaryStubFileBuilderVersions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexInfrastructureVersionBase base = (IndexInfrastructureVersionBase)o;
        return this.myBaseIndexes.equals(base.myBaseIndexes) && this.myFileBasedIndexVersions.equals(base.myFileBasedIndexVersions) && this.myStubIndexVersions.equals(base.myStubIndexVersions) && this.myStubFileElementTypeVersions.equals(base.myStubFileElementTypeVersions) && this.myCompositeBinaryStubFileBuilderVersions.equals(base.myCompositeBinaryStubFileBuilderVersions);
    }

    public int hashCode() {
        return Objects.hash(this.myBaseIndexes, this.myFileBasedIndexVersions, this.myStubIndexVersions, this.myStubFileElementTypeVersions, this.myCompositeBinaryStubFileBuilderVersions);
    }

    @NotNull
    public static Map<String, FileBasedIndexVersionInfo> fileBasedIndexVersions(@NotNull List<FileBasedIndexExtension<?, ?>> fileBasedIndexExtensions, @NotNull Function<? super FileBasedIndexExtension<?, ?>, String> versionExtractor) {
        if (fileBasedIndexExtensions == null) {
            IndexInfrastructureVersionBase.$$$reportNull$$$0(5);
        }
        if (versionExtractor == null) {
            IndexInfrastructureVersionBase.$$$reportNull$$$0(6);
        }
        HashMap<String, FileBasedIndexVersionInfo> builder2 = new HashMap<String, FileBasedIndexVersionInfo>();
        for (FileBasedIndexExtension<?, ?> extension2 : fileBasedIndexExtensions) {
            FileBasedIndexVersionInfo newValue2;
            ID indexId = extension2.getName();
            String name2 = indexId.getName();
            FileBasedIndexVersionInfo oldValue = builder2.put(name2, newValue2 = new FileBasedIndexVersionInfo((String)versionExtractor.fun(extension2), extension2.needsForwardIndexWhenSharing()));
            if (oldValue == null || oldValue.equals(newValue2)) continue;
            LOG.warn("Multiple declarations of the same file based index: " + name2 + ", old value " + oldValue + ", new value: " + newValue2);
        }
        HashMap<String, FileBasedIndexVersionInfo> hashMap = builder2;
        if (hashMap == null) {
            IndexInfrastructureVersionBase.$$$reportNull$$$0(7);
        }
        return hashMap;
    }

    @NotNull
    public static Map<String, String> stubIndexVersions(@NotNull List<StubIndexExtension<?, ?>> stubIndexExtensions) {
        if (stubIndexExtensions == null) {
            IndexInfrastructureVersionBase.$$$reportNull$$$0(8);
        }
        HashMap<String, String> builder2 = new HashMap<String, String>();
        FileBasedIndexExtension stubUpdatingIndex = (FileBasedIndexExtension)FileBasedIndexExtension.EXTENSION_POINT_NAME.findFirstSafe(ex -> ex.getName().equals(StubUpdatingIndex.INDEX_ID));
        if (stubUpdatingIndex == null) {
            throw new RuntimeException("Failed to find " + StubUpdatingIndex.INDEX_ID);
        }
        String commonPrefix = stubUpdatingIndex.getVersion() + ":";
        for (StubIndexExtension<?, ?> ex2 : stubIndexExtensions) {
            String newValue2;
            String name2 = ex2.getKey().getName();
            String oldValue = builder2.put(name2, newValue2 = commonPrefix + ex2.getVersion());
            if (oldValue == null || oldValue.equals(newValue2)) continue;
            LOG.warn("Multiple declarations of the same stub based index: " + name2 + ", old value " + oldValue + ", new value: " + newValue2);
        }
        HashMap<String, String> hashMap = builder2;
        if (hashMap == null) {
            IndexInfrastructureVersionBase.$$$reportNull$$$0(9);
        }
        return hashMap;
    }

    @NotNull
    public static Map<String, String> getAllCompositeBinaryFileStubBuilderVersions() {
        HashMap<String, String> result2 = new HashMap<String, String>();
        for (Map.Entry entry2 : BinaryFileStubBuilders.INSTANCE.getAllRegisteredExtensions().entrySet()) {
            BinaryFileStubBuilder builder2 = (BinaryFileStubBuilder)entry2.getValue();
            if (!(builder2 instanceof BinaryFileStubBuilder.CompositeBinaryFileStubBuilder)) continue;
            result2.put(((FileType)entry2.getKey()).getName(), IndexInfrastructureVersionBase.getBinaryFileStubBuilderVersion((BinaryFileStubBuilder.CompositeBinaryFileStubBuilder)builder2));
        }
        HashMap<String, String> hashMap = result2;
        if (hashMap == null) {
            IndexInfrastructureVersionBase.$$$reportNull$$$0(10);
        }
        return hashMap;
    }

    @NotNull
    public static String getBinaryFileStubBuilderVersion(@NotNull BinaryFileStubBuilder.CompositeBinaryFileStubBuilder<?> builder2) {
        if (builder2 == null) {
            IndexInfrastructureVersionBase.$$$reportNull$$$0(11);
        }
        BinaryFileStubBuilder.CompositeBinaryFileStubBuilder<?> genericBuilder = builder2;
        String string = builder2.getClass().getName() + ":" + builder2.getStubVersion() + ";" + genericBuilder.getAllSubBuilders().map(b -> genericBuilder.getSubBuilderVersion(b)).sorted().collect(Collectors.joining(";"));
        if (string == null) {
            IndexInfrastructureVersionBase.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public static Map<String, String> stubFileElementTypeVersions() {
        HashMap<String, String> builder2 = new HashMap<String, String>();
        for (IFileElementType fileElementType : IndexInfrastructureVersionBase.getAllStubFileElementTypes()) {
            String newVersion;
            if (!(fileElementType instanceof IStubFileElementType)) continue;
            int stubVersion = IndexInfrastructureVersionBase.getStubFileElementBaseVersion((IStubFileElementType)fileElementType);
            String name2 = IndexInfrastructureVersionBase.getStubFileElementTypeKey((IStubFileElementType)fileElementType);
            String oldValue = builder2.put(name2, newVersion = Integer.toString(stubVersion));
            if (oldValue == null || oldValue.equals(newVersion)) continue;
            LOG.warn("Multiple declarations of the same IFileElementType: " + name2 + ", old version " + oldValue + ", new version: " + newVersion);
        }
        HashMap<String, String> hashMap = builder2;
        if (hashMap == null) {
            IndexInfrastructureVersionBase.$$$reportNull$$$0(13);
        }
        return hashMap;
    }

    @NotNull
    public static List<IFileElementType> getAllStubFileElementTypes() {
        List<IFileElementType> list2 = Arrays.stream(FileTypeManager.getInstance().getRegisteredFileTypes()).filter(type -> type instanceof LanguageFileType).map(type -> ((LanguageFileType)type).getLanguage()).map(arg_0 -> ((LanguageParserDefinitions)LanguageParserDefinitions.INSTANCE).forLanguage(arg_0)).filter(Objects::nonNull).map(ParserDefinition::getFileNodeType).collect(Collectors.toList());
        if (list2 == null) {
            IndexInfrastructureVersionBase.$$$reportNull$$$0(14);
        }
        return list2;
    }

    @NotNull
    public static String getStubFileElementTypeKey(@NotNull IStubFileElementType<?> fileNodeType) {
        if (fileNodeType == null) {
            IndexInfrastructureVersionBase.$$$reportNull$$$0(15);
        }
        String string = fileNodeType.getExternalId() + ":" + fileNodeType.getLanguage().getID();
        if (string == null) {
            IndexInfrastructureVersionBase.$$$reportNull$$$0(16);
        }
        return string;
    }

    public static int getStubFileElementBaseVersion(@NotNull IStubFileElementType<?> fileNodeType) {
        if (fileNodeType == null) {
            IndexInfrastructureVersionBase.$$$reportNull$$$0(17);
        }
        int stubVersion = fileNodeType.getStubVersion();
        return fileNodeType.getLanguage() instanceof TemplateLanguage ? stubVersion - IStubFileElementType.getTemplateStubBaseVersion() : stubVersion;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseIndexes";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileBasedIndexVersions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubIndexVersions";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubFileElementTypeVersions";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compositeBinaryStubFileBuilderVersions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileBasedIndexExtensions";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionExtractor";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/IndexInfrastructureVersionBase";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubIndexExtensions";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNodeType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/IndexInfrastructureVersionBase";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "fileBasedIndexVersions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "stubIndexVersions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllCompositeBinaryFileStubBuilderVersions";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryFileStubBuilderVersion";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "stubFileElementTypeVersions";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllStubFileElementTypes";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubFileElementTypeKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fileBasedIndexVersions";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "stubIndexVersions";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryFileStubBuilderVersion";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getStubFileElementTypeKey";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getStubFileElementBaseVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

