/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.util.ExceptionUtil;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

final class RootChangesLogger {
    private static final int BATCH_CAPACITY = 10;
    @NotNull
    private static final Logger myLogger = Logger.getInstance(RootChangesLogger.class);
    @NotNull
    private final IntOpenHashSet myReportedHashes = new IntOpenHashSet();
    private final List<Report> myReports = new ArrayList<Report>(10);

    RootChangesLogger() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void info(@NotNull Project project, boolean fullReindex) {
        boolean isNew;
        if (project == null) {
            RootChangesLogger.$$$reportNull$$$0(0);
        }
        Throwable stacktrace = new Throwable();
        int hash = ThrowableInterner.computeAccurateTraceHashCode((Throwable)stacktrace);
        IntOpenHashSet intOpenHashSet = this.myReportedHashes;
        synchronized (intOpenHashSet) {
            isNew = this.myReportedHashes.add(hash);
        }
        if (isNew) {
            myLogger.info("New rootsChanged event for \"" + project.getName() + "\" project with " + (fullReindex ? "full" : "partial") + " reindex with trace_hash = " + hash + ":\n" + ExceptionUtil.getThrowableText((Throwable)stacktrace));
            return;
        }
        Report[] reports = null;
        List<Report> list2 = this.myReports;
        synchronized (list2) {
            this.myReports.add(new Report(hash, fullReindex));
            if (this.myReports.size() == 10) {
                reports = this.myReports.toArray(new Report[0]);
                this.myReports.clear();
            }
        }
        if (reports != null) {
            StringBuilder text2 = new StringBuilder();
            text2.append(10).append(" more rootsChanged events for \"").append(project.getName()).append("\" project.");
            Arrays.stream(reports).collect(Collectors.groupingBy(report2 -> report2)).forEach((report2, equalHashes) -> text2.append(" ").append(equalHashes.size()).append(" ").append(report2.myFullReindex ? "full" : "partial").append(" reindex with trace_hash = ").append(report2.myHash).append(";"));
            myLogger.info(text2.substring(0, text2.length() - 1));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/indexing/RootChangesLogger", "info"));
    }

    private static class Report {
        private final int myHash;
        private final boolean myFullReindex;

        Report(int hash, boolean isFullReindex) {
            this.myHash = hash;
            this.myFullReindex = isFullReindex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Report report2 = (Report)o;
            return this.myHash == report2.myHash && this.myFullReindex == report2.myFullReindex;
        }

        public int hashCode() {
            return Objects.hash(this.myHash, this.myFullReindex);
        }
    }
}

