/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.util.indexing.diagnostic.ProjectIndexingHistory;
import com.intellij.util.indexing.diagnostic.ProjectIndexingHistoryFusReporter;
import com.intellij.util.indexing.diagnostic.ProjectIndexingHistoryListener;
import com.intellij.util.indexing.diagnostic.StatsPerFileType;
import com.intellij.util.indexing.diagnostic.dto.JsonFileProviderIndexStatistics;
import com.intellij.util.indexing.diagnostic.dto.JsonScanningStatistics;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0004j\u0002`\u00062\n\u0010\u0007\u001a\u00060\u0004j\u0002`\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryFusReporterListener;", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryListener;", "()V", "calculateReadSpeed", "", "bytes", "Lcom/intellij/util/indexing/diagnostic/BytesNumber;", "loadingTime", "Lcom/intellij/util/indexing/diagnostic/TimeNano;", "onFinishedIndexing", "", "projectIndexingHistory", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory;", "onStartedIndexing", "intellij.platform.lang.impl"})
public final class ProjectIndexingHistoryFusReporterListener
implements ProjectIndexingHistoryListener {
    @Override
    public void onStartedIndexing(@NotNull ProjectIndexingHistory projectIndexingHistory) {
        Intrinsics.checkNotNullParameter((Object)projectIndexingHistory, (String)"projectIndexingHistory");
        ProjectIndexingHistoryFusReporter.INSTANCE.reportIndexingStarted(projectIndexingHistory.getProject(), projectIndexingHistory.getIndexingSessionId());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onFinishedIndexing(@NotNull ProjectIndexingHistory projectIndexingHistory) {
        long l;
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)projectIndexingHistory, (String)"projectIndexingHistory");
        long scanningTime = projectIndexingHistory.getTimes().getScanFilesDuration().toMillis();
        int numberOfFileProviders = projectIndexingHistory.getScanningStatistics().size();
        Iterable $this$sumBy$iv = projectIndexingHistory.getScanningStatistics();
        boolean $i$f$sumBy22 = false;
        int sum$iv22 = 0;
        for (Object element$iv : $this$sumBy$iv) {
            Object it22;
            JsonScanningStatistics jsonScanningStatistics = (JsonScanningStatistics)element$iv;
            n2 = sum$iv22;
            boolean bl = false;
            n = ((JsonScanningStatistics)it22).getNumberOfScannedFiles();
            sum$iv22 = n2 + n;
        }
        int numberOfScannedFiles = sum$iv22;
        Iterable $i$f$sumBy22 = projectIndexingHistory.getScanningStatistics();
        sum$iv22 = 0;
        int n3 = 0;
        for (Object it22 : $i$f$sumBy22) {
            void it;
            JsonScanningStatistics bl = (JsonScanningStatistics)it22;
            n2 = n3;
            boolean bl2 = false;
            n = it.getNumberOfFilesFullyIndexedByInfrastructureExtensions();
            n3 = n2 + n;
        }
        int numberOfFilesIndexedByExtensionsDuringScan = n3;
        Iterable sum$iv22 = projectIndexingHistory.getProviderStatistics();
        n3 = 0;
        int n4 = 0;
        for (Object e : sum$iv22) {
            void it32;
            JsonFileProviderIndexStatistics bl2 = (JsonFileProviderIndexStatistics)e;
            n2 = n4;
            boolean bl = false;
            n = it32.getTotalNumberOfFilesFullyIndexedByExtensions();
            n4 = n2 + n;
        }
        int numberOfFilesIndexedByExtensionsWithLoadingContent = n4;
        Iterable iterable = projectIndexingHistory.getProviderStatistics();
        n4 = 0;
        int it22 = 0;
        for (Object it32 : iterable) {
            void it;
            JsonFileProviderIndexStatistics bl = (JsonFileProviderIndexStatistics)it32;
            n2 = it22;
            boolean bl3 = false;
            n = it.getTotalNumberOfIndexedFiles();
            it22 = n2 + n;
        }
        int numberOfFilesIndexedWithLoadingContent = it22;
        Iterable it22 = projectIndexingHistory.getTotalStatsPerFileType().values();
        boolean bl = false;
        long it32 = 0L;
        for (Object t : it22) {
            Iterator it;
            StatsPerFileType statsPerFileType = (StatsPerFileType)t;
            long l2 = it32;
            boolean bl4 = false;
            l = it.getTotalContentLoadingTimeInAllThreads();
            it32 = l2 + l;
        }
        long totalContentLoadingTime = it32;
        Iterable it32 = projectIndexingHistory.getTotalStatsPerFileType().values();
        boolean bl5 = false;
        long bl3 = 0L;
        for (Object t : it32) {
            void it;
            StatsPerFileType statsPerFileType = (StatsPerFileType)t;
            long l3 = bl3;
            boolean bl6 = false;
            l = it.getTotalBytes();
            bl3 = l3 + l;
        }
        long totalContentData = bl3;
        long averageContentLoadingSpeed = this.calculateReadSpeed(totalContentData, totalContentLoadingTime);
        HashMap contentLoadingSpeedByFileType = new HashMap();
        Map<String, StatsPerFileType> $this$forEach$iv = projectIndexingHistory.getTotalStatsPerFileType();
        boolean $i$f$forEach = false;
        Map<String, StatsPerFileType> map2 = $this$forEach$iv;
        boolean bl7 = false;
        Iterator<Map.Entry<String, StatsPerFileType>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            void fileType;
            Map.Entry<String, StatsPerFileType> element$iv;
            Map.Entry<String, StatsPerFileType> $dstr$fileType$stats = element$iv = iterator2.next();
            boolean bl8 = false;
            Map.Entry<String, StatsPerFileType> entry2 = $dstr$fileType$stats;
            boolean bl9 = false;
            String string = entry2.getKey();
            entry2 = $dstr$fileType$stats;
            bl9 = false;
            StatsPerFileType stats = entry2.getValue();
            if (stats.getTotalContentLoadingTimeInAllThreads() == 0L || stats.getTotalBytes() == 0L) continue;
            Map map3 = contentLoadingSpeedByFileType;
            FileType fileType2 = FileTypeManager.getInstance().getStdFileType((String)fileType);
            Intrinsics.checkNotNullExpressionValue((Object)fileType2, (String)"FileTypeManager.getInsta\u2026.getStdFileType(fileType)");
            map3.put(fileType2, this.calculateReadSpeed(stats.getTotalBytes(), stats.getTotalContentLoadingTimeInAllThreads()));
        }
        ProjectIndexingHistoryFusReporter.INSTANCE.reportIndexingFinished(projectIndexingHistory.getProject(), projectIndexingHistory.getIndexingSessionId(), TimeUnit.NANOSECONDS.toMillis(projectIndexingHistory.getTimes().getTotalUpdatingTime()), scanningTime, numberOfFileProviders, numberOfScannedFiles, numberOfFilesIndexedByExtensionsDuringScan, numberOfFilesIndexedByExtensionsWithLoadingContent, numberOfFilesIndexedWithLoadingContent, averageContentLoadingSpeed, contentLoadingSpeedByFileType);
    }

    private final long calculateReadSpeed(long bytes, long loadingTime) {
        if (bytes == 0L || loadingTime == 0L) {
            return 0L;
        }
        long nanoSecondInOneSecond = TimeUnit.SECONDS.toNanos(1L);
        return bytes * nanoSecondInOneSecond > 0L ? bytes * nanoSecondInOneSecond / loadingTime : MathKt.roundToLong((double)((double)bytes / (double)loadingTime * (double)nanoSecondInOneSecond));
    }
}

