/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.indexing.diagnostic.dto.JsonConverterKt;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
@JsonIgnoreProperties(ignoreUnknown=true)
@Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0087\b\u0018\u00002\u00020\u0001:\u0002\u0015\u0016B\u0013\u0012\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\r\u0010\u000b\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\u0017\u0010\f\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\u0006\u0010\u0012\u001a\u00020\u0013J\t\u0010\u0014\u001a\u00020\u0013H\u00d6\u0001R\u0015\u0010\u0006\u001a\u00060\u0003j\u0002`\u00078G\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0017"}, d2={"Lcom/intellij/util/indexing/diagnostic/dto/JsonDuration;", "", "nano", "", "Lcom/intellij/util/indexing/diagnostic/TimeNano;", "(J)V", "milliseconds", "Lcom/intellij/util/indexing/diagnostic/TimeMillis;", "getMilliseconds", "()J", "getNano", "component1", "copy", "equals", "", "other", "hashCode", "", "presentableDuration", "", "toString", "Deserializer", "Serializer", "intellij.platform.lang.impl"})
public final class JsonDuration {
    private final long nano;

    @JsonIgnore
    public final long getMilliseconds() {
        return TimeUnit.NANOSECONDS.toMillis(this.nano);
    }

    @NotNull
    public final String presentableDuration() {
        String string;
        if (this.nano == 0L) {
            string = "0";
        } else if (this.nano < TimeUnit.MILLISECONDS.toNanos(1L)) {
            string = "< 1 ms";
        } else {
            String string2 = StringUtil.formatDuration((long)JsonConverterKt.toMillis(this.nano));
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringUtil.formatDuration(nano.toMillis())");
        }
        return string;
    }

    public final long getNano() {
        return this.nano;
    }

    public JsonDuration(long nano) {
        this.nano = nano;
    }

    public /* synthetic */ JsonDuration(long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = 0L;
        }
        this(l);
    }

    public JsonDuration() {
        this(0L, 1, null);
    }

    public final long component1() {
        return this.nano;
    }

    @NotNull
    public final JsonDuration copy(long nano) {
        return new JsonDuration(nano);
    }

    public static /* synthetic */ JsonDuration copy$default(JsonDuration jsonDuration, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = jsonDuration.nano;
        }
        return jsonDuration.copy(l);
    }

    @NotNull
    public String toString() {
        return "JsonDuration(nano=" + this.nano + ")";
    }

    public int hashCode() {
        return Long.hashCode(this.nano);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof JsonDuration)) break block3;
                JsonDuration jsonDuration = (JsonDuration)object;
                if (this.nano != jsonDuration.nano) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/util/indexing/diagnostic/dto/JsonDuration$Serializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lcom/intellij/util/indexing/diagnostic/dto/JsonDuration;", "()V", "serialize", "", "value", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializers", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "intellij.platform.lang.impl"})
    public static final class Serializer
    extends JsonSerializer<JsonDuration> {
        @NotNull
        public static final Serializer INSTANCE;

        public void serialize(@NotNull JsonDuration value2, @NotNull JsonGenerator gen, @Nullable SerializerProvider serializers) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Intrinsics.checkNotNullParameter((Object)gen, (String)"gen");
            gen.writeNumber(value2.getNano());
        }

        private Serializer() {
        }

        static {
            Serializer serializer2;
            INSTANCE = serializer2 = new Serializer();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/util/indexing/diagnostic/dto/JsonDuration$Deserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lcom/intellij/util/indexing/diagnostic/dto/JsonDuration;", "()V", "deserialize", "p", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "intellij.platform.lang.impl"})
    public static final class Deserializer
    extends JsonDeserializer<JsonDuration> {
        @NotNull
        public static final Deserializer INSTANCE;

        @NotNull
        public JsonDuration deserialize(@NotNull JsonParser p, @Nullable DeserializationContext ctxt) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return new JsonDuration(p.getLongValue());
        }

        private Deserializer() {
        }

        static {
            Deserializer deserializer;
            INSTANCE = deserializer = new Deserializer();
        }
    }
}

