/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic.dump.paths.resolvers;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePath;
import com.intellij.util.indexing.diagnostic.dump.paths.resolvers.LibraryRootPortableFilePathResolver$WhenMappings;
import com.intellij.util.indexing.diagnostic.dump.paths.resolvers.PortableFilePathResolver;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/util/indexing/diagnostic/dump/paths/resolvers/LibraryRootPortableFilePathResolver;", "Lcom/intellij/util/indexing/diagnostic/dump/paths/resolvers/PortableFilePathResolver;", "()V", "findFileByPath", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "portableFilePath", "Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath;", "findInLibraryTable", "libraryTable", "Lcom/intellij/openapi/roots/libraries/LibraryTable;", "Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath$LibraryRoot;", "intellij.platform.lang.impl"})
public final class LibraryRootPortableFilePathResolver
implements PortableFilePathResolver {
    @NotNull
    public static final LibraryRootPortableFilePathResolver INSTANCE;

    @Override
    @Nullable
    public VirtualFile findFileByPath(@NotNull Project project, @NotNull PortableFilePath portableFilePath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)portableFilePath, (String)"portableFilePath");
        if (portableFilePath instanceof PortableFilePath.LibraryRoot) {
            boolean $i$f$runReadAction = false;
            return (VirtualFile)ApplicationManager.getApplication().runReadAction(new Computable(portableFilePath, project){
                final /* synthetic */ PortableFilePath $portableFilePath$inlined;
                final /* synthetic */ Project $project$inlined;
                {
                    this.$portableFilePath$inlined = portableFilePath;
                    this.$project$inlined = project;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final T compute() {
                    VirtualFile virtualFile2;
                    boolean bl = false;
                    switch (LibraryRootPortableFilePathResolver$WhenMappings.$EnumSwitchMapping$0[((PortableFilePath.LibraryRoot)this.$portableFilePath$inlined).getLibraryType().ordinal()]) {
                        case 1: {
                            LibraryTablesRegistrar libraryTablesRegistrar = LibraryTablesRegistrar.getInstance();
                            Intrinsics.checkNotNullExpressionValue((Object)libraryTablesRegistrar, (String)"LibraryTablesRegistrar.getInstance()");
                            LibraryTable libraryTable = libraryTablesRegistrar.getLibraryTable();
                            Intrinsics.checkNotNullExpressionValue((Object)libraryTable, (String)"LibraryTablesRegistrar.getInstance().libraryTable");
                            virtualFile2 = LibraryRootPortableFilePathResolver.access$findInLibraryTable(LibraryRootPortableFilePathResolver.INSTANCE, libraryTable, (PortableFilePath.LibraryRoot)this.$portableFilePath$inlined);
                            break;
                        }
                        case 2: {
                            LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(this.$project$inlined);
                            Intrinsics.checkNotNullExpressionValue((Object)libraryTable, (String)"LibraryTablesRegistrar.g\u2026.getLibraryTable(project)");
                            virtualFile2 = LibraryRootPortableFilePathResolver.access$findInLibraryTable(LibraryRootPortableFilePathResolver.INSTANCE, libraryTable, (PortableFilePath.LibraryRoot)this.$portableFilePath$inlined);
                            break;
                        }
                        case 3: {
                            VirtualFile virtualFile3;
                            String string = ((PortableFilePath.LibraryRoot)this.$portableFilePath$inlined).getModuleName();
                            Intrinsics.checkNotNull((Object)string);
                            String moduleName = string;
                            Module module = ModuleManager.getInstance((Project)this.$project$inlined).findModuleByName(moduleName);
                            if (module == null) {
                                virtualFile2 = null;
                                break;
                            }
                            Intrinsics.checkNotNullExpressionValue((Object)module, (String)"ModuleManager.getInstanc\u2026return@runReadAction null");
                            Module module2 = module;
                            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module2);
                            Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
                            ModifiableRootModel modifiableRootModel = moduleRootManager.getModifiableModel();
                            Intrinsics.checkNotNullExpressionValue((Object)modifiableRootModel, (String)"ModuleRootManager.getIns\u2026e(module).modifiableModel");
                            ModifiableRootModel rootModel = modifiableRootModel;
                            try {
                                LibraryTable libraryTable = rootModel.getModuleLibraryTable();
                                Intrinsics.checkNotNullExpressionValue((Object)libraryTable, (String)"rootModel.moduleLibraryTable");
                                virtualFile3 = LibraryRootPortableFilePathResolver.access$findInLibraryTable(LibraryRootPortableFilePathResolver.INSTANCE, libraryTable, (PortableFilePath.LibraryRoot)this.$portableFilePath$inlined);
                            }
                            finally {
                                rootModel.dispose();
                            }
                            virtualFile2 = virtualFile3;
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    return (T)virtualFile2;
                }
            });
        }
        return null;
    }

    private final VirtualFile findInLibraryTable(LibraryTable libraryTable, PortableFilePath.LibraryRoot portableFilePath) {
        Library library2 = libraryTable.getLibraryByName(portableFilePath.getLibraryName());
        if (library2 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)library2, (String)"libraryTable.getLibraryB\u2026braryName) ?: return null");
        Library library3 = library2;
        OrderRootType rootType = portableFilePath.getInClassFiles() ? OrderRootType.CLASSES : OrderRootType.SOURCES;
        Object[] roots2 = library3.getRootProvider().getFiles(rootType);
        Intrinsics.checkNotNullExpressionValue((Object)roots2, (String)"roots");
        return (VirtualFile)ArraysKt.getOrNull((Object[])roots2, (int)portableFilePath.getLibraryRootIndex());
    }

    private LibraryRootPortableFilePathResolver() {
    }

    static {
        LibraryRootPortableFilePathResolver libraryRootPortableFilePathResolver;
        INSTANCE = libraryRootPortableFilePathResolver = new LibraryRootPortableFilePathResolver();
    }

    public static final /* synthetic */ VirtualFile access$findInLibraryTable(LibraryRootPortableFilePathResolver $this, LibraryTable libraryTable, PortableFilePath.LibraryRoot portableFilePath) {
        return $this.findInLibraryTable(libraryTable, portableFilePath);
    }
}

