/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.projectFilter;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.NonBlockingReadAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.util.Function;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import com.intellij.util.indexing.projectFilter.FileAddStatus;
import com.intellij.util.indexing.projectFilter.IncrementalProjectIndexableFilesFilter;
import com.intellij.util.indexing.projectFilter.IncrementalProjectIndexableFilesFilterHolder;
import com.intellij.util.indexing.projectFilter.ProjectIndexableFilesFilterHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\r0\fH\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u0016\u001a\u00020\u0010H\u0016J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0006H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/util/indexing/projectFilter/IncrementalProjectIndexableFilesFilterHolder;", "Lcom/intellij/util/indexing/projectFilter/ProjectIndexableFilesFilterHolder;", "()V", "myProjectFilters", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/util/indexing/projectFilter/IncrementalProjectIndexableFilesFilter;", "addFileId", "Lcom/intellij/util/indexing/projectFilter/FileAddStatus;", "fileId", "", "projects", "Lkotlin/Function0;", "", "project", "entireProjectUpdateFinished", "", "entireProjectUpdateStarted", "findProjectForFile", "getProjectIndexableFiles", "Lcom/intellij/util/indexing/IdFilter;", "removeFile", "runHealthCheck", "", "Lcom/intellij/util/indexing/projectFilter/IncrementalProjectIndexableFilesFilterHolder$HealthCheckError;", "filter", "HealthCheckError", "intellij.platform.lang.impl"})
public final class IncrementalProjectIndexableFilesFilterHolder
extends ProjectIndexableFilesFilterHolder {
    private final ConcurrentMap<Project, IncrementalProjectIndexableFilesFilter> myProjectFilters;

    @Override
    @Nullable
    public IdFilter getProjectIndexableFiles(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!UnindexedFilesUpdater.isProjectContentFullyScanned(project) || UnindexedFilesUpdater.isIndexUpdateInProgress(project)) {
            return null;
        }
        return (IdFilter)this.myProjectFilters.get(project);
    }

    @Override
    public void entireProjectUpdateStarted(@NotNull Project project) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            boolean bl = UnindexedFilesUpdater.isIndexUpdateInProgress(project);
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            IncrementalProjectIndexableFilesFilter incrementalProjectIndexableFilesFilter = (IncrementalProjectIndexableFilesFilter)((Object)this.myProjectFilters.get(project));
            if (incrementalProjectIndexableFilesFilter == null) break block1;
            incrementalProjectIndexableFilesFilter.memoizeAndResetFileIds();
        }
    }

    @Override
    public void entireProjectUpdateFinished(@NotNull Project project) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            boolean bl = UnindexedFilesUpdater.isIndexUpdateInProgress(project);
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            IncrementalProjectIndexableFilesFilter incrementalProjectIndexableFilesFilter = (IncrementalProjectIndexableFilesFilter)((Object)this.myProjectFilters.get(project));
            if (incrementalProjectIndexableFilesFilter == null) break block1;
            incrementalProjectIndexableFilesFilter.resetPreviousFileIds();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public FileAddStatus addFileId(int fileId, @NotNull Function0<? extends Set<? extends Project>> projects) {
        boolean bl;
        block10: {
            boolean bl2;
            List statuses;
            block9: {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter(projects, (String)"projects");
                KProperty kProperty = null;
                Lazy matchedProjects2 = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Set<? extends Project>>(projects){
                    final /* synthetic */ Function0 $projects;

                    @NotNull
                    public final Set<Project> invoke() {
                        return (Set)this.$projects.invoke();
                    }
                    {
                        this.$projects = function0;
                        super(0);
                    }
                }));
                Map $this$map$iv = this.myProjectFilters;
                boolean $i$f$map = false;
                Iterator iterator2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.size());
                boolean $i$f$mapTo = false;
                void var11_12 = $this$mapTo$iv$iv;
                boolean bl3 = false;
                Iterator iterator3 = var11_12.entrySet().iterator();
                while (iterator3.hasNext()) {
                    void p;
                    void $dstr$p$filter;
                    Map.Entry item$iv$iv;
                    Map.Entry entry2 = item$iv$iv = iterator3.next();
                    Collection collection = destination$iv$iv;
                    boolean bl4 = false;
                    void var17_20 = $dstr$p$filter;
                    boolean bl5 = false;
                    Project project = (Project)var17_20.getKey();
                    var17_20 = $dstr$p$filter;
                    bl5 = false;
                    IncrementalProjectIndexableFilesFilter filter = (IncrementalProjectIndexableFilesFilter)((Object)var17_20.getValue());
                    FileAddStatus fileAddStatus = filter.ensureFileIdPresent(fileId, (Function0<Boolean>)((Function0)new Function0<Boolean>((Project)p, fileId, matchedProjects2, kProperty){
                        final /* synthetic */ Project $p;
                        final /* synthetic */ int $fileId$inlined;
                        final /* synthetic */ Lazy $matchedProjects$inlined;
                        final /* synthetic */ KProperty $matchedProjects$metadata$inlined;
                        {
                            this.$p = project;
                            this.$fileId$inlined = n;
                            this.$matchedProjects$inlined = lazy;
                            this.$matchedProjects$metadata$inlined = kProperty;
                            super(0);
                        }

                        public final boolean invoke() {
                            Lazy lazy = this.$matchedProjects$inlined;
                            Object var2_2 = null;
                            KProperty kProperty = this.$matchedProjects$metadata$inlined;
                            boolean bl = false;
                            return ((Set)lazy.getValue()).contains(this.$p);
                        }
                    }));
                    collection.add(fileAddStatus);
                }
                statuses = (List)destination$iv$iv;
                Iterable $this$all$iv = statuses;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        FileAddStatus it = (FileAddStatus)((Object)element$iv);
                        boolean bl6 = false;
                        if (it == FileAddStatus.SKIPPED) continue;
                        bl2 = false;
                        break block9;
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                return FileAddStatus.SKIPPED;
            }
            Iterable $this$any$iv = statuses;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FileAddStatus it = (FileAddStatus)((Object)element$iv);
                    boolean bl7 = false;
                    if (!(it == FileAddStatus.ADDED)) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        if (bl) {
            return FileAddStatus.ADDED;
        }
        return FileAddStatus.PRESENT;
    }

    @Override
    @NotNull
    public FileAddStatus addFileId(int fileId, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object v = this.myProjectFilters.get(project);
        Intrinsics.checkNotNull(v);
        return ((IncrementalProjectIndexableFilesFilter)((Object)v)).ensureFileIdPresent(fileId, (Function0<Boolean>)((Function0)addFileId.3.INSTANCE));
    }

    @Override
    public void removeFile(int fileId) {
        for (IncrementalProjectIndexableFilesFilter filter : this.myProjectFilters.values()) {
            filter.removeFileId(fileId);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Project findProjectForFile(int fileId) {
        Map map2 = this.myProjectFilters;
        boolean bl = false;
        Iterator iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            void project;
            Map.Entry entry2;
            Map.Entry entry3 = entry2 = iterator2.next();
            boolean bl2 = false;
            map2 = (Project)entry3.getKey();
            entry3 = entry2;
            bl2 = false;
            IncrementalProjectIndexableFilesFilter filter = (IncrementalProjectIndexableFilesFilter)((Object)entry3.getValue());
            if (!filter.containsFileId(fileId)) continue;
            return project;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void runHealthCheck() {
        Map map2 = this.myProjectFilters;
        boolean bl = false;
        Iterator iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            void project;
            List errors2;
            Map.Entry entry2;
            Map.Entry entry3 = entry2 = iterator2.next();
            boolean bl2 = false;
            map2 = (Project)entry3.getKey();
            entry3 = entry2;
            bl2 = false;
            IncrementalProjectIndexableFilesFilter filter = (IncrementalProjectIndexableFilesFilter)((Object)entry3.getValue());
            List list2 = errors2 = (List)ReadAction.nonBlocking((Callable)new Callable(this, (Project)project, filter){
                final /* synthetic */ IncrementalProjectIndexableFilesFilterHolder this$0;
                final /* synthetic */ Project $project;
                final /* synthetic */ IncrementalProjectIndexableFilesFilter $filter;

                public final List<HealthCheckError> call() {
                    Project project = this.$project;
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                    IncrementalProjectIndexableFilesFilter incrementalProjectIndexableFilesFilter = this.$filter;
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)incrementalProjectIndexableFilesFilter), (String)"filter");
                    return IncrementalProjectIndexableFilesFilterHolder.access$runHealthCheck(this.this$0, project, incrementalProjectIndexableFilesFilter);
                }
                {
                    this.this$0 = incrementalProjectIndexableFilesFilterHolder;
                    this.$project = project;
                    this.$filter = incrementalProjectIndexableFilesFilter;
                }
            }).inSmartMode((Project)project).executeSynchronously();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"errors");
            Collection collection = list2;
            boolean bl3 = false;
            if (!collection.isEmpty()) {
                String message2;
                void $this$mapTo$iv$iv;
                for (HealthCheckError error : errors2) {
                    IncrementalProjectIndexableFilesFilter incrementalProjectIndexableFilesFilter = filter;
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)incrementalProjectIndexableFilesFilter), (String)"filter");
                    error.fix(incrementalProjectIndexableFilesFilter);
                }
                Iterable $this$map$iv = errors2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    HealthCheckError healthCheckError = (HealthCheckError)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl4 = false;
                    NonBlockingReadAction nonBlockingReadAction = ReadAction.nonBlocking((Callable)new Callable((HealthCheckError)it){
                        final /* synthetic */ HealthCheckError $it;

                        public final String call() {
                            return this.$it.getPresentableText();
                        }
                        {
                            this.$it = healthCheckError;
                        }
                    });
                    collection2.add(nonBlockingReadAction);
                }
                Intrinsics.checkNotNullExpressionValue((Object)StringUtil.first((String)CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null), (int)300, (boolean)true), (String)"StringUtil.first(errors.\u2026                    true)");
                FileBasedIndexImpl.LOG.error("Project indexable filter health check errors: " + message2);
                continue;
            }
            FileBasedIndexImpl.LOG.info("Health check heartbeat");
        }
    }

    private final List<HealthCheckError> runHealthCheck(Project project, IncrementalProjectIndexableFilesFilter filter) {
        boolean bl = false;
        List errors2 = new ArrayList();
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        if (fileBasedIndex == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.util.indexing.FileBasedIndexImpl");
        }
        FileBasedIndexImpl index2 = (FileBasedIndexImpl)fileBasedIndex;
        ContentIterator contentIterator = new ContentIterator(filter){
            final /* synthetic */ IncrementalProjectIndexableFilesFilter $filter;

            public final boolean processFile(@NotNull VirtualFile it) {
                int fileId;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (it instanceof VirtualFileWithId && !this.$filter.containsFileId(fileId = ((VirtualFileWithId)it).getId())) {
                    this.$filter.ensureFileIdPresent(fileId, (Function0<Boolean>)((Function0)runHealthCheck.1.INSTANCE));
                }
                return true;
            }
            {
                this.$filter = incrementalProjectIndexableFilesFilter;
            }
        };
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
        index2.iterateIndexableFiles(contentIterator, project, progressManager.getProgressIndicator());
        return errors2;
    }

    public IncrementalProjectIndexableFilesFilterHolder() {
        super(null);
        ConcurrentMap concurrentMap = ConcurrentFactoryMap.createMap((Function)myProjectFilters.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"ConcurrentFactoryMap.cre\u2026tIndexableFilesFilter() }");
        this.myProjectFilters = concurrentMap;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        application.getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectClosed(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                myProjectFilters.remove(project);
            }
        });
    }

    public static final /* synthetic */ List access$runHealthCheck(IncrementalProjectIndexableFilesFilterHolder $this, Project project, IncrementalProjectIndexableFilesFilter filter) {
        return $this.runHealthCheck(project, filter);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/util/indexing/projectFilter/IncrementalProjectIndexableFilesFilterHolder$HealthCheckError;", "", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "presentableText", "", "getPresentableText", "()Ljava/lang/String;", "fix", "", "filter", "Lcom/intellij/util/indexing/projectFilter/IncrementalProjectIndexableFilesFilter;", "intellij.platform.lang.impl"})
    private static final class HealthCheckError {
        private final Project project;
        private final VirtualFile virtualFile;

        @NotNull
        public final String getPresentableText() {
            return "file " + this.virtualFile.getPath() + " not found in " + this.project.getName();
        }

        public final void fix(@NotNull IncrementalProjectIndexableFilesFilter filter) {
            Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
            VirtualFile virtualFile2 = this.virtualFile;
            if (virtualFile2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.vfs.VirtualFileWithId");
            }
            filter.ensureFileIdPresent(((VirtualFileWithId)virtualFile2).getId(), (Function0<Boolean>)((Function0)fix.1.INSTANCE));
        }

        public HealthCheckError(@NotNull Project project, @NotNull VirtualFile virtualFile2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
            this.project = project;
            this.virtualFile = virtualFile2;
        }
    }
}

