/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.roots;

import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.roots.IndexableEntityProvider;
import com.intellij.util.indexing.roots.IndexableFilesContributor;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.roots.LibraryIndexableFilesIteratorImpl;
import com.intellij.util.indexing.roots.ModuleIndexableFilesIteratorImpl;
import com.intellij.util.indexing.roots.SdkIndexableFilesIteratorImpl;
import com.intellij.util.indexing.roots.builders.IndexableIteratorBuilders;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/util/indexing/roots/DefaultProjectIndexableFilesContributor;", "Lcom/intellij/util/indexing/roots/IndexableFilesContributor;", "()V", "getIndexableFiles", "", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "project", "Lcom/intellij/openapi/project/Project;", "getOwnFilePredicate", "Ljava/util/function/Predicate;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Companion", "intellij.platform.lang.impl"})
public final class DefaultProjectIndexableFilesContributor
implements IndexableFilesContributor {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public List<IndexableFilesIterator> getIndexableFiles(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (Companion.indexProjectBasedOnIndexableEntityProviders()) {
            boolean bl = false;
            List builders = new ArrayList();
            WorkspaceEntityStorage entityStorage = WorkspaceModel.Companion.getInstance(project).getEntityStorage().getCurrent();
            ExtensionPointName<IndexableEntityProvider<? extends WorkspaceEntity>> extensionPointName = IndexableEntityProvider.EP_NAME;
            Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"IndexableEntityProvider.EP_NAME");
            for (IndexableEntityProvider provider2 : extensionPointName.getExtensionList()) {
                if (!(provider2 instanceof IndexableEntityProvider.Existing)) continue;
                DefaultProjectIndexableFilesContributor.Companion.addIteratorBuildersFromProvider((IndexableEntityProvider.Existing)provider2, entityStorage, project, builders);
                ProgressManager.checkCanceled();
            }
            return IndexableIteratorBuilders.INSTANCE.instantiateBuilders(builders, project, entityStorage);
        }
        Set seenLibraries = new HashSet();
        Set seenSdks = new HashSet();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        Module[] modules2 = moduleManager.getSortedModules();
        boolean bl = false;
        List providers = new ArrayList();
        Module[] moduleArray = modules2;
        int n = moduleArray.length;
        for (int j = 0; j < n; ++j) {
            OrderEntry[] orderEntries;
            Module module;
            Module module2 = module = moduleArray[j];
            Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"module");
            providers.addAll(ModuleIndexableFilesIteratorImpl.Companion.getModuleIterators(module2));
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
            for (OrderEntry orderEntry : orderEntries = moduleRootManager.getOrderEntries()) {
                Sdk sdk2;
                OrderEntry orderEntry2 = orderEntry;
                if (orderEntry2 instanceof LibraryOrderEntry) {
                    Library library2 = ((LibraryOrderEntry)orderEntry).getLibrary();
                    if (library2 == null || !seenLibraries.add(library2)) continue;
                    providers.add(new LibraryIndexableFilesIteratorImpl(library2));
                    continue;
                }
                if (!(orderEntry2 instanceof JdkOrderEntry) || (sdk2 = ((JdkOrderEntry)orderEntry).getJdk()) == null || !seenSdks.add(sdk2)) continue;
                providers.add(new SdkIndexableFilesIteratorImpl(sdk2));
            }
        }
        return providers;
    }

    @NotNull
    public Predicate<VirtualFile> getOwnFilePredicate(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"ProjectFileIndex.getInstance(project)");
        ProjectFileIndex projectFileIndex2 = projectFileIndex;
        return new Predicate(project, projectFileIndex2){
            final /* synthetic */ Project $project;
            final /* synthetic */ ProjectFileIndex $projectFileIndex;

            public final boolean test(@NotNull VirtualFile it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (LightEdit.owns((Project)this.$project)) {
                    return false;
                }
                return this.$projectFileIndex.isInContent(it) || this.$projectFileIndex.isInLibrary(it) ? !FileTypeManager.getInstance().isFileIgnored(it) : false;
            }
            {
                this.$project = project;
                this.$projectFileIndex = projectFileIndex;
            }
        };
    }

    @Deprecated(message="Registry property introduced to provide quick workaround for possible performance issues. Should be removed when the feature is proved to be stable", replaceWith=@ReplaceWith(imports={}, expression="true"))
    @JvmStatic
    @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
    public static final boolean indexProjectBasedOnIndexableEntityProviders() {
        return Companion.indexProjectBasedOnIndexableEntityProviders();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u00020\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/util/indexing/roots/DefaultProjectIndexableFilesContributor$Companion;", "", "()V", "addIteratorBuildersFromProvider", "", "E", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "provider", "Lcom/intellij/util/indexing/roots/IndexableEntityProvider$Existing;", "entityStorage", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;", "project", "Lcom/intellij/openapi/project/Project;", "iterators", "", "Lcom/intellij/util/indexing/roots/IndexableEntityProvider$IndexableIteratorBuilder;", "indexProjectBasedOnIndexableEntityProviders", "", "intellij.platform.lang.impl"})
    public static final class Companion {
        private final <E extends WorkspaceEntity> void addIteratorBuildersFromProvider(IndexableEntityProvider.Existing<E> provider2, WorkspaceEntityStorage entityStorage, Project project, List<IndexableEntityProvider.IndexableIteratorBuilder> iterators) {
            Class clazz = provider2.getEntityClass();
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"provider.entityClass");
            Class entityClass = clazz;
            for (WorkspaceEntity entity : entityStorage.entities(entityClass)) {
                Collection<IndexableEntityProvider.IndexableIteratorBuilder> collection = provider2.getExistingEntityIteratorBuilder(entity, project);
                Intrinsics.checkNotNullExpressionValue(collection, (String)"provider.getExistingEnti\u2026rBuilder(entity, project)");
                iterators.addAll(collection);
            }
        }

        @Deprecated(message="Registry property introduced to provide quick workaround for possible performance issues. Should be removed when the feature is proved to be stable", replaceWith=@ReplaceWith(imports={}, expression="true"))
        @JvmStatic
        @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
        public final boolean indexProjectBasedOnIndexableEntityProviders() {
            return Registry.is((String)"indexing.enable.entity.provider.based.indexing");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

