/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.progress;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.progress.SubTaskProgressIndicator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ConcurrentTasksProgressManager {
    private final ProgressIndicator myParent;
    private final int myTotalWeight;
    private final AtomicLong myTotalFraction;
    private final Object myLock = new Object();
    private final LinkedHashMap<SubTaskProgressIndicator, @NlsContexts.ProgressDetails String> myText2Stack = new LinkedHashMap();
    private final AtomicInteger myRemainingTotalWeight;

    public ConcurrentTasksProgressManager(ProgressIndicator parent, int totalWeight) {
        if (totalWeight < 0) {
            throw new IllegalArgumentException("Total weight must not be negative: " + totalWeight);
        }
        this.myParent = parent;
        this.myTotalWeight = totalWeight;
        this.myTotalFraction = new AtomicLong();
        this.myRemainingTotalWeight = new AtomicInteger(totalWeight);
    }

    @NotNull
    public SubTaskProgressIndicator createSubTaskIndicator(int taskWeight) {
        if (taskWeight < 0) {
            throw new IllegalArgumentException("Task weight must not be negative: " + taskWeight);
        }
        if (this.myRemainingTotalWeight.addAndGet(-taskWeight) < 0) {
            throw new IllegalStateException("Attempted to create more task indicators than registered in constructor");
        }
        return new SubTaskProgressIndicator(this, taskWeight);
    }

    @NotNull
    ProgressIndicator getParent() {
        ProgressIndicator progressIndicator = this.myParent;
        if (progressIndicator == null) {
            ConcurrentTasksProgressManager.$$$reportNull$$$0(0);
        }
        return progressIndicator;
    }

    void updateTaskFraction(double taskDeltaFraction, int taskWeight) {
        double currentVal;
        double nextVal;
        long next;
        long current2;
        double delta;
        double d = delta = this.myTotalWeight == 0 ? 0.0 : taskDeltaFraction * (double)taskWeight / (double)this.myTotalWeight;
        while (!this.myTotalFraction.compareAndSet(current2 = this.myTotalFraction.get(), next = Double.doubleToRawLongBits(nextVal = (currentVal = Double.longBitsToDouble(current2)) + delta))) {
        }
        this.myParent.setFraction(nextVal);
    }

    public void setText(@NotNull @NlsContexts.ProgressText String text2) {
        if (text2 == null) {
            ConcurrentTasksProgressManager.$$$reportNull$$$0(1);
        }
        this.myParent.setText(text2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setText2(@NotNull SubTaskProgressIndicator subTask, @Nullable @NlsContexts.ProgressDetails String text2) {
        if (subTask == null) {
            ConcurrentTasksProgressManager.$$$reportNull$$$0(2);
        }
        if (text2 != null) {
            Object object = this.myLock;
            synchronized (object) {
                this.myText2Stack.put((Object)subTask, (Object)text2);
            }
            this.myParent.setText2(text2);
        } else {
            String prev2;
            Object object = this.myLock;
            synchronized (object) {
                this.myText2Stack.remove((Object)subTask);
                prev2 = (String)this.myText2Stack.getLastValue();
            }
            if (prev2 != null) {
                this.myParent.setText2(prev2);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/progress/ConcurrentTasksProgressManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getParent";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/progress/ConcurrentTasksProgressManager";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setText2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

