/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.data.CurrentBranchConditionCache;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.DataPackChangeListener;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.impl.facade.PermanentGraphImpl;
import com.intellij.vcs.log.util.SequentialLimitedLifoExecutor;
import com.intellij.vcs.log.util.StopWatch;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 /2\u00020\u0001:\u0005./012B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0013J&\u0010\u0007\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\t2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u001c\u001a\u00020\u0010H\u0003J\b\u0010\u001d\u001a\u00020\u0018H\u0003J \u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00100'2\u0006\u0010 \u001a\u00020!J\u001e\u0010(\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u001e\u0010)\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u001c\u0010*\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\b\u0010+\u001a\u00020\u0018H\u0002J\u000e\u0010,\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0013J\u001e\u0010-\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#Rf\u0010\u0007\u001aZ\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\f \n*\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b0\u000b \n*,\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\f \n*\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b0\u000b\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0014\u001a\f\u0012\b\u0012\u00060\u0016R\u00020\u00000\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/vcs/log/data/ContainingBranchesGetter;", "", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/vcs/log/data/VcsLogData;Lcom/intellij/openapi/Disposable;)V", "cache", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lcom/intellij/vcs/log/CommitId;", "kotlin.jvm.PlatformType", "", "", "conditionsCache", "Lcom/intellij/vcs/log/data/CurrentBranchConditionCache;", "currentBranchesChecksum", "", "loadingFinishedListeners", "", "Ljava/lang/Runnable;", "taskExecutor", "Lcom/intellij/vcs/log/util/SequentialLimitedLifoExecutor;", "Lcom/intellij/vcs/log/data/ContainingBranchesGetter$CachingTask;", "addTaskCompletedListener", "", "runnable", "commitId", "branches", "branchesChecksum", "clearCache", "createTask", "Lcom/intellij/vcs/log/data/ContainingBranchesGetter$Task;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "hash", "Lcom/intellij/vcs/log/Hash;", "dataPack", "Lcom/intellij/vcs/log/data/DataPack;", "getContainedInCurrentBranchCondition", "Lcom/intellij/openapi/util/Condition;", "getContainingBranchesFromCache", "getContainingBranchesQuickly", "getContainingBranchesSynchronously", "notifyListeners", "removeTaskCompletedListener", "requestContainingBranches", "CachingTask", "Companion", "GraphTask", "ProviderTask", "Task", "intellij.platform.vcs.log.impl"})
public final class ContainingBranchesGetter {
    private final SequentialLimitedLifoExecutor<CachingTask> taskExecutor;
    private final List<Runnable> loadingFinishedListeners;
    private final Cache<CommitId, List<String>> cache;
    private final CurrentBranchConditionCache conditionsCache;
    private int currentBranchesChecksum;
    private final VcsLogData logData;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @RequiresEdt
    private final void cache(CommitId commitId2, List<String> branches, int branchesChecksum) {
        if (branchesChecksum == this.currentBranchesChecksum) {
            this.cache.put((Object)commitId2, branches);
            this.notifyListeners();
        }
    }

    @RequiresEdt
    private final void clearCache() {
        this.cache.invalidateAll();
        this.taskExecutor.clear();
        this.conditionsCache.clear();
        ApplicationManager.getApplication().invokeLater(new Runnable(this){
            final /* synthetic */ ContainingBranchesGetter this$0;

            public final void run() {
                ContainingBranchesGetter.access$notifyListeners(this.this$0);
            }
            {
                this.this$0 = containingBranchesGetter;
            }
        });
    }

    public final void addTaskCompletedListener(@NotNull Runnable runnable2) {
        Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
        LOG.assertTrue(EventQueue.isDispatchThread());
        this.loadingFinishedListeners.add(runnable2);
    }

    public final void removeTaskCompletedListener(@NotNull Runnable runnable2) {
        Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
        LOG.assertTrue(EventQueue.isDispatchThread());
        this.loadingFinishedListeners.remove(runnable2);
    }

    private final void notifyListeners() {
        LOG.assertTrue(EventQueue.isDispatchThread());
        for (Runnable listener2 : this.loadingFinishedListeners) {
            listener2.run();
        }
    }

    @Nullable
    public final List<String> requestContainingBranches(@NotNull VirtualFile root2, @NotNull Hash hash) {
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        LOG.assertTrue(EventQueue.isDispatchThread());
        List<String> refs = this.getContainingBranchesFromCache(root2, hash);
        if (refs == null) {
            DataPack dataPack = this.logData.getDataPack();
            Intrinsics.checkNotNullExpressionValue((Object)dataPack, (String)"logData.dataPack");
            this.taskExecutor.queue(new CachingTask(this.createTask(root2, hash, dataPack), this.currentBranchesChecksum));
        }
        return refs;
    }

    @Nullable
    public final List<String> getContainingBranchesFromCache(@NotNull VirtualFile root2, @NotNull Hash hash) {
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        LOG.assertTrue(EventQueue.isDispatchThread());
        return (List)this.cache.getIfPresent((Object)new CommitId(hash, root2));
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final List<String> getContainingBranchesQuickly(@NotNull VirtualFile root, @NotNull Hash hash) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            ContainingBranchesGetter.LOG.assertTrue(EventQueue.isDispatchThread());
            commitId = new CommitId(hash, root);
            branches = (List)this.cache.getIfPresent((Object)commitId);
            if (branches != null) break block3;
            index = this.logData.getCommitIndex(hash, root);
            v0 = this.logData.getDataPack();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"logData.dataPack");
            v1 = v0.getPermanentGraph();
            Intrinsics.checkNotNullExpressionValue(v1, (String)"logData.dataPack.permanentGraph");
            pg = v1;
            if (!(pg instanceof PermanentGraphImpl)) break block3;
            nodeId = ((PermanentGraphImpl)pg).getPermanentCommitsInfo().getNodeId(index);
            if (nodeId >= 10000) ** GOTO lbl-1000
            v2 = this.logData.getLogProvider(root);
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"logData.getLogProvider(root)");
            if (com.intellij.vcs.log.data.ContainingBranchesGetter$Companion.access$canUseGraphForComputation(ContainingBranchesGetter.Companion, v2)) {
                v3 = this.getContainingBranchesSynchronously(root, hash);
            } else lbl-1000:
            // 2 sources

            {
                v3 = branches = (List)BackgroundTaskUtil.tryComputeFast((Function)new Function(this, root, hash){
                    final /* synthetic */ ContainingBranchesGetter this$0;
                    final /* synthetic */ VirtualFile $root;
                    final /* synthetic */ Hash $hash;

                    public final List<String> fun(ProgressIndicator it) {
                        return this.this$0.getContainingBranchesSynchronously(this.$root, this.$hash);
                    }
                    {
                        this.this$0 = containingBranchesGetter;
                        this.$root = virtualFile2;
                        this.$hash = hash;
                    }
                }, 100L);
            }
            if (branches != null) {
                this.cache.put((Object)commitId, (Object)branches);
            }
        }
        return branches;
    }

    @NotNull
    public final Condition<Integer> getContainedInCurrentBranchCondition(@NotNull VirtualFile root2) {
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        return this.conditionsCache.getContainedInCurrentBranchCondition(root2);
    }

    @NotNull
    public final List<String> getContainingBranchesSynchronously(@NotNull VirtualFile root2, @NotNull Hash hash) {
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        DataPack dataPack = this.logData.getDataPack();
        Intrinsics.checkNotNullExpressionValue((Object)dataPack, (String)"logData.dataPack");
        return this.createTask(root2, hash, dataPack).getContainingBranches();
    }

    private final Task createTask(VirtualFile root2, Hash hash, DataPack dataPack) {
        VcsLogProvider vcsLogProvider = this.logData.getLogProvider(root2);
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogProvider, (String)"logData.getLogProvider(root)");
        VcsLogProvider provider2 = vcsLogProvider;
        return ContainingBranchesGetter.Companion.canUseGraphForComputation(provider2) ? (Task)new GraphTask(provider2, root2, hash, dataPack) : (Task)new ProviderTask(provider2, root2, hash);
    }

    public ContainingBranchesGetter(@NotNull VcsLogData logData, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.logData = logData;
        this.loadingFinishedListeners = new ArrayList();
        this.cache = Caffeine.newBuilder().maximumSize(2000L).build();
        this.conditionsCache = new CurrentBranchConditionCache(this.logData, parentDisposable);
        Object object = 1.INSTANCE;
        if (object != null) {
            Function1 function1 = object;
            object = new ThrowableConsumer(function1){
                private final /* synthetic */ Function1 function;
                {
                    this.function = function1;
                }

                public final /* synthetic */ void consume(Object p0) {
                    Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(p0), (String)"invoke(...)");
                }
            };
        }
        this.taskExecutor = new SequentialLimitedLifoExecutor(parentDisposable, 10, (ThrowableConsumer)object);
        this.logData.addDataPackChangeListener(new DataPackChangeListener(){

            @Override
            public final void onDataPackChange(@NotNull DataPack dataPack) {
                Intrinsics.checkNotNullParameter((Object)dataPack, (String)"dataPack");
                RefsModel refsModel = dataPack.getRefsModel();
                Intrinsics.checkNotNullExpressionValue((Object)refsModel, (String)"dataPack.refsModel");
                Collection<VcsRef> collection = refsModel.getBranches();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"dataPack.refsModel.branches");
                Collection<VcsRef> currentBranches = collection;
                int checksum = ((Object)currentBranches).hashCode();
                if (currentBranchesChecksum != 0 && currentBranchesChecksum != checksum) {
                    this.clearCache();
                }
                currentBranchesChecksum = checksum;
            }
        });
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(ContainingBranchesGetter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Conta\u2026anchesGetter::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ void access$cache(ContainingBranchesGetter $this, CommitId commitId2, List branches, int branchesChecksum) {
        $this.cache(commitId2, branches, branchesChecksum);
    }

    public static final /* synthetic */ void access$notifyListeners(ContainingBranchesGetter $this) {
        $this.notifyListeners();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\b\"\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ&\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0007H$R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/intellij/vcs/log/data/ContainingBranchesGetter$Task;", "", "myProvider", "Lcom/intellij/vcs/log/VcsLogProvider;", "myRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "myHash", "Lcom/intellij/vcs/log/Hash;", "(Lcom/intellij/vcs/log/VcsLogProvider;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/vcs/log/Hash;)V", "getMyHash", "()Lcom/intellij/vcs/log/Hash;", "getMyRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getContainingBranches", "", "", "provider", "root", "hash", "intellij.platform.vcs.log.impl"})
    private static abstract class Task {
        private final VcsLogProvider myProvider;
        @NotNull
        private final VirtualFile myRoot;
        @NotNull
        private final Hash myHash;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final List<String> getContainingBranches() throws VcsException {
            List<String> list2;
            StopWatch stopWatch = StopWatch.start("get containing branches");
            Intrinsics.checkNotNullExpressionValue((Object)stopWatch, (String)"StopWatch.start(\"get containing branches\")");
            StopWatch sw = stopWatch;
            try {
                list2 = this.getContainingBranches(this.myProvider, this.myRoot, this.myHash);
            }
            catch (VcsException e) {
                LOG.warn((Throwable)e);
                list2 = CollectionsKt.emptyList();
            }
            finally {
                sw.report();
            }
            return list2;
        }

        @NotNull
        protected abstract List<String> getContainingBranches(@NotNull VcsLogProvider var1, @NotNull VirtualFile var2, @NotNull Hash var3) throws VcsException;

        @NotNull
        public final VirtualFile getMyRoot() {
            return this.myRoot;
        }

        @NotNull
        public final Hash getMyHash() {
            return this.myHash;
        }

        public Task(@NotNull VcsLogProvider myProvider, @NotNull VirtualFile myRoot, @NotNull Hash myHash) {
            Intrinsics.checkNotNullParameter((Object)myProvider, (String)"myProvider");
            Intrinsics.checkNotNullParameter((Object)myRoot, (String)"myRoot");
            Intrinsics.checkNotNullParameter((Object)myHash, (String)"myHash");
            this.myProvider = myProvider;
            this.myRoot = myRoot;
            this.myHash = myHash;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001e\u0010\u0012\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00140\u00140\u00132\u0006\u0010\u0015\u001a\u00020\rH\u0002J&\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014R!\u0010\u000b\u001a\u0015\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r0\f\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/vcs/log/data/ContainingBranchesGetter$GraphTask;", "Lcom/intellij/vcs/log/data/ContainingBranchesGetter$Task;", "provider", "Lcom/intellij/vcs/log/VcsLogProvider;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "hash", "Lcom/intellij/vcs/log/Hash;", "dataPack", "Lcom/intellij/vcs/log/data/DataPack;", "(Lcom/intellij/vcs/log/data/ContainingBranchesGetter;Lcom/intellij/vcs/log/VcsLogProvider;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/vcs/log/Hash;Lcom/intellij/vcs/log/data/DataPack;)V", "graph", "Lcom/intellij/vcs/log/graph/PermanentGraph;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "refs", "Lcom/intellij/vcs/log/data/RefsModel;", "getBranchesRefs", "", "Lcom/intellij/vcs/log/VcsRef;", "branchIndex", "getContainingBranches", "", "intellij.platform.vcs.log.impl"})
    private final class GraphTask
    extends Task {
        private final PermanentGraph<Integer> graph;
        private final RefsModel refs;

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        protected List<String> getContainingBranches(@NotNull VcsLogProvider provider2, @NotNull VirtualFile root2, @NotNull Hash hash) {
            void $this$mapTo$iv$iv;
            Object object;
            Collection collection;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
            Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            int commitIndex = ContainingBranchesGetter.this.logData.getCommitIndex(hash, root2);
            Set set2 = this.graph.getContainingBranches((Object)commitIndex);
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"graph.getContainingBranches(commitIndex)");
            Iterable iterable = set2;
            GraphTask graphTask = this;
            boolean $i$f$map22 = false;
            void var8_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void p1;
                int n = ((Number)item$iv$iv2).intValue();
                collection = destination$iv$iv;
                boolean bl = false;
                object = graphTask.getBranchesRefs((int)p1);
                collection.add(object);
            }
            Iterable iterable2 = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
            VcsLogRefManager vcsLogRefManager = provider2.getReferenceManager();
            Intrinsics.checkNotNullExpressionValue((Object)vcsLogRefManager, (String)"provider.referenceManager");
            Comparator comparator2 = vcsLogRefManager.getLabelsOrderComparator();
            Intrinsics.checkNotNullExpressionValue((Object)comparator2, (String)"provider.referenceManager.labelsOrderComparator");
            $this$map$iv = CollectionsKt.sortedWith((Iterable)iterable2, (Comparator)comparator2);
            boolean $i$f$map = false;
            Iterable $i$f$map22 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p1;
                Object item$iv$iv2;
                item$iv$iv2 = (VcsRef)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                object = p1.getName();
                collection.add(object);
            }
            return (List)destination$iv$iv2;
        }

        /*
         * WARNING - void declaration
         */
        private final List<VcsRef> getBranchesRefs(int branchIndex) {
            void $this$filterTo$iv$iv;
            List<VcsRef> list2 = this.refs.refsToCommit(branchIndex);
            Intrinsics.checkNotNullExpressionValue(list2, (String)"refs.refsToCommit(branchIndex)");
            Iterable $this$filter$iv = list2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                VcsRef it = (VcsRef)element$iv$iv;
                boolean bl = false;
                VcsRef vcsRef = it;
                Intrinsics.checkNotNullExpressionValue((Object)vcsRef, (String)"it");
                VcsRefType vcsRefType = vcsRef.getType();
                Intrinsics.checkNotNullExpressionValue((Object)vcsRefType, (String)"it.type");
                if (!vcsRefType.isBranch()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public GraphTask(@NotNull VcsLogProvider provider2, @NotNull VirtualFile root2, @NotNull Hash hash, DataPack dataPack) {
            Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
            Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Intrinsics.checkNotNullParameter((Object)dataPack, (String)"dataPack");
            super(provider2, root2, hash);
            PermanentGraph<Integer> permanentGraph = dataPack.getPermanentGraph();
            Intrinsics.checkNotNullExpressionValue(permanentGraph, (String)"dataPack.permanentGraph");
            this.graph = permanentGraph;
            RefsModel refsModel = dataPack.getRefsModel();
            Intrinsics.checkNotNullExpressionValue((Object)refsModel, (String)"dataPack.refsModel");
            this.refs = refsModel;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ.\u0010\t\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\r"}, d2={"Lcom/intellij/vcs/log/data/ContainingBranchesGetter$ProviderTask;", "Lcom/intellij/vcs/log/data/ContainingBranchesGetter$Task;", "provider", "Lcom/intellij/vcs/log/VcsLogProvider;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "hash", "Lcom/intellij/vcs/log/Hash;", "(Lcom/intellij/vcs/log/VcsLogProvider;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/vcs/log/Hash;)V", "getContainingBranches", "", "", "kotlin.jvm.PlatformType", "intellij.platform.vcs.log.impl"})
    private static final class ProviderTask
    extends Task {
        @Override
        @NotNull
        protected List<String> getContainingBranches(@NotNull VcsLogProvider provider2, @NotNull VirtualFile root2, @NotNull Hash hash) throws VcsException {
            Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
            Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Collection collection = provider2.getContainingBranches(root2, hash);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"provider.getContainingBranches(root, hash)");
            return CollectionsKt.sorted((Iterable)collection);
        }

        public ProviderTask(@NotNull VcsLogProvider provider2, @NotNull VirtualFile root2, @NotNull Hash hash) {
            Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
            Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            super(provider2, root2, hash);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/vcs/log/data/ContainingBranchesGetter$CachingTask;", "", "delegate", "Lcom/intellij/vcs/log/data/ContainingBranchesGetter$Task;", "branchesChecksum", "", "(Lcom/intellij/vcs/log/data/ContainingBranchesGetter;Lcom/intellij/vcs/log/data/ContainingBranchesGetter$Task;I)V", "run", "", "intellij.platform.vcs.log.impl"})
    private final class CachingTask {
        private final Task delegate;
        private final int branchesChecksum;

        public final void run() {
            List<String> branches = this.delegate.getContainingBranches();
            CommitId commitId2 = new CommitId(this.delegate.getMyHash(), this.delegate.getMyRoot());
            ApplicationManager.getApplication().invokeLater(new Runnable(this, commitId2, branches){
                final /* synthetic */ CachingTask this$0;
                final /* synthetic */ CommitId $commitId;
                final /* synthetic */ List $branches;

                public final void run() {
                    ContainingBranchesGetter.access$cache(this.this$0.ContainingBranchesGetter.this, this.$commitId, this.$branches, CachingTask.access$getBranchesChecksum$p(this.this$0));
                }
                {
                    this.this$0 = cachingTask;
                    this.$commitId = commitId2;
                    this.$branches = list2;
                }
            });
        }

        public CachingTask(Task delegate2, int branchesChecksum) {
            Intrinsics.checkNotNullParameter((Object)delegate2, (String)"delegate");
            this.delegate = delegate2;
            this.branchesChecksum = branchesChecksum;
        }

        public static final /* synthetic */ int access$getBranchesChecksum$p(CachingTask $this) {
            return $this.branchesChecksum;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\u00052\u0006\u0010\b\u001a\u00020\tH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/vcs/log/data/ContainingBranchesGetter$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "canUseGraphForComputation", "", "logProvider", "Lcom/intellij/vcs/log/VcsLogProvider;", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private final boolean canUseGraphForComputation(VcsLogProvider logProvider) {
            Object object = VcsLogProperties.LIGHTWEIGHT_BRANCHES.getOrDefault(logProvider);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"VcsLogProperties.LIGHTWE\u2026getOrDefault(logProvider)");
            return (Boolean)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

