/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSetInterner;
import com.intellij.util.containers.Interner;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.Page;
import com.intellij.util.io.PersistentBTreeEnumerator;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.data.VcsUserKeyDescriptor;
import com.intellij.vcs.log.data.VcsUserRegistryImpl;
import com.intellij.vcs.log.impl.VcsUserImpl;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0004\u0018\u0000 '2\u00020\u00012\u00020\u0002:\u0001'B\u000f\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tJ\u0014\u0010\u0014\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u0016J)\u0010\u0017\u001a\u00020\u00182!\u0010\u0019\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u00020\u00180\u001aJ\u0018\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0016J\b\u0010!\u001a\u00020\u0012H\u0016J\u0006\u0010\"\u001a\u00020\u0012J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\t0$H\u0016J\b\u0010%\u001a\u00020\u0018H\u0002J\b\u0010&\u001a\u00020\u0012H\u0002R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006("}, d2={"Lcom/intellij/vcs/log/data/VcsUserRegistryImpl;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/vcs/log/VcsUserRegistry;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "_persistentEnumerator", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/util/io/PersistentEnumeratorBase;", "Lcom/intellij/vcs/log/VcsUser;", "interner", "Lcom/intellij/util/containers/Interner;", "mapFile", "Ljava/io/File;", "persistentEnumerator", "getPersistentEnumerator", "()Lcom/intellij/util/io/PersistentEnumeratorBase;", "addUser", "", "user", "addUsers", "users", "", "all", "", "condition", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "t", "createUser", "", "email", "dispose", "flush", "getUsers", "", "initEnumerator", "rebuild", "Companion", "intellij.platform.vcs.log.impl"})
public final class VcsUserRegistryImpl
implements Disposable,
VcsUserRegistry {
    private final AtomicReference<PersistentEnumeratorBase<VcsUser>> _persistentEnumerator;
    private final Interner<VcsUser> interner;
    private final File mapFile;
    private static final Logger LOG;
    private static final File USER_CACHE_APP_DIR;
    private static final int STORAGE_VERSION = 2;
    @NotNull
    public static final Companion Companion;

    private final PersistentEnumeratorBase<VcsUser> getPersistentEnumerator() {
        return this._persistentEnumerator.get();
    }

    private final boolean initEnumerator() {
        try {
            PersistentBTreeEnumerator enumerator2 = (PersistentBTreeEnumerator)IOUtil.openCleanOrResetBroken((ThrowableComputable)new ThrowableComputable(this){
                final /* synthetic */ VcsUserRegistryImpl this$0;

                public final PersistentBTreeEnumerator<VcsUser> compute() {
                    return new PersistentBTreeEnumerator(VcsUserRegistryImpl.access$getMapFile$p(this.this$0).toPath(), (KeyDescriptor)new VcsUserKeyDescriptor(this.this$0), Page.PAGE_SIZE, null, 2);
                }
                {
                    this.this$0 = vcsUserRegistryImpl;
                }
            }, (File)this.mapFile);
            boolean wasSet = this._persistentEnumerator.compareAndSet(null, (PersistentEnumeratorBase<VcsUser>)enumerator2);
            if (!wasSet) {
                LOG.error("Could not assign newly opened enumerator");
                PersistentBTreeEnumerator persistentBTreeEnumerator = enumerator2;
                if (persistentBTreeEnumerator != null) {
                    persistentBTreeEnumerator.close();
                }
            }
            return wasSet;
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public VcsUser createUser(@NotNull String name2, @NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Interner<VcsUser> interner = this.interner;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (interner) {
            boolean bl3 = false;
            Object object = this.interner.intern((Object)new VcsUserImpl(name2, email));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"interner.intern(VcsUserImpl(name, email))");
            VcsUser vcsUser = (VcsUser)object;
            return vcsUser;
        }
    }

    public final void addUser(@NotNull VcsUser user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        try {
            PersistentEnumeratorBase<VcsUser> persistentEnumeratorBase = this.getPersistentEnumerator();
            if (persistentEnumeratorBase != null) {
                persistentEnumeratorBase.enumerate((Object)user);
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            this.rebuild();
        }
    }

    public final void addUsers(@NotNull Collection<? extends VcsUser> users) {
        Intrinsics.checkNotNullParameter(users, (String)"users");
        for (VcsUser vcsUser : users) {
            this.addUser(vcsUser);
        }
    }

    @NotNull
    public Set<VcsUser> getUsers() {
        Object object;
        try {
            Object object2 = this.getPersistentEnumerator();
            if (object2 == null || (object2 = object2.getAllDataObjects((PersistentEnumeratorBase.DataFilter)getUsers.1.INSTANCE)) == null || (object2 = CollectionsKt.toMutableSet((Iterable)((Iterable)object2))) == null) {
                object2 = SetsKt.emptySet();
            }
            object = object2;
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            this.rebuild();
            object = SetsKt.emptySet();
        }
        catch (ProcessCanceledException pce) {
            throw (Throwable)pce;
        }
        catch (Throwable t) {
            LOG.error(t);
            object = SetsKt.emptySet();
        }
        return object;
    }

    public final boolean all(@NotNull Function1<? super VcsUser, Boolean> condition) {
        boolean bl;
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        try {
            boolean bl2;
            PersistentEnumeratorBase<VcsUser> persistentEnumeratorBase = this.getPersistentEnumerator();
            if (persistentEnumeratorBase != null) {
                Function1<? super VcsUser, Boolean> function1 = condition;
                bl2 = persistentEnumeratorBase.iterateData(new Processor(function1){
                    private final /* synthetic */ Function1 function;
                    {
                        this.function = function1;
                    }

                    public final /* synthetic */ boolean process(Object p0) {
                        Object object = this.function.invoke(p0);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invoke(...)");
                        return (Boolean)object;
                    }
                });
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            this.rebuild();
            bl = false;
        }
        catch (ProcessCanceledException pce) {
            throw (Throwable)pce;
        }
        catch (Throwable t) {
            LOG.error(t);
            bl = false;
        }
        return bl;
    }

    private final void rebuild() {
        block2: {
            PersistentEnumeratorBase<VcsUser> persistentEnumeratorBase = this.getPersistentEnumerator();
            if (persistentEnumeratorBase == null) break block2;
            if (persistentEnumeratorBase.isCorrupted()) {
                PersistentEnumeratorBase persistentEnumeratorBase2 = this._persistentEnumerator.getAndSet(null);
                if (persistentEnumeratorBase2 != null) {
                    PersistentEnumeratorBase persistentEnumeratorBase3 = persistentEnumeratorBase2;
                    boolean bl = false;
                    boolean bl2 = false;
                    PersistentEnumeratorBase oldEnumerator = persistentEnumeratorBase3;
                    boolean bl3 = false;
                    ApplicationManager.getApplication().executeOnPooledThread(new Runnable(oldEnumerator, this){
                        final /* synthetic */ PersistentEnumeratorBase $oldEnumerator;
                        final /* synthetic */ VcsUserRegistryImpl this$0;
                        {
                            this.$oldEnumerator = persistentEnumeratorBase;
                            this.this$0 = vcsUserRegistryImpl;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public final void run() {
                            try {
                                this.$oldEnumerator.close();
                            }
                            catch (IOException iOException) {
                            }
                            finally {
                                VcsUserRegistryImpl.access$initEnumerator(this.this$0);
                            }
                        }
                    });
                }
            }
        }
    }

    public final void flush() {
        block0: {
            PersistentEnumeratorBase<VcsUser> persistentEnumeratorBase = this.getPersistentEnumerator();
            if (persistentEnumeratorBase == null) break block0;
            persistentEnumeratorBase.force();
        }
    }

    public void dispose() {
        try {
            PersistentEnumeratorBase<VcsUser> persistentEnumeratorBase = this.getPersistentEnumerator();
            if (persistentEnumeratorBase != null) {
                persistentEnumeratorBase.close();
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    public VcsUserRegistryImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this._persistentEnumerator = new AtomicReference();
        this.mapFile = new File(USER_CACHE_APP_DIR, project.getLocationHash() + "." + 2);
        this.initEnumerator();
        this.interner = (Interner)new HashSetInterner();
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(VcsUserRegistryImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(VcsUs\u2026RegistryImpl::class.java)");
        LOG = logger;
        USER_CACHE_APP_DIR = new File(PathManager.getSystemPath(), "vcs-users");
    }

    public static final /* synthetic */ File access$getMapFile$p(VcsUserRegistryImpl $this) {
        return $this.mapFile;
    }

    public static final /* synthetic */ boolean access$initEnumerator(VcsUserRegistryImpl $this) {
        return $this.initEnumerator();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/vcs/log/data/VcsUserRegistryImpl$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "STORAGE_VERSION", "", "USER_CACHE_APP_DIR", "Ljava/io/File;", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

