/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.KeyCollectionForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.PersistentMapBasedForwardIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IntCollectionDataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.Page;
import com.intellij.util.io.PersistentEnumerator;
import com.intellij.util.io.StorageLockContext;
import com.intellij.util.io.VoidDataExternalizer;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.data.VcsUserKeyDescriptor;
import com.intellij.vcs.log.data.index.VcsLogFullDetailsIndex;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.util.StorageId;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsLogUserIndex
extends VcsLogFullDetailsIndex<Void, VcsShortCommitDetails> {
    private static final Logger LOG = Logger.getInstance(VcsLogUserIndex.class);
    @NonNls
    private static final String USERS = "users";
    @NonNls
    private static final String USERS_IDS = "users-ids";
    @NotNull
    private final UserIndexer myUserIndexer;

    public VcsLogUserIndex(@NotNull StorageId storageId, @Nullable StorageLockContext storageLockContext, @NotNull VcsUserRegistry userRegistry, @NotNull FatalErrorHandler consumer2, @NotNull Disposable disposableParent) throws IOException {
        if (storageId == null) {
            VcsLogUserIndex.$$$reportNull$$$0(0);
        }
        if (userRegistry == null) {
            VcsLogUserIndex.$$$reportNull$$$0(1);
        }
        if (consumer2 == null) {
            VcsLogUserIndex.$$$reportNull$$$0(2);
        }
        if (disposableParent == null) {
            VcsLogUserIndex.$$$reportNull$$$0(3);
        }
        super(storageId, USERS, new UserIndexer(VcsLogUserIndex.createUsersEnumerator(storageId, storageLockContext, userRegistry)), VoidDataExternalizer.INSTANCE, storageLockContext, consumer2, disposableParent);
        this.myUserIndexer = (UserIndexer)this.myIndexer;
        ((UserIndexer)this.myIndexer).setFatalErrorConsumer((Consumer<? super Exception>)((Consumer)e -> consumer2.consume(this, (Throwable)e)));
    }

    @Override
    @NotNull
    protected Pair<ForwardIndex, ForwardIndexAccessor<Integer, Void>> createdForwardIndex(@Nullable StorageLockContext storageLockContext) throws IOException {
        return new Pair((Object)new PersistentMapBasedForwardIndex(this.myStorageId.getStorageFile(this.myName + ".idx"), true, false, storageLockContext), (Object)new KeyCollectionForwardIndexAccessor((DataExternalizer)new IntCollectionDataExternalizer()));
    }

    @NotNull
    private static PersistentEnumerator<VcsUser> createUsersEnumerator(@NotNull StorageId storageId, @Nullable StorageLockContext storageLockContext, @NotNull VcsUserRegistry userRegistry) throws IOException {
        if (storageId == null) {
            VcsLogUserIndex.$$$reportNull$$$0(4);
        }
        if (userRegistry == null) {
            VcsLogUserIndex.$$$reportNull$$$0(5);
        }
        Path storageFile = storageId.getStorageFile(USERS_IDS);
        return new PersistentEnumerator(storageFile, (KeyDescriptor)new VcsUserKeyDescriptor(userRegistry), Page.PAGE_SIZE, storageLockContext, storageId.getVersion());
    }

    public IntSet getCommitsForUsers(@NotNull Set<? extends VcsUser> users) throws IOException, StorageException {
        if (users == null) {
            VcsLogUserIndex.$$$reportNull$$$0(6);
        }
        IntOpenHashSet ids = new IntOpenHashSet();
        for (VcsUser vcsUser : users) {
            ids.add(this.myUserIndexer.getUserId(vcsUser));
        }
        return this.getCommitsWithAnyKey((IntSet)ids);
    }

    @Nullable
    public VcsUser getAuthorForCommit(int commit2) throws IOException {
        Collection<Integer> userIds = this.getKeysForCommit(commit2);
        if (userIds == null || userIds.isEmpty()) {
            return null;
        }
        LOG.assertTrue(userIds.size() == 1);
        return this.myUserIndexer.getUserById(Objects.requireNonNull((Integer)ContainerUtil.getFirstItem(userIds)));
    }

    public int getUserId(@NotNull VcsUser user) throws IOException {
        if (user == null) {
            VcsLogUserIndex.$$$reportNull$$$0(7);
        }
        return this.myUserIndexer.getUserId(user);
    }

    @Nullable
    public VcsUser getUserById(int id2) throws IOException {
        return this.myUserIndexer.getUserById(id2);
    }

    @Override
    public void flush() throws StorageException {
        super.flush();
        this.myUserIndexer.flush();
    }

    @Override
    public void dispose() {
        super.dispose();
        try {
            this.myUserIndexer.close();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageId";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userRegistry";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposableParent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = USERS;
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "user";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogUserIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createUsersEnumerator";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getCommitsForUsers";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getUserId";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class UserIndexer
    implements DataIndexer<Integer, Void, VcsShortCommitDetails> {
        @NotNull
        private final PersistentEnumerator<VcsUser> myUserEnumerator;
        @NotNull
        private Consumer<? super Exception> myFatalErrorConsumer;

        UserIndexer(@NotNull PersistentEnumerator<VcsUser> userEnumerator) {
            if (userEnumerator == null) {
                UserIndexer.$$$reportNull$$$0(0);
            }
            this.myFatalErrorConsumer = arg_0 -> ((Logger)LOG).error(arg_0);
            this.myUserEnumerator = userEnumerator;
        }

        @NotNull
        public Map<Integer, Void> map(@NotNull VcsShortCommitDetails inputData) {
            if (inputData == null) {
                UserIndexer.$$$reportNull$$$0(1);
            }
            Int2ObjectOpenHashMap result2 = new Int2ObjectOpenHashMap();
            try {
                result2.put(this.myUserEnumerator.enumerate((Object)inputData.getAuthor()), null);
            }
            catch (IOException e) {
                this.myFatalErrorConsumer.consume((Object)e);
            }
            Int2ObjectOpenHashMap int2ObjectOpenHashMap = result2;
            if (int2ObjectOpenHashMap == null) {
                UserIndexer.$$$reportNull$$$0(2);
            }
            return int2ObjectOpenHashMap;
        }

        @Nullable
        public VcsUser getUserById(int id2) throws IOException {
            return (VcsUser)this.myUserEnumerator.valueOf(id2);
        }

        public int getUserId(@NotNull VcsUser user) throws IOException {
            if (user == null) {
                UserIndexer.$$$reportNull$$$0(3);
            }
            return this.myUserEnumerator.enumerate((Object)user);
        }

        public void setFatalErrorConsumer(@NotNull Consumer<? super Exception> fatalErrorConsumer) {
            if (fatalErrorConsumer == null) {
                UserIndexer.$$$reportNull$$$0(4);
            }
            this.myFatalErrorConsumer = fatalErrorConsumer;
        }

        public void flush() {
            this.myUserEnumerator.force();
        }

        public void close() throws IOException {
            this.myUserEnumerator.close();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "userEnumerator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputData";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/index/VcsLogUserIndex$UserIndexer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "user";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fatalErrorConsumer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogUserIndex$UserIndexer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "map";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "map";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getUserId";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setFatalErrorConsumer";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

