/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.permanent;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.api.permanent.PermanentCommitsInfo;
import com.intellij.vcs.log.graph.utils.IntList;
import com.intellij.vcs.log.graph.utils.TimestampGetter;
import com.intellij.vcs.log.graph.utils.impl.CompressedIntList;
import com.intellij.vcs.log.graph.utils.impl.IntTimestampGetter;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.AbstractList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class PermanentCommitsInfoImpl<CommitId>
implements PermanentCommitsInfo<CommitId> {
    private static final Logger LOG = Logger.getInstance(PermanentCommitsInfoImpl.class);
    @NotNull
    private final TimestampGetter myTimestampGetter;
    @NotNull
    private final List<? extends CommitId> myCommitIdIndexes;
    @NotNull
    private final Int2ObjectMap<CommitId> myNotLoadCommits;

    @NotNull
    public static <CommitId> PermanentCommitsInfoImpl<CommitId> newInstance(@NotNull List<? extends GraphCommit<CommitId>> graphCommits, @NotNull Int2ObjectMap<CommitId> notLoadedCommits) {
        if (graphCommits == null) {
            PermanentCommitsInfoImpl.$$$reportNull$$$0(0);
        }
        if (notLoadedCommits == null) {
            PermanentCommitsInfoImpl.$$$reportNull$$$0(1);
        }
        IntTimestampGetter timestampGetter = PermanentCommitsInfoImpl.createTimestampGetter(graphCommits);
        boolean isIntegerCase = !graphCommits.isEmpty() && graphCommits.get(0).getId().getClass() == Integer.class;
        List commitIdIndex = isIntegerCase ? PermanentCommitsInfoImpl.createCompressedIntList(graphCommits) : ContainerUtil.map(graphCommits, GraphCommit::getId);
        return new PermanentCommitsInfoImpl<CommitId>(timestampGetter, commitIdIndex, notLoadedCommits);
    }

    @NotNull
    public static <CommitId> IntTimestampGetter createTimestampGetter(final @NotNull List<? extends GraphCommit<CommitId>> graphCommits) {
        if (graphCommits == null) {
            PermanentCommitsInfoImpl.$$$reportNull$$$0(2);
        }
        IntTimestampGetter intTimestampGetter = IntTimestampGetter.newInstance(new TimestampGetter(){

            @Override
            public int size() {
                return graphCommits.size();
            }

            @Override
            public long getTimestamp(int index2) {
                return ((GraphCommit)graphCommits.get(index2)).getTimestamp();
            }
        });
        if (intTimestampGetter == null) {
            PermanentCommitsInfoImpl.$$$reportNull$$$0(3);
        }
        return intTimestampGetter;
    }

    @NotNull
    private static List<Integer> createCompressedIntList(final @NotNull List<? extends GraphCommit<Integer>> graphCommits) {
        if (graphCommits == null) {
            PermanentCommitsInfoImpl.$$$reportNull$$$0(4);
        }
        final IntList compressedIntList = CompressedIntList.newInstance(new IntList(){

            @Override
            public int size() {
                return graphCommits.size();
            }

            @Override
            public int get(int index2) {
                return (Integer)((GraphCommit)graphCommits.get(index2)).getId();
            }
        }, 30);
        return new AbstractList<Integer>(){

            @Override
            @NotNull
            public Integer get(int index2) {
                Integer n = compressedIntList.get(index2);
                if (n == null) {
                    3.$$$reportNull$$$0(0);
                }
                return n;
            }

            @Override
            public int size() {
                return compressedIntList.size();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoImpl$3", "get"));
            }
        };
    }

    private PermanentCommitsInfoImpl(@NotNull TimestampGetter timestampGetter, @NotNull List<? extends CommitId> commitIdIndex, @NotNull Int2ObjectMap<CommitId> notLoadCommits) {
        if (timestampGetter == null) {
            PermanentCommitsInfoImpl.$$$reportNull$$$0(5);
        }
        if (commitIdIndex == null) {
            PermanentCommitsInfoImpl.$$$reportNull$$$0(6);
        }
        if (notLoadCommits == null) {
            PermanentCommitsInfoImpl.$$$reportNull$$$0(7);
        }
        this.myTimestampGetter = timestampGetter;
        this.myCommitIdIndexes = commitIdIndex;
        this.myNotLoadCommits = notLoadCommits;
    }

    @Override
    @NotNull
    public CommitId getCommitId(int nodeId) {
        if (nodeId < 0) {
            Object object = this.myNotLoadCommits.get(nodeId);
            if (object == null) {
                PermanentCommitsInfoImpl.$$$reportNull$$$0(8);
            }
            return (CommitId)object;
        }
        CommitId CommitId2 = this.myCommitIdIndexes.get(nodeId);
        if (CommitId2 == null) {
            PermanentCommitsInfoImpl.$$$reportNull$$$0(9);
        }
        return CommitId2;
    }

    @Override
    public long getTimestamp(int nodeId) {
        if (nodeId < 0) {
            return 0L;
        }
        return this.myTimestampGetter.getTimestamp(nodeId);
    }

    @NotNull
    public TimestampGetter getTimestampGetter() {
        TimestampGetter timestampGetter = this.myTimestampGetter;
        if (timestampGetter == null) {
            PermanentCommitsInfoImpl.$$$reportNull$$$0(10);
        }
        return timestampGetter;
    }

    @Override
    public int getNodeId(@NotNull CommitId commitId2) {
        int indexOf2;
        if (commitId2 == null) {
            PermanentCommitsInfoImpl.$$$reportNull$$$0(11);
        }
        if ((indexOf2 = this.myCommitIdIndexes.indexOf(commitId2)) != -1) {
            return indexOf2;
        }
        return this.getNotLoadNodeId(commitId2);
    }

    private int getNotLoadNodeId(@NotNull CommitId commitId2) {
        if (commitId2 == null) {
            PermanentCommitsInfoImpl.$$$reportNull$$$0(12);
        }
        for (Int2ObjectMap.Entry entry2 : this.myNotLoadCommits.int2ObjectEntrySet()) {
            if (!entry2.getValue().equals(commitId2)) continue;
            return entry2.getIntKey();
        }
        return -1;
    }

    @NotNull
    public List<CommitId> convertToCommitIdList(@NotNull Collection<Integer> commitIndexes) {
        if (commitIndexes == null) {
            PermanentCommitsInfoImpl.$$$reportNull$$$0(13);
        }
        List list2 = ContainerUtil.map(commitIndexes, this::getCommitId);
        if (list2 == null) {
            PermanentCommitsInfoImpl.$$$reportNull$$$0(14);
        }
        return list2;
    }

    @NotNull
    public Set<CommitId> convertToCommitIdSet(@NotNull Collection<Integer> commitIndexes) {
        if (commitIndexes == null) {
            PermanentCommitsInfoImpl.$$$reportNull$$$0(15);
        }
        Set set2 = ContainerUtil.map2Set(commitIndexes, this::getCommitId);
        if (set2 == null) {
            PermanentCommitsInfoImpl.$$$reportNull$$$0(16);
        }
        return set2;
    }

    @Override
    @NotNull
    public Set<Integer> convertToNodeIds(@NotNull Collection<? extends CommitId> commitIds) {
        if (commitIds == null) {
            PermanentCommitsInfoImpl.$$$reportNull$$$0(17);
        }
        Set<Integer> set2 = this.convertToNodeIds(commitIds, false);
        if (set2 == null) {
            PermanentCommitsInfoImpl.$$$reportNull$$$0(18);
        }
        return set2;
    }

    @NotNull
    public Set<Integer> convertToNodeIds(@NotNull Collection<? extends CommitId> commitIds, boolean reportNotFound) {
        Collection unmatchedIds;
        if (commitIds == null) {
            PermanentCommitsInfoImpl.$$$reportNull$$$0(19);
        }
        HashSet<Integer> result2 = new HashSet<Integer>();
        HashSet<CommitId> matchedIds = new HashSet<CommitId>();
        for (int i2 = 0; i2 < this.myCommitIdIndexes.size(); ++i2) {
            CommitId commitId2 = this.myCommitIdIndexes.get(i2);
            if (!commitIds.contains(commitId2)) continue;
            result2.add(i2);
            matchedIds.add(commitId2);
        }
        if (reportNotFound && !(unmatchedIds = ContainerUtil.subtract(commitIds, matchedIds)).isEmpty()) {
            LOG.warn("Unmatched commit ids " + unmatchedIds);
        }
        for (Int2ObjectMap.Entry entry2 : this.myNotLoadCommits.int2ObjectEntrySet()) {
            Object value2 = entry2.getValue();
            if (!commitIds.contains(value2)) continue;
            result2.add(entry2.getIntKey());
        }
        HashSet<Integer> hashSet = result2;
        if (hashSet == null) {
            PermanentCommitsInfoImpl.$$$reportNull$$$0(20);
        }
        return hashSet;
    }

    public boolean containsAll(@NotNull Collection<? extends CommitId> commitIds) {
        if (commitIds == null) {
            PermanentCommitsInfoImpl.$$$reportNull$$$0(21);
        }
        HashSet<CommitId> commitsToFind = new HashSet<CommitId>(commitIds);
        for (CommitId commitId2 : this.myCommitIdIndexes) {
            commitsToFind.remove(commitId2);
            if (!commitsToFind.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 16: 
            case 18: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 16: 
            case 18: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphCommits";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notLoadedCommits";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timestampGetter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitIdIndex";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notLoadCommits";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitId";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitIndexes";
                break;
            }
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createTimestampGetter";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitId";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTimestampGetter";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToCommitIdList";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToCommitIdSet";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToNodeIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newInstance";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createTimestampGetter";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 16: 
            case 18: 
            case 20: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createCompressedIntList";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getNodeId";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getNotLoadNodeId";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "convertToCommitIdList";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "convertToCommitIdSet";
                break;
            }
            case 17: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "convertToNodeIds";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "containsAll";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 16: 
            case 18: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

