/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.visible;

import com.intellij.util.Function;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.NormalEdge;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinearFragmentGenerator {
    private static final int SHORT_FRAGMENT_MAX_SIZE = 10;
    private static final int MAX_SEARCH_SIZE = 10;
    @NotNull
    private final LiteLinearGraph myLinearGraph;
    @NotNull
    private final Set<Integer> myPinnedNodes;
    private final Function<Integer, List<Integer>> upNodesFun;
    private final Function<Integer, List<Integer>> downNodesFun;

    public LinearFragmentGenerator(@NotNull LiteLinearGraph linearGraph, @NotNull Set<Integer> pinnedNodes) {
        if (linearGraph == null) {
            LinearFragmentGenerator.$$$reportNull$$$0(0);
        }
        if (pinnedNodes == null) {
            LinearFragmentGenerator.$$$reportNull$$$0(1);
        }
        this.upNodesFun = new Function<Integer, List<Integer>>(){

            public List<Integer> fun(Integer integer) {
                return LinearFragmentGenerator.this.myLinearGraph.getNodes(integer, LiteLinearGraph.NodeFilter.UP);
            }
        };
        this.downNodesFun = new Function<Integer, List<Integer>>(){

            public List<Integer> fun(Integer integer) {
                return LinearFragmentGenerator.this.myLinearGraph.getNodes(integer, LiteLinearGraph.NodeFilter.DOWN);
            }
        };
        this.myLinearGraph = linearGraph;
        this.myPinnedNodes = pinnedNodes;
    }

    @Nullable
    public GraphFragment getRelativeFragment(@NotNull GraphElement element2) {
        int downNodeIndex;
        int upNodeIndex;
        if (element2 == null) {
            LinearFragmentGenerator.$$$reportNull$$$0(2);
        }
        if (element2 instanceof GraphNode) {
            downNodeIndex = upNodeIndex = ((GraphNode)element2).getNodeIndex();
        } else {
            NormalEdge graphEdge = LinearGraphUtils.asNormalEdge((GraphEdge)element2);
            if (graphEdge == null) {
                return null;
            }
            upNodeIndex = graphEdge.up;
            downNodeIndex = graphEdge.down;
        }
        for (int i2 = 0; i2 < 10; ++i2) {
            GraphFragment graphFragment = this.getDownFragment(upNodeIndex);
            if (graphFragment != null && graphFragment.downNodeIndex >= downNodeIndex) {
                return graphFragment;
            }
            List<Integer> upNodes = this.myLinearGraph.getNodes(upNodeIndex, LiteLinearGraph.NodeFilter.UP);
            if (upNodes.size() != 1) break;
            upNodeIndex = upNodes.get(0);
        }
        return null;
    }

    @Nullable
    public GraphFragment getDownFragment(int upperVisibleNodeIndex) {
        return LinearFragmentGenerator.getFragment(upperVisibleNodeIndex, this.downNodesFun, this.upNodesFun, this.myPinnedNodes, true);
    }

    @Nullable
    public GraphFragment getUpFragment(int lowerNodeIndex) {
        return LinearFragmentGenerator.getFragment(lowerNodeIndex, this.upNodesFun, this.downNodesFun, this.myPinnedNodes, false);
    }

    @Nullable
    public GraphFragment getLongDownFragment(int rowIndex) {
        return this.getLongFragment(this.getDownFragment(rowIndex), Integer.MAX_VALUE);
    }

    @Nullable
    public GraphFragment getLongFragment(@NotNull GraphElement element2) {
        if (element2 == null) {
            LinearFragmentGenerator.$$$reportNull$$$0(3);
        }
        return this.getLongFragment(this.getRelativeFragment(element2), Integer.MAX_VALUE);
    }

    @Nullable
    public GraphFragment getPartLongFragment(@NotNull GraphElement element2) {
        if (element2 == null) {
            LinearFragmentGenerator.$$$reportNull$$$0(4);
        }
        return this.getLongFragment(this.getRelativeFragment(element2), 500);
    }

    @Nullable
    private GraphFragment getLongFragment(@Nullable GraphFragment startFragment, int bound) {
        GraphFragment shortFragment;
        if (startFragment == null) {
            return null;
        }
        int maxDown = startFragment.downNodeIndex;
        while ((shortFragment = this.getDownFragment(maxDown)) != null && !this.myPinnedNodes.contains(maxDown) && (maxDown = shortFragment.downNodeIndex) - startFragment.downNodeIndex <= bound) {
        }
        int maxUp = startFragment.upNodeIndex;
        while ((shortFragment = this.getUpFragment(maxUp)) != null && !this.myPinnedNodes.contains(maxUp) && startFragment.upNodeIndex - (maxUp = shortFragment.upNodeIndex) <= bound) {
        }
        if (maxUp != startFragment.upNodeIndex || maxDown != startFragment.downNodeIndex) {
            return new GraphFragment(maxUp, maxDown);
        }
        if (this.myLinearGraph.getNodes(startFragment.upNodeIndex, LiteLinearGraph.NodeFilter.DOWN).size() != 1) {
            return startFragment;
        }
        return null;
    }

    @Nullable
    private static GraphFragment getFragment(int startNode, Function<? super Integer, ? extends List<Integer>> getNextNodes, Function<? super Integer, ? extends List<Integer>> getPrevNodes, Set<Integer> thisNodeCantBeInMiddle, boolean isDown) {
        HashSet<Integer> blackNodes = new HashSet<Integer>();
        blackNodes.add(startNode);
        HashSet grayNodes = new HashSet((Collection)getNextNodes.fun((Object)startNode));
        int endNode = -1;
        while (blackNodes.size() < 10) {
            int nextBlackNode = -1;
            Iterator iterator2 = grayNodes.iterator();
            while (iterator2.hasNext()) {
                int grayNode = (Integer)iterator2.next();
                if (!blackNodes.containsAll((Collection)getPrevNodes.fun((Object)grayNode))) continue;
                nextBlackNode = grayNode;
                break;
            }
            if (nextBlackNode == -1) {
                return null;
            }
            if (grayNodes.size() == 1) {
                endNode = nextBlackNode;
                break;
            }
            List nextGrayNodes = (List)getNextNodes.fun((Object)nextBlackNode);
            if (nextGrayNodes.isEmpty() || thisNodeCantBeInMiddle.contains(nextBlackNode)) {
                return null;
            }
            blackNodes.add(nextBlackNode);
            grayNodes.remove(nextBlackNode);
            grayNodes.addAll(nextGrayNodes);
        }
        if (endNode != -1) {
            return isDown ? GraphFragment.create(startNode, endNode) : GraphFragment.create(endNode, startNode);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linearGraph";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pinnedNodes";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/graph/impl/visible/LinearFragmentGenerator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getRelativeFragment";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getLongFragment";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getPartLongFragment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class GraphFragment {
        public final int upNodeIndex;
        public final int downNodeIndex;

        public GraphFragment(int upNodeIndex, int downNodeIndex) {
            this.upNodeIndex = upNodeIndex;
            this.downNodeIndex = downNodeIndex;
        }

        public static GraphFragment create(int startNode, int endNode) {
            return new GraphFragment(startNode, endNode);
        }
    }
}

