/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils.impl;

import com.intellij.vcs.log.graph.utils.Flags;
import java.util.BitSet;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class BitSetFlags
implements Flags {
    private final int mySize;
    @NotNull
    private final BitSet myBitSet;

    public BitSetFlags(int size) {
        if (size < 0) {
            throw new NegativeArraySizeException("size < 0: " + size);
        }
        this.mySize = size;
        this.myBitSet = new BitSet();
    }

    public BitSetFlags(int size, boolean defaultValue) {
        this(size);
        if (defaultValue) {
            this.setAll(true);
        }
    }

    @Override
    public int size() {
        return this.mySize;
    }

    @Override
    public boolean get(int index2) {
        this.checkRange(index2);
        return this.myBitSet.get(index2);
    }

    @Override
    public void set(int index2, boolean value2) {
        this.checkRange(index2);
        this.myBitSet.set(index2, value2);
    }

    @Override
    public void setAll(boolean value2) {
        this.myBitSet.set(0, this.mySize, value2);
    }

    private void checkRange(int index2) {
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("index is " + index2 + " which is less than zero");
        }
        if (index2 >= this.mySize) {
            throw new IndexOutOfBoundsException("index is " + index2 + " and set size is " + this.mySize);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BitSetFlags flags = (BitSetFlags)o;
        return this.mySize == flags.mySize && this.myBitSet.equals(flags.myBitSet);
    }

    public int hashCode() {
        return Objects.hash(this.mySize, this.myBitSet);
    }

    public String toString() {
        return this.myBitSet + ", size = " + this.mySize;
    }
}

