/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils.impl;

import com.intellij.vcs.log.graph.utils.IntList;
import org.jetbrains.annotations.NotNull;

final class ByteArrayUtils {
    private static final int BYTE_OFFSET = 8;
    private static final int BYTE_MASK = 255;

    ByteArrayUtils() {
    }

    public static int countBytesAfterCompression(@NotNull IntList deltaList) {
        if (deltaList == null) {
            ByteArrayUtils.$$$reportNull$$$0(0);
        }
        int count = 0;
        for (int i2 = 0; i2 < deltaList.size(); ++i2) {
            count += ByteArrayUtils.sizeOf(deltaList.get(i2));
        }
        return count;
    }

    public static int sizeOf(int value2) {
        if (value2 < 0) {
            value2 ^= 0xFFFFFFFF;
        }
        value2 >>= 7;
        for (int i2 = 1; i2 < 4; ++i2) {
            if (value2 == 0) {
                return i2;
            }
            value2 >>= 8;
        }
        return 4;
    }

    public static void writeDelta(int startIndex, int value2, int sizeOf, byte[] bytes) {
        for (int i2 = sizeOf - 1; i2 >= 0; --i2) {
            bytes[startIndex + i2] = (byte)value2;
            value2 >>= 8;
        }
    }

    public static int readDelta(int startIndex, int sizeOf, byte[] bytes) {
        int i2;
        boolean isNegative;
        int result2 = 0;
        boolean bl = isNegative = bytes[startIndex] < 0;
        if (isNegative) {
            for (i2 = 0; i2 < 4 - sizeOf; ++i2) {
                result2 <<= 8;
                result2 |= 0xFF;
            }
        }
        for (i2 = startIndex; i2 < startIndex + sizeOf; ++i2) {
            result2 <<= 8;
            result2 |= bytes[i2] & 0xFF;
        }
        return result2;
    }

    public static int groundPointCount(int arraySize, int blockSize) {
        if (arraySize == 0) {
            return 1;
        }
        return (arraySize - 1) / blockSize + 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deltaList", "com/intellij/vcs/log/graph/utils/impl/ByteArrayUtils", "countBytesAfterCompression"));
    }
}

