/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeViewDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.vcs.log.ui.frame.VcsLogChangesBrowser;
import java.util.stream.Stream;
import javax.swing.JTree;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogChangeProcessor
extends ChangeViewDiffRequestProcessor {
    @NotNull
    private final VcsLogChangesBrowser myBrowser;
    private final boolean myIsInEditor;

    VcsLogChangeProcessor(@NotNull Project project, @NotNull VcsLogChangesBrowser browser2, boolean isInEditor, @NotNull Disposable disposable2) {
        if (project == null) {
            VcsLogChangeProcessor.$$$reportNull$$$0(0);
        }
        if (browser2 == null) {
            VcsLogChangeProcessor.$$$reportNull$$$0(1);
        }
        if (disposable2 == null) {
            VcsLogChangeProcessor.$$$reportNull$$$0(2);
        }
        super(project, isInEditor ? "Default" : "VcsLogView");
        this.myIsInEditor = isInEditor;
        this.myBrowser = browser2;
        if (!isInEditor) {
            this.myContentPanel.setBorder(IdeBorderFactory.createBorder((int)2));
        }
        Disposer.register((Disposable)disposable2, (Disposable)this);
        this.myBrowser.addListener(() -> this.updatePreviewLater(), this);
        this.myBrowser.getViewer().addSelectionListener(this::updatePreviewLater, this);
    }

    @Override
    protected boolean shouldAddToolbarBottomBorder(@NotNull FrameDiffTool.ToolbarComponents toolbarComponents) {
        if (toolbarComponents == null) {
            VcsLogChangeProcessor.$$$reportNull$$$0(3);
        }
        return false;
    }

    @NotNull
    public Wrapper getToolbarWrapper() {
        Wrapper wrapper2 = this.myToolbarWrapper;
        if (wrapper2 == null) {
            VcsLogChangeProcessor.$$$reportNull$$$0(4);
        }
        return wrapper2;
    }

    @NotNull
    public Stream<ChangeViewDiffRequestProcessor.Wrapper> getSelectedChanges() {
        return this.wrap(VcsTreeModelData.selected((JTree)((Object)this.myBrowser.getViewer())));
    }

    @NotNull
    public Stream<ChangeViewDiffRequestProcessor.Wrapper> getAllChanges() {
        return this.wrap(VcsTreeModelData.all((JTree)((Object)this.myBrowser.getViewer())));
    }

    @NotNull
    private Stream<ChangeViewDiffRequestProcessor.Wrapper> wrap(@NotNull VcsTreeModelData modelData) {
        if (modelData == null) {
            VcsLogChangeProcessor.$$$reportNull$$$0(5);
        }
        StreamEx streamEx = StreamEx.of(modelData.nodesStream()).select(ChangesBrowserChangeNode.class).map(n -> new MyChangeWrapper((Change)n.getUserObject(), this.myBrowser.getTag((Change)n.getUserObject())));
        if (streamEx == null) {
            VcsLogChangeProcessor.$$$reportNull$$$0(6);
        }
        return streamEx;
    }

    @Override
    protected void selectChange(@NotNull ChangeViewDiffRequestProcessor.Wrapper change) {
        if (change == null) {
            VcsLogChangeProcessor.$$$reportNull$$$0(7);
        }
        this.myBrowser.selectChange(change.getUserObject(), change.getTag());
    }

    private void updatePreviewLater() {
        ApplicationManager.getApplication().invokeLater(() -> this.updatePreview(this.myIsInEditor || this.getComponent().isShowing()));
    }

    public void updatePreview(boolean state) {
        this.updatePreview(state, false);
    }

    @NotNull
    public static VcsTreeModelData getSelectedOrAll(VcsLogChangesBrowser changesBrowser) {
        boolean hasSelection = changesBrowser.getViewer().getSelectionModel().getSelectionCount() != 0;
        VcsTreeModelData vcsTreeModelData = hasSelection ? VcsTreeModelData.selected((JTree)((Object)changesBrowser.getViewer())) : VcsTreeModelData.all((JTree)((Object)changesBrowser.getViewer()));
        if (vcsTreeModelData == null) {
            VcsLogChangeProcessor.$$$reportNull$$$0(8);
        }
        return vcsTreeModelData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browser";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolbarComponents";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/frame/VcsLogChangeProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelData";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/frame/VcsLogChangeProcessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbarWrapper";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "wrap";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedOrAll";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddToolbarBottomBorder";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "selectChange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyChangeWrapper
    extends ChangeViewDiffRequestProcessor.ChangeWrapper {
        MyChangeWrapper(@Nullable Change change, ChangesBrowserNode.Tag tag2) {
            if (change == null) {
                MyChangeWrapper.$$$reportNull$$$0(0);
            }
            super(change, tag2);
        }

        @Override
        @Nullable
        public DiffRequestProducer createProducer(@Nullable Project project) {
            return VcsLogChangeProcessor.this.myBrowser.getDiffRequestProducer(this.change, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/vcs/log/ui/frame/VcsLogChangeProcessor$MyChangeWrapper", "<init>"));
        }
    }
}

