/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.DiffPreview;
import com.intellij.openapi.vcs.changes.EditorTabDiffPreviewManager;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.TagChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vcs.changes.ui.browser.ChangesFilterer;
import com.intellij.openapi.vcs.changes.ui.browser.FilterableChangesBrowser;
import com.intellij.openapi.vcs.history.VcsDiffUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.switcher.QuickActionProvider;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.index.IndexedDetails;
import com.intellij.vcs.log.history.FileHistoryUtil;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.MergedChange;
import com.intellij.vcs.log.impl.MergedChangeDiffRequestProvider;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.frame.EditorDiffPreview;
import com.intellij.vcs.log.ui.frame.VcsLogChangeProcessor;
import com.intellij.vcs.log.ui.frame.VcsLogEditorDiffPreview;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import com.intellij.vcs.log.util.VcsLogUtil;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsLogChangesBrowser
extends FilterableChangesBrowser {
    @NotNull
    public static final DataKey<Boolean> HAS_AFFECTED_FILES = DataKey.create("VcsLogChangesBrowser.HasAffectedFiles");
    @NotNull
    private final MainVcsLogUiProperties myUiProperties;
    @NotNull
    private final Function<? super CommitId, ? extends VcsShortCommitDetails> myDataGetter;
    @NotNull
    private final VcsLogUiProperties.PropertiesChangeListener myListener;
    @NotNull
    private final Set<VirtualFile> myRoots;
    private boolean myHasMergeCommits;
    @NotNull
    private final List<Change> myChanges;
    @NotNull
    private final Map<CommitId, Set<Change>> myChangesToParents;
    @Nullable
    private Collection<FilePath> myAffectedPaths;
    @NotNull
    private Consumer<StatusText> myUpdateEmptyText;
    @NotNull
    private final Wrapper myToolbarWrapper;
    @NotNull
    private final EventDispatcher<Listener> myDispatcher;
    @Nullable
    private EditorDiffPreview myEditorDiffPreview;

    VcsLogChangesBrowser(@NotNull Project project, @NotNull MainVcsLogUiProperties uiProperties, @NotNull Function<? super CommitId, ? extends VcsShortCommitDetails> getter, boolean isWithEditorDiffPreview, @NotNull Disposable parent) {
        if (project == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(0);
        }
        if (uiProperties == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(1);
        }
        if (getter == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(2);
        }
        if (parent == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(3);
        }
        super(project, false, false);
        this.myRoots = new HashSet<VirtualFile>();
        this.myHasMergeCommits = false;
        this.myChanges = new ArrayList<Change>();
        this.myChangesToParents = new LinkedHashMap<CommitId, Set<Change>>();
        this.myUpdateEmptyText = this::updateEmptyText;
        this.myDispatcher = EventDispatcher.create(Listener.class);
        this.myUiProperties = uiProperties;
        this.myDataGetter = getter;
        this.myListener = new VcsLogUiProperties.PropertiesChangeListener(){

            @Override
            public <T> void onPropertyChanged(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property2) {
                if (property2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (MainVcsLogUiProperties.SHOW_CHANGES_FROM_PARENTS.equals(property2) || MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES.equals(property2)) {
                    VcsLogChangesBrowser.this.myViewer.rebuildTree();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/vcs/log/ui/frame/VcsLogChangesBrowser$1", "onPropertyChanged"));
            }
        };
        this.myUiProperties.addChangeListener(this.myListener);
        Disposer.register((Disposable)parent, (Disposable)this);
        JComponent toolbarComponent = this.getToolbar().getComponent();
        this.myToolbarWrapper = new Wrapper(toolbarComponent);
        GuiUtils.installVisibilityReferent((JComponent)this.myToolbarWrapper, (JComponent)toolbarComponent);
        this.init();
        this.setEditorDiffPreview(isWithEditorDiffPreview && VcsLogUiUtil.isDiffPreviewInEditor(this.myProject));
        if (isWithEditorDiffPreview) {
            EditorTabDiffPreviewManager.getInstance(this.myProject).subscribeToPreviewVisibilityChange(this, () -> this.setEditorDiffPreview(VcsLogUiUtil.isDiffPreviewInEditor(this.myProject)));
        }
        this.hideViewerBorder();
        this.myViewer.setEmptyText(VcsLogBundle.message((String)"vcs.log.changes.select.commits.to.view.changes.status", (Object[])new Object[0]));
        this.myViewer.rebuildTree();
    }

    @Override
    @NotNull
    protected JComponent createToolbarComponent() {
        Wrapper wrapper2 = this.myToolbarWrapper;
        if (wrapper2 == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(4);
        }
        return wrapper2;
    }

    @Override
    @NotNull
    protected JComponent createCenterPanel() {
        JComponent centerPanel = super.createCenterPanel();
        JScrollPane scrollPane = (JScrollPane)UIUtil.findComponentOfType((JComponent)centerPanel, JScrollPane.class);
        if (scrollPane != null) {
            ComponentUtil.putClientProperty((JComponent)scrollPane, (Key)UIUtil.KEEP_BORDER_SIDES, (Object)2);
        }
        JComponent jComponent = centerPanel;
        if (jComponent == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(5);
        }
        return jComponent;
    }

    public void setToolbarHeightReferent(@NotNull JComponent referent) {
        if (referent == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(6);
        }
        this.myToolbarWrapper.setVerticalSizeReferent(referent);
    }

    public void addListener(@NotNull Listener listener2, @NotNull Disposable disposable2) {
        if (listener2 == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(7);
        }
        if (disposable2 == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(8);
        }
        this.myDispatcher.addListener((EventListener)listener2, disposable2);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myUiProperties.removeChangeListener(this.myListener);
    }

    @Override
    @NotNull
    protected List<AnAction> createToolbarActions() {
        List list2 = ContainerUtil.append(super.createToolbarActions(), (Object[])new AnAction[]{CustomActionsSchema.getInstance().getCorrectedAction("Vcs.Log.ChangesBrowser.Toolbar")});
        if (list2 == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @Override
    @NotNull
    protected List<AnAction> createPopupMenuActions() {
        List list2 = ContainerUtil.append(super.createPopupMenuActions(), (Object[])new AnAction[]{ActionManager.getInstance().getAction("Vcs.Log.ChangesBrowser.Popup")});
        if (list2 == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(10);
        }
        return list2;
    }

    private void updateModel(@NotNull Runnable update2) {
        if (update2 == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(11);
        }
        this.myChanges.clear();
        this.myChangesToParents.clear();
        this.myRoots.clear();
        this.myHasMergeCommits = false;
        this.myUpdateEmptyText = this::updateEmptyText;
        update2.run();
        this.myUpdateEmptyText.accept(this.myViewer.getEmptyText());
        this.myViewer.rebuildTree();
        ((Listener)this.myDispatcher.getMulticaster()).onModelUpdated();
    }

    public void resetSelectedDetails() {
        this.updateModel(() -> {
            this.myUpdateEmptyText = text2 -> text2.setText("");
        });
    }

    public void showText(@NotNull Consumer<StatusText> statusTextConsumer) {
        if (statusTextConsumer == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(12);
        }
        this.updateModel(() -> {
            this.myUpdateEmptyText = statusTextConsumer;
        });
    }

    @Override
    protected void onActiveChangesFilterChanges() {
        super.onActiveChangesFilterChanges();
        this.myUpdateEmptyText.accept(this.myViewer.getEmptyText());
    }

    public void setAffectedPaths(@Nullable Collection<FilePath> paths2) {
        this.myAffectedPaths = paths2;
        this.myUpdateEmptyText.accept(this.myViewer.getEmptyText());
        this.myViewer.rebuildTree();
    }

    public void setSelectedDetails(@NotNull List<? extends VcsFullCommitDetails> detailsList) {
        if (detailsList == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(13);
        }
        this.updateModel(() -> {
            if (!detailsList.isEmpty()) {
                this.myRoots.addAll(ContainerUtil.map((Collection)detailsList, detail -> detail.getRoot()));
                this.myHasMergeCommits = ContainerUtil.exists((Iterable)detailsList, detail -> detail.getParents().size() > 1);
                if (detailsList.size() == 1) {
                    VcsFullCommitDetails detail2 = Objects.requireNonNull((VcsFullCommitDetails)ContainerUtil.getFirstItem((List)detailsList));
                    this.myChanges.addAll(detail2.getChanges());
                    if (detail2.getParents().size() > 1) {
                        for (int i2 = 0; i2 < detail2.getParents().size(); ++i2) {
                            ReferenceOpenHashSet changesSet = new ReferenceOpenHashSet(detail2.getChanges(i2));
                            this.myChangesToParents.put(new CommitId((Hash)detail2.getParents().get(i2), detail2.getRoot()), (Set<Change>)changesSet);
                        }
                    }
                } else {
                    this.myChanges.addAll(VcsLogUtil.collectChanges(detailsList, (Function<? super VcsFullCommitDetails, ? extends Collection<Change>>)((Function)VcsFullCommitDetails::getChanges)));
                }
            }
        });
    }

    private void updateEmptyText(@NotNull StatusText emptyText) {
        if (emptyText == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(14);
        }
        if (this.myRoots.isEmpty()) {
            emptyText.setText(VcsLogBundle.message((String)"vcs.log.changes.select.commits.to.view.changes.status", (Object[])new Object[0]));
        } else if (!this.myChangesToParents.isEmpty()) {
            emptyText.setText(VcsLogBundle.message((String)"vcs.log.changes.no.merge.conflicts.status", (Object[])new Object[0])).appendSecondaryText(VcsLogBundle.message((String)"vcs.log.changes.show.changes.to.parents.status.action", (Object[])new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, e -> this.myUiProperties.set(MainVcsLogUiProperties.SHOW_CHANGES_FROM_PARENTS, true));
        } else if (this.isShowOnlyAffectedSelected() && this.myAffectedPaths != null) {
            emptyText.setText(VcsLogBundle.message((String)"vcs.log.changes.no.changes.that.affect.selected.paths.status", (Object[])new Object[0])).appendSecondaryText(VcsLogBundle.message((String)"vcs.log.changes.show.all.paths.status.action", (Object[])new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, e -> this.myUiProperties.set(MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES, false));
        } else if (!this.myHasMergeCommits && this.hasActiveChangesFilter()) {
            emptyText.setText(VcsLogBundle.message((String)"vcs.log.changes.no.changes.that.affect.selected.filters.status", (Object[])new Object[0])).appendSecondaryText(VcsLogBundle.message((String)"vcs.log.changes.show.all.changes.status.action", (Object[])new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, e -> this.clearActiveChangesFilter());
        } else {
            emptyText.setText("");
        }
    }

    @Override
    @NotNull
    protected DefaultTreeModel buildTreeModel() {
        List<Change> changes = this.collectAffectedChanges(this.myChanges);
        ChangesFilterer.FilteredState filteredState = this.filterChanges(changes, !this.myHasMergeCommits);
        LinkedHashMap<CommitId, List<Change>> changesToParents = new LinkedHashMap<CommitId, List<Change>>();
        for (Map.Entry<CommitId, Set<Change>> entry2 : this.myChangesToParents.entrySet()) {
            changesToParents.put(entry2.getKey(), this.collectAffectedChanges((Collection<Change>)entry2.getValue()));
        }
        TreeModelBuilder builder2 = new TreeModelBuilder(this.myProject, this.getGrouping());
        VcsLogChangesBrowser.setFilteredChanges(builder2, filteredState, null);
        if (this.isShowChangesFromParents() && !changesToParents.isEmpty()) {
            if (changes.isEmpty()) {
                builder2.createTagNode(VcsLogBundle.message((String)"vcs.log.changes.no.merge.conflicts.node", (Object[])new Object[0]));
            }
            for (CommitId commitId2 : changesToParents.keySet()) {
                Collection changesFromParent = (Collection)changesToParents.get(commitId2);
                if (changesFromParent.isEmpty()) continue;
                TagChangesBrowserNode parentNode = new TagChangesBrowserNode(new ParentTag(commitId2.getHash(), this.getText(commitId2)), SimpleTextAttributes.REGULAR_ATTRIBUTES, false);
                parentNode.markAsHelperNode();
                builder2.insertSubtreeRoot((ChangesBrowserNode)parentNode);
                builder2.insertChanges(changesFromParent, parentNode);
            }
        }
        DefaultTreeModel defaultTreeModel = builder2.build();
        if (defaultTreeModel == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(15);
        }
        return defaultTreeModel;
    }

    @NotNull
    private List<Change> collectAffectedChanges(@NotNull Collection<Change> changes) {
        if (changes == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(16);
        }
        if (!this.isShowOnlyAffectedSelected() || this.myAffectedPaths == null) {
            return new ArrayList<Change>(changes);
        }
        List list2 = ContainerUtil.filter(changes, change -> ContainerUtil.or(this.myAffectedPaths, filePath -> {
            if (filePath.isDirectory()) {
                return FileHistoryUtil.affectsDirectory(change, filePath);
            }
            return FileHistoryUtil.affectsFile(change, filePath, false) || FileHistoryUtil.affectsFile(change, filePath, true);
        }));
        if (list2 == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(17);
        }
        return list2;
    }

    private boolean isShowChangesFromParents() {
        return this.myUiProperties.exists(MainVcsLogUiProperties.SHOW_CHANGES_FROM_PARENTS) && this.myUiProperties.get(MainVcsLogUiProperties.SHOW_CHANGES_FROM_PARENTS) != false;
    }

    private boolean isShowOnlyAffectedSelected() {
        return this.myUiProperties.exists(MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES) && this.myUiProperties.get(MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES) != false;
    }

    @NotNull
    public List<Change> getDirectChanges() {
        List<Change> list2 = this.myChanges;
        if (list2 == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(18);
        }
        return list2;
    }

    @NotNull
    public List<Change> getSelectedChanges() {
        List<Change> list2 = VcsTreeModelData.selected((JTree)((Object)this.myViewer)).userObjects(Change.class);
        if (list2 == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(19);
        }
        return list2;
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(20);
        }
        if (VcsDataKeys.VCS.is(dataId)) {
            AbstractVcs vcs = this.getVcs();
            if (vcs == null) {
                return null;
            }
            return vcs.getKeyInstanceMethod();
        }
        if (HAS_AFFECTED_FILES.is(dataId)) {
            return this.myAffectedPaths != null;
        }
        if (QuickActionProvider.KEY.is(dataId)) {
            return new QuickActionProvider(){

                @NotNull
                public List<AnAction> getActions(boolean originalProvider) {
                    List list2 = SimpleToolWindowPanel.collectActions((JComponent)VcsLogChangesBrowser.this);
                    if (list2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return list2;
                }

                public JComponent getComponent() {
                    return VcsLogChangesBrowser.this;
                }

                @NlsActions.ActionText
                @Nullable
                public String getName() {
                    return null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/VcsLogChangesBrowser$2", "getActions"));
                }
            };
        }
        return super.getData(dataId);
    }

    @Nullable
    private AbstractVcs getVcs() {
        List allVcs = ContainerUtil.mapNotNull(this.myRoots, root2 -> ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsFor(root2));
        if (allVcs.size() == 1) {
            return Objects.requireNonNull((AbstractVcs)ContainerUtil.getFirstItem((List)allVcs));
        }
        Set selectedVcs = ChangesUtil.getAffectedVcses(this.getSelectedChanges(), (Project)this.myProject);
        if (selectedVcs.size() == 1) {
            return Objects.requireNonNull((AbstractVcs)ContainerUtil.getFirstItem((Collection)selectedVcs));
        }
        return null;
    }

    @Override
    public ChangeDiffRequestChain.Producer getDiffRequestProducer(@NotNull Object userObject) {
        if (userObject == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(21);
        }
        return this.getDiffRequestProducer(userObject, false);
    }

    @Nullable
    public ChangeDiffRequestChain.Producer getDiffRequestProducer(@NotNull Object userObject, boolean forDiffPreview) {
        if (userObject == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(22);
        }
        if (!(userObject instanceof Change)) {
            return null;
        }
        Change change = (Change)userObject;
        HashMap context2 = new HashMap();
        if (!(change instanceof MergedChange)) {
            this.putRootTagIntoChangeContext(change, context2);
        }
        return VcsLogChangesBrowser.createDiffRequestProducer(this.myProject, change, context2, forDiffPreview);
    }

    @Nullable
    public static ChangeDiffRequestChain.Producer createDiffRequestProducer(@NotNull Project project, @NotNull Change change, @NotNull Map<Key<?>, Object> context2, boolean forDiffPreview) {
        MergedChange mergedChange;
        if (project == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(23);
        }
        if (change == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(24);
        }
        if (context2 == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(25);
        }
        if (change instanceof MergedChange && (mergedChange = (MergedChange)change).getSourceChanges().size() == 2) {
            if (forDiffPreview) {
                VcsLogChangesBrowser.putFilePathsIntoMergedChangeContext(mergedChange, context2);
            }
            return new MergedChangeDiffRequestProvider.MyProducer(project, mergedChange, context2);
        }
        if (forDiffPreview) {
            VcsDiffUtil.putFilePathsIntoChangeContext(change, context2);
        }
        return ChangeDiffRequestProducer.create(project, change, context2);
    }

    public void setEditorDiffPreview(boolean isWithEditorDiffPreview) {
        EditorDiffPreview preview2 = this.myEditorDiffPreview;
        if (isWithEditorDiffPreview && preview2 == null) {
            this.myEditorDiffPreview = preview2 = new VcsLogEditorDiffPreview(this.myProject, this);
        } else if (!isWithEditorDiffPreview && preview2 != null) {
            preview2.closePreview();
            this.myEditorDiffPreview = null;
        }
    }

    @NotNull
    public VcsLogChangeProcessor createChangeProcessor(boolean isInEditor) {
        return new VcsLogChangeProcessor(this.myProject, this, isInEditor, this);
    }

    @Override
    @Nullable
    protected DiffPreview getShowDiffActionPreview() {
        return this.myEditorDiffPreview;
    }

    public void selectChange(@NotNull Object userObject, @Nullable ChangesBrowserNode.Tag tag2) {
        if (userObject == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(26);
        }
        VcsLogChangesBrowser.selectObjectWithTag(this.myViewer, userObject, tag2);
    }

    @Nullable
    public ChangesBrowserNode.Tag getTag(@NotNull Change change) {
        if (change == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(27);
        }
        CommitId parentId = null;
        for (CommitId commitId2 : this.myChangesToParents.keySet()) {
            if (!this.myChangesToParents.get(commitId2).contains(change)) continue;
            parentId = commitId2;
            break;
        }
        if (parentId == null) {
            return null;
        }
        return new ParentTag(parentId.getHash(), this.getText(parentId));
    }

    private void putRootTagIntoChangeContext(@NotNull Change change, @NotNull Map<Key<?>, Object> context2) {
        ChangesBrowserNode.Tag tag2;
        if (change == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(28);
        }
        if (context2 == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(29);
        }
        if ((tag2 = this.getTag(change)) != null) {
            context2.put(ChangeDiffRequestProducer.TAG_KEY, tag2);
        }
    }

    private static void putFilePathsIntoMergedChangeContext(@NotNull MergedChange change, @NotNull Map<Key<?>, Object> context2) {
        if (change == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(30);
        }
        if (context2 == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(31);
        }
        ContentRevision centerRevision = change.getAfterRevision();
        ContentRevision leftRevision = change.getSourceChanges().get(0).getBeforeRevision();
        ContentRevision rightRevision = change.getSourceChanges().get(1).getBeforeRevision();
        FilePath centerFile = centerRevision == null ? null : centerRevision.getFile();
        FilePath leftFile = leftRevision == null ? null : leftRevision.getFile();
        FilePath rightFile = rightRevision == null ? null : rightRevision.getFile();
        context2.put(DiffUserDataKeysEx.VCS_DIFF_CENTER_CONTENT_TITLE, VcsDiffUtil.getRevisionTitle(centerRevision, centerFile, null));
        context2.put(DiffUserDataKeysEx.VCS_DIFF_RIGHT_CONTENT_TITLE, VcsDiffUtil.getRevisionTitle(rightRevision, rightFile, centerFile));
        context2.put(DiffUserDataKeysEx.VCS_DIFF_LEFT_CONTENT_TITLE, VcsDiffUtil.getRevisionTitle(leftRevision, leftFile, centerFile == null ? rightFile : centerFile));
    }

    @NotNull
    @Nls
    private String getText(@NotNull CommitId commitId2) {
        if (commitId2 == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(32);
        }
        Object text2 = VcsLogBundle.message((String)"vcs.log.changes.changes.to.parent.node", (Object[])new Object[]{commitId2.getHash().toShortString()});
        VcsShortCommitDetails detail = (VcsShortCommitDetails)this.myDataGetter.fun((Object)commitId2);
        if (!(detail instanceof LoadingDetails) || detail instanceof IndexedDetails) {
            text2 = (String)text2 + " " + StringUtil.shortenTextWithEllipsis((String)detail.getSubject(), (int)50, (int)0);
        }
        String string = text2;
        if (string == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(33);
        }
        return string;
    }

    public static void selectObjectWithTag(@NotNull ChangesTree tree, @NotNull Object userObject, @Nullable ChangesBrowserNode.Tag tag2) {
        DefaultMutableTreeNode node2;
        DefaultMutableTreeNode tagNode;
        if (tree == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(34);
        }
        if (userObject == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(35);
        }
        DefaultMutableTreeNode root2 = tree.getRoot();
        if (tag2 != null && (tagNode = TreeUtil.findNodeWithObject(root2, (Object)tag2)) != null) {
            root2 = tagNode;
        }
        if ((node2 = TreeUtil.findNodeWithObject(root2, (Object)userObject)) == null) {
            return;
        }
        TreeUtil.selectPath((JTree)((Object)tree), (TreePath)TreeUtil.getPathFromRoot((TreeNode)node2), (boolean)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiProperties";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/frame/VcsLogChangesBrowser";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "update";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusTextConsumer";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detailsList";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyText";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 21: 
            case 22: 
            case 26: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userObject";
                break;
            }
            case 24: 
            case 27: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 25: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitId";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/frame/VcsLogChangesBrowser";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarActions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupMenuActions";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTreeModel";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAffectedChanges";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectChanges";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedChanges";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 33: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setToolbarHeightReferent";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateModel";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "showText";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedDetails";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateEmptyText";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "collectAffectedChanges";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getDiffRequestProducer";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createDiffRequestProducer";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "selectChange";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getTag";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "putRootTagIntoChangeContext";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "putFilePathsIntoMergedChangeContext";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "selectObjectWithTag";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ParentTag
    extends ChangesBrowserNode.ValueTag<Hash> {
        @NotNull
        @Nls
        private final String myText;

        ParentTag(@NotNull Hash commit2, @NotNull @Nls String text2) {
            if (commit2 == null) {
                ParentTag.$$$reportNull$$$0(0);
            }
            if (text2 == null) {
                ParentTag.$$$reportNull$$$0(1);
            }
            super(commit2);
            this.myText = text2;
        }

        @Override
        public String toString() {
            return this.myText;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "commit";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
            }
            objectArray[1] = "com/intellij/vcs/log/ui/frame/VcsLogChangesBrowser$ParentTag";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface Listener
    extends EventListener {
        public void onModelUpdated();
    }
}

