/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.visible;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.DataPackBase;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.history.FileHistoryPaths;
import com.intellij.vcs.log.visible.EmptyVisibleGraph;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisiblePack
implements VcsLogDataPack,
UserDataHolder {
    @NotNull
    public static final VisiblePack EMPTY = new VisiblePack((DataPackBase)DataPack.EMPTY, (VisibleGraph)EmptyVisibleGraph.getInstance(), false, VcsLogFilterObject.EMPTY_COLLECTION){

        @Override
        public String toString() {
            return "EmptyVisiblePack";
        }
    };
    @NotNull
    private final DataPackBase myDataPack;
    @NotNull
    private final VisibleGraph<Integer> myVisibleGraph;
    private final boolean myCanRequestMore;
    @NotNull
    private final VcsLogFilterCollection myFilters;
    @NotNull
    private final Map<Key, Object> myAdditionalData;

    public VisiblePack(@NotNull DataPackBase dataPack, @NotNull VisibleGraph<Integer> graph2, boolean canRequestMore, @NotNull VcsLogFilterCollection filters) {
        if (dataPack == null) {
            VisiblePack.$$$reportNull$$$0(0);
        }
        if (graph2 == null) {
            VisiblePack.$$$reportNull$$$0(1);
        }
        if (filters == null) {
            VisiblePack.$$$reportNull$$$0(2);
        }
        this(dataPack, graph2, canRequestMore, filters, Collections.emptyMap());
    }

    public VisiblePack(@NotNull DataPackBase dataPack, @NotNull VisibleGraph<Integer> graph2, boolean canRequestMore, @NotNull VcsLogFilterCollection filters, @NotNull Map<Key, Object> additionalData) {
        if (dataPack == null) {
            VisiblePack.$$$reportNull$$$0(3);
        }
        if (graph2 == null) {
            VisiblePack.$$$reportNull$$$0(4);
        }
        if (filters == null) {
            VisiblePack.$$$reportNull$$$0(5);
        }
        if (additionalData == null) {
            VisiblePack.$$$reportNull$$$0(6);
        }
        this.myAdditionalData = new ConcurrentHashMap<Key, Object>();
        this.myDataPack = dataPack;
        this.myVisibleGraph = graph2;
        this.myCanRequestMore = canRequestMore;
        this.myFilters = filters;
        this.myAdditionalData.putAll(additionalData);
    }

    @NotNull
    public VisibleGraph<Integer> getVisibleGraph() {
        VisibleGraph<Integer> visibleGraph = this.myVisibleGraph;
        if (visibleGraph == null) {
            VisiblePack.$$$reportNull$$$0(7);
        }
        return visibleGraph;
    }

    @NotNull
    public DataPackBase getDataPack() {
        DataPackBase dataPackBase = this.myDataPack;
        if (dataPackBase == null) {
            VisiblePack.$$$reportNull$$$0(8);
        }
        return dataPackBase;
    }

    public boolean canRequestMore() {
        return this.myCanRequestMore;
    }

    @NotNull
    public Map<VirtualFile, VcsLogProvider> getLogProviders() {
        Map<VirtualFile, VcsLogProvider> map2 = this.myDataPack.getLogProviders();
        if (map2 == null) {
            VisiblePack.$$$reportNull$$$0(9);
        }
        return map2;
    }

    @NotNull
    public VcsLogRefs getRefs() {
        RefsModel refsModel = this.myDataPack.getRefsModel();
        if (refsModel == null) {
            VisiblePack.$$$reportNull$$$0(10);
        }
        return refsModel;
    }

    public boolean isFull() {
        return this.myDataPack.isFull();
    }

    @NotNull
    public VcsLogFilterCollection getFilters() {
        VcsLogFilterCollection vcsLogFilterCollection = this.myFilters;
        if (vcsLogFilterCollection == null) {
            VisiblePack.$$$reportNull$$$0(11);
        }
        return vcsLogFilterCollection;
    }

    public boolean isEmpty() {
        return this.getVisibleGraph().getVisibleCommitCount() == 0;
    }

    public VirtualFile getRoot(int row2) {
        int head = (Integer)this.myVisibleGraph.getRowInfo(row2).getOneOfHeads();
        return this.myDataPack.getRefsModel().rootAtHead(head);
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            VisiblePack.$$$reportNull$$$0(12);
        }
        return (T)this.myAdditionalData.get(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
        if (key == null) {
            VisiblePack.$$$reportNull$$$0(13);
        }
        this.myAdditionalData.put(key, value2);
    }

    @NotNull
    public Map<Key, Object> getAdditionalData() {
        Map<Key, Object> map2 = this.myAdditionalData;
        if (map2 == null) {
            VisiblePack.$$$reportNull$$$0(14);
        }
        return map2;
    }

    @NonNls
    public String toString() {
        return "VisiblePack{size=" + this.myVisibleGraph.getVisibleCommitCount() + ", filters=" + this.myFilters + ", canRequestMore=" + this.myCanRequestMore + "}";
    }

    @NotNull
    public FilePath getFilePath(int index2) {
        FilePath path2;
        if (FileHistoryPaths.hasPathsInformation(this) && (path2 = FileHistoryPaths.filePathOrDefault(this, (Integer)this.myVisibleGraph.getRowInfo(index2).getCommit())) != null) {
            FilePath filePath = path2;
            if (filePath == null) {
                VisiblePack.$$$reportNull$$$0(15);
            }
            return filePath;
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)this.getRoot(index2));
        if (filePath == null) {
            VisiblePack.$$$reportNull$$$0(16);
        }
        return filePath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPack";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalData";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/visible/VisiblePack";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/visible/VisiblePack";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleGraph";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataPack";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogProviders";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefs";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilters";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalData";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ErrorVisiblePack
    extends VisiblePack {
        @NotNull
        private final Throwable myError;

        public ErrorVisiblePack(@NotNull DataPackBase dataPack, @NotNull VcsLogFilterCollection filters, @NotNull Throwable error) {
            if (dataPack == null) {
                ErrorVisiblePack.$$$reportNull$$$0(0);
            }
            if (filters == null) {
                ErrorVisiblePack.$$$reportNull$$$0(1);
            }
            if (error == null) {
                ErrorVisiblePack.$$$reportNull$$$0(2);
            }
            super(dataPack, EmptyVisibleGraph.getInstance(), false, filters);
            this.myError = error;
        }

        @NotNull
        public Throwable getError() {
            Throwable throwable = this.myError;
            if (throwable == null) {
                ErrorVisiblePack.$$$reportNull$$$0(3);
            }
            return throwable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataPack";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filters";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "error";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/visible/VisiblePack$ErrorVisiblePack";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/visible/VisiblePack$ErrorVisiblePack";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getError";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

