/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.packaging;

import com.intellij.CommonBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.ide.ActivityTracker;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.DumbAwareActionButton;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.CatchingConsumer;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.webcore.packaging.InstalledPackage;
import com.intellij.webcore.packaging.ManagePackagesDialog;
import com.intellij.webcore.packaging.PackageManagementService;
import com.intellij.webcore.packaging.PackageManagementServiceEx;
import com.intellij.webcore.packaging.PackageManagementUsageCollector;
import com.intellij.webcore.packaging.PackageVersionComparator;
import com.intellij.webcore.packaging.PackagesNotificationPanel;
import com.intellij.webcore.packaging.RepoPackage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstalledPackagesPanel
extends JPanel {
    private static final Logger LOG = Logger.getInstance(InstalledPackagesPanel.class);
    private final AnActionButton myUpgradeButton;
    protected final AnActionButton myInstallButton;
    private final AnActionButton myUninstallButton;
    protected final JBTable myPackagesTable;
    private final DefaultTableModel myPackagesTableModel;
    protected volatile PackageManagementService myPackageManagementService;
    protected final Project myProject;
    protected final PackagesNotificationPanel myNotificationArea;
    private final Set<String> myCurrentlyInstalling;
    private final Map<InstalledPackage, String> myWaitingToUpgrade;

    public InstalledPackagesPanel(@NotNull Project project, @NotNull PackagesNotificationPanel area) {
        if (project == null) {
            InstalledPackagesPanel.$$$reportNull$$$0(0);
        }
        if (area == null) {
            InstalledPackagesPanel.$$$reportNull$$$0(1);
        }
        super(new BorderLayout());
        this.myCurrentlyInstalling = new HashSet<String>();
        this.myWaitingToUpgrade = new HashMap<InstalledPackage, String>();
        this.myProject = project;
        this.myNotificationArea = area;
        Object[] names2 = new String[]{IdeBundle.message((String)"packages.settings.package", (Object[])new Object[0]), IdeBundle.message((String)"packages.settings.version", (Object[])new Object[0]), IdeBundle.message((String)"packages.settings.latest.version", (Object[])new Object[0])};
        this.myPackagesTableModel = new DefaultTableModel(names2, 0){

            @Override
            public boolean isCellEditable(int i2, int i1) {
                return false;
            }
        };
        final MyTableCellRenderer tableCellRenderer = new MyTableCellRenderer();
        this.myPackagesTable = new JBTable(this.myPackagesTableModel){

            public TableCellRenderer getCellRenderer(int row2, int column2) {
                return tableCellRenderer;
            }
        };
        this.myPackagesTable.setShowGrid(false);
        this.myPackagesTable.getTableHeader().setReorderingAllowed(false);
        new TableSpeedSearch((JTable)this.myPackagesTable);
        this.myUpgradeButton = new DumbAwareActionButton(IdeBundle.messagePointer((String)"action.AnActionButton.text.upgrade", (Object[])new Object[0]), IconUtil.getMoveUpIcon()){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                PackageManagementUsageCollector.triggerUpgradePerformed(InstalledPackagesPanel.this.myProject, InstalledPackagesPanel.this.myPackageManagementService);
                InstalledPackagesPanel.this.upgradeAction();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/webcore/packaging/InstalledPackagesPanel$3", "actionPerformed"));
            }
        };
        this.myInstallButton = new DumbAwareActionButton(IdeBundle.messagePointer((String)"action.AnActionButton.text.install", (Object[])new Object[0]), IconUtil.getAddIcon()){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                PackageManagementUsageCollector.triggerBrowseAvailablePackagesPerformed(InstalledPackagesPanel.this.myProject, InstalledPackagesPanel.this.myPackageManagementService);
                if (InstalledPackagesPanel.this.myPackageManagementService != null) {
                    ManagePackagesDialog dialog2 = InstalledPackagesPanel.this.createManagePackagesDialog();
                    dialog2.show();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/webcore/packaging/InstalledPackagesPanel$4", "actionPerformed"));
            }
        };
        this.myInstallButton.setShortcut(CommonShortcuts.getNew());
        this.myUninstallButton = new DumbAwareActionButton(IdeBundle.messagePointer((String)"action.AnActionButton.text.uninstall", (Object[])new Object[0]), IconUtil.getRemoveIcon()){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                PackageManagementUsageCollector.triggerUninstallPerformed(InstalledPackagesPanel.this.myProject, InstalledPackagesPanel.this.myPackageManagementService);
                InstalledPackagesPanel.this.uninstallAction();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/webcore/packaging/InstalledPackagesPanel$5", "actionPerformed"));
            }
        };
        this.myUninstallButton.setShortcut(CommonShortcuts.getDelete());
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTable)this.myPackagesTable).disableUpDownActions().disableAddAction().disableRemoveAction().addExtraAction(this.myInstallButton).addExtraAction(this.myUninstallButton).addExtraAction(this.myUpgradeButton);
        decorator.addExtraActions(this.getExtraActions());
        this.add(decorator.createPanel());
        this.myInstallButton.setEnabled(false);
        this.myUninstallButton.setEnabled(false);
        this.myUpgradeButton.setEnabled(false);
        this.myPackagesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                InstalledPackagesPanel.this.updateUninstallUpgrade();
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                if (e == null) {
                    7.$$$reportNull$$$0(0);
                }
                if (InstalledPackagesPanel.this.myPackageManagementService != null && InstalledPackagesPanel.this.myInstallButton.isEnabled()) {
                    Object pkg;
                    ManagePackagesDialog dialog2 = InstalledPackagesPanel.this.createManagePackagesDialog();
                    Point p = e.getPoint();
                    int row2 = InstalledPackagesPanel.this.myPackagesTable.rowAtPoint(p);
                    int column2 = InstalledPackagesPanel.this.myPackagesTable.columnAtPoint(p);
                    if (row2 >= 0 && column2 >= 0 && (pkg = InstalledPackagesPanel.this.myPackagesTable.getValueAt(row2, 0)) instanceof InstalledPackage) {
                        dialog2.selectPackage((InstalledPackage)pkg);
                    }
                    dialog2.show();
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/webcore/packaging/InstalledPackagesPanel$7", "onDoubleClick"));
            }
        }.installOn((Component)this.myPackagesTable);
    }

    protected AnActionButton[] getExtraActions() {
        return new AnActionButton[0];
    }

    @NotNull
    protected ManagePackagesDialog createManagePackagesDialog() {
        return new ManagePackagesDialog(this.myProject, this.myPackageManagementService, new PackageManagementService.Listener(){

            public void operationStarted(String packageName) {
                InstalledPackagesPanel.this.myNotificationArea.hide();
                InstalledPackagesPanel.this.myPackagesTable.setPaintBusy(true);
            }

            public void operationFinished(String packageName, @Nullable PackageManagementService.ErrorDescription errorDescription) {
                InstalledPackagesPanel.this.myNotificationArea.showResult(packageName, errorDescription);
                InstalledPackagesPanel.this.myPackagesTable.clearSelection();
                InstalledPackagesPanel.this.doUpdatePackages(InstalledPackagesPanel.this.myPackageManagementService);
            }
        }, this.createNotificationPanel());
    }

    @NotNull
    protected PackagesNotificationPanel createNotificationPanel() {
        return new PackagesNotificationPanel();
    }

    private void upgradeAction() {
        int[] rows = this.myPackagesTable.getSelectedRows();
        if (this.myPackageManagementService != null) {
            HashSet<String> upgradedPackages = new HashSet<String>();
            Set<String> packagesShouldBePostponed = this.getPackagesToPostpone();
            for (int row2 : rows) {
                Object packageObj = this.myPackagesTableModel.getValueAt(row2, 0);
                if (!(packageObj instanceof InstalledPackage)) continue;
                InstalledPackage pkg = (InstalledPackage)packageObj;
                String packageName = pkg.getName();
                String currentVersion = pkg.getVersion();
                String availableVersion = (String)this.myPackagesTableModel.getValueAt(row2, 2);
                if (packagesShouldBePostponed.contains(packageName)) {
                    this.myWaitingToUpgrade.put(pkg, availableVersion);
                    continue;
                }
                if (!this.isUpdateAvailable(currentVersion, availableVersion)) continue;
                this.upgradePackage(pkg, availableVersion);
                upgradedPackages.add(packageName);
            }
            if (this.myCurrentlyInstalling.isEmpty() && upgradedPackages.isEmpty() && !this.myWaitingToUpgrade.isEmpty()) {
                this.upgradePostponedPackages();
            }
        }
    }

    private void upgradePostponedPackages() {
        Iterator<Map.Entry<InstalledPackage, String>> iterator2 = this.myWaitingToUpgrade.entrySet().iterator();
        Map.Entry<InstalledPackage, String> toUpgrade = iterator2.next();
        iterator2.remove();
        this.upgradePackage(toUpgrade.getKey(), toUpgrade.getValue());
    }

    protected Set<String> getPackagesToPostpone() {
        return Collections.emptySet();
    }

    private void upgradePackage(final @NotNull InstalledPackage pkg, final @Nullable String toVersion) {
        if (pkg == null) {
            InstalledPackagesPanel.$$$reportNull$$$0(2);
        }
        final PackageManagementService selPackageManagementService = this.myPackageManagementService;
        this.myPackageManagementService.fetchPackageVersions(pkg.getName(), (CatchingConsumer)new CatchingConsumer<List<String>, Exception>(){

            public void consume(List<String> releases) {
                if (!releases.isEmpty() && !InstalledPackagesPanel.this.isUpdateAvailable(pkg.getVersion(), releases.get(0))) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    final ModalityState modalityState = ModalityState.current();
                    PackageManagementService.Listener listener2 = new PackageManagementService.Listener(){

                        public void operationStarted(String packageName) {
                            ApplicationManager.getApplication().invokeLater(() -> {
                                InstalledPackagesPanel.this.myPackagesTable.setPaintBusy(true);
                                InstalledPackagesPanel.this.myCurrentlyInstalling.add(packageName);
                            }, modalityState);
                        }

                        public void operationFinished(String packageName, @Nullable PackageManagementService.ErrorDescription errorDescription) {
                            ApplicationManager.getApplication().invokeLater(() -> {
                                InstalledPackagesPanel.this.myPackagesTable.clearSelection();
                                InstalledPackagesPanel.this.updatePackages(selPackageManagementService);
                                InstalledPackagesPanel.this.myCurrentlyInstalling.remove(packageName);
                                InstalledPackagesPanel.this.myPackagesTable.setPaintBusy(!InstalledPackagesPanel.this.myCurrentlyInstalling.isEmpty());
                                if (errorDescription == null) {
                                    InstalledPackagesPanel.this.myNotificationArea.showSuccess(IdeBundle.message((String)"package.successfully.upgraded", (Object[])new Object[]{packageName}));
                                } else {
                                    InstalledPackagesPanel.this.myNotificationArea.showError(IdeBundle.message((String)"upgrade.packages.failed", (Object[])new Object[0]), IdeBundle.message((String)"upgrade.packages.failed.dialog.title", (Object[])new Object[0]), errorDescription);
                                }
                                if (InstalledPackagesPanel.this.myCurrentlyInstalling.isEmpty() && !InstalledPackagesPanel.this.myWaitingToUpgrade.isEmpty()) {
                                    InstalledPackagesPanel.this.upgradePostponedPackages();
                                }
                            }, modalityState);
                        }
                    };
                    PackageManagementServiceEx serviceEx = InstalledPackagesPanel.this.getServiceEx();
                    if (serviceEx != null) {
                        serviceEx.updatePackage(pkg, toVersion, listener2);
                    } else {
                        InstalledPackagesPanel.this.myPackageManagementService.installPackage(new RepoPackage(pkg.getName(), null), null, true, null, listener2, false);
                    }
                    InstalledPackagesPanel.this.myUpgradeButton.setEnabled(false);
                }, ModalityState.any());
            }

            public void consume(Exception e) {
                ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((String)IdeBundle.message((String)"error.occurred.please.check.your.internet.connection", (Object[])new Object[0]), (String)IdeBundle.message((String)"upgrade.package.failed.title", (Object[])new Object[0])), ModalityState.any());
            }
        });
    }

    @Nullable
    private PackageManagementServiceEx getServiceEx() {
        return (PackageManagementServiceEx)((Object)ObjectUtils.tryCast((Object)this.myPackageManagementService, PackageManagementServiceEx.class));
    }

    protected void updateUninstallUpgrade() {
        int[] selected2 = this.myPackagesTable.getSelectedRows();
        boolean upgradeAvailable = false;
        boolean canUninstall = selected2.length != 0;
        boolean canInstall = this.installEnabled();
        boolean canUpgrade = true;
        if (this.myPackageManagementService != null && selected2.length != 0) {
            for (int i2 = 0; i2 != selected2.length; ++i2) {
                Object value2;
                int index2 = selected2[i2];
                if (index2 >= this.myPackagesTable.getRowCount() || !((value2 = this.myPackagesTable.getValueAt(index2, 0)) instanceof InstalledPackage)) continue;
                InstalledPackage pkg = (InstalledPackage)value2;
                if (!this.canUninstallPackage(pkg)) {
                    canUninstall = false;
                }
                canInstall = this.canInstallPackage(pkg);
                if (!this.canUpgradePackage(pkg)) {
                    canUpgrade = false;
                }
                String pyPackageName = pkg.getName();
                String availableVersion = (String)this.myPackagesTable.getValueAt(index2, 2);
                if (!upgradeAvailable) {
                    boolean bl = upgradeAvailable = this.isUpdateAvailable(pkg.getVersion(), availableVersion) && !this.myCurrentlyInstalling.contains(pyPackageName);
                }
                if (!canUninstall && !canUpgrade) break;
            }
        }
        this.myUninstallButton.setEnabled(canUninstall);
        this.myInstallButton.setEnabled(canInstall);
        this.myUpgradeButton.setEnabled(upgradeAvailable && canUpgrade);
    }

    protected boolean canUninstallPackage(InstalledPackage pyPackage) {
        return true;
    }

    protected boolean canInstallPackage(@NotNull InstalledPackage pyPackage) {
        if (pyPackage == null) {
            InstalledPackagesPanel.$$$reportNull$$$0(3);
        }
        return true;
    }

    protected boolean installEnabled() {
        return true;
    }

    protected boolean canUpgradePackage(InstalledPackage pyPackage) {
        return true;
    }

    private void uninstallAction() {
        List<InstalledPackage> packages = this.getSelectedPackages();
        final PackageManagementService selPackageManagementService = this.myPackageManagementService;
        if (selPackageManagementService != null) {
            final ModalityState modalityState = ModalityState.current();
            PackageManagementService.Listener listener2 = new PackageManagementService.Listener(){

                public void operationStarted(String packageName) {
                    ApplicationManager.getApplication().invokeLater(() -> InstalledPackagesPanel.this.myPackagesTable.setPaintBusy(true), modalityState);
                }

                public void operationFinished(String packageName, @Nullable PackageManagementService.ErrorDescription errorDescription) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        InstalledPackagesPanel.this.myPackagesTable.clearSelection();
                        InstalledPackagesPanel.this.updatePackages(selPackageManagementService);
                        InstalledPackagesPanel.this.myPackagesTable.setPaintBusy(!InstalledPackagesPanel.this.myCurrentlyInstalling.isEmpty());
                        if (errorDescription == null) {
                            if (packageName != null) {
                                InstalledPackagesPanel.this.myNotificationArea.showSuccess(IdeBundle.message((String)"package.successfully.uninstalled", (Object[])new Object[]{packageName}));
                            } else {
                                InstalledPackagesPanel.this.myNotificationArea.showSuccess(IdeBundle.message((String)"packages.successfully.uninstalled", (Object[])new Object[0]));
                            }
                        } else {
                            InstalledPackagesPanel.this.myNotificationArea.showError(IdeBundle.message((String)"uninstall.packages.failed", (Object[])new Object[0]), IdeBundle.message((String)"uninstall.packages.failed.dialog.title", (Object[])new Object[0]), errorDescription);
                        }
                    }, modalityState);
                }
            };
            this.myPackageManagementService.uninstallPackages(packages, listener2);
        }
    }

    @NotNull
    private List<InstalledPackage> getSelectedPackages() {
        int[] rows;
        ArrayList<InstalledPackage> results = new ArrayList<InstalledPackage>();
        for (int row2 : rows = this.myPackagesTable.getSelectedRows()) {
            Object packageName = this.myPackagesTableModel.getValueAt(row2, 0);
            if (!(packageName instanceof InstalledPackage)) continue;
            results.add((InstalledPackage)packageName);
        }
        ArrayList<InstalledPackage> arrayList = results;
        if (arrayList == null) {
            InstalledPackagesPanel.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    public void updatePackages(@Nullable PackageManagementService packageManagementService) {
        this.myPackageManagementService = packageManagementService;
        this.myPackagesTable.clearSelection();
        this.myPackagesTableModel.getDataVector().clear();
        this.myPackagesTableModel.fireTableDataChanged();
        if (packageManagementService != null) {
            this.doUpdatePackages(packageManagementService);
        }
    }

    private void onUpdateStarted() {
        this.myPackagesTable.setPaintBusy(true);
        this.myPackagesTable.getEmptyText().setText(CommonBundle.getLoadingTreeNodeText());
    }

    private void onUpdateFinished() {
        this.myPackagesTable.setPaintBusy(!this.myCurrentlyInstalling.isEmpty());
        this.myPackagesTable.getEmptyText().setText(StatusText.getDefaultEmptyText());
        this.updateUninstallUpgrade();
        ActivityTracker.getInstance().inc();
    }

    public void doUpdatePackages(final @NotNull PackageManagementService packageManagementService) {
        if (packageManagementService == null) {
            InstalledPackagesPanel.$$$reportNull$$$0(5);
        }
        this.onUpdateStarted();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, IdeBundle.message((String)"packages.settings.loading", (Object[])new Object[0]), true, PerformInBackgroundOption.ALWAYS_BACKGROUND){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator2) {
                if (indicator2 == null) {
                    11.$$$reportNull$$$0(0);
                }
                List packages = List.of();
                try {
                    packages = packageManagementService.getInstalledPackagesList();
                }
                catch (ExecutionException e) {
                    LOG.warn(e.getMessage());
                }
                finally {
                    Map<String, RepoPackage> cache2 = InstalledPackagesPanel.this.buildNameToPackageMap(packageManagementService.getAllPackagesCached());
                    boolean shouldFetchLatestVersionsForOnlyInstalledPackages = InstalledPackagesPanel.this.shouldFetchLatestVersionsForOnlyInstalledPackages();
                    if (cache2.isEmpty() && !shouldFetchLatestVersionsForOnlyInstalledPackages) {
                        InstalledPackagesPanel.this.refreshLatestVersions(packageManagementService);
                    }
                    List rows = ContainerUtil.map((Collection)packages, pkg -> new Object[]{pkg, pkg.getVersion(), InstalledPackagesPanel.getVersionString((RepoPackage)cache2.get(pkg.getName()))});
                    UIUtil.invokeLaterIfNeeded(() -> {
                        if (packageManagementService == InstalledPackagesPanel.this.myPackageManagementService) {
                            InstalledPackagesPanel.this.myPackagesTableModel.getDataVector().clear();
                            for (Object[] row2 : rows) {
                                InstalledPackagesPanel.this.myPackagesTableModel.addRow(row2);
                            }
                            if (!cache2.isEmpty()) {
                                InstalledPackagesPanel.this.onUpdateFinished();
                            }
                            if (shouldFetchLatestVersionsForOnlyInstalledPackages) {
                                InstalledPackagesPanel.this.setLatestVersionsForInstalledPackages();
                            }
                        }
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/webcore/packaging/InstalledPackagesPanel$11", "run"));
            }
        });
    }

    private InstalledPackage getInstalledPackageAt(int index2) {
        return (InstalledPackage)this.myPackagesTableModel.getValueAt(index2, 0);
    }

    private void setLatestVersionsForInstalledPackages() {
        PackageManagementServiceEx serviceEx = this.getServiceEx();
        if (serviceEx == null) {
            return;
        }
        int packageCount = this.myPackagesTableModel.getRowCount();
        if (packageCount == 0) {
            this.onUpdateFinished();
        }
        final AtomicInteger inProgressPackageCount = new AtomicInteger(packageCount);
        int i2 = 0;
        while (i2 < packageCount) {
            final int finalIndex = i2++;
            final InstalledPackage pkg = this.getInstalledPackageAt(finalIndex);
            serviceEx.fetchLatestVersion(pkg, new CatchingConsumer<String, Exception>(){

                private void decrement() {
                    if (inProgressPackageCount.decrementAndGet() == 0) {
                        InstalledPackagesPanel.this.onUpdateFinished();
                    }
                }

                public void consume(Exception e) {
                    UIUtil.invokeLaterIfNeeded(() -> this.decrement());
                    LOG.warn("Cannot fetch the latest version of the installed package " + pkg, (Throwable)e);
                }

                public void consume(@Nullable String latestVersion) {
                    UIUtil.invokeLaterIfNeeded(() -> {
                        InstalledPackage p;
                        if (finalIndex < InstalledPackagesPanel.this.myPackagesTableModel.getRowCount() && pkg == (p = InstalledPackagesPanel.this.getInstalledPackageAt(finalIndex))) {
                            InstalledPackagesPanel.this.myPackagesTableModel.setValueAt(latestVersion, finalIndex, 2);
                        }
                        this.decrement();
                    });
                }
            });
        }
    }

    private boolean shouldFetchLatestVersionsForOnlyInstalledPackages() {
        PackageManagementServiceEx serviceEx = this.getServiceEx();
        if (serviceEx != null) {
            return serviceEx.shouldFetchLatestVersionsForOnlyInstalledPackages();
        }
        return false;
    }

    private boolean isUpdateAvailable(@Nullable String currentVersion, @Nullable String availableVersion) {
        if (availableVersion == null) {
            return false;
        }
        if (currentVersion == null) {
            return true;
        }
        PackageManagementService service = this.myPackageManagementService;
        if (service != null) {
            return service.compareVersions(currentVersion, availableVersion) < 0;
        }
        return PackageVersionComparator.VERSION_COMPARATOR.compare(currentVersion, availableVersion) < 0;
    }

    private void refreshLatestVersions(@NotNull PackageManagementService packageManagementService) {
        if (packageManagementService == null) {
            InstalledPackagesPanel.$$$reportNull$$$0(6);
        }
        Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(() -> {
            if (packageManagementService == this.myPackageManagementService) {
                try {
                    List packages = packageManagementService.reloadAllPackages();
                    Map<String, RepoPackage> packageMap = this.buildNameToPackageMap(packages);
                    application.invokeLater(() -> {
                        for (int i2 = 0; i2 != this.myPackagesTableModel.getRowCount(); ++i2) {
                            InstalledPackage pyPackage = (InstalledPackage)this.myPackagesTableModel.getValueAt(i2, 0);
                            RepoPackage repoPackage = (RepoPackage)packageMap.get(pyPackage.getName());
                            this.myPackagesTableModel.setValueAt(repoPackage == null ? null : repoPackage.getLatestVersion(), i2, 2);
                        }
                        this.myPackagesTable.setPaintBusy(!this.myCurrentlyInstalling.isEmpty());
                    }, ModalityState.stateForComponent((Component)this.myPackagesTable));
                }
                catch (IOException ignored) {
                    LOG.warn("Cannot refresh the list of available packages with their latest versions", (Throwable)ignored);
                    this.myPackagesTable.setPaintBusy(false);
                }
            }
        });
    }

    private Map<String, RepoPackage> buildNameToPackageMap(List<? extends RepoPackage> packages) {
        try {
            return InstalledPackagesPanel.doBuildNameToPackageMap(packages);
        }
        catch (Exception e) {
            PackageManagementService service = this.myPackageManagementService;
            LOG.error("Failure in " + this.getClass().getName() + ", service: " + (service != null ? service.getClass().getName() : null), (Throwable)e);
            return Collections.emptyMap();
        }
    }

    private static Map<String, RepoPackage> doBuildNameToPackageMap(List<? extends RepoPackage> packages) {
        HashMap<String, RepoPackage> packageMap = new HashMap<String, RepoPackage>();
        for (RepoPackage repoPackage : packages) {
            packageMap.put(repoPackage.getName(), repoPackage);
        }
        return packageMap;
    }

    @NotNull
    private static String getVersionString(@Nullable RepoPackage repoPackage) {
        String version2 = repoPackage != null ? repoPackage.getLatestVersion() : null;
        return version2 != null ? version2 : "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "area";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyPackage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webcore/packaging/InstalledPackagesPanel";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageManagementService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webcore/packaging/InstalledPackagesPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedPackages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "upgradePackage";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canInstallPackage";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doUpdatePackages";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "refreshLatestVersions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyTableCellRenderer
    extends DefaultTableCellRenderer {
        private MyTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row2, int column2) {
            JLabel cell2 = (JLabel)super.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row2, column2);
            String version2 = (String)table.getValueAt(row2, 1);
            String availableVersion = (String)table.getValueAt(row2, 2);
            boolean update2 = column2 == 2 && StringUtil.isNotEmpty((String)availableVersion) && InstalledPackagesPanel.this.isUpdateAvailable(version2, availableVersion);
            cell2.setIcon(update2 ? IconUtil.getMoveUpIcon() : null);
            Object pyPackage = table.getValueAt(row2, 0);
            if (pyPackage instanceof InstalledPackage) {
                cell2.setToolTipText(((InstalledPackage)pyPackage).getTooltipText());
            }
            return cell2;
        }
    }
}

