/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl;

import com.google.common.base.Stopwatch;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.SingleAlarm;
import com.intellij.util.io.PathKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.workspaceModel.ide.VirtualFileUrlManagerUtil;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.ide.WorkspaceModelCache;
import com.intellij.workspaceModel.ide.WorkspaceModelCacheVersion;
import com.intellij.workspaceModel.ide.WorkspaceModelChangeListener;
import com.intellij.workspaceModel.ide.WorkspaceModelTopics;
import com.intellij.workspaceModel.ide.impl.WorkspaceModelCacheImpl;
import com.intellij.workspaceModel.storage.EntityStorageSerializer;
import com.intellij.workspaceModel.storage.EntityTypesResolver;
import com.intellij.workspaceModel.storage.SerializationResult;
import com.intellij.workspaceModel.storage.VersionedStorageChange;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageBuilder;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleEntity;
import com.intellij.workspaceModel.storage.impl.EntityStorageSerializerImpl;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityStorageImplKt;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlManager;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\b\u0007\u0018\u0000 '2\u00020\u00012\u00020\u0002:\u0002'(B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020 H\u0002J\b\u0010\"\u001a\u00020\u0007H\u0002J\b\u0010#\u001a\u00020 H\u0002J\n\u0010$\u001a\u0004\u0018\u00010\u001dH\u0016J\u0010\u0010%\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002J\b\u0010&\u001a\u00020 H\u0016R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR#\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u000b\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/workspaceModel/ide/impl/WorkspaceModelCacheImpl;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/workspaceModel/ide/WorkspaceModelCache;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cacheFile", "Ljava/nio/file/Path;", "getCacheFile", "()Ljava/nio/file/Path;", "cacheFile$delegate", "Lkotlin/Lazy;", "enabled", "", "getEnabled", "()Z", "invalidateProjectCacheMarkerFile", "Ljava/io/File;", "kotlin.jvm.PlatformType", "getInvalidateProjectCacheMarkerFile", "()Ljava/io/File;", "invalidateProjectCacheMarkerFile$delegate", "saveAlarm", "Lcom/intellij/util/SingleAlarm;", "serializer", "Lcom/intellij/workspaceModel/storage/EntityStorageSerializer;", "virtualFileManager", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrlManager;", "cachePreProcess", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;", "storage", "dispose", "", "doCacheSaving", "initCacheFile", "invalidateProjectCache", "loadCache", "saveCache", "saveCacheNow", "Companion", "PluginAwareEntityTypesResolver", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class WorkspaceModelCacheImpl
implements Disposable,
WorkspaceModelCache {
    private final boolean enabled;
    private final Lazy cacheFile$delegate;
    private final Lazy invalidateProjectCacheMarkerFile$delegate;
    private final VirtualFileUrlManager virtualFileManager;
    private final EntityStorageSerializer serializer;
    private final SingleAlarm saveAlarm;
    private final Project project;
    private static final Logger LOG;
    @NotNull
    public static final String DATA_DIR_NAME = "project-model-cache";
    private static boolean forceEnableCaching;
    @TestOnly
    @Nullable
    private static File testCacheFile;
    private static final AtomicBoolean cachesInvalidated;
    @NotNull
    private static final File invalidateCachesMarkerFile;
    private static final ExtensionPointName<WorkspaceModelCacheVersion> WORKSPACE_MODEL_CACHE_VERSION_EP;
    @NotNull
    public static final Companion Companion;

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    private final Path getCacheFile() {
        Lazy lazy = this.cacheFile$delegate;
        WorkspaceModelCacheImpl workspaceModelCacheImpl = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Path)lazy.getValue();
    }

    private final File getInvalidateProjectCacheMarkerFile() {
        Lazy lazy = this.invalidateProjectCacheMarkerFile$delegate;
        WorkspaceModelCacheImpl workspaceModelCacheImpl = this;
        Object var3_3 = null;
        boolean bl = false;
        return (File)lazy.getValue();
    }

    private final Path initCacheFile() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode() && testCacheFile != null) {
            Path testFile;
            File file2 = testCacheFile;
            Intrinsics.checkNotNull((Object)file2);
            Path path2 = testFile = file2.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"testFile");
            if (!PathKt.exists((Path)path2)) {
                String string = "Test cache file defined, but doesn't exist";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return testFile;
        }
        Path path3 = ProjectUtil.getProjectDataPath((Project)this.project, (String)DATA_DIR_NAME).resolve("cache.data");
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"project.getProjectDataPa\u2026ME).resolve(\"cache.data\")");
        return path3;
    }

    @Override
    public void saveCacheNow() {
        this.saveAlarm.cancel();
        this.doCacheSaving();
    }

    private final void doCacheSaving() {
        WorkspaceEntityStorage storage2 = WorkspaceModel.Companion.getInstance(this.project).getEntityStorage().getCurrent();
        if (!WorkspaceEntityStorageImplKt.isConsistent(storage2)) {
            this.invalidateProjectCache();
        }
        if (!cachesInvalidated.get()) {
            LOG.debug("Saving project model cache to " + this.getCacheFile());
            WorkspaceEntityStorage processedStorage = this.cachePreProcess(storage2);
            this.saveCache(processedStorage);
        }
        if (cachesInvalidated.get()) {
            FileUtil.delete((Path)this.getCacheFile());
        }
    }

    private final WorkspaceEntityStorage cachePreProcess(WorkspaceEntityStorage storage2) {
        WorkspaceEntityStorageBuilder builder2 = WorkspaceEntityStorageBuilder.Companion.from(storage2);
        List nonPersistentModules2 = SequencesKt.toList((Sequence)SequencesKt.filter(builder2.entities(ModuleEntity.class), (Function1)cachePreProcess.nonPersistentModules.1.INSTANCE));
        Iterable $this$forEach$iv = nonPersistentModules2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModuleEntity it = (ModuleEntity)element$iv;
            boolean bl = false;
            builder2.removeEntity(it);
        }
        return builder2.toStorage();
    }

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public WorkspaceEntityStorage loadCache() {
        try {
            WorkspaceEntityStorageBuilder workspaceEntityStorageBuilder;
            if (!PathKt.exists((Path)this.getCacheFile())) {
                return null;
            }
            if (invalidateCachesMarkerFile.exists() && PathKt.lastModified((Path)this.getCacheFile()).toMillis() < invalidateCachesMarkerFile.lastModified() || this.getInvalidateProjectCacheMarkerFile().exists() && PathKt.lastModified((Path)this.getCacheFile()).toMillis() < this.getInvalidateProjectCacheMarkerFile().lastModified()) {
                LOG.info("Skipping project model cache since '" + invalidateCachesMarkerFile + "' is present and newer than cache file '" + this.getCacheFile() + '\'');
                FileUtil.delete((Path)this.getCacheFile());
                return null;
            }
            LOG.debug("Loading project model cache from " + this.getCacheFile());
            Stopwatch stopWatch = Stopwatch.createStarted();
            Closeable closeable = PathKt.inputStream((Path)this.getCacheFile());
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl3 = false;
                workspaceEntityStorageBuilder = this.serializer.deserializeCache(it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            WorkspaceEntityStorageBuilder builder2 = workspaceEntityStorageBuilder;
            LOG.debug("Loaded project model cache from " + this.getCacheFile() + " in " + stopWatch.stop());
            return builder2;
        }
        catch (Throwable t) {
            LOG.warn("Could not deserialize project model cache from " + this.getCacheFile(), t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveCache(WorkspaceEntityStorage storage2) {
        File file2 = FileUtil.createTempFile((File)this.getCacheFile().getParent().toFile(), (String)"cache", (String)".tmp");
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"FileUtil.createTempFile(\u2026oFile(), \"cache\", \".tmp\")");
        File tmpFile = file2;
        try {
            SerializationResult serializationResult;
            Object object = tmpFile;
            boolean bl = false;
            object = new FileOutputStream((File)object);
            bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                FileOutputStream it = (FileOutputStream)object;
                boolean bl3 = false;
                serializationResult = this.serializer.serializeCache(it, storage2);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            SerializationResult serializationResult2 = serializationResult;
            if (serializationResult2 instanceof SerializationResult.Fail) {
                LOG.warn("Workspace model cache was not serialized: " + ((SerializationResult.Fail)serializationResult2).getInfo());
            }
            try {
                Files.move(tmpFile.toPath(), this.getCacheFile(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (AtomicMoveNotSupportedException e) {
                LOG.warn((Throwable)e);
                Files.move(tmpFile.toPath(), this.getCacheFile(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        finally {
            tmpFile.delete();
        }
    }

    private final void invalidateProjectCache() {
        LOG.info("Invalidating project model cache by creating " + this.getInvalidateProjectCacheMarkerFile());
        cachesInvalidated.set(true);
        try {
            FileUtil.createParentDirs((File)this.getInvalidateProjectCacheMarkerFile());
            FileUtil.writeToFile((File)this.getInvalidateProjectCacheMarkerFile(), (String)String.valueOf(System.currentTimeMillis()));
        }
        catch (Throwable t) {
            LOG.warn("Cannot update the project invalidation marker file", t);
        }
    }

    public WorkspaceModelCacheImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        this.enabled = !application.isUnitTestMode() && Registry.is((String)"ide.new.project.model.cache") || forceEnableCaching;
        this.cacheFile$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Path>(this){
            final /* synthetic */ WorkspaceModelCacheImpl this$0;

            @NotNull
            public final Path invoke() {
                return WorkspaceModelCacheImpl.access$initCacheFile(this.this$0);
            }
            {
                this.this$0 = workspaceModelCacheImpl;
                super(0);
            }
        }));
        this.invalidateProjectCacheMarkerFile$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ WorkspaceModelCacheImpl this$0;

            public final File invoke() {
                return ProjectUtil.getProjectDataPath((Project)WorkspaceModelCacheImpl.access$getProject$p(this.this$0), (String)"project-model-cache").resolve(".invalidate").toFile();
            }
            {
                this.this$0 = workspaceModelCacheImpl;
                super(0);
            }
        }));
        this.virtualFileManager = VirtualFileUrlManagerUtil.getInstance(VirtualFileUrlManager.Companion, this.project);
        this.serializer = new EntityStorageSerializerImpl(PluginAwareEntityTypesResolver.INSTANCE, this.virtualFileManager, (Function0<? extends Map<String, String>>)((Function0)new Function0<Map<String, ? extends String>>(Companion){

            @NotNull
            public final Map<String, String> invoke() {
                return ((Companion)this.receiver).collectExternalCacheVersions();
            }
        }));
        if (this.getEnabled()) {
            LOG.debug("Project Model Cache at " + this.getCacheFile());
            WorkspaceModelTopics workspaceModelTopics = WorkspaceModelTopics.Companion.getInstance(this.project);
            MessageBusConnection messageBusConnection2 = this.project.getMessageBus().connect((Disposable)this);
            Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection2, (String)"project.messageBus.connect(this)");
            workspaceModelTopics.subscribeImmediately(messageBusConnection2, new WorkspaceModelChangeListener(){

                @Override
                public void changed(@NotNull VersionedStorageChange event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    LOG.debug("Schedule cache update");
                    SingleAlarm.request$default((SingleAlarm)saveAlarm, (boolean)false, (int)0, (int)3, null);
                }

                @Override
                public void beforeChanged(@NotNull VersionedStorageChange event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    WorkspaceModelChangeListener.DefaultImpls.beforeChanged(this, event);
                }
            });
        }
        this.saveAlarm = SingleAlarm.Companion.pooledThreadSingleAlarm(1000, (Disposable)this, (Function0)new Function0<Unit>(this){
            final /* synthetic */ WorkspaceModelCacheImpl this$0;

            public final void invoke() {
                WorkspaceModelCacheImpl.access$doCacheSaving(this.this$0);
            }
            {
                this.this$0 = workspaceModelCacheImpl;
                super(0);
            }
        });
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(WorkspaceModelCacheImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
        cachesInvalidated = new AtomicBoolean(false);
        invalidateCachesMarkerFile = new File(ProjectUtil.getProjectsDataDir().toFile(), ".invalidate");
        ExtensionPointName extensionPointName = ExtensionPointName.create((String)"com.intellij.workspaceModel.cache.version");
        Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"ExtensionPointName.creat\u2026paceModel.cache.version\")");
        WORKSPACE_MODEL_CACHE_VERSION_EP = extensionPointName;
    }

    public static final /* synthetic */ Path access$initCacheFile(WorkspaceModelCacheImpl $this) {
        return $this.initCacheFile();
    }

    public static final /* synthetic */ Project access$getProject$p(WorkspaceModelCacheImpl $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$doCacheSaving(WorkspaceModelCacheImpl $this) {
        $this.doCacheSaving();
    }

    public static final /* synthetic */ boolean access$getForceEnableCaching$cp() {
        return forceEnableCaching;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016J\u001e\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\b\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u0004H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/workspaceModel/ide/impl/WorkspaceModelCacheImpl$PluginAwareEntityTypesResolver;", "Lcom/intellij/workspaceModel/storage/EntityTypesResolver;", "()V", "getPluginId", "", "clazz", "Ljava/lang/Class;", "resolveClass", "name", "pluginId", "intellij.platform.ide.impl"})
    public static final class PluginAwareEntityTypesResolver
    implements EntityTypesResolver {
        @NotNull
        public static final PluginAwareEntityTypesResolver INSTANCE;

        @Override
        @Nullable
        public String getPluginId(@NotNull Class<?> clazz) {
            String className;
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            String string = className = clazz.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className");
            if (StringsKt.startsWith$default((String)string, (String)"[", (boolean)false, (int)2, null)) {
                PluginManager pluginManager = PluginManager.getInstance();
                Class<?> clazz2 = clazz.getComponentType();
                Intrinsics.checkNotNullExpressionValue(clazz2, (String)"clazz.componentType");
                PluginId pluginId = pluginManager.getPluginOrPlatformByClassName(clazz2.getName());
                return pluginId != null ? pluginId.getIdString() : null;
            }
            PluginId pluginId = PluginManager.getInstance().getPluginOrPlatformByClassName(className);
            return pluginId != null ? pluginId.getIdString() : null;
        }

        @Override
        @NotNull
        public Class<?> resolveClass(@NotNull String name2, @Nullable String pluginId) {
            ClassLoader classloader;
            ClassLoader classLoader;
            PluginId id2;
            PluginId pluginId2;
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            String string = pluginId;
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                pluginId2 = PluginId.getId((String)it);
            } else {
                pluginId2 = id2 = null;
            }
            if (id2 == null) {
                classLoader = ApplicationManager.class.getClassLoader();
            } else {
                IdeaPluginDescriptor ideaPluginDescriptor = PluginManagerCore.getPlugin(id2);
                if (ideaPluginDescriptor == null) {
                    String string3 = "Could not resolve plugin by id '" + pluginId + "' for type: " + name2;
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string3.toString());
                }
                Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptor, (String)"PluginManagerCore.getPlu\u2026uginId' for type: $name\")");
                IdeaPluginDescriptor plugin2 = ideaPluginDescriptor;
                classLoader = plugin2.getPluginClassLoader();
                if (classLoader == null) {
                    classLoader = classloader = ApplicationManager.class.getClassLoader();
                }
            }
            if (StringsKt.startsWith$default((String)name2, (String)"[", (boolean)false, (int)2, null)) {
                Class<?> clazz = Class.forName(name2, true, classloader);
                Intrinsics.checkNotNullExpressionValue(clazz, (String)"Class.forName(name, true, classloader)");
                return clazz;
            }
            Class<?> clazz = classloader.loadClass(name2);
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"classloader.loadClass(name)");
            return clazz;
        }

        private PluginAwareEntityTypesResolver() {
        }

        static {
            PluginAwareEntityTypesResolver pluginAwareEntityTypesResolver;
            INSTANCE = pluginAwareEntityTypesResolver = new PluginAwareEntityTypesResolver();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0019J\u000e\u0010\u000e\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001aR\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\b\u001a\u0015\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\t\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R \u0010\u0014\u001a\u0004\u0018\u00010\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0013\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001e"}, d2={"Lcom/intellij/workspaceModel/ide/impl/WorkspaceModelCacheImpl$Companion;", "", "()V", "DATA_DIR_NAME", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "WORKSPACE_MODEL_CACHE_VERSION_EP", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/workspaceModel/ide/WorkspaceModelCacheVersion;", "kotlin.jvm.PlatformType", "cachesInvalidated", "Ljava/util/concurrent/atomic/AtomicBoolean;", "forceEnableCaching", "", "invalidateCachesMarkerFile", "Ljava/io/File;", "getInvalidateCachesMarkerFile$intellij_platform_ide_impl", "()Ljava/io/File;", "testCacheFile", "getTestCacheFile", "setTestCacheFile", "(Ljava/io/File;)V", "collectExternalCacheVersions", "", "", "disposable", "Lcom/intellij/openapi/Disposable;", "invalidateCaches", "intellij.platform.ide.impl"})
    public static final class Companion {
        @Nullable
        public final File getTestCacheFile() {
            return testCacheFile;
        }

        public final void setTestCacheFile(@Nullable File file2) {
            testCacheFile = file2;
        }

        @NotNull
        public final File getInvalidateCachesMarkerFile$intellij_platform_ide_impl() {
            return invalidateCachesMarkerFile;
        }

        public final void invalidateCaches() {
            LOG.info("Invalidating caches by creating " + this.getInvalidateCachesMarkerFile$intellij_platform_ide_impl());
            cachesInvalidated.set(true);
            try {
                FileUtil.createParentDirs((File)this.getInvalidateCachesMarkerFile$intellij_platform_ide_impl());
                FileUtil.writeToFile((File)this.getInvalidateCachesMarkerFile$intellij_platform_ide_impl(), (String)String.valueOf(System.currentTimeMillis()));
            }
            catch (Throwable t) {
                LOG.warn("Cannot update the invalidation marker file", t);
            }
        }

        @NotNull
        public final Map<String, String> collectExternalCacheVersions() {
            Function1 function1;
            Stream stream = WORKSPACE_MODEL_CACHE_VERSION_EP.extensions();
            Object object = collectExternalCacheVersions.1.INSTANCE;
            if (object != null) {
                function1 = object;
                object = new Function(function1){
                    private final /* synthetic */ Function1 function;
                    {
                        this.function = function1;
                    }

                    public final /* synthetic */ Object apply(Object p0) {
                        return this.function.invoke(p0);
                    }
                };
            }
            Function function = (Function)object;
            Object object2 = collectExternalCacheVersions.2.INSTANCE;
            if (object2 != null) {
                function1 = object2;
                object2 = new /* invalid duplicate definition of identical inner class */;
            }
            Map<String, String> map2 = stream.collect(Collectors.toMap(function, (Function)object2));
            Intrinsics.checkNotNullExpressionValue(map2, (String)"WORKSPACE_MODEL_CACHE_VE\u2026acheVersion::getVersion))");
            return map2;
        }

        public final void forceEnableCaching(@NotNull Disposable disposable2) {
            Intrinsics.checkNotNullParameter((Object)disposable2, (String)"disposable");
            forceEnableCaching = true;
            Disposer.register((Disposable)disposable2, (Disposable)forceEnableCaching.1.INSTANCE);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

