/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.workspaceModel.storage.EntityReference;
import com.intellij.workspaceModel.storage.EntitySource;
import com.intellij.workspaceModel.storage.ExternalEntityMapping;
import com.intellij.workspaceModel.storage.PersistentEntityId;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageBuilder;
import com.intellij.workspaceModel.storage.WorkspaceEntityWithPersistentId;
import com.intellij.workspaceModel.storage.impl.AbstractRefsTable;
import com.intellij.workspaceModel.storage.impl.ClassToIntConverterKt;
import com.intellij.workspaceModel.storage.impl.ConsistencyCheckerKt;
import com.intellij.workspaceModel.storage.impl.ConsistencyCheckingMode;
import com.intellij.workspaceModel.storage.impl.EntitiesBarrel;
import com.intellij.workspaceModel.storage.impl.EntityFamily;
import com.intellij.workspaceModel.storage.impl.EntityIdKt;
import com.intellij.workspaceModel.storage.impl.EntityReferenceImpl;
import com.intellij.workspaceModel.storage.impl.ErrorReportingKt;
import com.intellij.workspaceModel.storage.impl.StorageIndexes;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityBase;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityData;
import com.intellij.workspaceModel.storage.impl.external.EmptyExternalEntityMapping;
import com.intellij.workspaceModel.storage.impl.external.ExternalEntityMappingImpl;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000 N2\u00020\u0001:\u0001NB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J?\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00042\u0014\u0010!\u001a\u0010\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\n\u0018\u00010\"2\b\u0010$\u001a\u0004\u0018\u00010\u00012\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u0000\u00a2\u0006\u0002\b&J%\u0010'\u001a\b\u0012\u0004\u0012\u0002H)0(\"\b\b\u0000\u0010)*\u00020*2\u0006\u0010+\u001a\u0002H)H\u0016\u00a2\u0006\u0002\u0010,J&\u0010-\u001a\b\u0012\u0004\u0012\u0002H)0.\"\b\b\u0000\u0010)*\u00020*2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H)00H\u0016J \u00101\u001a\u000202\"\b\b\u0000\u0010)*\u00020*2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H)00H\u0016JB\u00103\u001a(\u0012\u0004\u0012\u00020#\u0012\u001e\u0012\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020*00\u0012\n\u0012\b\u0012\u0004\u0012\u00020*0504042\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\n0\"H\u0016J#\u00106\u001a\f\u0012\u0006\b\u0001\u0012\u00020*\u0018\u0001072\n\u00108\u001a\u000609j\u0002`:H\u0000\u00a2\u0006\u0002\b;J!\u0010<\u001a\n\u0012\u0006\b\u0001\u0012\u00020*072\n\u00108\u001a\u000609j\u0002`:H\u0000\u00a2\u0006\u0002\b=J\u001c\u0010>\u001a\b\u0012\u0004\u0012\u0002H@0?\"\u0004\b\u0000\u0010@2\u0006\u0010A\u001a\u00020\u0004H\u0016J\b\u0010B\u001a\u00020CH\u0016JW\u0010D\u001a\b\u0012\u0004\u0012\u0002HE0.\"\b\b\u0000\u0010)*\u00020*\"\b\b\u0001\u0010E*\u00020*2\u0006\u0010+\u001a\u0002H)2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002HE0F2\u0018\u0010G\u001a\u0014\u0012\u0004\u0012\u0002HE\u0012\n\u0012\b\u0012\u0004\u0012\u0002H)0(0HH\u0016\u00a2\u0006\u0002\u0010IJ>\u0010D\u001a\b\u0012\u0004\u0012\u0002HE0.\"\b\b\u0000\u0010)*\u00020J\"\b\b\u0001\u0010E*\u00020*2\f\u00108\u001a\b\u0012\u0004\u0012\u0002H)0K2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002HE00H\u0016J'\u0010L\u001a\u0004\u0018\u0001H)\"\b\b\u0000\u0010)*\u00020J2\f\u00108\u001a\b\u0012\u0004\u0012\u0002H)0KH\u0016\u00a2\u0006\u0002\u0010MR\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0010X\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0013\u001a\u00020\u0014X\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0012\u0010\u0017\u001a\u00020\u0018X\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\f\"\u0004\b\u001d\u0010\u000e\u0082\u0001\u0002OP\u00a8\u0006Q"}, d2={"Lcom/intellij/workspaceModel/storage/impl/AbstractEntityStorage;", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;", "()V", "applyInfo", "", "getApplyInfo$intellij_platform_workspaceModel_storage", "()Ljava/lang/String;", "setApplyInfo$intellij_platform_workspaceModel_storage", "(Ljava/lang/String;)V", "brokenConsistency", "", "getBrokenConsistency$intellij_platform_workspaceModel_storage", "()Z", "setBrokenConsistency$intellij_platform_workspaceModel_storage", "(Z)V", "entitiesByType", "Lcom/intellij/workspaceModel/storage/impl/EntitiesBarrel;", "getEntitiesByType$intellij_platform_workspaceModel_storage", "()Lcom/intellij/workspaceModel/storage/impl/EntitiesBarrel;", "indexes", "Lcom/intellij/workspaceModel/storage/impl/StorageIndexes;", "getIndexes$intellij_platform_workspaceModel_storage", "()Lcom/intellij/workspaceModel/storage/impl/StorageIndexes;", "refs", "Lcom/intellij/workspaceModel/storage/impl/AbstractRefsTable;", "getRefs$intellij_platform_workspaceModel_storage", "()Lcom/intellij/workspaceModel/storage/impl/AbstractRefsTable;", "storageIsAlreadyApplied", "getStorageIsAlreadyApplied$intellij_platform_workspaceModel_storage", "setStorageIsAlreadyApplied$intellij_platform_workspaceModel_storage", "assertConsistencyInStrictMode", "", "message", "sourceFilter", "Lkotlin/Function1;", "Lcom/intellij/workspaceModel/storage/EntitySource;", "left", "right", "assertConsistencyInStrictMode$intellij_platform_workspaceModel_storage", "createReference", "Lcom/intellij/workspaceModel/storage/EntityReference;", "E", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "e", "(Lcom/intellij/workspaceModel/storage/WorkspaceEntity;)Lcom/intellij/workspaceModel/storage/EntityReference;", "entities", "Lkotlin/sequences/Sequence;", "entityClass", "Ljava/lang/Class;", "entitiesAmount", "", "entitiesBySource", "", "", "entityDataById", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityData;", "id", "", "Lcom/intellij/workspaceModel/storage/impl/EntityId;", "entityDataById$intellij_platform_workspaceModel_storage", "entityDataByIdOrDie", "entityDataByIdOrDie$intellij_platform_workspaceModel_storage", "getExternalMapping", "Lcom/intellij/workspaceModel/storage/ExternalEntityMapping;", "T", "identifier", "getVirtualFileUrlIndex", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrlIndex;", "referrers", "R", "Lkotlin/reflect/KClass;", "property", "Lkotlin/reflect/KProperty1;", "(Lcom/intellij/workspaceModel/storage/WorkspaceEntity;Lkotlin/reflect/KClass;Lkotlin/reflect/KProperty1;)Lkotlin/sequences/Sequence;", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityWithPersistentId;", "Lcom/intellij/workspaceModel/storage/PersistentEntityId;", "resolve", "(Lcom/intellij/workspaceModel/storage/PersistentEntityId;)Lcom/intellij/workspaceModel/storage/WorkspaceEntityWithPersistentId;", "Companion", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageImpl;", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageBuilderImpl;", "intellij.platform.workspaceModel.storage"})
public abstract class AbstractEntityStorage
implements WorkspaceEntityStorage {
    private boolean brokenConsistency;
    private boolean storageIsAlreadyApplied;
    @Nullable
    private String applyInfo;
    @NotNull
    private static final Logger LOG;
    private static final ExecutorService consistencyChecker;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public abstract EntitiesBarrel getEntitiesByType$intellij_platform_workspaceModel_storage();

    @NotNull
    public abstract AbstractRefsTable getRefs$intellij_platform_workspaceModel_storage();

    @NotNull
    public abstract StorageIndexes getIndexes$intellij_platform_workspaceModel_storage();

    public final boolean getBrokenConsistency$intellij_platform_workspaceModel_storage() {
        return this.brokenConsistency;
    }

    public final void setBrokenConsistency$intellij_platform_workspaceModel_storage(boolean bl) {
        this.brokenConsistency = bl;
    }

    public final boolean getStorageIsAlreadyApplied$intellij_platform_workspaceModel_storage() {
        return this.storageIsAlreadyApplied;
    }

    public final void setStorageIsAlreadyApplied$intellij_platform_workspaceModel_storage(boolean bl) {
        this.storageIsAlreadyApplied = bl;
    }

    @Nullable
    public final String getApplyInfo$intellij_platform_workspaceModel_storage() {
        return this.applyInfo;
    }

    public final void setApplyInfo$intellij_platform_workspaceModel_storage(@Nullable String string) {
        this.applyInfo = string;
    }

    @Override
    @NotNull
    public <E extends WorkspaceEntity> Sequence<E> entities(@NotNull Class<E> entityClass) {
        Sequence sequence;
        Sequence sequence2;
        Intrinsics.checkNotNullParameter(entityClass, (String)"entityClass");
        EntityFamily<? extends WorkspaceEntity> entityFamily = this.getEntitiesByType$intellij_platform_workspaceModel_storage().get(ClassToIntConverterKt.toClassId(entityClass));
        if (!((entityFamily != null && (entityFamily = entityFamily.all()) != null ? SequencesKt.map(entityFamily, (Function1)((Function1)new Function1<WorkspaceEntityData<? extends WorkspaceEntity>, WorkspaceEntity>(this){
            final /* synthetic */ AbstractEntityStorage this$0;

            @NotNull
            public final WorkspaceEntity invoke(@NotNull WorkspaceEntityData<? extends WorkspaceEntity> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return it.createEntity(this.this$0);
            }
            {
                this.this$0 = abstractEntityStorage;
                super(1);
            }
        })) : (sequence2 = null)) instanceof Sequence)) {
            sequence2 = sequence = null;
        }
        if (sequence2 == null) {
            sequence = SequencesKt.emptySequence();
        }
        return sequence;
    }

    @Override
    public <E extends WorkspaceEntity> int entitiesAmount(@NotNull Class<E> entityClass) {
        Intrinsics.checkNotNullParameter(entityClass, (String)"entityClass");
        EntityFamily<? extends WorkspaceEntity> entityFamily = this.getEntitiesByType$intellij_platform_workspaceModel_storage().get(ClassToIntConverterKt.toClassId(entityClass));
        return entityFamily != null ? entityFamily.size() : 0;
    }

    @Nullable
    public final WorkspaceEntityData<? extends WorkspaceEntity> entityDataById$intellij_platform_workspaceModel_storage(long id2) {
        EntityFamily<? extends WorkspaceEntity> entityFamily = this.getEntitiesByType$intellij_platform_workspaceModel_storage().get(EntityIdKt.getClazz(id2));
        return entityFamily != null ? entityFamily.get(EntityIdKt.getArrayId(id2)) : null;
    }

    @NotNull
    public final WorkspaceEntityData<? extends WorkspaceEntity> entityDataByIdOrDie$intellij_platform_workspaceModel_storage(long id2) {
        EntityFamily<? extends WorkspaceEntity> entityFamily = this.getEntitiesByType$intellij_platform_workspaceModel_storage().get(EntityIdKt.getClazz(id2));
        if (entityFamily == null || (entityFamily = entityFamily.get(EntityIdKt.getArrayId(id2))) == null) {
            String string = "Cannot find an entity by id " + id2;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return entityFamily;
    }

    @Override
    @NotNull
    public <E extends WorkspaceEntity, R extends WorkspaceEntity> Sequence<R> referrers(@NotNull E e, @NotNull KClass<R> entityClass, @NotNull KProperty1<R, ? extends EntityReference<? extends E>> property2) {
        Intrinsics.checkNotNullParameter(e, (String)"e");
        Intrinsics.checkNotNullParameter(entityClass, (String)"entityClass");
        Intrinsics.checkNotNullParameter(property2, (String)"property");
        boolean bl = false;
        throw (Throwable)new NotImplementedError(null, 1, null);
    }

    @Override
    @NotNull
    public <E extends WorkspaceEntityWithPersistentId, R extends WorkspaceEntity> Sequence<R> referrers(@NotNull PersistentEntityId<? extends E> id2, @NotNull Class<R> entityClass) {
        Intrinsics.checkNotNullParameter(id2, (String)"id");
        Intrinsics.checkNotNullParameter(entityClass, (String)"entityClass");
        int classId = ClassToIntConverterKt.toClassId(entityClass);
        return SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.getIndexes$intellij_platform_workspaceModel_storage().getSoftLinks$intellij_platform_workspaceModel_storage().getIdsByEntry$intellij_platform_workspaceModel_storage(id2)), (Function1)((Function1)new Function1<Long, Boolean>(classId){
            final /* synthetic */ int $classId;

            public final boolean invoke(long it) {
                return EntityIdKt.getClazz(it) == this.$classId;
            }
            {
                this.$classId = n;
                super(1);
            }
        })), (Function1)new Function1<Long, R>(this){
            final /* synthetic */ AbstractEntityStorage this$0;

            @NotNull
            public final R invoke(long it) {
                WorkspaceEntity workspaceEntity = this.this$0.entityDataByIdOrDie$intellij_platform_workspaceModel_storage(it).createEntity(this.this$0);
                if (workspaceEntity == null) {
                    throw new NullPointerException("null cannot be cast to non-null type R");
                }
                return (R)workspaceEntity;
            }
            {
                this.this$0 = abstractEntityStorage;
                super(1);
            }
        });
    }

    @Override
    @Nullable
    public <E extends WorkspaceEntityWithPersistentId> E resolve(@NotNull PersistentEntityId<? extends E> id2) {
        Intrinsics.checkNotNullParameter(id2, (String)"id");
        Long l = this.getIndexes$intellij_platform_workspaceModel_storage().getPersistentIdIndex$intellij_platform_workspaceModel_storage().getIdsByEntry$intellij_platform_workspaceModel_storage(id2);
        if (l == null) {
            return null;
        }
        long entityIds = l;
        WorkspaceEntityData<? extends WorkspaceEntity> workspaceEntityData = this.entityDataById$intellij_platform_workspaceModel_storage(entityIds);
        return (E)((WorkspaceEntityWithPersistentId)(workspaceEntityData != null ? workspaceEntityData.createEntity(this) : null));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<EntitySource, Map<Class<? extends WorkspaceEntity>, List<WorkspaceEntity>>> entitiesBySource(@NotNull Function1<? super EntitySource, Boolean> sourceFilter) {
        Intrinsics.checkNotNullParameter(sourceFilter, (String)"sourceFilter");
        Sequence $this$associateWith$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.getIndexes$intellij_platform_workspaceModel_storage().getEntitySourceIndex$intellij_platform_workspaceModel_storage().entries$intellij_platform_workspaceModel_storage()), (Function1)((Function1)new Function1<EntitySource, Boolean>(sourceFilter){
            final /* synthetic */ Function1 $sourceFilter;

            public final boolean invoke(@NotNull EntitySource it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (Boolean)this.$sourceFilter.invoke((Object)it);
            }
            {
                this.$sourceFilter = function1;
                super(1);
            }
        }));
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        Sequence $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$groupByTo$iv$iv;
            void $this$groupBy$iv;
            void $this$mapTo$iv$iv;
            void source;
            EntitySource entitySource = (EntitySource)element$iv$iv;
            Object e = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            List<Long> list2 = this.getIndexes$intellij_platform_workspaceModel_storage().getEntitySourceIndex$intellij_platform_workspaceModel_storage().getIdsByEntry$intellij_platform_workspaceModel_storage((EntitySource)source);
            Intrinsics.checkNotNull(list2);
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                long l = ((Number)item$iv$iv).longValue();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                WorkspaceEntityData<? extends WorkspaceEntity> workspaceEntityData = this.entityDataById$intellij_platform_workspaceModel_storage((long)it);
                if (workspaceEntityData == null || (workspaceEntityData = workspaceEntityData.createEntity(this)) == null) {
                    AbstractEntityStorage abstractEntityStorage = this;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    AbstractEntityStorage $this$run = abstractEntityStorage;
                    boolean bl5 = false;
                    ErrorReportingKt.reportErrorAndAttachStorage("Cannot find an entity by id " + (long)it, this);
                    String string = "Cannot find an entity by id " + (long)it;
                    boolean bl6 = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                WorkspaceEntityData<? extends WorkspaceEntity> workspaceEntityData2 = workspaceEntityData;
                collection.add(workspaceEntityData2);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$groupBy = false;
            $this$mapTo$iv$iv = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv2 : $this$groupByTo$iv$iv) {
                Object object;
                Class<?> key$iv$iv;
                WorkspaceEntity it = (WorkspaceEntity)element$iv$iv2;
                boolean bl7 = false;
                if (it.getClass() == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<out com.intellij.workspaceModel.storage.WorkspaceEntity>");
                }
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl8 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv2);
            }
            Object object = destination$iv$iv;
            map2.put(e, object);
        }
        return result$iv;
    }

    @Override
    @NotNull
    public <T> ExternalEntityMapping<T> getExternalMapping(@NotNull String identifier) {
        ExternalEntityMappingImpl<?> index2;
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        ExternalEntityMappingImpl<?> externalEntityMappingImpl = this.getIndexes$intellij_platform_workspaceModel_storage().getExternalMappings$intellij_platform_workspaceModel_storage().get(identifier);
        if (!(externalEntityMappingImpl instanceof ExternalEntityMappingImpl)) {
            externalEntityMappingImpl = null;
        }
        if ((index2 = externalEntityMappingImpl) == null) {
            EmptyExternalEntityMapping emptyExternalEntityMapping = EmptyExternalEntityMapping.INSTANCE;
            if (emptyExternalEntityMapping == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.ExternalEntityMapping<T>");
            }
            return emptyExternalEntityMapping;
        }
        index2.setTypedEntityStorage$intellij_platform_workspaceModel_storage(this);
        return index2;
    }

    @Override
    @NotNull
    public VirtualFileUrlIndex getVirtualFileUrlIndex() {
        this.getIndexes$intellij_platform_workspaceModel_storage().getVirtualFileIndex$intellij_platform_workspaceModel_storage().setTypedEntityStorage$intellij_platform_workspaceModel_storage(this);
        return this.getIndexes$intellij_platform_workspaceModel_storage().getVirtualFileIndex$intellij_platform_workspaceModel_storage();
    }

    @Override
    @NotNull
    public <E extends WorkspaceEntity> EntityReference<E> createReference(@NotNull E e) {
        Intrinsics.checkNotNullParameter(e, (String)"e");
        return new EntityReferenceImpl(((WorkspaceEntityBase)e).getId$intellij_platform_workspaceModel_storage());
    }

    public final void assertConsistencyInStrictMode$intellij_platform_workspaceModel_storage(@NotNull String message2, @Nullable Function1<? super EntitySource, Boolean> sourceFilter, @Nullable WorkspaceEntityStorage left, @Nullable WorkspaceEntityStorage right) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        if (ConsistencyCheckingMode.Companion.getCurrent() != ConsistencyCheckingMode.DISABLED) {
            try {
                ConsistencyCheckerKt.assertConsistency(this);
            }
            catch (Throwable e) {
                AbstractEntityStorage abstractEntityStorage;
                this.brokenConsistency = true;
                if (this instanceof WorkspaceEntityStorageBuilder) {
                    WorkspaceEntityStorage workspaceEntityStorage = ((WorkspaceEntityStorageBuilder)((Object)this)).toStorage();
                    if (workspaceEntityStorage == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.AbstractEntityStorage");
                    }
                    abstractEntityStorage = (AbstractEntityStorage)workspaceEntityStorage;
                } else {
                    abstractEntityStorage = this;
                }
                AbstractEntityStorage storage2 = abstractEntityStorage;
                Function0 report2 = (Function0)new Function0<Unit>(message2, e, sourceFilter, left, right, storage2){
                    final /* synthetic */ String $message;
                    final /* synthetic */ Throwable $e;
                    final /* synthetic */ Function1 $sourceFilter;
                    final /* synthetic */ WorkspaceEntityStorage $left;
                    final /* synthetic */ WorkspaceEntityStorage $right;
                    final /* synthetic */ AbstractEntityStorage $storage;

                    public final void invoke() {
                        ErrorReportingKt.reportConsistencyIssue(this.$message, this.$e, (Function1<? super EntitySource, Boolean>)this.$sourceFilter, this.$left, this.$right, this.$storage);
                    }
                    {
                        this.$message = string;
                        this.$e = throwable;
                        this.$sourceFilter = function1;
                        this.$left = workspaceEntityStorage;
                        this.$right = workspaceEntityStorage2;
                        this.$storage = abstractEntityStorage;
                        super(0);
                    }
                };
                if (ConsistencyCheckingMode.Companion.getCurrent() == ConsistencyCheckingMode.ASYNCHRONOUS) {
                    Function0 function0 = report2;
                    consistencyChecker.execute(new Runnable(function0){
                        private final /* synthetic */ Function0 function;
                        {
                            this.function = function0;
                        }

                        public final /* synthetic */ void run() {
                            Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(), (String)"invoke(...)");
                        }
                    });
                }
                report2.invoke();
            }
        }
    }

    private AbstractEntityStorage() {
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AbstractEntityStorage.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Check workspace model consistency", (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"AppExecutorUtil.createBo\u2026ce model consistency\", 1)");
        consistencyChecker = executorService;
    }

    public /* synthetic */ AbstractEntityStorage(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/workspaceModel/storage/impl/AbstractEntityStorage$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "consistencyChecker", "Ljava/util/concurrent/ExecutorService;", "intellij.platform.workspaceModel.storage"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

