/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.impl;

import com.google.common.collect.BiMap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.impl.AbstractEntityStorage;
import com.intellij.workspaceModel.storage.impl.ChildEntityId;
import com.intellij.workspaceModel.storage.impl.ClassToIntConverter;
import com.intellij.workspaceModel.storage.impl.ClassToIntConverterKt;
import com.intellij.workspaceModel.storage.impl.ConnectionId;
import com.intellij.workspaceModel.storage.impl.EntityFamily;
import com.intellij.workspaceModel.storage.impl.EntityIdKt;
import com.intellij.workspaceModel.storage.impl.ImmutableEntityFamily;
import com.intellij.workspaceModel.storage.impl.ParentEntityId;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityData;
import com.intellij.workspaceModel.storage.impl.containers.IntIntUniqueBiMap;
import com.intellij.workspaceModel.storage.impl.containers.LinkedBidirectionalMap;
import com.intellij.workspaceModel.storage.impl.containers.NonNegativeIntIntBiMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntMaps;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000H\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006H\u0002\u001a \u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0002\u001a2\u0010\f\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00032\u0010\u0010\u000e\u001a\f\u0012\b\u0012\u00060\u0005j\u0002`\u00060\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a8\u0010\u0012\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u00060\u0005j\u0002`\u00060\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a0\u0010\u0016\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u001a\f\u0010\u001b\u001a\u00020\u0001*\u00020\tH\u0000\u00a8\u0006\u001c"}, d2={"assertCorrectEntityClass", "", "connectionClass", "", "entityId", "", "Lcom/intellij/workspaceModel/storage/impl/EntityId;", "assertResolvable", "storage", "Lcom/intellij/workspaceModel/storage/impl/AbstractEntityStorage;", "clazz", "id", "checkAllStrongConnections", "entityFamilyClass", "keys", "", "debugInfo", "", "checkStrongAbstractConnection", "connectionKeys", "", "entityFamilyClasses", "checkStrongConnection", "Lit/unimi/dsi/fastutil/ints/IntSet;", "connectionTo", "connectionId", "Lcom/intellij/workspaceModel/storage/impl/ConnectionId;", "assertConsistency", "intellij.platform.workspaceModel.storage"})
public final class ConsistencyCheckerKt {
    /*
     * WARNING - void declaration
     */
    public static final void assertConsistency(@NotNull AbstractEntityStorage $this$assertConsistency) {
        Integer n;
        Map.Entry<ConnectionId, Object> $this$map$iv232;
        Object object;
        Collection<Long> collection;
        Iterable $this$map$iv;
        boolean $i$f$map;
        AbstractEntityStorage abstractEntityStorage;
        ChildEntityId childId;
        ParentEntityId parentId;
        boolean bl;
        Object $this$forEach$iv;
        Object this_$iv22;
        Object map2;
        boolean $i$f$forEachKey;
        Object this_$iv332;
        boolean bl2;
        ConnectionId connectionId;
        Map.Entry<ConnectionId, Object> $dstr$connectionId$map;
        Intrinsics.checkNotNullParameter((Object)$this$assertConsistency, (String)"$this$assertConsistency");
        Logger $this$trace$iv = AbstractEntityStorage.Companion.getLOG();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl3 = false;
            String string = "Checking consistency of " + $this$assertConsistency;
            logger.trace(string);
        }
        $this$assertConsistency.getEntitiesByType$intellij_platform_workspaceModel_storage().assertConsistency($this$assertConsistency);
        Map<ConnectionId, NonNegativeIntIntBiMap> $this$forEach$iv2 = $this$assertConsistency.getRefs$intellij_platform_workspaceModel_storage().getOneToManyContainer$intellij_platform_workspaceModel_storage();
        boolean $i$f$forEach2 = false;
        Map<ConnectionId, Object> map3 = $this$forEach$iv2;
        boolean bl4 = false;
        for (Map.Entry<ConnectionId, NonNegativeIntIntBiMap> element$iv2 : map3.entrySet()) {
            $dstr$connectionId$map = element$iv2;
            boolean bl5 = false;
            Map.Entry<ConnectionId, NonNegativeIntIntBiMap> entry2 = $dstr$connectionId$map;
            boolean bl6 = false;
            ConnectionId connectionId2 = entry2.getKey();
            entry2 = $dstr$connectionId$map;
            bl6 = false;
            NonNegativeIntIntBiMap map22 = entry2.getValue();
            boolean bl7 = connectionId.getConnectionType() == ConnectionId.ConnectionType.ONE_TO_MANY;
            bl6 = false;
            bl2 = false;
            if (_Assertions.ENABLED && !bl7) {
                boolean bl8 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            this_$iv332 = map22;
            $i$f$forEachKey = false;
            Int2IntMaps.fastForEach((Int2IntMap)((NonNegativeIntIntBiMap)this_$iv332).getAccess$key2Value(), (Consumer)new Consumer(connectionId, $this$assertConsistency){
                final /* synthetic */ ConnectionId $connectionId$inlined;
                final /* synthetic */ AbstractEntityStorage $this_assertConsistency$inlined;
                {
                    this.$connectionId$inlined = connectionId;
                    this.$this_assertConsistency$inlined = abstractEntityStorage;
                }

                public final void accept(Int2IntMap.Entry it) {
                    Int2IntMap.Entry entry2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)entry2, (String)"it");
                    int parentId = it.getIntValue();
                    int childId = entry2.getIntKey();
                    boolean bl = false;
                    ConsistencyCheckerKt.access$assertResolvable(this.$this_assertConsistency$inlined, this.$connectionId$inlined.getParentClass(), parentId);
                    ConsistencyCheckerKt.access$assertResolvable(this.$this_assertConsistency$inlined, this.$connectionId$inlined.getChildClass(), childId);
                }
            });
            if (connectionId.isParentNullable()) continue;
            ConsistencyCheckerKt.checkStrongConnection($this$assertConsistency, map22.getKeys(), connectionId.getChildClass(), connectionId.getParentClass(), connectionId);
        }
        Map<ConnectionId, Object> $this$forEach$iv3 = $this$assertConsistency.getRefs$intellij_platform_workspaceModel_storage().getOneToOneContainer$intellij_platform_workspaceModel_storage();
        boolean $i$f$forEach = false;
        map3 = $this$forEach$iv3;
        bl4 = false;
        for (Map.Entry<ConnectionId, Object> element$iv : map3.entrySet()) {
            $dstr$connectionId$map = element$iv;
            boolean bl9 = false;
            this_$iv332 = $dstr$connectionId$map;
            $i$f$forEachKey = false;
            connectionId = this_$iv332.getKey();
            this_$iv332 = $dstr$connectionId$map;
            $i$f$forEachKey = false;
            map2 = (IntIntUniqueBiMap)this_$iv332.getValue();
            boolean this_$iv332 = connectionId.getConnectionType() == ConnectionId.ConnectionType.ONE_TO_ONE;
            $i$f$forEachKey = false;
            bl2 = false;
            if (_Assertions.ENABLED && !this_$iv332) {
                boolean bl10 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            this_$iv22 = map2;
            $i$f$forEachKey = false;
            Int2IntMaps.fastForEach((Int2IntMap)((IntIntUniqueBiMap)this_$iv22).getAccess$key2Value(), (Consumer)new Consumer(connectionId, $this$assertConsistency){
                final /* synthetic */ ConnectionId $connectionId$inlined;
                final /* synthetic */ AbstractEntityStorage $this_assertConsistency$inlined;
                {
                    this.$connectionId$inlined = connectionId;
                    this.$this_assertConsistency$inlined = abstractEntityStorage;
                }

                public final void accept(Int2IntMap.Entry it) {
                    Int2IntMap.Entry entry2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)entry2, (String)"it");
                    int parentId = it.getIntValue();
                    int childId = entry2.getIntKey();
                    boolean bl = false;
                    ConsistencyCheckerKt.access$assertResolvable(this.$this_assertConsistency$inlined, this.$connectionId$inlined.getParentClass(), parentId);
                    ConsistencyCheckerKt.access$assertResolvable(this.$this_assertConsistency$inlined, this.$connectionId$inlined.getChildClass(), childId);
                }
            });
            if (connectionId.isParentNullable()) continue;
            ConsistencyCheckerKt.checkStrongConnection($this$assertConsistency, ((IntIntUniqueBiMap)map2).getKeys(), connectionId.getChildClass(), connectionId.getParentClass(), connectionId);
        }
        $this$forEach$iv3 = $this$assertConsistency.getRefs$intellij_platform_workspaceModel_storage().getOneToAbstractManyContainer$intellij_platform_workspaceModel_storage();
        $i$f$forEach = false;
        map3 = $this$forEach$iv3;
        bl4 = false;
        for (Map.Entry<ConnectionId, Object> element$iv : map3.entrySet()) {
            void $this$mapTo$iv$iv232;
            Map.Entry<ConnectionId, Object> $this$mapTo$iv$iv;
            $dstr$connectionId$map = element$iv;
            boolean bl11 = false;
            this_$iv22 = $dstr$connectionId$map;
            $i$f$forEachKey = false;
            connectionId = this_$iv22.getKey();
            this_$iv22 = $dstr$connectionId$map;
            $i$f$forEachKey = false;
            map2 = (LinkedBidirectionalMap)this_$iv22.getValue();
            boolean this_$iv22 = connectionId.getConnectionType() == ConnectionId.ConnectionType.ONE_TO_ABSTRACT_MANY;
            $i$f$forEachKey = false;
            boolean bl12 = false;
            if (_Assertions.ENABLED && !this_$iv22) {
                boolean bl13 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            $this$forEach$iv = (Map)map2;
            boolean $i$f$forEach3 = false;
            Map object2 = $this$forEach$iv;
            boolean bl14 = false;
            Iterator iterator2 = object2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry2;
                Map.Entry $dstr$childId$parentId = entry2 = iterator2.next();
                boolean bl15 = false;
                Map.Entry entry3 = $dstr$childId$parentId;
                bl = false;
                ChildEntityId childEntityId = (ChildEntityId)entry3.getKey();
                entry3 = $dstr$childId$parentId;
                bl = false;
                parentId = (ParentEntityId)entry3.getValue();
                ConsistencyCheckerKt.assertResolvable($this$assertConsistency, EntityIdKt.getClazz(parentId.getId()), EntityIdKt.getArrayId(parentId.getId()));
                ConsistencyCheckerKt.assertResolvable($this$assertConsistency, EntityIdKt.getClazz(childId.getId()), EntityIdKt.getArrayId(childId.getId()));
                ConsistencyCheckerKt.assertCorrectEntityClass(connectionId.getParentClass(), parentId.getId());
                ConsistencyCheckerKt.assertCorrectEntityClass(connectionId.getChildClass(), childId.getId());
            }
            if (connectionId.isParentNullable()) continue;
            $this$forEach$iv = ((LinkedBidirectionalMap)map2).keySet();
            abstractEntityStorage = $this$assertConsistency;
            $i$f$map = false;
            object2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator3 = $this$mapTo$iv$iv.iterator();
            while (iterator3.hasNext()) {
                void it;
                Object item$iv$iv = iterator3.next();
                ChildEntityId bl15 = (ChildEntityId)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl16 = false;
                object = it.getId();
                collection.add((Long)object);
            }
            collection = (List)destination$iv$iv;
            $this$map$iv = ((LinkedBidirectionalMap)map2).keySet();
            collection = CollectionsKt.toMutableSet((Iterable)collection);
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv232;
            Collection destination$iv$iv3232 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv232, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv232) {
                ChildEntityId it = (ChildEntityId)item$iv$iv;
                object = destination$iv$iv3232;
                boolean bl17 = false;
                n = EntityIdKt.getClazz(it.getId());
                object.add(n);
            }
            object = (List)destination$iv$iv3232;
            ConsistencyCheckerKt.checkStrongAbstractConnection(abstractEntityStorage, collection, CollectionsKt.toSet((Iterable)((Iterable)object)), connectionId.debugStr());
        }
        $this$forEach$iv3 = $this$assertConsistency.getRefs$intellij_platform_workspaceModel_storage().getAbstractOneToOneContainer$intellij_platform_workspaceModel_storage();
        $i$f$forEach = false;
        map3 = $this$forEach$iv3;
        bl4 = false;
        for (Map.Entry<ConnectionId, Object> element$iv : map3.entrySet()) {
            void $this$mapTo$iv$iv;
            void destination$iv;
            Iterable $this$mapTo$iv;
            $dstr$connectionId$map = element$iv;
            boolean bl18 = false;
            $this$map$iv232 = $dstr$connectionId$map;
            $i$f$map = false;
            connectionId = $this$map$iv232.getKey();
            $this$map$iv232 = $dstr$connectionId$map;
            $i$f$map = false;
            map2 = (BiMap)$this$map$iv232.getValue();
            boolean $this$map$iv232 = connectionId.getConnectionType() == ConnectionId.ConnectionType.ABSTRACT_ONE_TO_ONE;
            $i$f$map = false;
            boolean $this$mapTo$iv$iv232 = false;
            if (_Assertions.ENABLED && !$this$map$iv232) {
                boolean destination$iv$iv3232 = false;
                String destination$iv$iv3232 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)destination$iv$iv3232));
            }
            $this$forEach$iv = (Map)map2;
            boolean $i$f$forEach232 = false;
            Map $this$mapTo$iv$iv232 = $this$forEach$iv;
            boolean destination$iv$iv3232 = false;
            Iterator $i$f$mapTo = $this$mapTo$iv$iv232.entrySet().iterator();
            while ($i$f$mapTo.hasNext()) {
                Map.Entry entry4;
                Map.Entry $dstr$childId$parentId = entry4 = $i$f$mapTo.next();
                boolean bl19 = false;
                Map.Entry bl17 = $dstr$childId$parentId;
                bl = false;
                childId = (ChildEntityId)bl17.getKey();
                bl17 = $dstr$childId$parentId;
                bl = false;
                parentId = (ParentEntityId)bl17.getValue();
                ConsistencyCheckerKt.assertResolvable($this$assertConsistency, EntityIdKt.getClazz(parentId.getId()), EntityIdKt.getArrayId(parentId.getId()));
                ConsistencyCheckerKt.assertResolvable($this$assertConsistency, EntityIdKt.getClazz(childId.getId()), EntityIdKt.getArrayId(childId.getId()));
                ConsistencyCheckerKt.assertCorrectEntityClass(connectionId.getParentClass(), parentId.getId());
                ConsistencyCheckerKt.assertCorrectEntityClass(connectionId.getChildClass(), childId.getId());
            }
            if (connectionId.isParentNullable()) continue;
            $this$forEach$iv = map2.keySet();
            Collection $i$f$forEach232 = new HashSet();
            abstractEntityStorage = $this$assertConsistency;
            boolean $i$f$mapTo232 = false;
            for (Object item$iv : $this$mapTo$iv) {
                ChildEntityId childEntityId = (ChildEntityId)item$iv;
                collection = destination$iv;
                boolean bl20 = false;
                object = childEntityId.getId();
                collection.add((Long)object);
            }
            collection = destination$iv;
            $this$mapTo$iv = CollectionsKt.toMutableSet((Iterable)map2.keySet());
            collection = (Set)collection;
            $i$f$map = false;
            Iterable $i$f$mapTo232 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ChildEntityId bl19 = (ChildEntityId)item$iv$iv;
                object = destination$iv$iv;
                boolean bl21 = false;
                n = EntityIdKt.getClazz(it.getId());
                object.add(n);
            }
            object = (List)destination$iv$iv;
            ConsistencyCheckerKt.checkStrongAbstractConnection(abstractEntityStorage, collection, CollectionsKt.toSet((Iterable)((Iterable)object)), connectionId.debugStr());
        }
        $this$assertConsistency.getIndexes$intellij_platform_workspaceModel_storage().assertConsistency($this$assertConsistency);
    }

    private static final void assertCorrectEntityClass(int connectionClass, long entityId) {
        int $this$findEntityClass$iv = connectionClass;
        boolean $i$f$findEntityClass = false;
        Class<?> clazz = ClassToIntConverter.INSTANCE.getClassOrDie($this$findEntityClass$iv);
        if (clazz == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<E>");
        }
        $this$findEntityClass$iv = EntityIdKt.getClazz(entityId);
        $i$f$findEntityClass = false;
        Class<?> clazz2 = ClassToIntConverter.INSTANCE.getClassOrDie($this$findEntityClass$iv);
        if (clazz2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<E>");
        }
        boolean bl = clazz.isAssignableFrom(clazz2);
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            int $this$findEntityClass$iv2 = connectionClass;
            boolean $i$f$findEntityClass2 = false;
            Class<?> clazz3 = ClassToIntConverter.INSTANCE.getClassOrDie($this$findEntityClass$iv2);
            if (clazz3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<E>");
            }
            String string = "Entity storage with connection class " + clazz3 + " contains entity data of wrong type " + entityId;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    private static final void assertResolvable(AbstractEntityStorage storage2, int clazz, int id2) {
        EntityFamily<? extends WorkspaceEntity> entityFamily = storage2.getEntitiesByType$intellij_platform_workspaceModel_storage().get(clazz);
        boolean bl = (entityFamily != null ? entityFamily.get(id2) : null) != null;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            int $this$findEntityClass$iv = clazz;
            boolean $i$f$findEntityClass = false;
            Class<?> clazz2 = ClassToIntConverter.INSTANCE.getClassOrDie($this$findEntityClass$iv);
            if (clazz2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<E>");
            }
            String string = "Reference to " + clazz2 + "-:-" + id2 + " cannot be resolved";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    private static final void checkAllStrongConnections(AbstractEntityStorage storage2, int entityFamilyClass, Set<Long> keys2, String debugInfo) {
        EntityFamily<? extends WorkspaceEntity> entityFamily = storage2.getEntitiesByType$intellij_platform_workspaceModel_storage().getEntityFamilies$intellij_platform_workspaceModel_storage().get(entityFamilyClass);
        if (entityFamily == null) {
            String string = "Entity family doesn't exist. " + debugInfo;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        EntityFamily<? extends WorkspaceEntity> entityFamily2 = entityFamily;
        Iterable $this$forEach$iv = entityFamily2.getEntities$intellij_platform_workspaceModel_storage();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WorkspaceEntityData entity = (WorkspaceEntityData)element$iv;
            boolean bl = false;
            if (entity == null) continue;
            boolean removed = keys2.remove(entity.createEntityId$intellij_platform_workspaceModel_storage());
            boolean bl2 = false;
            if (!_Assertions.ENABLED || removed) continue;
            boolean bl3 = false;
            String string = "Entity " + entity + " doesn't have a correct connection. " + debugInfo;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    private static final void checkStrongAbstractConnection(AbstractEntityStorage storage2, Set<Long> connectionKeys, Set<Integer> entityFamilyClasses, String debugInfo) {
        Set keys2 = CollectionsKt.toMutableSet((Iterable)connectionKeys);
        Iterable $this$forEach$iv = entityFamilyClasses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int entityFamilyClass = ((Number)element$iv).intValue();
            boolean bl = false;
            ConsistencyCheckerKt.checkAllStrongConnections(storage2, entityFamilyClass, keys2, debugInfo);
        }
        boolean bl = keys2.isEmpty();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Store is inconsistent. " + debugInfo;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void checkStrongConnection(AbstractEntityStorage storage2, IntSet connectionKeys, int entityFamilyClass, int connectionTo, ConnectionId connectionId) {
        int counter = 0;
        EntityFamily entityFamily = storage2.getEntitiesByType$intellij_platform_workspaceModel_storage().get(entityFamilyClass);
        if (entityFamily == null) {
            entityFamily = new ImmutableEntityFamily();
        }
        EntityFamily entityFamily2 = entityFamily;
        Iterable $this$forEachIndexed$iv = entityFamily2.getEntities$intellij_platform_workspaceModel_storage();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void entity;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            WorkspaceEntityData workspaceEntityData = (WorkspaceEntityData)item$iv;
            int i2 = n;
            boolean bl2 = false;
            if (entity == null) continue;
            int n2 = connectionKeys.contains(i2);
            boolean bl3 = false;
            if (_Assertions.ENABLED && n2 == 0) {
                boolean bl4 = false;
                String string = StringsKt.trimMargin$default((String)("\n            |Storage inconsistency. Hard reference broken.\n            |Existing entity " + entity + "\n            |Misses a reference to " + ClassToIntConverterKt.findWorkspaceEntity(connectionTo) + "\n            |Reference id: " + i2 + "\n            |ConnectionId: " + connectionId + "\n            "), null, (int)1, null);
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            n2 = counter;
            counter = n2 + 1;
        }
        boolean bl = counter == connectionKeys.size();
        boolean bl5 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl6 = false;
            String string = "Store is inconsistent";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    public static final /* synthetic */ void access$assertResolvable(AbstractEntityStorage storage2, int clazz, int id2) {
        ConsistencyCheckerKt.assertResolvable(storage2, clazz, id2);
    }
}

