/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.impl;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.io.Compressor;
import com.intellij.workspaceModel.storage.EntitySource;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageBuilder;
import com.intellij.workspaceModel.storage.impl.AbstractEntityStorage;
import com.intellij.workspaceModel.storage.impl.AnonymizedEntitySource;
import com.intellij.workspaceModel.storage.impl.ChangeEntry;
import com.intellij.workspaceModel.storage.impl.ConsistencyCheckingMode;
import com.intellij.workspaceModel.storage.impl.EntityStorageSerializerImpl;
import com.intellij.workspaceModel.storage.impl.ErrorReportingKt;
import com.intellij.workspaceModel.storage.impl.MatchedEntitySource;
import com.intellij.workspaceModel.storage.impl.SimpleEntityTypesResolver;
import com.intellij.workspaceModel.storage.impl.StorageIndexes;
import com.intellij.workspaceModel.storage.impl.UnmatchedEntitySource;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityStorageBuilderImpl;
import com.intellij.workspaceModel.storage.impl.indices.EntityStorageInternalIndex;
import com.intellij.workspaceModel.storage.impl.url.VirtualFileUrlManagerImpl;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000p\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003H\u0002\u001a\b\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0018\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n2\u0006\u0010\f\u001a\u00020\u0001H\u0002\u001a\b\u0010\r\u001a\u00020\u000eH\u0000\u001a\b\u0010\u000f\u001a\u00020\bH\u0002\u001aJ\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b\u0018\u00010\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001a\u001a\u00020\u0018H\u0000\u001a\u0018\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u0018H\u0007\u001a*\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u000e2\u0018\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00050 H\u0000\u001aD\u0010#\u001a\u0004\u0018\u00010\u00032\u0006\u0010$\u001a\u00020\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001a\u001a\u00020\u00182\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b\u0018\u00010\u0015H\u0002\u001a\u0018\u0010%\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u0018H\u0000\u001a\"\u0010&\u001a\u00020\u0016*\u00020\u00162\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b\u0018\u00010\u0015H\u0000\u001a\"\u0010&\u001a\u00020\u0018*\u00020\u00182\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b\u0018\u00010\u0015H\u0000\u001a4\u0010&\u001a\u0016\u0012\b\u0012\u00060\u0001j\u0002`(\u0012\u0004\u0012\u00020)0'j\u0002`**\u0016\u0012\b\u0012\u00060\u0001j\u0002`(\u0012\u0004\u0012\u00020)0'j\u0002`*H\u0000\u001a\f\u0010+\u001a\u00020\u0018*\u00020\u0018H\u0002\u001a\u001c\u0010,\u001a\u00020\u0005*\u00020-2\u0006\u0010.\u001a\u00020!2\u0006\u0010/\u001a\u00020\"H\u0002\u001a\u0014\u0010,\u001a\u00020\u0005*\u00020-2\u0006\u0010/\u001a\u00020\"H\u0000\u001a\u0014\u00100\u001a\u00020\u0005*\u00020\u00182\u0006\u0010/\u001a\u00020\"H\u0000\u00a8\u00061"}, d2={"ageInDays", "", "file", "Ljava/io/File;", "cleanOldFiles", "", "parentDir", "executingOnTC", "", "formatTime", "", "kotlin.jvm.PlatformType", "timeMs", "getStoreDumpDirectory", "Ljava/nio/file/Path;", "isWrapped", "reportConsistencyIssue", "message", "e", "", "sourceFilter", "Lkotlin/Function1;", "Lcom/intellij/workspaceModel/storage/EntitySource;", "left", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;", "right", "resulting", "reportErrorAndAttachStorage", "storage", "serializeContent", "path", "howToSerialize", "Lkotlin/Function2;", "Lcom/intellij/workspaceModel/storage/impl/EntityStorageSerializerImpl;", "Ljava/io/OutputStream;", "serializeContentToFolder", "contentFolder", "serializeEntityStorage", "anonymize", "", "Lcom/intellij/workspaceModel/storage/impl/EntityId;", "Lcom/intellij/workspaceModel/storage/impl/ChangeEntry;", "Lcom/intellij/workspaceModel/storage/impl/ChangeLog;", "makeSureItsStore", "serializeDiff", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageBuilderImpl;", "serializer", "stream", "serializeTo", "intellij.platform.workspaceModel.storage"})
public final class ErrorReportingKt {
    @ApiStatus.Internal
    public static final void reportErrorAndAttachStorage(@NotNull String message2, @NotNull WorkspaceEntityStorage storage2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)storage2, (String)"storage");
        ErrorReportingKt.reportConsistencyIssue(message2, new IllegalStateException(), null, null, null, storage2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void serializeContent(@NotNull Path path2, @NotNull Function2<? super EntityStorageSerializerImpl, ? super OutputStream, Unit> howToSerialize) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter(howToSerialize, (String)"howToSerialize");
        EntityStorageSerializerImpl serializer2 = new EntityStorageSerializerImpl(SimpleEntityTypesResolver.INSTANCE, new VirtualFileUrlManagerImpl(), null, 4, null);
        File file2 = path2.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"path.toFile()");
        Object object = file2;
        boolean bl = false;
        object = new FileOutputStream((File)object);
        bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            FileOutputStream it = (FileOutputStream)object;
            boolean bl3 = false;
            howToSerialize.invoke((Object)serializer2, (Object)it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    public static final void serializeEntityStorage(@NotNull Path path2, @NotNull WorkspaceEntityStorage storage2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)storage2, (String)"storage");
        ErrorReportingKt.serializeContent(path2, (Function2<? super EntityStorageSerializerImpl, ? super OutputStream, Unit>)((Function2)new Function2<EntityStorageSerializerImpl, OutputStream, Unit>(storage2){
            final /* synthetic */ WorkspaceEntityStorage $storage;

            public final void invoke(@NotNull EntityStorageSerializerImpl serializer2, @NotNull OutputStream stream) {
                Intrinsics.checkNotNullParameter((Object)serializer2, (String)"serializer");
                Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
                serializer2.serializeCache(stream, ErrorReportingKt.access$makeSureItsStore(this.$storage));
            }
            {
                this.$storage = workspaceEntityStorage;
                super(2);
            }
        }));
    }

    private static final WorkspaceEntityStorage makeSureItsStore(WorkspaceEntityStorage $this$makeSureItsStore) {
        return $this$makeSureItsStore instanceof WorkspaceEntityStorageBuilderImpl ? (WorkspaceEntityStorage)((WorkspaceEntityStorageBuilderImpl)$this$makeSureItsStore).toStorage() : $this$makeSureItsStore;
    }

    @NotNull
    public static final Path getStoreDumpDirectory() {
        String property2 = System.getProperty("ide.new.project.model.store.dump.directory");
        if (property2 == null) {
            String pathPrefix = "storeDump-" + ErrorReportingKt.formatTime(System.currentTimeMillis());
            Path workspaceModelDumps = Paths.get(PathManager.getLogPath(), "workspaceModel");
            File file2 = workspaceModelDumps.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"workspaceModelDumps.toFile()");
            ErrorReportingKt.cleanOldFiles(file2);
            Path currentDumpDir = workspaceModelDumps.resolve(pathPrefix);
            FileUtil.createDirectory((File)currentDumpDir.toFile());
            Path path2 = currentDumpDir;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"currentDumpDir");
            return path2;
        }
        Path path3 = Paths.get(property2, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"Paths.get(property)");
        return path3;
    }

    public static final boolean executingOnTC() {
        return System.getProperty("ide.new.project.model.store.dump.directory") != null;
    }

    /*
     * WARNING - void declaration
     */
    private static final void cleanOldFiles(File parentDir) {
        Object[] objectArray = parentDir.listFiles();
        if (objectArray == null) {
            return;
        }
        Object[] children2 = objectArray;
        Arrays.sort(children2);
        int n = 0;
        int n2 = children2.length;
        while (n < n2) {
            void i2;
            block6: {
                Object child2;
                block5: {
                    child2 = children2[i2];
                    if (i2 < children2.length - 30) break block5;
                    Object object = child2;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"child");
                    if (ErrorReportingKt.ageInDays((File)object) <= (long)7) break block6;
                }
                FileUtil.delete((File)child2);
            }
            ++i2;
        }
    }

    private static final String formatTime(long timeMs) {
        return new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date(timeMs));
    }

    private static final long ageInDays(File file2) {
        return TimeUnit.DAYS.convert(System.currentTimeMillis() - file2.lastModified(), TimeUnit.MILLISECONDS);
    }

    public static final void serializeTo(@NotNull WorkspaceEntityStorage $this$serializeTo, @NotNull OutputStream stream) {
        Intrinsics.checkNotNullParameter((Object)$this$serializeTo, (String)"$this$serializeTo");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        EntityStorageSerializerImpl serializer2 = new EntityStorageSerializerImpl(SimpleEntityTypesResolver.INSTANCE, new VirtualFileUrlManagerImpl(), null, 4, null);
        serializer2.serializeCache(stream, ErrorReportingKt.makeSureItsStore($this$serializeTo));
    }

    public static final void serializeDiff(@NotNull WorkspaceEntityStorageBuilderImpl $this$serializeDiff, @NotNull OutputStream stream) {
        Intrinsics.checkNotNullParameter((Object)$this$serializeDiff, (String)"$this$serializeDiff");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        EntityStorageSerializerImpl serializer2 = new EntityStorageSerializerImpl(SimpleEntityTypesResolver.INSTANCE, new VirtualFileUrlManagerImpl(), null, 4, null);
        ErrorReportingKt.serializeDiff($this$serializeDiff, serializer2, stream);
    }

    private static final void serializeDiff(WorkspaceEntityStorageBuilderImpl $this$serializeDiff, EntityStorageSerializerImpl serializer2, OutputStream stream) {
        serializer2.serializeDiffLog$intellij_platform_workspaceModel_storage(stream, ErrorReportingKt.anonymize($this$serializeDiff.getChangeLog$intellij_platform_workspaceModel_storage().getChangeLog$intellij_platform_workspaceModel_storage()));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final WorkspaceEntityStorage anonymize(@NotNull WorkspaceEntityStorage $this$anonymize, @Nullable Function1<? super EntitySource, Boolean> sourceFilter) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$anonymize, (String)"$this$anonymize");
        if (!ErrorReportingKt.isWrapped()) {
            return $this$anonymize;
        }
        WorkspaceEntityStorageBuilder builder2 = WorkspaceEntityStorageBuilder.Companion.from($this$anonymize);
        Map<EntitySource, Map<Class<? extends WorkspaceEntity>, List<WorkspaceEntity>>> $this$flatMap$iv = builder2.entitiesBySource((Function1<? super EntitySource, Boolean>)((Function1)anonymize.1.INSTANCE));
        boolean $i$f$flatMap = false;
        Map<EntitySource, Map<Class<? extends WorkspaceEntity>, List<WorkspaceEntity>>> map2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        void var8_9 = $this$flatMapTo$iv$iv;
        boolean bl = false;
        Iterator iterator2 = var8_9.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $this$flatMapTo$iv$iv2;
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl2 = false;
            Map $this$flatMap$iv2 = (Map)it.getValue();
            boolean $i$f$flatMap2 = false;
            Map map3 = $this$flatMap$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            void var19_21 = $this$flatMapTo$iv$iv2;
            boolean bl3 = false;
            Iterator iterator3 = var19_21.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry element$iv$iv2;
                Map.Entry it2 = element$iv$iv2 = iterator3.next();
                boolean bl4 = false;
                Iterable list$iv$iv = (List)it2.getValue();
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WorkspaceEntity entity = (WorkspaceEntity)element$iv;
            boolean bl5 = false;
            builder2.changeSource(entity, ErrorReportingKt.anonymize(entity.getEntitySource(), sourceFilter));
        }
        return builder2.toStorage();
    }

    @NotNull
    public static final Map<Long, ChangeEntry> anonymize(@NotNull Map<Long, ChangeEntry> $this$anonymize) {
        Intrinsics.checkNotNullParameter($this$anonymize, (String)"$this$anonymize");
        if (!ErrorReportingKt.isWrapped()) {
            return $this$anonymize;
        }
        HashMap<Long, ChangeEntry> result2 = new HashMap<Long, ChangeEntry>($this$anonymize);
        result2.replaceAll(anonymize.4.INSTANCE);
        return result2;
    }

    @NotNull
    public static final EntitySource anonymize(@NotNull EntitySource $this$anonymize, @Nullable Function1<? super EntitySource, Boolean> sourceFilter) {
        Intrinsics.checkNotNullParameter((Object)$this$anonymize, (String)"$this$anonymize");
        return sourceFilter != null ? (((Boolean)sourceFilter.invoke((Object)$this$anonymize)).booleanValue() ? (EntitySource)new MatchedEntitySource($this$anonymize.toString()) : (EntitySource)new UnmatchedEntitySource($this$anonymize.toString())) : (EntitySource)new AnonymizedEntitySource($this$anonymize.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final File serializeContentToFolder(Path contentFolder, WorkspaceEntityStorage left, WorkspaceEntityStorage right, WorkspaceEntityStorage resulting, Function1<? super EntitySource, Boolean> sourceFilter) {
        File file2;
        Object object;
        Object entitySourceFilter2;
        Path operationFile;
        boolean bl;
        WorkspaceEntityStorage workspaceEntityStorage;
        FileAttribute[] it;
        boolean bl2;
        boolean bl3;
        FileAttribute[] fileAttributeArray;
        if (right instanceof WorkspaceEntityStorageBuilder) {
            Path path2 = contentFolder.resolve("Right_Diff_Log");
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"contentFolder.resolve(\"Right_Diff_Log\")");
            ErrorReportingKt.serializeContent(path2, (Function2<? super EntityStorageSerializerImpl, ? super OutputStream, Unit>)((Function2)new Function2<EntityStorageSerializerImpl, OutputStream, Unit>(right){
                final /* synthetic */ WorkspaceEntityStorage $right;

                public final void invoke(@NotNull EntityStorageSerializerImpl serializer2, @NotNull OutputStream stream) {
                    Intrinsics.checkNotNullParameter((Object)serializer2, (String)"serializer");
                    Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
                    WorkspaceEntityStorage workspaceEntityStorage = this.$right;
                    if (workspaceEntityStorage == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityStorageBuilderImpl");
                    }
                    WorkspaceEntityStorageBuilderImpl cfr_ignored_0 = (WorkspaceEntityStorageBuilderImpl)workspaceEntityStorage;
                    ErrorReportingKt.access$serializeDiff((WorkspaceEntityStorageBuilderImpl)this.$right, serializer2, stream);
                }
                {
                    this.$right = workspaceEntityStorage;
                    super(2);
                }
            }));
        }
        FileAttribute[] fileAttributeArray2 = left;
        if (left != null && (fileAttributeArray2 = ErrorReportingKt.anonymize((WorkspaceEntityStorage)fileAttributeArray2, sourceFilter)) != null) {
            fileAttributeArray = fileAttributeArray2;
            bl3 = false;
            bl2 = false;
            it = fileAttributeArray;
            boolean bl4 = false;
            Path path3 = contentFolder.resolve("Left_Store");
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"contentFolder.resolve(\"Left_Store\")");
            ErrorReportingKt.serializeEntityStorage(path3, (WorkspaceEntityStorage)it);
        }
        if ((workspaceEntityStorage = right) != null && (workspaceEntityStorage = ErrorReportingKt.anonymize(workspaceEntityStorage, sourceFilter)) != null) {
            fileAttributeArray = workspaceEntityStorage;
            bl3 = false;
            bl2 = false;
            it = fileAttributeArray;
            bl = false;
            Path path4 = contentFolder.resolve("Right_Store");
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"contentFolder.resolve(\"Right_Store\")");
            ErrorReportingKt.serializeEntityStorage(path4, (WorkspaceEntityStorage)it);
        }
        Path path5 = contentFolder.resolve("Res_Store");
        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"contentFolder.resolve(\"Res_Store\")");
        ErrorReportingKt.serializeEntityStorage(path5, ErrorReportingKt.anonymize(resulting, sourceFilter));
        Path path6 = contentFolder.resolve("ClassToIntConverter");
        Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"contentFolder.resolve(\"ClassToIntConverter\")");
        ErrorReportingKt.serializeContent(path6, (Function2<? super EntityStorageSerializerImpl, ? super OutputStream, Unit>)((Function2)serializeContentToFolder.4.INSTANCE));
        String operationName = sourceFilter == null ? "Add_Diff" : "Replace_By_Source";
        Path path7 = operationFile = contentFolder.resolve(operationName);
        Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"operationFile");
        Path path8 = path7;
        it = new FileAttribute[]{};
        bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(path8, Arrays.copyOf(it, it.length)), (String)"Files.createFile(this, *attributes)");
        if (!ErrorReportingKt.isWrapped()) {
            String string;
            if (sourceFilter != null) {
                void $this$fold$iv;
                Object object2;
                WorkspaceEntityStorage workspaceEntityStorage2;
                HashSet allEntitySources;
                HashSet hashSet;
                FileAttribute[] fileAttributeArray3 = left;
                if (!(left instanceof AbstractEntityStorage)) {
                    fileAttributeArray3 = null;
                }
                if ((hashSet = (AbstractEntityStorage)fileAttributeArray3) == null || (hashSet = ((AbstractEntityStorage)((Object)hashSet)).getIndexes$intellij_platform_workspaceModel_storage()) == null || (hashSet = ((StorageIndexes)((Object)hashSet)).getEntitySourceIndex$intellij_platform_workspaceModel_storage()) == null || (hashSet = ((EntityStorageInternalIndex)((Object)hashSet)).entries$intellij_platform_workspaceModel_storage()) == null || (hashSet = CollectionsKt.toHashSet((Iterable)hashSet)) == null) {
                    bl = false;
                    hashSet = allEntitySources = new HashSet();
                }
                if (!((workspaceEntityStorage2 = right) instanceof AbstractEntityStorage)) {
                    workspaceEntityStorage2 = null;
                }
                if ((object2 = (AbstractEntityStorage)workspaceEntityStorage2) == null || (object2 = ((AbstractEntityStorage)object2).getIndexes$intellij_platform_workspaceModel_storage()) == null || (object2 = ((StorageIndexes)object2).getEntitySourceIndex$intellij_platform_workspaceModel_storage()) == null || (object2 = ((EntityStorageInternalIndex)object2).entries$intellij_platform_workspaceModel_storage()) == null) {
                    object2 = SetsKt.emptySet();
                }
                allEntitySources.addAll(object2);
                Iterable $this$sortedBy$iv = allEntitySources;
                boolean $i$f$sortedBy = false;
                boolean bl5 = false;
                $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        EntitySource it = (EntitySource)a;
                        boolean bl2 = false;
                        Comparable comparable = (Comparable)((Object)it.toString());
                        it = (EntitySource)b;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        String string = it.toString();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                    }
                });
                String initial$iv = "";
                boolean $i$f$fold = false;
                String accumulator$iv = initial$iv;
                for (Object element$iv : $this$fold$iv) {
                    void source;
                    EntitySource entitySource = (EntitySource)element$iv;
                    String acc = accumulator$iv;
                    boolean bl6 = false;
                    accumulator$iv = acc + ((Boolean)sourceFilter.invoke((Object)source) != false ? "1" : "0");
                }
                string = accumulator$iv;
            } else {
                string = "";
            }
            entitySourceFilter2 = string;
            PathsKt.writeText$default((Path)operationFile, (CharSequence)((CharSequence)entitySourceFilter2), null, (OpenOption[])new OpenOption[0], (int)2, null);
        }
        if (ErrorReportingKt.isWrapped()) {
            Path path9 = contentFolder.resolve("Report_Wrapped");
            Intrinsics.checkNotNullExpressionValue((Object)path9, (String)"contentFolder.resolve(\"Report_Wrapped\")");
            entitySourceFilter2 = path9;
            object = new FileAttribute[]{};
            boolean bl7 = false;
            Intrinsics.checkNotNullExpressionValue((Object)Files.createFile((Path)entitySourceFilter2, Arrays.copyOf(object, ((FileAttribute[])object).length)), (String)"Files.createFile(this, *attributes)");
        }
        if (!ErrorReportingKt.executingOnTC()) {
            File zipFile = contentFolder.getParent().resolve(PathsKt.getName((Path)contentFolder) + ".zip").toFile();
            object = (Closeable)new Compressor.Zip(zipFile);
            boolean bl8 = false;
            boolean bl9 = false;
            Throwable throwable = null;
            try {
                Compressor.Zip it2 = (Compressor.Zip)object;
                boolean bl10 = false;
                it2.addDirectory(contentFolder.toFile());
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            FileUtil.delete((Path)contentFolder);
            file2 = zipFile;
        } else {
            file2 = null;
        }
        return file2;
    }

    public static final void reportConsistencyIssue(@NotNull String message2, @NotNull Throwable e, @Nullable Function1<? super EntitySource, Boolean> sourceFilter, @Nullable WorkspaceEntityStorage left, @Nullable WorkspaceEntityStorage right, @NotNull WorkspaceEntityStorage resulting) {
        File zipFile;
        File file2;
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)resulting, (String)"resulting");
        String finalMessage = message2 + "\n\n";
        finalMessage = finalMessage + "\nVersion: v30";
        if (ConsistencyCheckingMode.Companion.getCurrent() != ConsistencyCheckingMode.DISABLED) {
            Path dumpDirectory = ErrorReportingKt.getStoreDumpDirectory();
            finalMessage = finalMessage + "\nSaving store content at: " + dumpDirectory;
            file2 = ErrorReportingKt.serializeContentToFolder(dumpDirectory, left, right, resulting, sourceFilter);
        } else {
            file2 = zipFile = null;
        }
        if (zipFile != null) {
            Attachment attachment = new Attachment("workspaceModelDump.zip", FilesKt.readBytes(zipFile), "Zip of workspace model store");
            attachment.setIncluded(true);
            AbstractEntityStorage.Companion.getLOG().error(finalMessage, e, new Attachment[]{attachment});
        } else {
            AbstractEntityStorage.Companion.getLOG().error(finalMessage, e);
        }
    }

    private static final boolean isWrapped() {
        return Registry.is((String)"ide.new.project.model.report.wrapped", (boolean)true);
    }

    public static final /* synthetic */ WorkspaceEntityStorage access$makeSureItsStore(WorkspaceEntityStorage $this$access_u24makeSureItsStore) {
        return ErrorReportingKt.makeSureItsStore($this$access_u24makeSureItsStore);
    }

    public static final /* synthetic */ void access$serializeDiff(WorkspaceEntityStorageBuilderImpl $this$access_u24serializeDiff, EntityStorageSerializerImpl serializer2, OutputStream stream) {
        ErrorReportingKt.serializeDiff($this$access_u24serializeDiff, serializer2, stream);
    }
}

