/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ExceptionUtil;
import com.intellij.workspaceModel.storage.ClassConversion;
import com.intellij.workspaceModel.storage.EntityChange;
import com.intellij.workspaceModel.storage.EntitySource;
import com.intellij.workspaceModel.storage.ModifiableWorkspaceEntity;
import com.intellij.workspaceModel.storage.MutableExternalEntityMapping;
import com.intellij.workspaceModel.storage.PersistentEntityId;
import com.intellij.workspaceModel.storage.UtilsKt;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageBuilder;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageDiffBuilder;
import com.intellij.workspaceModel.storage.WorkspaceEntityWithPersistentId;
import com.intellij.workspaceModel.storage.impl.AbstractEntityStorage;
import com.intellij.workspaceModel.storage.impl.AddDiffOperation;
import com.intellij.workspaceModel.storage.impl.ChangeEntry;
import com.intellij.workspaceModel.storage.impl.ChildEntityId;
import com.intellij.workspaceModel.storage.impl.ClassToIntConverter;
import com.intellij.workspaceModel.storage.impl.ClassToIntConverterKt;
import com.intellij.workspaceModel.storage.impl.ConnectionId;
import com.intellij.workspaceModel.storage.impl.ConsistencyCheckerKt;
import com.intellij.workspaceModel.storage.impl.EntitiesKt;
import com.intellij.workspaceModel.storage.impl.EntityIdKt;
import com.intellij.workspaceModel.storage.impl.ErrorReportingKt;
import com.intellij.workspaceModel.storage.impl.ImmutableEntitiesBarrel;
import com.intellij.workspaceModel.storage.impl.ModifiableWorkspaceEntityBase;
import com.intellij.workspaceModel.storage.impl.MutableEntitiesBarrel;
import com.intellij.workspaceModel.storage.impl.MutableRefsTable;
import com.intellij.workspaceModel.storage.impl.MutableStorageIndexes;
import com.intellij.workspaceModel.storage.impl.ParentEntityId;
import com.intellij.workspaceModel.storage.impl.RefsTable;
import com.intellij.workspaceModel.storage.impl.RefsTableKt;
import com.intellij.workspaceModel.storage.impl.ReplaceBySourceAsGraph;
import com.intellij.workspaceModel.storage.impl.SoftLinkable;
import com.intellij.workspaceModel.storage.impl.StorageIndexes;
import com.intellij.workspaceModel.storage.impl.WorkspaceBuilderChangeLog;
import com.intellij.workspaceModel.storage.impl.WorkspaceBuilderChangeLogKt;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityBase;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityData;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityStorageBuilderImpl;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityStorageImpl;
import com.intellij.workspaceModel.storage.impl.containers.ContainerExtensionsKt;
import com.intellij.workspaceModel.storage.impl.exceptions.AddDiffException;
import com.intellij.workspaceModel.storage.impl.exceptions.PersistentIdAlreadyExistsException;
import com.intellij.workspaceModel.storage.impl.external.MutableExternalEntityMappingImpl;
import com.intellij.workspaceModel.storage.impl.indices.EntityStorageInternalIndex;
import com.intellij.workspaceModel.storage.impl.indices.VirtualFileIndex;
import com.intellij.workspaceModel.storage.url.MutableVirtualFileUrlIndex;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 b2\u00020\u00012\u00020\u0002:\u0001bB'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ>\u0010!\u001a\u00020\"2\n\u0010#\u001a\u00060\u0015j\u0002`$2\u0010\u0010%\u001a\f\u0012\b\u0012\u00060\u0015j\u0002`$0&2\u0016\u0010'\u001a\u0012\u0012\b\u0012\u00060\u0015j\u0002`$\u0012\u0004\u0012\u00020\n0(H\u0002J\u0010\u0010)\u001a\u00020\"2\u0006\u0010*\u001a\u00020+H\u0016J'\u0010,\u001a\u00020\"2\u0006\u0010-\u001a\u00020\u001b2\b\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u00020/H\u0000\u00a2\u0006\u0002\b1JV\u00102\u001a\u0002H3\"\u000e\b\u0000\u00104*\b\u0012\u0004\u0012\u0002H305\"\b\b\u0001\u00103*\u0002062\f\u00107\u001a\b\u0012\u0004\u0012\u0002H4082\u0006\u00109\u001a\u00020:2\u0017\u0010;\u001a\u0013\u0012\u0004\u0012\u0002H4\u0012\u0004\u0012\u00020\"0(\u00a2\u0006\u0002\b<H\u0016\u00a2\u0006\u0002\u0010=J\u0018\u0010>\u001a\u00020\"2\u0006\u0010*\u001a\u00020\u00022\u0006\u0010?\u001a\u00020\u001bH\u0002J'\u0010@\u001a\u0002H3\"\b\b\u0000\u00103*\u0002062\u0006\u0010A\u001a\u0002H32\u0006\u0010B\u001a\u00020:H\u0016\u00a2\u0006\u0002\u0010CJ*\u0010D\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u000308\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030G0F0E2\u0006\u0010H\u001a\u00020/H\u0016J%\u0010I\u001a\u00020\"\"\b\b\u0000\u00103*\u0002062\f\u0010J\u001a\b\u0012\u0004\u0012\u0002H30KH\u0000\u00a2\u0006\u0002\bLJ\u001c\u0010M\u001a\b\u0012\u0004\u0012\u0002H30N\"\u0004\b\u0000\u001032\u0006\u0010O\u001a\u00020\u001bH\u0016J\b\u0010P\u001a\u00020QH\u0016J\r\u0010R\u001a\u00020\"H\u0000\u00a2\u0006\u0002\bSJ\b\u0010T\u001a\u00020\nH\u0016J\b\u0010U\u001a\u00020\"H\u0002JX\u0010V\u001a\u0002H3\"\u0010\b\u0000\u00104*\n\u0012\u0006\b\u0001\u0012\u0002H305\"\b\b\u0001\u00103*\u0002062\f\u00107\u001a\b\u0012\u0004\u0012\u0002H4082\u0006\u0010A\u001a\u0002H32\u0017\u0010W\u001a\u0013\u0012\u0004\u0012\u0002H4\u0012\u0004\u0012\u00020\"0(\u00a2\u0006\u0002\b<H\u0016\u00a2\u0006\u0002\u0010XJ\u0010\u0010Y\u001a\u00020\"2\u0006\u0010A\u001a\u000206H\u0016J3\u0010Y\u001a\u00020\"2\n\u0010Z\u001a\u00060\u0015j\u0002`$2\u0018\b\u0002\u0010'\u001a\u0012\u0012\b\u0012\u00060\u0015j\u0002`$\u0012\u0004\u0012\u00020\n0(H\u0000\u00a2\u0006\u0002\b[J$\u0010\\\u001a\u00020\"2\u0012\u0010]\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020\n0(2\u0006\u0010^\u001a\u00020/H\u0016J\b\u0010_\u001a\u00020`H\u0016J\b\u0010a\u001a\u00020\"H\u0002R\u0014\u0010\f\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0003\u001a\u00020\u0004X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0007\u001a\u00020\bX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0005\u001a\u00020\u0006X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006c"}, d2={"Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageBuilderImpl;", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorageBuilder;", "Lcom/intellij/workspaceModel/storage/impl/AbstractEntityStorage;", "entitiesByType", "Lcom/intellij/workspaceModel/storage/impl/MutableEntitiesBarrel;", "refs", "Lcom/intellij/workspaceModel/storage/impl/MutableRefsTable;", "indexes", "Lcom/intellij/workspaceModel/storage/impl/MutableStorageIndexes;", "trackStackTrace", "", "(Lcom/intellij/workspaceModel/storage/impl/MutableEntitiesBarrel;Lcom/intellij/workspaceModel/storage/impl/MutableRefsTable;Lcom/intellij/workspaceModel/storage/impl/MutableStorageIndexes;Z)V", "changeLog", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceBuilderChangeLog;", "getChangeLog$intellij_platform_workspaceModel_storage", "()Lcom/intellij/workspaceModel/storage/impl/WorkspaceBuilderChangeLog;", "getEntitiesByType$intellij_platform_workspaceModel_storage", "()Lcom/intellij/workspaceModel/storage/impl/MutableEntitiesBarrel;", "getIndexes$intellij_platform_workspaceModel_storage", "()Lcom/intellij/workspaceModel/storage/impl/MutableStorageIndexes;", "modificationCount", "", "getModificationCount", "()J", "getRefs$intellij_platform_workspaceModel_storage", "()Lcom/intellij/workspaceModel/storage/impl/MutableRefsTable;", "stackTrace", "", "threadId", "Ljava/lang/Long;", "threadName", "writingFlag", "Ljava/util/concurrent/atomic/AtomicBoolean;", "accumulateEntitiesToRemove", "", "id", "Lcom/intellij/workspaceModel/storage/impl/EntityId;", "accumulator", "", "entityFilter", "Lkotlin/Function1;", "addDiff", "diff", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorageDiffBuilder;", "addDiffAndReport", "message", "left", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;", "right", "addDiffAndReport$intellij_platform_workspaceModel_storage", "addEntity", "T", "M", "Lcom/intellij/workspaceModel/storage/ModifiableWorkspaceEntity;", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "clazz", "Ljava/lang/Class;", "source", "Lcom/intellij/workspaceModel/storage/EntitySource;", "initializer", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/Class;Lcom/intellij/workspaceModel/storage/EntitySource;Lkotlin/jvm/functions/Function1;)Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "applyDiffProtection", "method", "changeSource", "e", "newSource", "(Lcom/intellij/workspaceModel/storage/WorkspaceEntity;Lcom/intellij/workspaceModel/storage/EntitySource;)Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "collectChanges", "", "", "Lcom/intellij/workspaceModel/storage/EntityChange;", "original", "createAddEvent", "pEntityData", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityData;", "createAddEvent$intellij_platform_workspaceModel_storage", "getMutableExternalMapping", "Lcom/intellij/workspaceModel/storage/MutableExternalEntityMapping;", "identifier", "getMutableVirtualFileUrlIndex", "Lcom/intellij/workspaceModel/storage/url/MutableVirtualFileUrlIndex;", "incModificationCount", "incModificationCount$intellij_platform_workspaceModel_storage", "isEmpty", "lockWrite", "modifyEntity", "change", "(Ljava/lang/Class;Lcom/intellij/workspaceModel/storage/WorkspaceEntity;Lkotlin/jvm/functions/Function1;)Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "removeEntity", "idx", "removeEntity$intellij_platform_workspaceModel_storage", "replaceBySource", "sourceFilter", "replaceWith", "toStorage", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageImpl;", "unlockWrite", "Companion", "intellij.platform.workspaceModel.storage"})
public final class WorkspaceEntityStorageBuilderImpl
extends AbstractEntityStorage
implements WorkspaceEntityStorageBuilder {
    @NotNull
    private final WorkspaceBuilderChangeLog changeLog;
    private final AtomicBoolean writingFlag;
    private volatile String stackTrace;
    private volatile Long threadId;
    private volatile String threadName;
    @NotNull
    private final MutableEntitiesBarrel entitiesByType;
    @NotNull
    private final MutableRefsTable refs;
    @NotNull
    private final MutableStorageIndexes indexes;
    private volatile boolean trackStackTrace;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final WorkspaceBuilderChangeLog getChangeLog$intellij_platform_workspaceModel_storage() {
        return this.changeLog;
    }

    public final void incModificationCount$intellij_platform_workspaceModel_storage() {
        WorkspaceBuilderChangeLog workspaceBuilderChangeLog = this.changeLog;
        long l = workspaceBuilderChangeLog.getModificationCount();
        workspaceBuilderChangeLog.setModificationCount(l + 1L);
    }

    @Override
    public long getModificationCount() {
        return this.changeLog.getModificationCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public <M extends ModifiableWorkspaceEntity<T>, T extends WorkspaceEntity> T addEntity(@NotNull Class<M> clazz, @NotNull EntitySource source, @NotNull Function1<? super M, Unit> initializer) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(initializer, (String)"initializer");
        try {
            boolean bl;
            ModifiableWorkspaceEntity modifiableEntity;
            this.lockWrite();
            Class unmodifiableEntityClass = JvmClassMappingKt.getJavaClass(ClassConversion.INSTANCE.modifiableEntityToEntity(JvmClassMappingKt.getKotlinClass(clazz)));
            KClass entityDataClass = ClassConversion.INSTANCE.entityToEntityData(JvmClassMappingKt.getKotlinClass((Class)unmodifiableEntityClass));
            int unmodifiableEntityClassId = ClassToIntConverterKt.toClassId(unmodifiableEntityClass);
            WorkspaceEntityData pEntityData = (WorkspaceEntityData)JvmClassMappingKt.getJavaClass(entityDataClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            pEntityData.setEntitySource(source);
            MutableEntitiesBarrel mutableEntitiesBarrel = this.getEntitiesByType$intellij_platform_workspaceModel_storage();
            WorkspaceEntityData workspaceEntityData = pEntityData;
            Intrinsics.checkNotNullExpressionValue((Object)workspaceEntityData, (String)"pEntityData");
            mutableEntitiesBarrel.add(workspaceEntityData, unmodifiableEntityClassId);
            ModifiableWorkspaceEntity modifiableWorkspaceEntity = pEntityData.wrapAsModifiable$intellij_platform_workspaceModel_storage(this);
            if (modifiableWorkspaceEntity == null) {
                throw new NullPointerException("null cannot be cast to non-null type M");
            }
            ModifiableWorkspaceEntity modifiableWorkspaceEntity2 = modifiableEntity = modifiableWorkspaceEntity;
            if (modifiableWorkspaceEntity2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.ModifiableWorkspaceEntityBase<*>");
            }
            Object this_$iv = (ModifiableWorkspaceEntityBase)modifiableWorkspaceEntity2;
            boolean $i$f$allowModifications$intellij_platform_workspaceModel_storage = false;
            ((ModifiableWorkspaceEntityBase)this_$iv).getModifiable$intellij_platform_workspaceModel_storage().set(true);
            try {
                bl = false;
                initializer.invoke(modifiableEntity);
            }
            finally {
                ((ModifiableWorkspaceEntityBase)this_$iv).getModifiable$intellij_platform_workspaceModel_storage().remove();
            }
            PersistentEntityId<?> persistentEntityId = EntitiesKt.persistentId(pEntityData);
            if (persistentEntityId != null) {
                this_$iv = persistentEntityId;
                $i$f$allowModifications$intellij_platform_workspaceModel_storage = false;
                bl = false;
                Object persistentId = this_$iv;
                boolean bl2 = false;
                Long ids = this.getIndexes$intellij_platform_workspaceModel_storage().getPersistentIdIndex$intellij_platform_workspaceModel_storage().getIdsByEntry$intellij_platform_workspaceModel_storage((PersistentEntityId<?>)persistentId);
                if (ids != null) {
                    WorkspaceEntityData<? extends WorkspaceEntity> existingEntityData = this.entityDataByIdOrDie$intellij_platform_workspaceModel_storage(ids);
                    WorkspaceEntity existingEntity = existingEntityData.createEntity(this);
                    this.removeEntity(existingEntity);
                    LOG.error(StringsKt.trimIndent((String)("\n            addEntity: persistent id already exists. Replacing entity with the new one.\n            Persistent id: " + persistentId + "\n            \n            Existing entity data: " + existingEntityData + "\n            New entity data: " + pEntityData + "\n            \n            Broken consistency: " + this.getBrokenConsistency$intellij_platform_workspaceModel_storage() + "\n          ")), (Throwable)new PersistentIdAlreadyExistsException((PersistentEntityId<?>)persistentId));
                }
            }
            this.createAddEvent$intellij_platform_workspaceModel_storage(pEntityData);
            this.getIndexes$intellij_platform_workspaceModel_storage().entityAdded(pEntityData);
            if (LOG.isTraceEnabled()) {
                Logger $this$trace$iv = LOG;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl3 = false;
                    String string = "New entity added: " + clazz + '-' + pEntityData.getId() + ". PersistentId: " + EntitiesKt.persistentId(pEntityData) + ". Store: " + this + ".\n" + UtilsKt.currentStackTrace(10);
                    logger.trace(string);
                }
            } else {
                Logger $this$debug$iv = LOG;
                Exception e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug$iv.isDebugEnabled()) {
                    Logger logger = $this$debug$iv;
                    boolean bl4 = false;
                    String string = "New entity added: " + clazz + '-' + pEntityData.getId() + ". PersistentId: " + EntitiesKt.persistentId(pEntityData) + '.';
                    logger.debug(string, (Throwable)e$iv);
                }
            }
            Object e = pEntityData.createEntity(this);
            return (T)e;
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <M extends ModifiableWorkspaceEntity<? extends T>, T extends WorkspaceEntity> T modifyEntity(@NotNull Class<M> clazz, @NotNull T e, @NotNull Function1<? super M, Unit> change) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter(e, (String)"e");
        Intrinsics.checkNotNullParameter(change, (String)"change");
        try {
            void $this$flatMapTo$iv$iv;
            this.lockWrite();
            long entityId = ((WorkspaceEntityBase)e).getId$intellij_platform_workspaceModel_storage();
            WorkspaceEntityData<?> workspaceEntityData = WorkspaceBuilderChangeLogKt.getOriginalEntityData(this, entityId);
            if (workspaceEntityData == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityData<T>");
            }
            WorkspaceEntityData<?> originalEntityData = workspaceEntityData;
            WorkspaceEntityData<?> workspaceEntityData2 = this.getEntitiesByType$intellij_platform_workspaceModel_storage().getEntityDataForModification(entityId);
            if (workspaceEntityData2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityData<T>");
            }
            WorkspaceEntityData<?> copiedData = workspaceEntityData2;
            ModifiableWorkspaceEntity<?> modifiableWorkspaceEntity = copiedData.wrapAsModifiable$intellij_platform_workspaceModel_storage(this);
            if (modifiableWorkspaceEntity == null) {
                throw new NullPointerException("null cannot be cast to non-null type M");
            }
            ModifiableWorkspaceEntity<?> modifiableEntity = modifiableWorkspaceEntity;
            PersistentEntityId<?> beforePersistentId = e instanceof WorkspaceEntityWithPersistentId ? ((WorkspaceEntityWithPersistentId)e).persistentId() : null;
            Map<ConnectionId, ParentEntityId> originalParents = WorkspaceBuilderChangeLogKt.getOriginalParents(this, RefsTableKt.asChild(entityId));
            Map<ConnectionId, ParentEntityId> beforeParents = this.getRefs$intellij_platform_workspaceModel_storage().getParentRefsOfChild(RefsTableKt.asChild(entityId));
            Map<ConnectionId, List<ChildEntityId>> $this$flatMap$iv = this.getRefs$intellij_platform_workspaceModel_storage().getChildrenRefsOfParentBy(RefsTableKt.asParent(entityId));
            boolean $i$f$flatMap = false;
            Map<ConnectionId, List<ChildEntityId>> map2 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            void var18_22 = $this$flatMapTo$iv$iv;
            boolean bl = false;
            Iterator iterator2 = var18_22.entrySet().iterator();
            while (iterator2.hasNext()) {
                void $this$mapTo$iv$iv;
                Map.Entry element$iv$iv;
                Map.Entry $dstr$key$value = element$iv$iv = iterator2.next();
                boolean bl2 = false;
                Map.Entry entry2 = $dstr$key$value;
                boolean bl3 = false;
                ConnectionId connectionId = (ConnectionId)entry2.getKey();
                entry2 = $dstr$key$value;
                bl3 = false;
                List value2 = (List)entry2.getValue();
                Iterable $this$map$iv = value2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    void key;
                    ChildEntityId childEntityId = (ChildEntityId)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl4 = false;
                    Pair pair = TuplesKt.to((Object)key, (Object)it);
                    collection.add(pair);
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List beforeChildren = (List)destination$iv$iv;
            ModifiableWorkspaceEntity<?> modifiableWorkspaceEntity2 = modifiableEntity;
            if (modifiableWorkspaceEntity2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.ModifiableWorkspaceEntityBase<*>");
            }
            ModifiableWorkspaceEntityBase this_$iv = (ModifiableWorkspaceEntityBase)modifiableWorkspaceEntity2;
            boolean $i$f$allowModifications$intellij_platform_workspaceModel_storage = false;
            this_$iv.getModifiable$intellij_platform_workspaceModel_storage().set(true);
            try {
                boolean bl5 = false;
                change.invoke(modifiableEntity);
            }
            finally {
                this_$iv.getModifiable$intellij_platform_workspaceModel_storage().remove();
            }
            if (beforePersistentId != null) {
                PersistentEntityId<?> newPersistentId = EntitiesKt.persistentId(copiedData);
                if (newPersistentId != null) {
                    Long ids = this.getIndexes$intellij_platform_workspaceModel_storage().getPersistentIdIndex$intellij_platform_workspaceModel_storage().getIdsByEntry$intellij_platform_workspaceModel_storage(newPersistentId);
                    if (Intrinsics.areEqual(beforePersistentId, newPersistentId) ^ true && ids != null) {
                        WorkspaceEntityData<? extends WorkspaceEntity> existingEntityData = this.entityDataByIdOrDie$intellij_platform_workspaceModel_storage(ids);
                        WorkspaceEntity existingEntity = existingEntityData.createEntity(this);
                        this.removeEntity(existingEntity);
                        LOG.error(StringsKt.trimIndent((String)("\n              modifyEntity: persistent id already exists. Replacing entity with the new one.\n              Old entity: " + existingEntityData + "\n              Persistent id: " + copiedData + "\n              \n              Broken consistency: " + this.getBrokenConsistency$intellij_platform_workspaceModel_storage() + "\n            ")), (Throwable)new PersistentIdAlreadyExistsException(newPersistentId));
                    }
                } else {
                    LOG.error("Persistent id expected for entity: " + copiedData);
                }
            }
            Companion.addReplaceEvent$intellij_platform_workspaceModel_storage(this, entityId, beforeChildren, beforeParents, copiedData, originalEntityData, originalParents);
            Object updatedEntity = copiedData.createEntity(this);
            this.getIndexes$intellij_platform_workspaceModel_storage().updatePersistentIdIndexes(this, (WorkspaceEntity)updatedEntity, beforePersistentId, copiedData, (ModifiableWorkspaceEntityBase)modifiableEntity);
            Object obj2 = updatedEntity;
            return (T)obj2;
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public <T extends WorkspaceEntity> T changeSource(@NotNull T e, @NotNull EntitySource newSource) {
        Intrinsics.checkNotNullParameter(e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)newSource, (String)"newSource");
        try {
            VirtualFileUrl virtualFileUrl;
            this.lockWrite();
            EntitySource originalSource = WorkspaceBuilderChangeLogKt.getOriginalSource(this, ((WorkspaceEntityBase)e).getId$intellij_platform_workspaceModel_storage());
            WorkspaceEntityData<?> workspaceEntityData = this.getEntitiesByType$intellij_platform_workspaceModel_storage().getEntityDataForModification(((WorkspaceEntityBase)e).getId$intellij_platform_workspaceModel_storage());
            if (workspaceEntityData == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityData<T>");
            }
            WorkspaceEntityData<?> copiedData = workspaceEntityData;
            copiedData.setEntitySource(newSource);
            long entityId = copiedData.createEntityId$intellij_platform_workspaceModel_storage();
            this.changeLog.addChangeSourceEvent$intellij_platform_workspaceModel_storage(entityId, copiedData, originalSource);
            ((EntityStorageInternalIndex.MutableEntityStorageInternalIndex)this.getIndexes$intellij_platform_workspaceModel_storage().getEntitySourceIndex$intellij_platform_workspaceModel_storage()).index$intellij_platform_workspaceModel_storage(entityId, newSource);
            VirtualFileUrl virtualFileUrl2 = newSource.getVirtualFileUrl();
            if (virtualFileUrl2 != null) {
                virtualFileUrl = virtualFileUrl2;
                boolean bl = false;
                boolean bl2 = false;
                VirtualFileUrl it = virtualFileUrl;
                boolean bl3 = false;
                this.getIndexes$intellij_platform_workspaceModel_storage().getVirtualFileIndex$intellij_platform_workspaceModel_storage().index$intellij_platform_workspaceModel_storage(entityId, "entitySource", it);
            }
            virtualFileUrl = copiedData.createEntity(this);
            return (T)virtualFileUrl;
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEntity(@NotNull WorkspaceEntity e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        try {
            this.lockWrite();
            Logger $this$debug$iv = LOG;
            Exception e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug$iv.isDebugEnabled()) {
                Logger logger = $this$debug$iv;
                boolean bl = false;
                String string = "Removing " + e.getClass() + "...";
                logger.debug(string, (Throwable)e$iv);
            }
            WorkspaceEntityBase cfr_ignored_0 = (WorkspaceEntityBase)e;
            WorkspaceEntityStorageBuilderImpl.removeEntity$intellij_platform_workspaceModel_storage$default(this, ((WorkspaceEntityBase)e).getId$intellij_platform_workspaceModel_storage(), null, 2, null);
            if (LOG.isTraceEnabled()) {
                ConsistencyCheckerKt.assertConsistency(this);
                LOG.trace("After remove operation storage has no consistency issues");
            }
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceBySource(@NotNull Function1<? super EntitySource, Boolean> sourceFilter, @NotNull WorkspaceEntityStorage replaceWith) {
        Intrinsics.checkNotNullParameter(sourceFilter, (String)"sourceFilter");
        Intrinsics.checkNotNullParameter((Object)replaceWith, (String)"replaceWith");
        try {
            this.lockWrite();
            AbstractEntityStorage cfr_ignored_0 = (AbstractEntityStorage)replaceWith;
            ReplaceBySourceAsGraph.replaceBySourceAsGraph$intellij_platform_workspaceModel_storage$default(ReplaceBySourceAsGraph.INSTANCE, this, replaceWith, sourceFilter, false, 8, null);
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<Class<?>, List<EntityChange<?>>> collectChanges(@NotNull WorkspaceEntityStorage original) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        try {
            Object object;
            this.lockWrite();
            AbstractEntityStorage originalImpl = (AbstractEntityStorage)original;
            HashMap res2 = new HashMap();
            Map<Long, ChangeEntry> map2 = this.changeLog.getChangeLog$intellij_platform_workspaceModel_storage();
            boolean bl = false;
            Iterator<Map.Entry<Long, ChangeEntry>> iterator2 = map2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Object object2;
                void key$iv;
                WorkspaceEntityData<? extends WorkspaceEntity> oldData;
                List answer$iv;
                Object value$iv;
                WorkspaceEntityBase replaceToData;
                WorkspaceEntityBase replacedData;
                Map key$iv2;
                void entityId;
                Object object3 = object = iterator2.next();
                boolean bl2 = false;
                long l = ((Number)object3.getKey()).longValue();
                object3 = object;
                bl2 = false;
                ChangeEntry change = (ChangeEntry)object3.getValue();
                if ((object3 = change) instanceof ChangeEntry.AddEntity) {
                    Object object4;
                    void $this$getOrPut$iv;
                    WorkspaceEntity workspaceEntity = ((ChangeEntry.AddEntity)change).getEntityData().createEntity(this);
                    if (workspaceEntity == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityBase");
                    }
                    WorkspaceEntityBase addedEntity = (WorkspaceEntityBase)workspaceEntity;
                    Map map3 = res2;
                    int $this$findEntityClass$iv = EntityIdKt.getClazz((long)entityId);
                    boolean $i$f$findEntityClass = false;
                    if (ClassToIntConverter.INSTANCE.getClassOrDie($this$findEntityClass$iv) == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<E>");
                    }
                    boolean $i$f$getOrPut = false;
                    Object value$iv2 = $this$getOrPut$iv.get(key$iv2);
                    if (value$iv2 == null) {
                        boolean bl3 = false;
                        List answer$iv2 = new ArrayList();
                        $this$getOrPut$iv.put(key$iv2, answer$iv2);
                        object4 = answer$iv2;
                    } else {
                        object4 = value$iv2;
                    }
                    ((List)object4).add(new EntityChange.Added<WorkspaceEntity>(addedEntity));
                    continue;
                }
                if (object3 instanceof ChangeEntry.RemoveEntity) {
                    Object object5;
                    void key$iv3;
                    void $this$getOrPut$iv;
                    WorkspaceEntityData<? extends WorkspaceEntity> removedData;
                    if (originalImpl.entityDataById$intellij_platform_workspaceModel_storage(((ChangeEntry.RemoveEntity)change).getId()) == null) {
                        continue;
                    }
                    WorkspaceEntity workspaceEntity = removedData.createEntity(originalImpl);
                    if (workspaceEntity == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityBase");
                    }
                    WorkspaceEntityBase removedEntity = (WorkspaceEntityBase)workspaceEntity;
                    key$iv2 = res2;
                    int $this$findEntityClass$iv = EntityIdKt.getClazz((long)entityId);
                    boolean $i$f$findEntityClass = false;
                    if (ClassToIntConverter.INSTANCE.getClassOrDie($this$findEntityClass$iv) == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<E>");
                    }
                    boolean $i$f$getOrPut = false;
                    Object value$iv3 = $this$getOrPut$iv.get(key$iv3);
                    if (value$iv3 == null) {
                        boolean bl4 = false;
                        List answer$iv3 = new ArrayList();
                        $this$getOrPut$iv.put(key$iv3, answer$iv3);
                        object5 = answer$iv3;
                    } else {
                        object5 = value$iv3;
                    }
                    ((List)object5).add(new EntityChange.Removed<WorkspaceEntity>(removedEntity));
                    continue;
                }
                if (object3 instanceof ChangeEntry.ReplaceEntity) {
                    Object object6;
                    void key$iv4;
                    void $this$getOrPut$iv;
                    WorkspaceEntityData<? extends WorkspaceEntity> oldData2;
                    if (originalImpl.entityDataById$intellij_platform_workspaceModel_storage((long)entityId) == null) {
                        continue;
                    }
                    WorkspaceEntity workspaceEntity = oldData2.createEntity(originalImpl);
                    if (workspaceEntity == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityBase");
                    }
                    replacedData = (WorkspaceEntityBase)workspaceEntity;
                    WorkspaceEntity workspaceEntity2 = ((ChangeEntry.ReplaceEntity)change).getNewData().createEntity(this);
                    if (workspaceEntity2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityBase");
                    }
                    replaceToData = (WorkspaceEntityBase)workspaceEntity2;
                    Map key$iv3 = res2;
                    int $this$findEntityClass$iv = EntityIdKt.getClazz((long)entityId);
                    boolean $i$f$findEntityClass = false;
                    if (ClassToIntConverter.INSTANCE.getClassOrDie($this$findEntityClass$iv) == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<E>");
                    }
                    boolean $i$f$getOrPut = false;
                    value$iv = $this$getOrPut$iv.get(key$iv4);
                    if (value$iv == null) {
                        boolean bl5 = false;
                        answer$iv = new ArrayList();
                        $this$getOrPut$iv.put(key$iv4, answer$iv);
                        object6 = answer$iv;
                    } else {
                        object6 = value$iv;
                    }
                    ((List)object6).add(new EntityChange.Replaced<WorkspaceEntity>(replacedData, replaceToData));
                    continue;
                }
                if (object3 instanceof ChangeEntry.ChangeEntitySource) {
                    Object object7;
                    void key$iv5;
                    WorkspaceEntityData<? extends WorkspaceEntity> oldData3;
                    if (originalImpl.entityDataById$intellij_platform_workspaceModel_storage((long)entityId) == null) {
                        continue;
                    }
                    WorkspaceEntity workspaceEntity = oldData3.createEntity(originalImpl);
                    if (workspaceEntity == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityBase");
                    }
                    replacedData = (WorkspaceEntityBase)workspaceEntity;
                    WorkspaceEntity workspaceEntity3 = ((ChangeEntry.ChangeEntitySource)change).getNewData().createEntity(this);
                    if (workspaceEntity3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityBase");
                    }
                    replaceToData = (WorkspaceEntityBase)workspaceEntity3;
                    Map $this$getOrPut$iv = res2;
                    int $this$findEntityClass$iv = EntityIdKt.getClazz((long)entityId);
                    boolean $i$f$findEntityClass = false;
                    if (ClassToIntConverter.INSTANCE.getClassOrDie($this$findEntityClass$iv) == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<E>");
                    }
                    boolean $i$f$getOrPut = false;
                    value$iv = $this$getOrPut$iv.get(key$iv5);
                    if (value$iv == null) {
                        boolean bl6 = false;
                        answer$iv = new ArrayList();
                        $this$getOrPut$iv.put(key$iv5, answer$iv);
                        object7 = answer$iv;
                    } else {
                        object7 = value$iv;
                    }
                    ((List)object7).add(new EntityChange.Replaced<WorkspaceEntity>(replacedData, replaceToData));
                    continue;
                }
                if (!(object3 instanceof ChangeEntry.ReplaceAndChangeSource)) continue;
                if (originalImpl.entityDataById$intellij_platform_workspaceModel_storage((long)entityId) == null) {
                    continue;
                }
                WorkspaceEntity workspaceEntity = oldData.createEntity(originalImpl);
                if (workspaceEntity == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityBase");
                }
                replacedData = (WorkspaceEntityBase)workspaceEntity;
                WorkspaceEntity workspaceEntity4 = ((ChangeEntry.ReplaceAndChangeSource)change).getDataChange().getNewData().createEntity(this);
                if (workspaceEntity4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityBase");
                }
                replaceToData = (WorkspaceEntityBase)workspaceEntity4;
                Map $this$getOrPut$iv = res2;
                int $this$findEntityClass$iv = EntityIdKt.getClazz((long)entityId);
                boolean $i$f$findEntityClass = false;
                if (ClassToIntConverter.INSTANCE.getClassOrDie($this$findEntityClass$iv) == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<E>");
                }
                boolean $i$f$getOrPut = false;
                value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl7 = false;
                    answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                ((List)object2).add(new EntityChange.Replaced<WorkspaceEntity>(replacedData, replaceToData));
            }
            object = res2;
            return object;
        }
        finally {
            this.unlockWrite();
        }
    }

    @Override
    @NotNull
    public WorkspaceEntityStorageImpl toStorage() {
        ImmutableEntitiesBarrel newEntities = this.getEntitiesByType$intellij_platform_workspaceModel_storage().toImmutable();
        RefsTable newRefs = this.getRefs$intellij_platform_workspaceModel_storage().toImmutable();
        StorageIndexes newIndexes = this.getIndexes$intellij_platform_workspaceModel_storage().toImmutable();
        return new WorkspaceEntityStorageImpl(newEntities, newRefs, newIndexes);
    }

    @Override
    public boolean isEmpty() {
        return this.changeLog.getChangeLog$intellij_platform_workspaceModel_storage().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDiff(@NotNull WorkspaceEntityStorageDiffBuilder diff) {
        Intrinsics.checkNotNullParameter((Object)diff, (String)"diff");
        try {
            this.lockWrite();
            WorkspaceEntityStorageBuilderImpl cfr_ignored_0 = (WorkspaceEntityStorageBuilderImpl)diff;
            this.applyDiffProtection((AbstractEntityStorage)((Object)diff), "addDiff");
            new AddDiffOperation(this, (WorkspaceEntityStorageBuilderImpl)diff).addDiff();
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public <T> MutableExternalEntityMapping<T> getMutableExternalMapping(@NotNull String identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        try {
            this.lockWrite();
            MutableExternalEntityMappingImpl<?> mutableExternalEntityMappingImpl = this.getIndexes$intellij_platform_workspaceModel_storage().getExternalMappings$intellij_platform_workspaceModel_storage().computeIfAbsent(identifier, getMutableExternalMapping.mapping.1.INSTANCE);
            if (mutableExternalEntityMappingImpl == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.external.MutableExternalEntityMappingImpl<T>");
            }
            MutableExternalEntityMappingImpl<?> mapping2 = mutableExternalEntityMappingImpl;
            mapping2.setTypedEntityStorage$intellij_platform_workspaceModel_storage(this);
            MutableExternalEntityMapping mutableExternalEntityMapping = mapping2;
            return mutableExternalEntityMapping;
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public MutableVirtualFileUrlIndex getMutableVirtualFileUrlIndex() {
        try {
            this.lockWrite();
            VirtualFileIndex.MutableVirtualFileIndex virtualFileIndex = this.getIndexes$intellij_platform_workspaceModel_storage().getVirtualFileIndex$intellij_platform_workspaceModel_storage();
            virtualFileIndex.setTypedEntityStorage$intellij_platform_workspaceModel_storage(this);
            MutableVirtualFileUrlIndex mutableVirtualFileUrlIndex = virtualFileIndex;
            return mutableVirtualFileUrlIndex;
        }
        finally {
            this.unlockWrite();
        }
    }

    public final void addDiffAndReport$intellij_platform_workspaceModel_storage(@NotNull String message2, @Nullable WorkspaceEntityStorage left, @NotNull WorkspaceEntityStorage right) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        ErrorReportingKt.reportConsistencyIssue(message2, new AddDiffException(message2), null, left, right, this);
    }

    private final void applyDiffProtection(AbstractEntityStorage diff, String method2) {
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            String string = "Applying " + method2 + ". Builder: " + diff;
            logger.trace(string);
        }
        if (diff.getStorageIsAlreadyApplied$intellij_platform_workspaceModel_storage()) {
            LOG.error("Builder is already applied.\n Info: \n" + diff.getApplyInfo$intellij_platform_workspaceModel_storage());
        } else {
            diff.setStorageIsAlreadyApplied$intellij_platform_workspaceModel_storage(true);
            String info2 = "Applying builder using " + method2 + ". Previous stack trace >>>>\n";
            if (LOG.isTraceEnabled()) {
                String string = ExceptionUtil.currentStackTrace();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ExceptionUtil.currentStackTrace()");
                String currentStackTrace2 = string;
                info2 = info2 + '\n' + currentStackTrace2;
            }
            info2 = info2 + "<<<<";
            diff.setApplyInfo$intellij_platform_workspaceModel_storage(info2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void removeEntity$intellij_platform_workspaceModel_storage(long idx, @NotNull Function1<? super Long, Boolean> entityFilter2) {
        Intrinsics.checkNotNullParameter(entityFilter2, (String)"entityFilter");
        Set accumulator = SetsKt.mutableSetOf((Object[])new Long[]{idx});
        this.accumulateEntitiesToRemove(idx, accumulator, entityFilter2);
        Iterable $this$associateWith$iv = accumulator;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            long l = ((Number)element$iv$iv).longValue();
            Object t = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            WorkspaceEntityData<?> workspaceEntityData = WorkspaceBuilderChangeLogKt.getOriginalEntityData(this, (long)it);
            if (workspaceEntityData == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityData<com.intellij.workspaceModel.storage.WorkspaceEntity>");
            }
            Pair pair = TuplesKt.to(workspaceEntityData, WorkspaceBuilderChangeLogKt.getOriginalParents(this, RefsTableKt.asChild((long)it)));
            map2.put(t, pair);
        }
        Map originals = result$iv;
        Iterator<Object> iterator2 = accumulator.iterator();
        while (iterator2.hasNext()) {
            long id2 = ((Number)iterator2.next()).longValue();
            WorkspaceEntityData<? extends WorkspaceEntity> entityData = this.entityDataById$intellij_platform_workspaceModel_storage(id2);
            if (entityData instanceof SoftLinkable) {
                this.getIndexes$intellij_platform_workspaceModel_storage().removeFromSoftLinksIndex((SoftLinkable)((Object)entityData));
            }
            this.getEntitiesByType$intellij_platform_workspaceModel_storage().remove(EntityIdKt.getArrayId(id2), EntityIdKt.getClazz(id2));
        }
        iterator2 = accumulator.iterator();
        while (iterator2.hasNext()) {
            long id3 = ((Number)iterator2.next()).longValue();
            this.getIndexes$intellij_platform_workspaceModel_storage().entityRemoved(id3);
        }
        Iterable $this$forEach$iv = accumulator;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            long it = ((Number)element$iv).longValue();
            boolean bl = false;
            Logger $this$debug$iv = LOG;
            Exception e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug$iv.isDebugEnabled()) {
                Logger logger = $this$debug$iv;
                boolean bl2 = false;
                String string = "Cascade removing: " + ClassToIntConverter.INSTANCE.getClassOrDie(EntityIdKt.getClazz(it)) + '-' + EntityIdKt.getArrayId(it);
                logger.debug(string, (Throwable)e$iv);
            }
            Object v = originals.get(it);
            Intrinsics.checkNotNull(v);
            WorkspaceEntityData workspaceEntityData = (WorkspaceEntityData)((Pair)v).getFirst();
            Object v2 = originals.get(it);
            Intrinsics.checkNotNull(v2);
            this.changeLog.addRemoveEvent$intellij_platform_workspaceModel_storage(it, workspaceEntityData, (Map)((Pair)v2).getSecond());
        }
    }

    public static /* synthetic */ void removeEntity$intellij_platform_workspaceModel_storage$default(WorkspaceEntityStorageBuilderImpl workspaceEntityStorageBuilderImpl, long l, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = removeEntity.2.INSTANCE;
        }
        workspaceEntityStorageBuilderImpl.removeEntity$intellij_platform_workspaceModel_storage(l, (Function1<? super Long, Boolean>)function1);
    }

    private final void lockWrite() {
        Thread currentThread = Thread.currentThread();
        if (this.writingFlag.getAndSet(true) && this.threadId != null) {
            Long l = this.threadId;
            Thread thread = currentThread;
            Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"currentThread");
            long l2 = thread.getId();
            if (l == null || l != l2) {
                LOG.error(StringsKt.trimIndent((String)("\n            Concurrent write to builder from the following threads\n            First Thread: " + this.threadName + "\n            Second Thread: " + currentThread.getName() + "\n            Previous stack trace: " + this.stackTrace + "\n          ")));
                this.trackStackTrace = true;
            }
        }
        if (this.trackStackTrace || LOG.isTraceEnabled()) {
            this.stackTrace = ExceptionUtil.currentStackTrace();
        }
        Thread thread = currentThread;
        Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"currentThread");
        this.threadId = thread.getId();
        this.threadName = currentThread.getName();
    }

    private final void unlockWrite() {
        this.writingFlag.set(false);
        this.stackTrace = null;
        this.threadId = null;
        this.threadName = null;
    }

    public final <T extends WorkspaceEntity> void createAddEvent$intellij_platform_workspaceModel_storage(@NotNull WorkspaceEntityData<T> pEntityData) {
        Intrinsics.checkNotNullParameter(pEntityData, (String)"pEntityData");
        long entityId = pEntityData.createEntityId$intellij_platform_workspaceModel_storage();
        this.changeLog.addAddEvent$intellij_platform_workspaceModel_storage(entityId, pEntityData);
    }

    /*
     * WARNING - void declaration
     */
    private final void accumulateEntitiesToRemove(long id2, Set<Long> accumulator, Function1<? super Long, Boolean> entityFilter2) {
        Map<ConnectionId, List<ChildEntityId>> children2 = this.getRefs$intellij_platform_workspaceModel_storage().getChildrenRefsOfParentBy(RefsTableKt.asParent(id2));
        Iterator<Map.Entry<ConnectionId, ParentEntityId>> iterator2 = children2;
        boolean bl = false;
        Object object = iterator2.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry<ConnectionId, List<ChildEntityId>> entry2;
            Map.Entry<ConnectionId, List<ChildEntityId>> entry3 = entry2 = object.next();
            boolean bl2 = false;
            iterator2 = entry3.getKey();
            entry3 = entry2;
            bl2 = false;
            List<ChildEntityId> childrenIds = entry3.getValue();
            for (ChildEntityId childId : childrenIds) {
                void connectionId;
                if (accumulator.contains(childId.getId()) || !((Boolean)entityFilter2.invoke((Object)childId.getId())).booleanValue()) continue;
                accumulator.add(childId.getId());
                this.accumulateEntitiesToRemove(childId.getId(), accumulator, entityFilter2);
                this.getRefs$intellij_platform_workspaceModel_storage().removeRefsByParent((ConnectionId)connectionId, RefsTableKt.asParent(id2));
            }
        }
        Map<ConnectionId, ParentEntityId> parents2 = this.getRefs$intellij_platform_workspaceModel_storage().getParentRefsOfChild(RefsTableKt.asChild(id2));
        Object childrenIds = parents2;
        boolean childId = false;
        iterator2 = childrenIds.entrySet().iterator();
        while (iterator2.hasNext()) {
            void connectionId;
            Object object2 = object = iterator2.next();
            boolean bl3 = false;
            childrenIds = (ConnectionId)object2.getKey();
            object2 = object;
            bl3 = false;
            ParentEntityId parent = (ParentEntityId)object2.getValue();
            this.getRefs$intellij_platform_workspaceModel_storage().removeParentToChildRef((ConnectionId)connectionId, parent, RefsTableKt.asChild(id2));
        }
    }

    @Override
    @NotNull
    public MutableEntitiesBarrel getEntitiesByType$intellij_platform_workspaceModel_storage() {
        return this.entitiesByType;
    }

    @Override
    @NotNull
    public MutableRefsTable getRefs$intellij_platform_workspaceModel_storage() {
        return this.refs;
    }

    @Override
    @NotNull
    public MutableStorageIndexes getIndexes$intellij_platform_workspaceModel_storage() {
        return this.indexes;
    }

    public WorkspaceEntityStorageBuilderImpl(@NotNull MutableEntitiesBarrel entitiesByType, @NotNull MutableRefsTable refs, @NotNull MutableStorageIndexes indexes, boolean trackStackTrace) {
        Intrinsics.checkNotNullParameter((Object)entitiesByType, (String)"entitiesByType");
        Intrinsics.checkNotNullParameter((Object)refs, (String)"refs");
        Intrinsics.checkNotNullParameter((Object)indexes, (String)"indexes");
        super(null);
        this.entitiesByType = entitiesByType;
        this.refs = refs;
        this.indexes = indexes;
        this.trackStackTrace = trackStackTrace;
        this.changeLog = new WorkspaceBuilderChangeLog();
        this.writingFlag = new AtomicBoolean();
    }

    public /* synthetic */ WorkspaceEntityStorageBuilderImpl(MutableEntitiesBarrel mutableEntitiesBarrel, MutableRefsTable mutableRefsTable, MutableStorageIndexes mutableStorageIndexes, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        this(mutableEntitiesBarrel, mutableRefsTable, mutableStorageIndexes, bl);
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(WorkspaceEntityStorageBuilderImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ void access$setTrackStackTrace$p(WorkspaceEntityStorageBuilderImpl $this, boolean bl) {
        $this.trackStackTrace = bl;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0083\u0001\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u00060\u000bj\u0002`\f2\u0018\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f0\u000e2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00140\u00132\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u00162\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u00162\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00140\u0013H\u0000\u00a2\u0006\u0002\b\u001aJ\u0006\u0010\u001b\u001a\u00020\tJ\u000e\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001eR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageBuilderImpl$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "addReplaceEvent", "", "builder", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageBuilderImpl;", "entityId", "", "Lcom/intellij/workspaceModel/storage/impl/EntityId;", "beforeChildren", "", "Lkotlin/Pair;", "Lcom/intellij/workspaceModel/storage/impl/ConnectionId;", "Lcom/intellij/workspaceModel/storage/impl/ChildEntityId;", "beforeParents", "", "Lcom/intellij/workspaceModel/storage/impl/ParentEntityId;", "copiedData", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityData;", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "originalEntity", "originalParents", "addReplaceEvent$intellij_platform_workspaceModel_storage", "create", "from", "storage", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;", "intellij.platform.workspaceModel.storage"})
    public static final class Companion {
        @NotNull
        public final WorkspaceEntityStorageBuilderImpl create() {
            return this.from(WorkspaceEntityStorageImpl.Companion.getEMPTY());
        }

        @NotNull
        public final WorkspaceEntityStorageBuilderImpl from(@NotNull WorkspaceEntityStorage storage2) {
            WorkspaceEntityStorageBuilderImpl workspaceEntityStorageBuilderImpl;
            MutableRefsTable copiedRefs;
            MutableEntitiesBarrel copiedBarrel;
            Intrinsics.checkNotNullParameter((Object)storage2, (String)"storage");
            AbstractEntityStorage cfr_ignored_0 = (AbstractEntityStorage)storage2;
            WorkspaceEntityStorage workspaceEntityStorage = storage2;
            if (workspaceEntityStorage instanceof WorkspaceEntityStorageImpl) {
                copiedBarrel = MutableEntitiesBarrel.Companion.from(((WorkspaceEntityStorageImpl)storage2).getEntitiesByType$intellij_platform_workspaceModel_storage());
                copiedRefs = MutableRefsTable.Companion.from(((WorkspaceEntityStorageImpl)storage2).getRefs$intellij_platform_workspaceModel_storage());
                MutableStorageIndexes copiedIndex = ((AbstractEntityStorage)storage2).getIndexes$intellij_platform_workspaceModel_storage().toMutable();
                workspaceEntityStorageBuilderImpl = new WorkspaceEntityStorageBuilderImpl(copiedBarrel, copiedRefs, copiedIndex, false, 8, null);
            } else if (workspaceEntityStorage instanceof WorkspaceEntityStorageBuilderImpl) {
                copiedBarrel = MutableEntitiesBarrel.Companion.from(((WorkspaceEntityStorageBuilderImpl)storage2).getEntitiesByType$intellij_platform_workspaceModel_storage().toImmutable());
                copiedRefs = MutableRefsTable.Companion.from(((WorkspaceEntityStorageBuilderImpl)storage2).getRefs$intellij_platform_workspaceModel_storage().toImmutable());
                MutableStorageIndexes copiedIndexes = ((WorkspaceEntityStorageBuilderImpl)storage2).getIndexes$intellij_platform_workspaceModel_storage().toMutable();
                workspaceEntityStorageBuilderImpl = new WorkspaceEntityStorageBuilderImpl(copiedBarrel, copiedRefs, copiedIndexes, ((WorkspaceEntityStorageBuilderImpl)storage2).trackStackTrace);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            WorkspaceEntityStorageBuilderImpl newBuilder = workspaceEntityStorageBuilderImpl;
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                String string = "Create new builder " + newBuilder + " from " + storage2 + ".\n" + UtilsKt.currentStackTrace(10);
                logger.trace(string);
            }
            return newBuilder;
        }

        /*
         * WARNING - void declaration
         */
        public final void addReplaceEvent$intellij_platform_workspaceModel_storage(@NotNull WorkspaceEntityStorageBuilderImpl builder2, long entityId, @NotNull List<Pair<ConnectionId, ChildEntityId>> beforeChildren, @NotNull Map<ConnectionId, ParentEntityId> beforeParents, @NotNull WorkspaceEntityData<? extends WorkspaceEntity> copiedData, @NotNull WorkspaceEntityData<? extends WorkspaceEntity> originalEntity, @NotNull Map<ConnectionId, ParentEntityId> originalParents) {
            void removedChildren;
            Object list$iv$iv;
            void $this$flatMapTo$iv$iv;
            Map<ConnectionId, List<ChildEntityId>> unmappedChildren;
            Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
            Intrinsics.checkNotNullParameter(beforeChildren, (String)"beforeChildren");
            Intrinsics.checkNotNullParameter(beforeParents, (String)"beforeParents");
            Intrinsics.checkNotNullParameter(copiedData, (String)"copiedData");
            Intrinsics.checkNotNullParameter(originalEntity, (String)"originalEntity");
            Intrinsics.checkNotNullParameter(originalParents, (String)"originalParents");
            Map<ConnectionId, ParentEntityId> parents2 = builder2.getRefs$intellij_platform_workspaceModel_storage().getParentRefsOfChild(RefsTableKt.asChild(entityId));
            Map<ConnectionId, List<ChildEntityId>> $this$flatMap$iv = unmappedChildren = builder2.getRefs$intellij_platform_workspaceModel_storage().getChildrenRefsOfParentBy(RefsTableKt.asParent(entityId));
            boolean $i$f$flatMap232 = false;
            Map<ConnectionId, List<ChildEntityId>> map2 = $this$flatMap$iv;
            Pair destination$iv$iv = (Pair)new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            void var17_18 = $this$flatMapTo$iv$iv;
            boolean bl = false;
            Iterator iterator2 = var17_18.entrySet().iterator();
            while (iterator2.hasNext()) {
                void $this$mapTo$iv$iv;
                Map.Entry entry2;
                Map.Entry $dstr$key$value = entry2 = iterator2.next();
                boolean bl2 = false;
                Map.Entry entry3 = $dstr$key$value;
                boolean bl3 = false;
                ConnectionId connectionId = (ConnectionId)entry3.getKey();
                entry3 = $dstr$key$value;
                bl3 = false;
                List value2 = (List)entry3.getValue();
                Iterable $this$map$iv = value2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    void key;
                    ChildEntityId childEntityId = (ChildEntityId)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl4 = false;
                    Pair pair = TuplesKt.to((Object)key, (Object)it);
                    collection.add(pair);
                }
                list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll(destination$iv$iv, (Iterable)list$iv$iv);
            }
            List children2 = (List)destination$iv$iv;
            Set beforeChildrenSet = CollectionsKt.toMutableSet((Iterable)beforeChildren);
            destination$iv$iv = ContainerExtensionsKt.getDiff(beforeChildrenSet, children2);
            Set $i$f$flatMap232 = (Set)destination$iv$iv.component1();
            ArrayList addedChildren = (ArrayList)destination$iv$iv.component2();
            Map parentsMapRes = MapsKt.toMutableMap(beforeParents);
            Object object = parents2;
            boolean bl5 = false;
            list$iv$iv = object.entrySet().iterator();
            while (list$iv$iv.hasNext()) {
                void connectionId;
                Map.Entry<ConnectionId, ParentEntityId> entry4 = $i$f$flatMapTo2 = list$iv$iv.next();
                boolean $dstr$key$value = false;
                object = entry4.getKey();
                Map.Entry<ConnectionId, ParentEntityId> entry5 = $i$f$flatMapTo2;
                $dstr$key$value = false;
                ParentEntityId parentId = entry5.getValue();
                ParentEntityId parentEntityId = (ParentEntityId)parentsMapRes.get(connectionId);
                if (parentEntityId != null) {
                    if (Intrinsics.areEqual((Object)parentEntityId, (Object)parentId)) {
                        parentsMapRes.remove(connectionId, parentId);
                        continue;
                    }
                    parentsMapRes.put(connectionId, parentId);
                    continue;
                }
                parentsMapRes.put(connectionId, parentId);
            }
            Set removedKeys = SetsKt.minus(beforeParents.keySet(), (Iterable)parents2.keySet());
            Iterable $this$forEach$iv = removedKeys;
            boolean $i$f$forEach = false;
            for (Object t : $this$forEach$iv) {
                ConnectionId it = (ConnectionId)t;
                boolean bl6 = false;
                parentsMapRes.put(it, null);
            }
            builder2.getChangeLog$intellij_platform_workspaceModel_storage().addReplaceEvent$intellij_platform_workspaceModel_storage(entityId, copiedData, originalEntity, originalParents, addedChildren, (Set<Pair<ConnectionId, ChildEntityId>>)removedChildren, parentsMapRes);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

