/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions.handlers;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ComponentUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.actions.MarkObjectActionHandler;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkerPresentationDialog;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeState;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.Component;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XMarkObjectActionHandler
extends MarkObjectActionHandler {
    @Override
    public void perform(@NotNull Project project, AnActionEvent event) {
        XDebugSession session2;
        if (project == null) {
            XMarkObjectActionHandler.$$$reportNull$$$0(0);
        }
        if ((session2 = DebuggerUIUtil.getSession(event)) == null) {
            return;
        }
        XValueMarkers<?, ?> markers = ((XDebugSessionImpl)session2).getValueMarkers();
        XValueNodeImpl node2 = XDebuggerTreeActionBase.getSelectedNode(event.getDataContext());
        if (markers == null || node2 == null) {
            return;
        }
        XValue value2 = (XValue)node2.getValueContainer();
        boolean detachedView = DebuggerUIUtil.isInDetachedTree(event);
        XDebuggerTreeState treeState = XDebuggerTreeState.saveState(node2.getTree());
        ValueMarkup existing = markers.getMarkup(value2);
        if (existing != null) {
            markers.unmarkValue(value2);
        } else {
            Component component2 = (Component)event.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT);
            Window window = ComponentUtil.getWindow((Component)component2);
            if (!(window instanceof JFrame) && !(window instanceof JDialog)) {
                component2 = window.getOwner();
            }
            ValueMarkerPresentationDialog dialog2 = new ValueMarkerPresentationDialog(component2, node2.getName(), markers.getAllMarkers().values());
            dialog2.show();
            ValueMarkup markup = dialog2.getConfiguredMarkup();
            if (dialog2.isOK() && markup != null) {
                markers.markValue(value2, markup);
            }
        }
        if (detachedView) {
            node2.getTree().rebuildAndRestore(treeState);
        }
        session2.rebuildViews();
    }

    @Override
    public boolean isEnabled(@NotNull Project project, AnActionEvent event) {
        XValueMarkers<?, ?> markers;
        if (project == null) {
            XMarkObjectActionHandler.$$$reportNull$$$0(1);
        }
        if ((markers = XMarkObjectActionHandler.getValueMarkers(event)) == null) {
            return false;
        }
        XValue value2 = XDebuggerTreeActionBase.getSelectedValue(event.getDataContext());
        return value2 != null && markers.canMarkValue(value2);
    }

    @Override
    public boolean isMarked(@NotNull Project project, @NotNull AnActionEvent event) {
        XValueMarkers<?, ?> markers;
        if (project == null) {
            XMarkObjectActionHandler.$$$reportNull$$$0(2);
        }
        if (event == null) {
            XMarkObjectActionHandler.$$$reportNull$$$0(3);
        }
        if ((markers = XMarkObjectActionHandler.getValueMarkers(event)) == null) {
            return false;
        }
        XValue value2 = XDebuggerTreeActionBase.getSelectedValue(event.getDataContext());
        return value2 != null && markers.getMarkup(value2) != null;
    }

    @Override
    public boolean isHidden(@NotNull Project project, AnActionEvent event) {
        if (project == null) {
            XMarkObjectActionHandler.$$$reportNull$$$0(4);
        }
        return XMarkObjectActionHandler.getValueMarkers(event) == null;
    }

    @Nullable
    private static XValueMarkers<?, ?> getValueMarkers(AnActionEvent event) {
        XDebugSession session2 = DebuggerUIUtil.getSession(event);
        return session2 != null ? ((XDebugSessionImpl)session2).getValueMarkers() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/actions/handlers/XMarkObjectActionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "perform";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isMarked";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isHidden";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

