/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.popup.util.DetailView;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointItem;
import com.intellij.xdebugger.impl.breakpoints.ui.XLightBreakpointPropertiesPanel;
import com.intellij.xdebugger.ui.DebuggerColors;
import java.awt.Color;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

class XBreakpointItem
extends BreakpointItem {
    private final XBreakpoint<?> myBreakpoint;
    private XLightBreakpointPropertiesPanel myPropertiesPanel;

    XBreakpointItem(XBreakpoint<?> breakpoint) {
        this.myBreakpoint = breakpoint;
    }

    @Override
    public void setupRenderer(ColoredListCellRenderer renderer2, Project project, boolean selected2) {
        this.setupGenericRenderer((SimpleColoredComponent)renderer2, true);
    }

    @Override
    public void setupRenderer(ColoredTreeCellRenderer renderer2, Project project, boolean selected2) {
        this.setupGenericRenderer((SimpleColoredComponent)renderer2, false);
    }

    @Override
    public void setupGenericRenderer(SimpleColoredComponent renderer2, boolean plainView) {
        renderer2.setIcon(this.getIcon());
        SimpleTextAttributes attributes2 = this.myBreakpoint.isEnabled() ? SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES;
        renderer2.append(StringUtil.notNullize((String)this.getDisplayText()), attributes2);
        String description = this.getUserDescription();
        if (!StringUtil.isEmpty((String)description)) {
            renderer2.append(" (" + description + ")", SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES);
        }
    }

    @Override
    public String getDisplayText() {
        return XBreakpointUtil.getShortText(this.myBreakpoint);
    }

    @Nullable
    @Nls
    private String getUserDescription() {
        return ((XBreakpointBase)this.myBreakpoint).getUserDescription();
    }

    @Override
    public Icon getIcon() {
        return ((XBreakpointBase)this.myBreakpoint).getIcon();
    }

    public String speedSearchText() {
        return this.getDisplayText() + " " + StringUtil.notNullize((String)this.getUserDescription());
    }

    @Nls
    public String footerText() {
        return XBreakpointUtil.getDisplayText(this.myBreakpoint);
    }

    @Override
    public void saveState() {
        if (this.myPropertiesPanel != null) {
            this.myPropertiesPanel.saveProperties();
        }
    }

    public void doUpdateDetailView(DetailView panel2, boolean editorOnly) {
        XBreakpointBase breakpoint = (XBreakpointBase)this.myBreakpoint;
        Project project = breakpoint.getProject();
        if (this.myPropertiesPanel != null) {
            this.myPropertiesPanel.dispose();
            this.myPropertiesPanel = null;
        }
        if (!editorOnly) {
            this.myPropertiesPanel = new XLightBreakpointPropertiesPanel(project, this.getManager(), breakpoint, true);
            panel2.setPropertiesPanel(this.myPropertiesPanel.getMainPanel());
        }
        panel2.clearEditor();
        ReadAction.nonBlocking(() -> this.myBreakpoint.getSourcePosition()).finishOnUiThread(ModalityState.defaultModalityState(), sourcePosition -> {
            if (sourcePosition != null && sourcePosition.getFile().isValid()) {
                this.showInEditor(panel2, sourcePosition.getFile(), sourcePosition.getLine());
            } else {
                panel2.clearEditor();
            }
        }).coalesceBy(new Object[]{panel2}).submit((Executor)AppExecutorUtil.getAppExecutorService());
        if (this.myPropertiesPanel != null) {
            this.myPropertiesPanel.setDetailView(panel2);
            this.myPropertiesPanel.loadProperties();
            this.myPropertiesPanel.getMainPanel().revalidate();
        }
    }

    private void showInEditor(DetailView panel2, VirtualFile virtualFile2, int line) {
        Editor editor2;
        TextAttributes attributes2 = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(DebuggerColors.BREAKPOINT_ATTRIBUTES);
        DetailView.PreviewEditorState state = DetailView.PreviewEditorState.create((VirtualFile)virtualFile2, (int)line, (TextAttributes)(this.myBreakpoint instanceof XLineBreakpoint ? null : attributes2));
        if (state.equals((Object)panel2.getEditorState())) {
            return;
        }
        panel2.navigateInPreviewEditor(state);
        TextAttributes softerAttributes = attributes2.clone();
        Color backgroundColor = softerAttributes.getBackgroundColor();
        if (backgroundColor != null) {
            softerAttributes.setBackgroundColor(ColorUtil.desaturate((Color)backgroundColor, (int)10));
        }
        if ((editor2 = panel2.getEditor()) != null) {
            MarkupModel editorModel = editor2.getMarkupModel();
            MarkupModel documentModel = DocumentMarkupModel.forDocument(editor2.getDocument(), editor2.getProject(), false);
            for (RangeHighlighter highlighter : documentModel.getAllHighlighters()) {
                int line1;
                if (highlighter.getUserData(DebuggerColors.BREAKPOINT_HIGHLIGHTER_KEY) != Boolean.TRUE || (line1 = editor2.offsetToLogicalPosition((int)highlighter.getStartOffset()).line) == line) continue;
                if (highlighter.getTargetArea() == HighlighterTargetArea.LINES_IN_RANGE) {
                    editorModel.addLineHighlighter(line1, 3002, softerAttributes);
                    continue;
                }
                editorModel.addRangeHighlighter(highlighter.getStartOffset(), highlighter.getEndOffset(), 3002, softerAttributes, HighlighterTargetArea.EXACT_RANGE);
            }
        }
    }

    public void navigate(boolean requestFocus) {
        Navigatable navigatable2 = this.myBreakpoint.getNavigatable();
        if (navigatable2 != null && navigatable2.canNavigate()) {
            navigatable2.navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        Navigatable navigatable2 = this.myBreakpoint.getNavigatable();
        return navigatable2 != null && navigatable2.canNavigate();
    }

    public boolean canNavigateToSource() {
        Navigatable navigatable2 = this.myBreakpoint.getNavigatable();
        return navigatable2 != null && navigatable2.canNavigateToSource();
    }

    private XBreakpointManagerImpl getManager() {
        return ((XBreakpointBase)this.myBreakpoint).getBreakpointManager();
    }

    public boolean allowedToRemove() {
        return !this.getManager().isDefaultBreakpoint(this.myBreakpoint);
    }

    public void removed(Project project) {
        XDebuggerUtil.getInstance().removeBreakpoint(project, this.myBreakpoint);
    }

    @Override
    public Object getBreakpoint() {
        return this.myBreakpoint;
    }

    @Override
    public boolean isEnabled() {
        return this.myBreakpoint.isEnabled();
    }

    @Override
    public void setEnabled(boolean state) {
        this.myBreakpoint.setEnabled(state);
    }

    @Override
    public boolean isDefaultBreakpoint() {
        return this.getManager().isDefaultBreakpoint(this.myBreakpoint);
    }

    @Override
    public int compareTo(BreakpointItem breakpointItem) {
        if (breakpointItem.getBreakpoint() instanceof XBreakpointBase) {
            return ((XBreakpointBase)this.myBreakpoint).compareTo((XBreakpoint)breakpointItem.getBreakpoint());
        }
        return 0;
    }

    @Override
    public void dispose() {
        if (this.myPropertiesPanel != null) {
            this.myPropertiesPanel.dispose();
            this.myPropertiesPanel = null;
        }
    }
}

