/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui;

import com.intellij.DynamicBundle;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.popup.util.DetailView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.ui.XBreakpointActionsPanel;
import com.intellij.xdebugger.impl.breakpoints.ui.XBreakpointPropertiesSubPanel;
import com.intellij.xdebugger.impl.breakpoints.ui.XMasterBreakpointPanel;
import com.intellij.xdebugger.impl.breakpoints.ui.XSuspendPolicyPanel;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebuggerExpressionComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executor;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import org.jetbrains.annotations.Nullable;

public class XLightBreakpointPropertiesPanel
implements XSuspendPolicyPanel.Delegate {
    public static final String CONDITION_HISTORY_ID = "breakpointCondition";
    private boolean myShowMoreOptions;
    private JPanel myConditionPanel;
    private JPanel myMainPanel;
    private Delegate myDelegate;
    private XSuspendPolicyPanel mySuspendPolicyPanel;
    private XBreakpointActionsPanel myActionsPanel;
    private XMasterBreakpointPanel myMasterBreakpointPanel;
    private JPanel myCustomPropertiesPanelWrapper;
    private JPanel myCustomConditionsPanelWrapper;
    private JCheckBox myEnabledCheckbox;
    private JPanel myCustomRightPropertiesPanelWrapper;
    private JBCheckBox myConditionEnabledCheckbox;
    private JPanel myCustomTopPropertiesPanelWrapper;
    private JBLabel myBreakpointNameLabel;
    private JPanel myConditionCheckboxPanel;
    private JPanel myLanguageChooserPanel;
    private JPanel myConditionExpressionPanel;
    private ActionLink myRestoreLink;
    private final List<XBreakpointCustomPropertiesPanel> myCustomPanels;
    private final List<XBreakpointPropertiesSubPanel> mySubPanels;
    @Nullable
    private XDebuggerExpressionComboBox myConditionComboBox;
    private final XBreakpointBase myBreakpoint;
    private final boolean myShowAllOptions;

    public boolean showMoreOptions() {
        return this.myShowMoreOptions;
    }

    @Override
    public void showMoreOptionsIfNeeded() {
        if (this.myShowMoreOptions && this.myDelegate != null) {
            this.myDelegate.showMoreOptions();
        }
    }

    private void createUIComponents() {
        this.myRestoreLink = new ActionLink(XDebuggerBundle.message((String)"xbreakpoints.restore.label", (Object[])new Object[0]), e -> WriteAction.run(() -> ((XBreakpointManagerImpl)XDebuggerManager.getInstance((Project)this.myBreakpoint.getProject()).getBreakpointManager()).restoreLastRemovedBreakpoint()));
    }

    public Delegate getDelegate() {
        return this.myDelegate;
    }

    public void setDelegate(Delegate delegate2) {
        this.myDelegate = delegate2;
    }

    public void setDetailView(DetailView detailView) {
        this.myMasterBreakpointPanel.setDetailView(detailView);
    }

    public XLightBreakpointPropertiesPanel(Project project, XBreakpointManager breakpointManager, XBreakpointBase breakpoint, boolean showAllOptions) {
        this.$$$setupUI$$$();
        this.mySubPanels = new ArrayList<XBreakpointPropertiesSubPanel>();
        this.myBreakpoint = breakpoint;
        this.myShowAllOptions = showAllOptions;
        final XBreakpointType breakpointType = breakpoint.getType();
        if (breakpointType.getVisibleStandardPanels().contains(XBreakpointType.StandardPanels.SUSPEND_POLICY)) {
            this.mySuspendPolicyPanel.init(project, breakpointManager, breakpoint);
            this.mySuspendPolicyPanel.setDelegate(this);
            this.mySubPanels.add(this.mySuspendPolicyPanel);
        } else {
            this.mySuspendPolicyPanel.hide();
        }
        if (breakpointType.getVisibleStandardPanels().contains(XBreakpointType.StandardPanels.DEPENDENCY)) {
            this.myMasterBreakpointPanel.init(project, breakpointManager, breakpoint);
            this.mySubPanels.add(this.myMasterBreakpointPanel);
        } else {
            this.myMasterBreakpointPanel.hide();
        }
        XDebuggerEditorsProvider debuggerEditorsProvider = breakpointType.getEditorsProvider((XBreakpoint)breakpoint, project);
        if (breakpointType.getVisibleStandardPanels().contains(XBreakpointType.StandardPanels.ACTIONS)) {
            this.myActionsPanel.init(project, breakpointManager, breakpoint, debuggerEditorsProvider);
            this.mySubPanels.add(this.myActionsPanel);
        } else {
            this.myActionsPanel.hide();
        }
        this.myCustomPanels = new ArrayList<XBreakpointCustomPropertiesPanel>();
        if (debuggerEditorsProvider != null) {
            this.myConditionEnabledCheckbox = new JBCheckBox(XDebuggerBundle.message((String)"xbreakpoints.condition.checkbox", (Object[])new Object[0]));
            this.myConditionComboBox = new XDebuggerExpressionComboBox(project, debuggerEditorsProvider, CONDITION_HISTORY_ID, null, true, false);
            this.myLanguageChooserPanel.add((Component)this.myConditionComboBox.getLanguageChooser(), "Center");
            this.myConditionExpressionPanel.add((Component)this.myConditionComboBox.getComponent(), "Center");
            this.myConditionEnabledCheckbox.addActionListener(e -> this.onCheckboxChanged());
            DebuggerUIUtil.focusEditorOnCheck((JCheckBox)this.myConditionEnabledCheckbox, this.myConditionComboBox.getEditorComponent());
        } else {
            this.myConditionPanel.setVisible(false);
        }
        this.myShowMoreOptions = false;
        for (XBreakpointPropertiesSubPanel panel2 : this.mySubPanels) {
            if (!panel2.lightVariant(showAllOptions)) continue;
            this.myShowMoreOptions = true;
        }
        XBreakpointCustomPropertiesPanel customPropertiesPanel = breakpointType.createCustomPropertiesPanel(project);
        if (customPropertiesPanel != null) {
            this.myCustomPropertiesPanelWrapper.add((Component)customPropertiesPanel.getComponent(), "Center");
            this.myCustomPanels.add(customPropertiesPanel);
        } else {
            this.myCustomPropertiesPanelWrapper.getParent().remove(this.myCustomPropertiesPanelWrapper);
        }
        XBreakpointCustomPropertiesPanel customConditionPanel = breakpointType.createCustomConditionsPanel();
        if (customConditionPanel != null) {
            this.myCustomConditionsPanelWrapper.add((Component)customConditionPanel.getComponent(), "Center");
            this.myCustomPanels.add(customConditionPanel);
        } else {
            this.myCustomConditionsPanelWrapper.getParent().remove(this.myCustomConditionsPanelWrapper);
        }
        XBreakpointCustomPropertiesPanel customRightConditionPanel = breakpointType.createCustomRightPropertiesPanel(project);
        if (customRightConditionPanel != null && (showAllOptions || customRightConditionPanel.isVisibleOnPopup((XBreakpoint)breakpoint))) {
            this.myCustomRightPropertiesPanelWrapper.add((Component)customRightConditionPanel.getComponent(), "Center");
            this.myCustomPanels.add(customRightConditionPanel);
        } else {
            this.myCustomRightPropertiesPanelWrapper.getParent().remove(this.myCustomRightPropertiesPanelWrapper);
        }
        XBreakpointCustomPropertiesPanel customTopPropertiesPanel = breakpointType.createCustomTopPropertiesPanel(project);
        if (customTopPropertiesPanel != null) {
            this.myCustomTopPropertiesPanelWrapper.add((Component)customTopPropertiesPanel.getComponent(), "Center");
            this.myCustomPanels.add(customTopPropertiesPanel);
        } else {
            this.myCustomTopPropertiesPanelWrapper.getParent().remove(this.myCustomTopPropertiesPanelWrapper);
        }
        this.myMainPanel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent event) {
                JComponent compToFocus = null;
                if (XLightBreakpointPropertiesPanel.this.myConditionComboBox != null && XLightBreakpointPropertiesPanel.this.myConditionComboBox.getComboBox().isEnabled()) {
                    compToFocus = XLightBreakpointPropertiesPanel.this.myConditionComboBox.getEditorComponent();
                } else if (breakpointType.getVisibleStandardPanels().contains(XBreakpointType.StandardPanels.ACTIONS)) {
                    compToFocus = XLightBreakpointPropertiesPanel.this.myActionsPanel.getDefaultFocusComponent();
                }
                if (compToFocus != null) {
                    IdeFocusManager.findInstance().requestFocus((Component)compToFocus, false);
                }
            }
        });
        this.myEnabledCheckbox.addActionListener(e -> this.myBreakpoint.setEnabled(this.myEnabledCheckbox.isSelected()));
        this.myRestoreLink.setVisible(false);
        ReadAction.nonBlocking(() -> {
            XSourcePosition sourcePosition = this.myBreakpoint.getSourcePosition();
            XBreakpointBase lastRemovedBreakpoint = ((XBreakpointManagerImpl)breakpointManager).getLastRemovedBreakpoint();
            boolean restore2 = lastRemovedBreakpoint != null && breakpointType.equals(lastRemovedBreakpoint.getType()) && XSourcePosition.isOnTheSameLine((XSourcePosition)sourcePosition, (XSourcePosition)lastRemovedBreakpoint.getSourcePosition()) && XBreakpointManagerImpl.statesAreDifferent(lastRemovedBreakpoint.getState(), breakpoint.getState(), true);
            return Pair.create((Object)sourcePosition, (Object)restore2);
        }).finishOnUiThread(ModalityState.defaultModalityState(), pair -> {
            XSourcePosition sourcePosition = (XSourcePosition)pair.getFirst();
            if (this.myConditionComboBox != null) {
                this.myConditionComboBox.setSourcePosition(sourcePosition);
            }
            this.myActionsPanel.setSourcePosition(sourcePosition);
            this.myRestoreLink.setVisible(((Boolean)pair.getSecond()).booleanValue());
        }).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private void onCheckboxChanged() {
        if (this.myConditionComboBox != null) {
            this.myConditionComboBox.setEnabled(this.myConditionEnabledCheckbox.isSelected());
        }
    }

    public void saveProperties() {
        this.mySubPanels.forEach(XBreakpointPropertiesSubPanel::saveProperties);
        if (this.myConditionComboBox != null) {
            XExpression expression = this.myConditionComboBox.getExpression();
            XExpression condition = !XDebuggerUtilImpl.isEmptyExpression(expression) ? expression : null;
            this.myBreakpoint.setConditionEnabled(condition == null || this.myConditionEnabledCheckbox.isSelected());
            this.myBreakpoint.setConditionExpression(condition);
            this.myConditionComboBox.saveTextInHistory();
        }
        for (XBreakpointCustomPropertiesPanel customPanel : this.myCustomPanels) {
            customPanel.saveTo((XBreakpoint)this.myBreakpoint);
        }
        this.myBreakpoint.setEnabled(this.myEnabledCheckbox.isSelected());
    }

    public void loadProperties() {
        this.mySubPanels.forEach(XBreakpointPropertiesSubPanel::loadProperties);
        if (this.myConditionComboBox != null) {
            XExpression condition = this.myBreakpoint.getConditionExpressionInt();
            this.myConditionComboBox.setExpression(condition);
            boolean hideCheckbox = !this.myShowAllOptions && condition == null;
            this.myConditionEnabledCheckbox.setSelected(hideCheckbox || this.myBreakpoint.isConditionEnabled() && condition != null);
            this.myConditionCheckboxPanel.removeAll();
            if (hideCheckbox) {
                JBLabel label2 = new JBLabel(XDebuggerBundle.message((String)"xbreakpoints.condition.checkbox", (Object[])new Object[0]));
                label2.setBorder((Border)JBUI.Borders.empty((int)0, (int)4, (int)4, (int)0));
                label2.setLabelFor((Component)this.myConditionComboBox.getComboBox());
                this.myConditionCheckboxPanel.add((Component)label2);
                this.myConditionExpressionPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)3));
            } else {
                this.myConditionCheckboxPanel.add((Component)this.myConditionEnabledCheckbox);
                this.myConditionExpressionPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)UIUtil.getCheckBoxTextHorizontalOffset((JCheckBox)this.myConditionEnabledCheckbox)));
            }
            this.onCheckboxChanged();
        }
        for (XBreakpointCustomPropertiesPanel customPanel : this.myCustomPanels) {
            customPanel.loadFrom((XBreakpoint)this.myBreakpoint);
        }
        this.myEnabledCheckbox.setSelected(this.myBreakpoint.isEnabled());
        this.myBreakpointNameLabel.setText(XBreakpointUtil.getShortText(this.myBreakpoint));
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    public void dispose() {
        this.myActionsPanel.dispose();
        this.myCustomPanels.forEach(Disposer::dispose);
        this.myCustomPanels.clear();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JCheckBox jCheckBox;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5;
        XMasterBreakpointPanel xMasterBreakpointPanel;
        XBreakpointActionsPanel xBreakpointActionsPanel;
        XSuspendPolicyPanel xSuspendPolicyPanel;
        JPanel jPanel6;
        JPanel jPanel7;
        JPanel jPanel8;
        JPanel jPanel9;
        JPanel jPanel10;
        this.createUIComponents();
        this.myMainPanel = jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(12, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel10.add((Component)spacer, new GridConstraints(11, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myConditionPanel = jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel10.add((Component)jPanel9, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myConditionCheckboxPanel = jPanel8 = new JPanel();
        jPanel8.setLayout(new BorderLayout(0, 0));
        jPanel9.add((Component)jPanel8, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myLanguageChooserPanel = jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout(0, 0));
        jPanel9.add((Component)jPanel7, new GridConstraints(0, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myConditionExpressionPanel = jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(0, 0));
        jPanel9.add((Component)jPanel6, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel9.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.mySuspendPolicyPanel = xSuspendPolicyPanel = new XSuspendPolicyPanel();
        JComponent jComponent = xSuspendPolicyPanel.$$$getRootComponent$$$();
        jPanel10.add((Component)jComponent, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myActionsPanel = xBreakpointActionsPanel = new XBreakpointActionsPanel();
        JComponent jComponent2 = xBreakpointActionsPanel.$$$getRootComponent$$$();
        jPanel10.add((Component)jComponent2, new GridConstraints(6, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myMasterBreakpointPanel = xMasterBreakpointPanel = new XMasterBreakpointPanel();
        JComponent jComponent3 = xMasterBreakpointPanel.$$$getRootComponent$$$();
        jPanel10.add((Component)jComponent3, new GridConstraints(7, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCustomPropertiesPanelWrapper = jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        jPanel10.add((Component)jPanel5, new GridConstraints(9, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel10.add((Component)spacer3, new GridConstraints(10, 0, 1, 2, 0, 1, 6, 1, null, new Dimension(400, -1), null));
        this.myCustomConditionsPanelWrapper = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel10.add((Component)jPanel4, new GridConstraints(5, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myCustomRightPropertiesPanelWrapper = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        ((Component)jPanel3).setEnabled(true);
        ((Component)jPanel3).setVisible(true);
        jPanel10.add((Component)jPanel3, new GridConstraints(6, 1, 3, 1, 0, 3, 3, 3, null, null, null, 2));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0), null, 0, 0, null, null));
        Spacer spacer4 = new Spacer();
        jPanel10.add((Component)spacer4, new GridConstraints(8, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myCustomTopPropertiesPanelWrapper = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel10.add((Component)jPanel2, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(5, 0, 0, 0), -1, -1, false, false));
        jPanel10.add((Component)jPanel11, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myEnabledCheckbox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/XDebuggerBundle", XLightBreakpointPropertiesPanel.class).getString("xbreakpoints.enabled.label"));
        jPanel11.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.add((Component)jPanel12, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myBreakpointNameLabel = jBLabel = new JBLabel();
        Font font = this.$$$getFont$$$(null, 1, -1, jBLabel.getFont());
        if (font != null) {
            jBLabel.setFont(font);
        }
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/XDebuggerBundle", XLightBreakpointPropertiesPanel.class).getString("xbreakpoints.breakpoint.name"));
        jPanel12.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ActionLink actionLink2 = this.myRestoreLink;
        this.$$$loadButtonText$$$((AbstractButton)actionLink2, DynamicBundle.getBundle((String)"messages/XDebuggerBundle", XLightBreakpointPropertiesPanel.class).getString("xbreakpoints.restore.label"));
        jPanel12.add((Component)actionLink2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        Font font3 = new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
        boolean bl = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font font4 = bl ? new Font(font3.getFamily(), font3.getStyle(), font3.getSize()) : new StyleContext().getFont(font3.getFamily(), font3.getStyle(), font3.getSize());
        return font4 instanceof FontUIResource ? font4 : new FontUIResource(font4);
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public static interface Delegate {
        public void showMoreOptions();
    }
}

