/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui.tree;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.Convertor;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointItem;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointItemNode;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointItemsTreeController;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointsGroupNode;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointsTreeCellRenderer;
import javax.swing.tree.TreePath;

public class BreakpointsCheckboxTree
extends CheckboxTree {
    private Delegate myDelegate = null;

    protected void nodeStateWillChange(CheckedTreeNode node2) {
        super.nodeStateWillChange(node2);
        if (this.myDelegate != null) {
            this.myDelegate.nodeStateWillChange(node2);
        }
    }

    protected void onNodeStateChanged(CheckedTreeNode node2) {
        super.onNodeStateChanged(node2);
        if (this.myDelegate != null) {
            this.myDelegate.nodeStateDidChange(node2);
        }
    }

    public void setDelegate(Delegate delegate2) {
        this.myDelegate = delegate2;
    }

    public BreakpointsCheckboxTree(Project project, BreakpointItemsTreeController model2) {
        super(new BreakpointsTreeCellRenderer.BreakpointsCheckboxTreeCellRenderer(project), model2.getRoot());
    }

    @Override
    protected void installSpeedSearch() {
        new TreeSpeedSearch((Tree)this, (Convertor<? super TreePath, String>)((Convertor)path2 -> {
            Object node2 = path2.getLastPathComponent();
            if (node2 instanceof BreakpointItemNode) {
                return ((BreakpointItemNode)((Object)((Object)node2))).getBreakpointItem().speedSearchText();
            }
            if (node2 instanceof BreakpointsGroupNode) {
                return ((BreakpointsGroupNode)((Object)((Object)node2))).getGroup().getName();
            }
            return "";
        }), true);
    }

    public String convertValueToText(Object value2, boolean selected2, boolean expanded2, boolean leaf, int row2, boolean hasFocus) {
        if (value2 instanceof BreakpointItemNode) {
            String displayText2;
            BreakpointItem breakpointItem = ((BreakpointItemNode)((Object)value2)).getBreakpointItem();
            String string = displayText2 = breakpointItem != null ? breakpointItem.getDisplayText() : null;
            if (!StringUtil.isEmptyOrSpaces((String)displayText2)) {
                return displayText2;
            }
        }
        return super.convertValueToText(value2, selected2, expanded2, leaf, row2, hasFocus);
    }

    static interface Delegate {
        public void nodeStateDidChange(CheckedTreeNode var1);

        public void nodeStateWillChange(CheckedTreeNode var1);
    }
}

