/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NavigatableAdapter;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.CaptionPanel;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.table.ComponentsListFocusTraversalPolicy;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.frame.XDebugView;
import com.intellij.xdebugger.impl.frame.XDebuggerFramesList;
import com.intellij.xdebugger.impl.frame.XStackFrameContainerEx;
import com.intellij.xdebugger.impl.ui.XDebuggerEmbeddedComboBox;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.ComboPopup;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XFramesView
extends XDebugView {
    private static final Logger LOG = Logger.getInstance(XFramesView.class);
    private final JPanel myMainPanel;
    private final XDebuggerFramesList myFramesList;
    private final ComboBox<XExecutionStack> myThreadComboBox;
    private final Object2IntMap<XExecutionStack> myExecutionStacksWithSelection;
    private final AutoScrollToSourceHandler myFrameSelectionHandler;
    private XExecutionStack mySelectedStack;
    private int mySelectedFrameIndex;
    private Rectangle myVisibleRect;
    private boolean myListenersEnabled;
    private final Map<XExecutionStack, StackFramesListBuilder> myBuilders;
    private final ActionToolbarImpl myToolbar;
    private final Wrapper myThreadsPanel;
    private boolean myThreadsCalculated;
    private boolean myRefresh;

    public XFramesView(@NotNull Project project) {
        if (project == null) {
            XFramesView.$$$reportNull$$$0(0);
        }
        this.myExecutionStacksWithSelection = new Object2IntOpenHashMap();
        this.myBuilders = new HashMap<XExecutionStack, StackFramesListBuilder>();
        this.myMainPanel = new JPanel(new BorderLayout());
        this.myFrameSelectionHandler = new AutoScrollToSourceHandler(){

            protected boolean isAutoScrollMode() {
                return XFramesView.this.myListenersEnabled;
            }

            protected void setAutoScrollMode(boolean state) {
            }

            protected boolean needToCheckFocus() {
                return false;
            }

            protected void scrollToSource(@NotNull Component list2) {
                if (list2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (XFramesView.this.myListenersEnabled) {
                    XFramesView.this.processFrameSelection(XDebugView.getSession(list2), true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/xdebugger/impl/frame/XFramesView$1", "scrollToSource"));
            }
        };
        this.myFramesList = new XDebuggerFramesList(project){

            @Override
            @NotNull
            protected OccurenceNavigator.OccurenceInfo goOccurrence(int step2) {
                OccurenceNavigator.OccurenceInfo info2 = super.goOccurrence(step2);
                ScrollingUtil.ensureIndexIsVisible((JList)((Object)this), (int)this.getSelectedIndex(), (int)step2);
                OccurenceNavigator.OccurenceInfo occurenceInfo = info2;
                if (occurenceInfo == null) {
                    2.$$$reportNull$$$0(0);
                }
                return occurenceInfo;
            }

            @Override
            @NotNull
            protected Navigatable getSelectedFrameNavigatable() {
                final Navigatable navigatable2 = super.getSelectedFrameNavigatable();
                return new NavigatableAdapter(){

                    public void navigate(boolean requestFocus) {
                        if (navigatable2 != null && navigatable2.canNavigate()) {
                            navigatable2.navigate(requestFocus);
                        }
                        XFramesView.this.handleFrameSelection();
                    }
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/frame/XFramesView$2", "goOccurrence"));
            }
        };
        this.myFrameSelectionHandler.install((JList)((Object)this.myFramesList));
        EditSourceOnDoubleClickHandler.install((JList)((Object)this.myFramesList));
        this.myFramesList.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                int i2 = XFramesView.this.myFramesList.locationToIndex(new Point(x, y));
                if (i2 != -1) {
                    XFramesView.this.myFramesList.selectFrame(i2);
                }
                ActionManager actionManager = ActionManager.getInstance();
                ActionGroup group2 = (ActionGroup)actionManager.getAction("XDebugger.Frames.Tree.Popup");
                actionManager.createActionPopupMenu("unknown", group2).getComponent().show(comp, x, y);
            }
        });
        this.myMainPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myFramesList)), "Center");
        ScrollingUtil.installActions((JList)((Object)this.myFramesList), (JComponent)this.myMainPanel, (boolean)false);
        this.myThreadComboBox = new XDebuggerEmbeddedComboBox<XExecutionStack>();
        this.myThreadComboBox.setSwingPopup(false);
        this.myThreadComboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label2, value2, index2) -> {
            if (value2 != null) {
                label2.setText(value2.getDisplayName());
                label2.setIcon(value2.getIcon());
            } else if (index2 >= 0) {
                label2.setText(CommonBundle.getLoadingTreeNodeText());
            }
        }));
        this.myThreadComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                XDebugSession session2;
                Object item;
                if (!XFramesView.this.myListenersEnabled) {
                    return;
                }
                if (e.getStateChange() == 1 && (item = e.getItem()) != XFramesView.this.mySelectedStack && item instanceof XExecutionStack && (session2 = XDebugView.getSession(e)) != null) {
                    XFramesView.this.myRefresh = false;
                    XFramesView.this.updateFrames((XExecutionStack)item, session2, null, false);
                }
            }
        });
        this.myThreadComboBox.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){
            ThreadsBuilder myBuilder;

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                this.stopBuilder();
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
                this.stopBuilder();
            }

            private void stopBuilder() {
                if (this.myBuilder != null) {
                    this.myBuilder.setObsolete();
                    this.myBuilder = null;
                }
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                XSuspendContext context2;
                XDebugSession session2 = XDebugView.getSession(e);
                XSuspendContext xSuspendContext = context2 = session2 == null ? null : session2.getSuspendContext();
                if (context2 != null && !XFramesView.this.myThreadsCalculated) {
                    this.myBuilder = new ThreadsBuilder();
                    context2.computeExecutionStacks((XSuspendContext.XExecutionStackContainer)this.myBuilder);
                }
            }
        });
        new ComboboxSpeedSearch((JComboBox)this.myThreadComboBox){

            @Override
            protected String getElementText(Object element2) {
                return ((XExecutionStack)element2).getDisplayName();
            }
        };
        this.myToolbar = this.createToolbar();
        this.myThreadsPanel = new Wrapper();
        this.myToolbar.setOpaque(false);
        ((XDebuggerEmbeddedComboBox)this.myThreadComboBox).setExtension(this.myToolbar);
        this.myMainPanel.add((Component)this.myThreadsPanel, "North");
        this.myMainPanel.setFocusCycleRoot(true);
        this.myMainPanel.setFocusTraversalPolicy(new MyFocusPolicy());
        if (this.myMainPanel.getLayout() instanceof BorderLayout) {
            String prev2 = XFramesView.getShortcutText("PreviousOccurence");
            String next = XFramesView.getShortcutText("NextOccurence");
            String propKey = "XFramesView.AdPanel.SwitchFrames.enabled";
            if (PropertiesComponent.getInstance().getBoolean(propKey, true) && prev2 != null && next != null) {
                String message2 = XDebuggerBundle.message((String)"debugger.switch.frames.from.anywhere.hint", (Object[])new Object[]{prev2, next});
                MyAdPanel hint = new MyAdPanel(message2, p -> {
                    this.myMainPanel.remove((Component)((Object)p));
                    this.myMainPanel.revalidate();
                    PropertiesComponent.getInstance().setValue(propKey, false, true);
                });
                this.myMainPanel.add((Component)((Object)hint), "South");
            }
        }
    }

    public void onFrameSelectionKeyPressed(final @NotNull Consumer<XStackFrame> handler2) {
        if (handler2 == null) {
            XFramesView.$$$reportNull$$$0(1);
        }
        this.myFramesList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int key = e.getKeyCode();
                if (key == 10 || key == 32 || key == 39) {
                    XFramesView.this.handleFrameSelection();
                    ApplicationManager.getApplication().invokeLater(() -> handler2.accept(XFramesView.this.myFramesList.getSelectedFrame()));
                }
            }
        });
    }

    private void handleFrameSelection() {
        this.myFrameSelectionHandler.onMouseClicked((Component)((Object)this.myFramesList));
    }

    @Nullable
    @NlsSafe
    private static String getShortcutText(@NotNull @NonNls String actionId) {
        KeyboardShortcut shortcut;
        if (actionId == null) {
            XFramesView.$$$reportNull$$$0(2);
        }
        if ((shortcut = ActionManager.getInstance().getKeyboardShortcut(actionId)) == null) {
            return null;
        }
        return KeymapUtil.getShortcutText((Shortcut)shortcut);
    }

    public JComponent getDefaultFocusedComponent() {
        return this.myFramesList;
    }

    private ActionToolbarImpl createToolbar() {
        DefaultActionGroup framesGroup = new DefaultActionGroup();
        framesGroup.addAll(new AnAction[]{ActionManager.getInstance().getAction("XDebugger.Frames.TopToolbar")});
        ActionToolbarImpl toolbar = (ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("DebuggerToolbar", (ActionGroup)framesGroup, true);
        toolbar.setReservePlaceAutoPopupIcon(false);
        toolbar.setTargetComponent((JComponent)((Object)this.myFramesList));
        return toolbar;
    }

    private StackFramesListBuilder getOrCreateBuilder(XExecutionStack executionStack, XDebugSession session2) {
        return this.myBuilders.computeIfAbsent(executionStack, k -> new StackFramesListBuilder(executionStack, session2));
    }

    private void withCurrentBuilder(Consumer<? super StackFramesListBuilder> consumer2) {
        StackFramesListBuilder builder2 = this.myBuilders.get(this.mySelectedStack);
        if (builder2 != null) {
            consumer2.accept(builder2);
        }
    }

    @Override
    public void processSessionEvent(@NotNull XDebugView.SessionEvent event, @NotNull XDebugSession session2) {
        if (event == null) {
            XFramesView.$$$reportNull$$$0(3);
        }
        if (session2 == null) {
            XFramesView.$$$reportNull$$$0(4);
        }
        boolean bl = this.myRefresh = event == XDebugView.SessionEvent.SETTINGS_CHANGED;
        if (event == XDebugView.SessionEvent.BEFORE_RESUME) {
            return;
        }
        XExecutionStack currentExecutionStack = ((XDebugSessionImpl)session2).getCurrentExecutionStack();
        XStackFrame currentStackFrame = session2.getCurrentStackFrame();
        XSuspendContext suspendContext = session2.getSuspendContext();
        if (event == XDebugView.SessionEvent.FRAME_CHANGED && Objects.equals(this.mySelectedStack, currentExecutionStack)) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (currentStackFrame != null) {
                this.myFramesList.setSelectedValue(currentStackFrame, true);
                this.mySelectedFrameIndex = this.myFramesList.getSelectedIndex();
                this.myExecutionStacksWithSelection.put((Object)this.mySelectedStack, this.mySelectedFrameIndex);
            }
            return;
        }
        EdtExecutorService.getInstance().execute(() -> {
            if (event != XDebugView.SessionEvent.SETTINGS_CHANGED) {
                this.mySelectedFrameIndex = 0;
                this.mySelectedStack = null;
                this.myVisibleRect = null;
            } else {
                this.myVisibleRect = this.myFramesList.getVisibleRect();
            }
            this.myListenersEnabled = false;
            this.myBuilders.values().forEach(StackFramesListBuilder::dispose);
            this.myBuilders.clear();
            if (suspendContext == null) {
                this.requestClear();
                return;
            }
            if (event == XDebugView.SessionEvent.PAUSED) {
                this.cancelClear();
                this.clear();
            }
            XExecutionStack activeExecutionStack = this.mySelectedStack != null ? this.mySelectedStack : currentExecutionStack;
            this.addExecutionStacks(Collections.singletonList(activeExecutionStack), false);
            this.myThreadComboBox.setSelectedItem((Object)activeExecutionStack);
            boolean invisible = activeExecutionStack == null || StringUtil.isEmpty((String)activeExecutionStack.getDisplayName());
            if (invisible != (this.myThreadComboBox.getParent() == null)) {
                if (invisible) {
                    this.myThreadsPanel.remove(this.myThreadComboBox);
                    this.myThreadsPanel.setBorder(null);
                } else {
                    this.myThreadsPanel.add(this.myThreadComboBox, (Object)"Center");
                    this.myThreadsPanel.setBorder((Border)new CustomLineBorder(CaptionPanel.CNT_ACTIVE_BORDER_COLOR, 0, 0, 1, 0));
                }
                this.myThreadsPanel.revalidate();
            }
            this.updateFrames(activeExecutionStack, session2, (XStackFrame)(event == XDebugView.SessionEvent.FRAME_CHANGED ? currentStackFrame : null), event == XDebugView.SessionEvent.SETTINGS_CHANGED);
        });
    }

    @Override
    protected void clear() {
        this.myThreadComboBox.removeAllItems();
        this.myFramesList.clear();
        this.myThreadsCalculated = false;
        this.myExecutionStacksWithSelection.clear();
    }

    private boolean addExecutionStacks(List<? extends XExecutionStack> executionStacks, boolean addBeforeSelection) {
        int count = this.myThreadComboBox.getItemCount();
        boolean loading = count > 0 && this.myThreadComboBox.getItemAt(count - 1) == null;
        Object selectedItem = this.myThreadComboBox.getSelectedItem();
        for (XExecutionStack xExecutionStack : executionStacks) {
            if (addBeforeSelection && xExecutionStack.equals(selectedItem)) {
                addBeforeSelection = false;
            }
            if (this.myExecutionStacksWithSelection.containsKey((Object)xExecutionStack)) continue;
            if (addBeforeSelection) {
                this.myThreadComboBox.insertItemAt((Object)xExecutionStack, this.myThreadComboBox.getSelectedIndex());
            } else if (loading) {
                this.myThreadComboBox.insertItemAt((Object)xExecutionStack, this.myThreadComboBox.getItemCount() - 1);
            } else {
                this.myThreadComboBox.addItem((Object)xExecutionStack);
            }
            this.myExecutionStacksWithSelection.put((Object)xExecutionStack, 0);
        }
        return addBeforeSelection;
    }

    private void updateFrames(XExecutionStack executionStack, @NotNull XDebugSession session2, @Nullable XStackFrame frameToSelect, boolean refresh2) {
        if (session2 == null) {
            XFramesView.$$$reportNull$$$0(5);
        }
        if (this.mySelectedStack != null) {
            this.withCurrentBuilder(StackFramesListBuilder::stop);
        }
        this.mySelectedStack = executionStack;
        if (executionStack != null) {
            this.mySelectedFrameIndex = this.myExecutionStacksWithSelection.getInt((Object)executionStack);
            StackFramesListBuilder builder2 = this.getOrCreateBuilder(executionStack, session2);
            builder2.setRefresh(refresh2);
            builder2.setToSelect(frameToSelect != null ? frameToSelect : Integer.valueOf(this.mySelectedFrameIndex));
            this.myListenersEnabled = false;
            boolean selected2 = builder2.initModel(this.myFramesList.getModel());
            this.myListenersEnabled = !builder2.start() || selected2;
        }
    }

    public void dispose() {
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    @Override
    public JComponent getMainComponent() {
        return this.getMainPanel();
    }

    private void processFrameSelection(XDebugSession session2, boolean force) {
        this.mySelectedFrameIndex = this.myFramesList.getSelectedIndex();
        this.myExecutionStacksWithSelection.put((Object)this.mySelectedStack, this.mySelectedFrameIndex);
        this.withCurrentBuilder(b -> b.setToSelect(null));
        Object selected2 = this.myFramesList.getSelectedValue();
        if (selected2 instanceof XStackFrame && session2 != null && (force || !this.myRefresh && session2.getCurrentStackFrame() != selected2)) {
            session2.setCurrentStackFrame(this.mySelectedStack, (XStackFrame)selected2, this.mySelectedFrameIndex == 0);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/frame/XFramesView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "onFrameSelectionKeyPressed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getShortcutText";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processSessionEvent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "updateFrames";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyAdPanel
    extends BorderLayoutPanel {
        MyAdPanel(@NotNull @NlsContexts.Label String message2, @NotNull Consumer<MyAdPanel> closeListener) {
            if (message2 == null) {
                MyAdPanel.$$$reportNull$$$0(0);
            }
            if (closeListener == null) {
                MyAdPanel.$$$reportNull$$$0(1);
            }
            JBLabel label2 = new JBLabel(message2, UIUtil.ComponentStyle.SMALL);
            label2.setForeground(UIUtil.getContextHelpForeground());
            label2.setToolTipText(message2);
            JButton closeButton2 = new JButton();
            closeButton2.setText(null);
            closeButton2.setOpaque(false);
            closeButton2.setBorder(null);
            closeButton2.setBorderPainted(false);
            closeButton2.setContentAreaFilled(false);
            closeButton2.setIcon(AllIcons.Actions.Close);
            closeButton2.setRolloverIcon(AllIcons.Actions.CloseDarkGrey);
            closeButton2.setToolTipText(CommonBundle.getCloseButtonText());
            closeButton2.addActionListener(e -> closeListener.accept(this));
            Dimension dim = new Dimension(AllIcons.Actions.Close.getIconHeight(), AllIcons.Actions.Close.getIconWidth());
            closeButton2.setPreferredSize(dim);
            this.addToCenter((Component)label2);
            this.addToRight(closeButton2);
            this.setBorder((Border)JBUI.Borders.empty((int)3, (int)8, (int)3, (int)4));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "message";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "closeListener";
                    break;
                }
            }
            objectArray[1] = "com/intellij/xdebugger/impl/frame/XFramesView$MyAdPanel";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class StackFramesListBuilder
    implements XStackFrameContainerEx {
        private XExecutionStack myExecutionStack;
        private final List<XStackFrame> myStackFrames;
        private String myErrorMessage;
        private int myNextFrameIndex;
        private volatile boolean myRunning;
        private boolean myAllFramesLoaded;
        private final XDebugSession mySession;
        private Object myToSelect;
        private boolean myRefresh;

        private StackFramesListBuilder(XExecutionStack executionStack, XDebugSession session2) {
            this.myExecutionStack = executionStack;
            this.mySession = session2;
            this.myStackFrames = new ArrayList<XStackFrame>();
        }

        void setToSelect(Object toSelect2) {
            this.myToSelect = toSelect2;
        }

        private void setRefresh(boolean refresh2) {
            this.myRefresh = refresh2;
        }

        public void addStackFrames(@NotNull List<? extends XStackFrame> stackFrames, boolean last) {
            if (stackFrames == null) {
                StackFramesListBuilder.$$$reportNull$$$0(0);
            }
            this.addStackFrames(stackFrames, null, last);
        }

        @Override
        public void addStackFrames(@NotNull List<? extends XStackFrame> stackFrames, @Nullable XStackFrame toSelect2, boolean last) {
            if (stackFrames == null) {
                StackFramesListBuilder.$$$reportNull$$$0(1);
            }
            if (this.isObsolete()) {
                return;
            }
            EdtExecutorService.getInstance().execute(() -> {
                if (this.isObsolete()) {
                    return;
                }
                this.myStackFrames.addAll(stackFrames);
                this.addFrameListElements(stackFrames, last);
                if (toSelect2 != null && !this.myRefresh) {
                    this.setToSelect(toSelect2);
                }
                this.myNextFrameIndex += stackFrames.size();
                this.myAllFramesLoaded = last;
                this.selectCurrentFrame();
                if (last) {
                    if (XFramesView.this.myVisibleRect != null) {
                        XFramesView.this.myFramesList.scrollRectToVisible(XFramesView.this.myVisibleRect);
                    }
                    this.myRunning = false;
                    XFramesView.this.myListenersEnabled = true;
                }
            });
        }

        public void errorOccurred(@NotNull String errorMessage) {
            if (errorMessage == null) {
                StackFramesListBuilder.$$$reportNull$$$0(2);
            }
            if (this.isObsolete()) {
                return;
            }
            EdtExecutorService.getInstance().execute(() -> {
                if (this.isObsolete()) {
                    return;
                }
                if (this.myErrorMessage == null) {
                    this.myErrorMessage = errorMessage;
                    this.addFrameListElements(Collections.singletonList(errorMessage), true);
                    this.myRunning = false;
                    XFramesView.this.myListenersEnabled = true;
                }
            });
        }

        private void addFrameListElements(List<?> values2, boolean last) {
            if (this.myExecutionStack != null && this.myExecutionStack == XFramesView.this.mySelectedStack) {
                boolean loadingPresent;
                CollectionListModel model2 = XFramesView.this.myFramesList.getModel();
                int insertIndex = model2.getSize();
                boolean bl = loadingPresent = insertIndex > 0 && model2.getElementAt(insertIndex - 1) == null;
                if (loadingPresent) {
                    --insertIndex;
                }
                model2.addAll(insertIndex, values2);
                if (last) {
                    if (loadingPresent) {
                        model2.remove(model2.getSize() - 1);
                    }
                } else if (!loadingPresent) {
                    model2.add(null);
                }
                XFramesView.this.myFramesList.repaint();
            }
        }

        public boolean isObsolete() {
            return !this.myRunning;
        }

        public void dispose() {
            this.myRunning = false;
            this.myExecutionStack = null;
        }

        public boolean start() {
            if (this.myExecutionStack == null || this.myErrorMessage != null) {
                return false;
            }
            this.myRunning = true;
            this.myExecutionStack.computeStackFrames(this.myNextFrameIndex, (XExecutionStack.XStackFrameContainer)this);
            return true;
        }

        public void stop() {
            this.myRunning = false;
        }

        private boolean selectCurrentFrame() {
            if (this.selectFrame(this.myToSelect)) {
                XFramesView.this.myListenersEnabled = true;
                XFramesView.this.processFrameSelection(this.mySession, false);
                return true;
            }
            return false;
        }

        private boolean selectFrame(Object toSelect2) {
            if (toSelect2 instanceof XStackFrame) {
                if (XFramesView.this.myFramesList.selectFrame((XStackFrame)toSelect2)) {
                    return true;
                }
                if (this.myAllFramesLoaded && XFramesView.this.myFramesList.getSelectedValue() == null) {
                    LOG.error("Frame was not found, " + this.myToSelect.getClass() + " must correctly override equals");
                }
            } else if (toSelect2 instanceof Integer && XFramesView.this.myFramesList.selectFrame((Integer)toSelect2)) {
                return true;
            }
            return false;
        }

        public boolean initModel(CollectionListModel model2) {
            model2.replaceAll(this.myStackFrames);
            if (this.myErrorMessage != null) {
                model2.add((Object)this.myErrorMessage);
            } else if (!this.myAllFramesLoaded) {
                model2.add(null);
            }
            return this.selectCurrentFrame();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stackFrames";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorMessage";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/xdebugger/impl/frame/XFramesView$StackFramesListBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addStackFrames";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "errorOccurred";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ThreadsBuilder
    implements XSuspendContext.XExecutionStackContainer {
        private volatile boolean myObsolete;
        private boolean myAddBeforeSelection = true;

        ThreadsBuilder() {
            XFramesView.this.myThreadComboBox.addItem(null);
        }

        public void addExecutionStack(@NotNull List<? extends XExecutionStack> executionStacks, boolean last) {
            if (executionStacks == null) {
                ThreadsBuilder.$$$reportNull$$$0(0);
            }
            ArrayList<? extends XExecutionStack> copyStacks = new ArrayList<XExecutionStack>(executionStacks);
            ApplicationManager.getApplication().invokeLater(() -> {
                ComboPopup popup2;
                int initialCount = XFramesView.this.myThreadComboBox.getItemCount();
                if (last) {
                    this.removeLoading();
                    XFramesView.this.myThreadsCalculated = true;
                }
                this.myAddBeforeSelection = XFramesView.this.addExecutionStacks(copyStacks, this.myAddBeforeSelection);
                int newCount = XFramesView.this.myThreadComboBox.getItemCount();
                int maxComboboxRows = XFramesView.this.myThreadComboBox.getMaximumRowCount();
                if (newCount != initialCount && (initialCount < maxComboboxRows || newCount < maxComboboxRows) && (popup2 = XFramesView.this.myThreadComboBox.getPopup()) != null && popup2.isVisible()) {
                    popup2.hide();
                    popup2.show();
                }
            });
        }

        public void errorOccurred(@NotNull String errorMessage) {
            if (errorMessage == null) {
                ThreadsBuilder.$$$reportNull$$$0(1);
            }
            ApplicationManager.getApplication().invokeLater(this::removeLoading);
        }

        public boolean isObsolete() {
            return this.myObsolete;
        }

        public void setObsolete() {
            if (!this.myObsolete) {
                this.myObsolete = true;
                this.removeLoading();
            }
        }

        void removeLoading() {
            XFramesView.this.myThreadComboBox.removeItem(null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executionStacks";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorMessage";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/xdebugger/impl/frame/XFramesView$ThreadsBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addExecutionStack";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "errorOccurred";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyFocusPolicy
    extends ComponentsListFocusTraversalPolicy {
        private MyFocusPolicy() {
        }

        @Override
        @NotNull
        protected List<Component> getOrderedComponents() {
            List<Component> list2 = Arrays.asList(XFramesView.this.myFramesList, XFramesView.this.myThreadComboBox);
            if (list2 == null) {
                MyFocusPolicy.$$$reportNull$$$0(0);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/frame/XFramesView$MyFocusPolicy", "getOrderedComponents"));
        }
    }
}

