/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.pinned.items;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.Alarm;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.PinToTopManagerState;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.pinned.items.PinToTopUtilKt;
import com.intellij.xdebugger.impl.pinned.items.PinToTopValue;
import com.intellij.xdebugger.impl.pinned.items.PinnedItemInfo;
import com.intellij.xdebugger.impl.pinned.items.XDebuggerPinToTopListener;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import icons.PlatformDebuggerImplIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 02\u00020\u0001:\u00010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0014J\u0016\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u000fJ\b\u0010\u001e\u001a\u00020\u0019H\u0002J\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00140 J\u0006\u0010!\u001a\u00020\"J\u0010\u0010#\u001a\u00020\"2\b\u0010$\u001a\u0004\u0018\u00010\u0005J\u0010\u0010%\u001a\u00020\"2\b\u0010$\u001a\u0004\u0018\u00010\nJ\u000e\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u0014J\u000e\u0010(\u001a\u00020\u00192\u0006\u0010)\u001a\u00020*J\u0018\u0010+\u001a\u00020\u00192\b\u0010$\u001a\u0004\u0018\u00010\n2\u0006\u0010,\u001a\u00020\u000fJ\u000e\u0010-\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0014J\u000e\u0010.\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\rJ\u000e\u0010/\u001a\u00020\u00192\u0006\u0010)\u001a\u00020*R!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\b\u00a8\u00061"}, d2={"Lcom/intellij/xdebugger/impl/pinned/items/XDebuggerPinToTopManager;", "", "()V", "compoundComparator", "Ljava/util/Comparator;", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl;", "Lkotlin/Comparator;", "getCompoundComparator", "()Ljava/util/Comparator;", "myActiveNode", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XDebuggerTreeNode;", "myListeners", "", "Lcom/intellij/xdebugger/impl/pinned/items/XDebuggerPinToTopListener;", "myNodeHoverLifetime", "Lcom/intellij/openapi/Disposable;", "myPinToTopIconAlarm", "Lcom/intellij/util/Alarm;", "myPinnedMembers", "Ljava/util/HashSet;", "Lcom/intellij/xdebugger/impl/pinned/items/PinnedItemInfo;", "Lkotlin/collections/HashSet;", "pinToTopComparator", "getPinToTopComparator", "addItemInfo", "", "info", "addListener", "listener", "disposable", "disposeCurrentNodeHoverSubscription", "getPinnedItemInfos", "", "isEnabled", "", "isItemPinned", "node", "isPinToTopSupported", "isPinned", "pinnedItemInfo", "loadState", "state", "Lcom/intellij/xdebugger/impl/PinToTopManagerState;", "onNodeHovered", "lifetimeHolder", "removeItemInfo", "removeListener", "saveState", "Companion", "intellij.platform.debugger.impl"})
public class XDebuggerPinToTopManager {
    private final List<XDebuggerPinToTopListener> myListeners;
    private Disposable myNodeHoverLifetime;
    private XDebuggerTreeNode myActiveNode;
    private HashSet<PinnedItemInfo> myPinnedMembers;
    private final Alarm myPinToTopIconAlarm;
    @NotNull
    private final Comparator<XValueNodeImpl> pinToTopComparator;
    @NotNull
    private final Comparator<XValueNodeImpl> compoundComparator;
    private static final long DEFAULT_ICON_DELAY = 300L;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Comparator<XValueNodeImpl> getPinToTopComparator() {
        return this.pinToTopComparator;
    }

    @NotNull
    public final Comparator<XValueNodeImpl> getCompoundComparator() {
        return this.compoundComparator;
    }

    public final boolean isEnabled() {
        return Registry.is((String)"debugger.field.pin.to.top", (boolean)true);
    }

    /*
     * WARNING - void declaration
     */
    public final void onNodeHovered(@Nullable XDebuggerTreeNode node2, @NotNull Disposable lifetimeHolder) {
        void oldIcon;
        Intrinsics.checkNotNullParameter((Object)lifetimeHolder, (String)"lifetimeHolder");
        if (Intrinsics.areEqual((Object)this.myActiveNode, (Object)node2)) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        this.disposeCurrentNodeHoverSubscription();
        if (!this.isPinToTopSupported(node2)) {
            return;
        }
        XDebuggerTreeNode xDebuggerTreeNode = node2;
        if (!(xDebuggerTreeNode instanceof XValueNodeImpl)) {
            xDebuggerTreeNode = null;
        }
        XValueNodeImpl xValueNodeImpl = (XValueNodeImpl)xDebuggerTreeNode;
        if (xValueNodeImpl == null) {
            return;
        }
        XValueNodeImpl valueNode = xValueNodeImpl;
        if (!PinToTopUtilKt.canBePinned(valueNode) || PinToTopUtilKt.isPinned((XValueNodeImpl)node2, this)) {
            return;
        }
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = valueNode.getIcon();
        Disposable changeIconLifetime2 = new Disposable(this, node2, (Ref.ObjectRef)oldIcon){
            final /* synthetic */ XDebuggerPinToTopManager this$0;
            final /* synthetic */ XDebuggerTreeNode $node;
            final /* synthetic */ Ref.ObjectRef $oldIcon;

            public final void dispose() {
                XValuePresentation xValuePresentation = ((XValueNodeImpl)this.$node).getValuePresentation();
                if (Intrinsics.areEqual((Object)((XValueNodeImpl)this.$node).getIcon(), (Object)PlatformDebuggerImplIcons.PinToTop.UnpinnedItem) && xValuePresentation != null) {
                    ((XValueNodeImpl)this.$node).setPresentation((Icon)this.$oldIcon.element, xValuePresentation, !((XValueNodeImpl)this.$node).isLeaf());
                }
                XDebuggerPinToTopManager.access$setMyActiveNode$p(this.this$0, null);
            }
            {
                this.this$0 = xDebuggerPinToTopManager;
                this.$node = xDebuggerTreeNode;
                this.$oldIcon = objectRef;
            }
        };
        this.myActiveNode = node2;
        this.myPinToTopIconAlarm.addRequest(new Runnable(node2, (Ref.ObjectRef)oldIcon){
            final /* synthetic */ XDebuggerTreeNode $node;
            final /* synthetic */ Ref.ObjectRef $oldIcon;

            public final void run() {
                XValuePresentation xValuePresentation = ((XValueNodeImpl)this.$node).getValuePresentation();
                if (xValuePresentation == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)xValuePresentation, (String)"node.valuePresentation ?: return@addRequest");
                XValuePresentation xValuePresentation2 = xValuePresentation;
                this.$oldIcon.element = ((XValueNodeImpl)this.$node).getIcon();
                ((XValueNodeImpl)this.$node).setPresentation(PlatformDebuggerImplIcons.PinToTop.UnpinnedItem, xValuePresentation2, !((XValueNodeImpl)this.$node).isLeaf());
            }
            {
                this.$node = xDebuggerTreeNode;
                this.$oldIcon = objectRef;
            }
        }, 300L);
        this.myNodeHoverLifetime = changeIconLifetime2;
        Disposer.register((Disposable)lifetimeHolder, (Disposable)changeIconLifetime2);
    }

    public final void addListener(@NotNull XDebuggerPinToTopListener listener2, @NotNull Disposable disposable2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)disposable2, (String)"disposable");
        this.myListeners.add(listener2);
        Disposer.register((Disposable)disposable2, (Disposable)new Disposable(this, listener2){
            final /* synthetic */ XDebuggerPinToTopManager this$0;
            final /* synthetic */ XDebuggerPinToTopListener $listener;

            public final void dispose() {
                XDebuggerPinToTopManager.access$getMyListeners$p(this.this$0).remove(this.$listener);
            }
            {
                this.this$0 = xDebuggerPinToTopManager;
                this.$listener = xDebuggerPinToTopListener;
            }
        });
    }

    public final void removeListener(@NotNull XDebuggerPinToTopListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.myListeners.remove(listener2);
    }

    @NotNull
    public final List<PinnedItemInfo> getPinnedItemInfos() {
        return CollectionsKt.toList((Iterable)this.myPinnedMembers);
    }

    public final void addItemInfo(@NotNull PinnedItemInfo info2) {
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        this.myPinnedMembers.add(info2);
        for (XDebuggerPinToTopListener listener2 : this.myListeners) {
            listener2.onPinnedItemAdded(info2);
        }
    }

    public final void removeItemInfo(@NotNull PinnedItemInfo info2) {
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        this.myPinnedMembers.remove(info2);
        for (XDebuggerPinToTopListener listener2 : this.myListeners) {
            listener2.onPinnedItemRemoved(info2);
        }
    }

    public final boolean isItemPinned(@Nullable XValueNodeImpl node2) {
        return PinToTopUtilKt.isPinned(node2, this);
    }

    public final boolean isPinned(@NotNull PinnedItemInfo pinnedItemInfo) {
        Intrinsics.checkNotNullParameter((Object)pinnedItemInfo, (String)"pinnedItemInfo");
        return this.myPinnedMembers.contains(pinnedItemInfo);
    }

    private final void disposeCurrentNodeHoverSubscription() {
        Disposable disposable2 = this.myNodeHoverLifetime;
        if (disposable2 == null) {
            return;
        }
        Disposer.dispose((Disposable)disposable2);
        this.myPinToTopIconAlarm.cancelAllRequests();
    }

    public final void saveState(@NotNull PinToTopManagerState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        state.setPinnedMembersList(CollectionsKt.toMutableList((Collection)this.myPinnedMembers));
    }

    public final void loadState(@NotNull PinToTopManagerState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        this.myPinnedMembers.addAll((Collection<PinnedItemInfo>)state.getPinnedMembersList());
    }

    public final boolean isPinToTopSupported(@Nullable XDebuggerTreeNode node2) {
        if (!(node2 instanceof XValueContainerNode)) {
            return false;
        }
        return ((XValueContainerNode)node2).getValueContainer() instanceof PinToTopValue;
    }

    public XDebuggerPinToTopManager() {
        boolean bl = false;
        this.myListeners = new ArrayList();
        this.myPinnedMembers = new HashSet();
        this.myPinToTopIconAlarm = new Alarm();
        Comparator comparator2 = Comparator.comparing(new Function(this){
            final /* synthetic */ XDebuggerPinToTopManager this$0;

            public final Boolean apply(XValueNodeImpl it) {
                return !this.this$0.isItemPinned(it);
            }
            {
                this.this$0 = xDebuggerPinToTopManager;
            }
        });
        Intrinsics.checkNotNullExpressionValue(comparator2, (String)"Comparator.comparing<XVa\u2026an> { !isItemPinned(it) }");
        this.pinToTopComparator = comparator2;
        Comparator<XValueNodeImpl> comparator3 = XValueNodeImpl.COMPARATOR;
        Intrinsics.checkNotNullExpressionValue(comparator3, (String)"XValueNodeImpl.COMPARATOR");
        this.compoundComparator = ComparisonsKt.then(this.pinToTopComparator, comparator3);
    }

    public static final /* synthetic */ XDebuggerTreeNode access$getMyActiveNode$p(XDebuggerPinToTopManager $this) {
        return $this.myActiveNode;
    }

    public static final /* synthetic */ void access$setMyActiveNode$p(XDebuggerPinToTopManager $this, XDebuggerTreeNode xDebuggerTreeNode) {
        $this.myActiveNode = xDebuggerTreeNode;
    }

    public static final /* synthetic */ List access$getMyListeners$p(XDebuggerPinToTopManager $this) {
        return $this.myListeners;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/xdebugger/impl/pinned/items/XDebuggerPinToTopManager$Companion;", "", "()V", "DEFAULT_ICON_DELAY", "", "getInstance", "Lcom/intellij/xdebugger/impl/pinned/items/XDebuggerPinToTopManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.debugger.impl"})
    public static final class Companion {
        @NotNull
        public final XDebuggerPinToTopManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            XDebuggerManager xDebuggerManager = XDebuggerManager.getInstance((Project)project);
            if (xDebuggerManager == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.xdebugger.impl.XDebuggerManagerImpl");
            }
            XDebuggerPinToTopManager xDebuggerPinToTopManager = ((XDebuggerManagerImpl)xDebuggerManager).getPinToTopManager();
            Intrinsics.checkNotNullExpressionValue((Object)xDebuggerPinToTopManager, (String)"(XDebuggerManager.getIns\u2026agerImpl).pinToTopManager");
            return xDebuggerPinToTopManager;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

