/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.nodes;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.frame.XValueGroup;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.RestorableStateNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValuePresentationUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XValueGroupNodeImpl
extends XValueContainerNode<XValueGroup>
implements RestorableStateNode {
    public XValueGroupNodeImpl(XDebuggerTree tree, XDebuggerTreeNode parent, @NotNull XValueGroup group2) {
        if (group2 == null) {
            XValueGroupNodeImpl.$$$reportNull$$$0(0);
        }
        super(tree, parent, false, group2);
        this.setIcon(group2.getIcon());
        this.myText.append(group2.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        String comment = group2.getComment();
        if (comment != null) {
            XValuePresentationUtil.appendSeparator(this.myText, group2.getSeparator());
            this.myText.append(comment, SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        if (this.isExpand(group2)) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!this.isObsolete()) {
                    this.myTree.expandPath(this.getPath());
                }
            });
        }
        this.myTree.nodeLoaded(this, group2.getName());
    }

    private boolean isExpand(@NotNull XValueGroup group2) {
        String name2;
        if (group2 == null) {
            XValueGroupNodeImpl.$$$reportNull$$$0(1);
        }
        if (group2.isRestoreExpansion() && StringUtil.isNotEmpty((String)(name2 = group2.getName())) && PropertiesComponent.getInstance((Project)this.getTree().getProject()).isValueSet(group2.getName())) {
            return PropertiesComponent.getInstance((Project)this.getTree().getProject()).getBoolean(name2);
        }
        return group2.isAutoExpand();
    }

    public void onExpansion(boolean expanded2) {
        String name2;
        XValueGroup group2 = (XValueGroup)this.getValueContainer();
        if (group2.isRestoreExpansion() && StringUtil.isNotEmpty((String)(name2 = group2.getName()))) {
            PropertiesComponent.getInstance((Project)this.getTree().getProject()).setValue(group2.getName(), String.valueOf(expanded2), null);
        }
    }

    @Override
    public String toString() {
        return "Group:" + ((XValueGroup)this.myValueContainer).getName();
    }

    @Nullable
    public String getName() {
        return ((XValueGroup)this.myValueContainer).getName();
    }

    @Override
    @Nullable
    public String getRawValue() {
        return null;
    }

    @Override
    public boolean isComputed() {
        return true;
    }

    @Override
    public void markChanged() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "group";
        objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/nodes/XValueGroupNodeImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isExpand";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

