/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.nodes;

import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueTextRendererBase;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XValuePresentationUtil {
    public static void renderValue(@NotNull @NlsSafe String value2, @NotNull ColoredTextContainer text2, @NotNull SimpleTextAttributes attributes2, int maxLength, @Nullable String additionalCharsToEscape) {
        if (value2 == null) {
            XValuePresentationUtil.$$$reportNull$$$0(0);
        }
        if (text2 == null) {
            XValuePresentationUtil.$$$reportNull$$$0(1);
        }
        if (attributes2 == null) {
            XValuePresentationUtil.$$$reportNull$$$0(2);
        }
        SimpleTextAttributes escapeAttributes = null;
        int lastOffset = 0;
        int length = maxLength == -1 ? value2.length() : Math.min(value2.length(), maxLength);
        for (int i2 = 0; i2 < length; ++i2) {
            char ch = value2.charAt(i2);
            int additionalCharIndex = -1;
            if (ch != '\n' && ch != '\r' && ch != '\t' && ch != '\b' && ch != '\f' && (additionalCharsToEscape == null || (additionalCharIndex = additionalCharsToEscape.indexOf(ch)) == -1)) continue;
            if (i2 > lastOffset) {
                text2.append(value2.substring(lastOffset, i2), attributes2);
            }
            lastOffset = i2 + 1;
            if (escapeAttributes == null) {
                TextAttributes fromHighlighter = DebuggerUIUtil.getColorScheme().getAttributes(DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE);
                escapeAttributes = fromHighlighter != null ? SimpleTextAttributes.fromTextAttributes(fromHighlighter) : new SimpleTextAttributes(1, (Color)JBColor.GRAY);
            }
            if (additionalCharIndex == -1) {
                text2.append("\\", escapeAttributes);
            }
            text2.append(String.valueOf(XValuePresentationUtil.getEscapingSymbol(ch)), escapeAttributes);
        }
        if (lastOffset < length) {
            text2.append(value2.substring(lastOffset, length), attributes2);
        }
    }

    private static char getEscapingSymbol(char ch) {
        switch (ch) {
            case '\n': {
                return 'n';
            }
            case '\r': {
                return 'r';
            }
            case '\t': {
                return 't';
            }
            case '\b': {
                return 'b';
            }
            case '\f': {
                return 'f';
            }
        }
        return ch;
    }

    public static void appendSeparator(@NotNull ColoredTextContainer text2, @NotNull @NlsSafe String separator2) {
        if (text2 == null) {
            XValuePresentationUtil.$$$reportNull$$$0(3);
        }
        if (separator2 == null) {
            XValuePresentationUtil.$$$reportNull$$$0(4);
        }
        if (!separator2.isEmpty()) {
            text2.append(separator2, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }

    @NotNull
    public static String computeValueText(@NotNull XValuePresentation presentation2) {
        if (presentation2 == null) {
            XValuePresentationUtil.$$$reportNull$$$0(5);
        }
        XValuePresentationTextExtractor extractor = new XValuePresentationTextExtractor();
        presentation2.renderValue((XValuePresentation.XValueTextRenderer)extractor);
        String string = extractor.getText();
        if (string == null) {
            XValuePresentationUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/ui/tree/nodes/XValuePresentationUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/nodes/XValuePresentationUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "computeValueText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "renderValue";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "appendSeparator";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "computeValueText";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class XValuePresentationTextExtractor
    extends XValueTextRendererBase {
        private final StringBuilder myBuilder = new StringBuilder();

        XValuePresentationTextExtractor() {
        }

        public void renderValue(@NotNull String value2) {
            if (value2 == null) {
                XValuePresentationTextExtractor.$$$reportNull$$$0(0);
            }
            this.myBuilder.append(value2);
        }

        @Override
        protected void renderRawValue(@NotNull String value2, @NotNull TextAttributesKey key) {
            if (value2 == null) {
                XValuePresentationTextExtractor.$$$reportNull$$$0(1);
            }
            if (key == null) {
                XValuePresentationTextExtractor.$$$reportNull$$$0(2);
            }
            this.myBuilder.append(value2);
        }

        public void renderStringValue(@NotNull String value2, @Nullable String additionalSpecialCharsToHighlight, int maxLength) {
            if (value2 == null) {
                XValuePresentationTextExtractor.$$$reportNull$$$0(3);
            }
            this.myBuilder.append(value2);
        }

        public void renderComment(@NotNull String comment) {
            if (comment == null) {
                XValuePresentationTextExtractor.$$$reportNull$$$0(4);
            }
            this.myBuilder.append(comment);
        }

        public void renderError(@NotNull String error) {
            if (error == null) {
                XValuePresentationTextExtractor.$$$reportNull$$$0(5);
            }
            this.myBuilder.append(error);
        }

        public void renderSpecialSymbol(@NotNull String symbol) {
            if (symbol == null) {
                XValuePresentationTextExtractor.$$$reportNull$$$0(6);
            }
            this.myBuilder.append(symbol);
        }

        public String getText() {
            return this.myBuilder.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comment";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "error";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "symbol";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/nodes/XValuePresentationUtil$XValuePresentationTextExtractor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renderValue";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renderRawValue";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renderStringValue";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renderComment";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renderError";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renderSpecialSymbol";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

